/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.ap.mservice.PayRecSettleService;
import kd.fi.ap.mservice.PaySelfSettleService;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.service.IManualSettleService;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.ManualSettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class PayRecManualSettleService
implements IManualSettleService {
    protected static final String RECBILL = "cas_recbill";
    protected static final String PAYBILL = "cas_paybill";
    private PayRecSettleService service;

    public PayRecManualSettleService() {
        this.service = new PayRecSettleService();
    }

    public PayRecManualSettleService(PayRecSettleService service) {
        this.service = service;
    }

    public void manualSettle(DynamicObject[] mainRows, DynamicObject[] asstRows, ManualSettleParam manualParam) throws KDBizException {
        HashSet<Long> payBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> payEntryIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> paidBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> paidEntryIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject mainRow : mainRows) {
            DynamicObject[] entityName = mainRow.getString("billtype");
            if (PAYBILL.equals(entityName)) {
                payBillIdSet.add(mainRow.getLong("id"));
                payEntryIdSet.add(mainRow.getLong("entryid"));
                continue;
            }
            paidBillIdSet.add(mainRow.getLong("id"));
            paidEntryIdSet.add(mainRow.getLong("entryid"));
        }
        HashSet<Long> recBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> recEntryIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> recedBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> recedEntryIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asstRow : asstRows) {
            String entityName = asstRow.getString("asst_billtype");
            if (RECBILL.equals(entityName)) {
                recBillIdSet.add(asstRow.getLong("asst_id"));
                recEntryIdSet.add(asstRow.getLong("asst_entryid"));
                continue;
            }
            recedBillIdSet.add(asstRow.getLong("asst_id"));
            recedEntryIdSet.add(asstRow.getLong("asst_entryid"));
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setSettle(true);
        scheme.setManual(true);
        scheme.setDiffCurrencySettle(manualParam.isDiffCurrencySettle());
        scheme.setSettleDate(manualParam.getSettleDate());
        Object[] recArr = this.reloadRecArr(recBillIdSet);
        Object[] recedArr = this.reloadRecedArr(recedBillIdSet);
        Object[] payArr = this.reloadPayArr(payBillIdSet);
        Object[] paidArr = this.reloadPaidArr(paidBillIdSet);
        DynamicObject[] recMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])recArr, (Object[])recedArr);
        DynamicObject[] payMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])payArr, (Object[])paidArr);
        List mainListVO = PayBillHandleHelper.getMainListVO((DynamicObject[])payMergeArr);
        List asstListVO = RecBillHandlerHelper.getAsstListVO((DynamicObject[])recMergeArr);
        if (manualParam.isSingleSettle()) {
            scheme.setSettleSelf(true);
            this.settleSelfFirst(mainListVO, asstListVO, scheme);
            return;
        }
        if ((manualParam.isSettleSelfFirst() || manualParam.isTotal()) && !manualParam.isDiffCurrencySettle()) {
            scheme.setSettleSelf(true);
            this.settleSelfFirst(mainListVO, asstListVO, scheme);
            recArr = this.reloadRecArr(recBillIdSet);
            recedArr = this.reloadRecedArr(recedBillIdSet);
            payArr = this.reloadPayArr(payBillIdSet);
            paidArr = this.reloadPaidArr(paidBillIdSet);
        }
        this.processMain((DynamicObject[])payArr, mainRows, payEntryIdSet, manualParam);
        this.processMain((DynamicObject[])paidArr, mainRows, paidEntryIdSet, manualParam);
        this.processAsst((DynamicObject[])recArr, asstRows, recEntryIdSet, manualParam);
        this.processAsst((DynamicObject[])recedArr, asstRows, recedEntryIdSet, manualParam);
        recMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])recArr, (Object[])recedArr);
        payMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])payArr, (Object[])paidArr);
        mainListVO = PayBillHandleHelper.getMainListVO((DynamicObject[])payMergeArr);
        asstListVO = RecBillHandlerHelper.getAsstListVO((DynamicObject[])recMergeArr);
        this.service.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.MANUAL.getValue());
    }

    private void settleSelfFirst(List<BillSettleVO> mainListVO, List<BillSettleVO> asstListVO, SettleSchemeVO scheme) {
        List mainPositiveList = this.getPositiveList(mainListVO);
        List mainNegativeList = this.getNegativeList(mainListVO);
        if (mainPositiveList.size() > 0 && mainNegativeList.size() > 0) {
            PaySelfSettleService apSelfService = new PaySelfSettleService();
            apSelfService.settleByVO(mainPositiveList, mainNegativeList, scheme, SettleTypeEnum.MANUAL.getValue());
        }
        List asstPositiveList = this.getPositiveList(asstListVO);
        List asstNegativeList = this.getNegativeList(asstListVO);
        if (asstPositiveList.size() > 0 && asstNegativeList.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"recself", (String)"settleByVO", (Object[])new Object[]{asstPositiveList, asstNegativeList, scheme, SettleTypeEnum.MANUAL.getValue()});
        }
        scheme.setSettleSelf(false);
    }

    protected void processMain(DynamicObject[] mainArr, DynamicObject[] mainRows, Set<Long> mainEntryIdSet, ManualSettleParam param) {
        if (param.isTotal()) {
            for (DynamicObject mainRow : mainRows) {
                BigDecimal curSettleAmt = mainRow.getBigDecimal("cursettleamt");
                long id = mainRow.getLong("id");
                for (DynamicObject mainObj : mainArr) {
                    if (id != mainObj.getLong("id")) continue;
                    mainObj.set("exchangerate", (Object)mainRow.getBigDecimal("exchangerate"));
                    DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnSettleAmt = entry.getBigDecimal("e_unsettledamt");
                        if (entryUnSettleAmt.compareTo(BigDecimal.ZERO) < 0) continue;
                        if (PAYBILL.equals(mainObj.getDataEntityType().getName()) && (!param.getOrgPk().equals(entry.get("settleorg.id")) || ObjectUtils.isEmpty((Object)entry.getDynamicObject("e_paymenttype")) || !entry.getDynamicObject("e_paymenttype").getBoolean("ispartpayment"))) {
                            entry.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        if (curSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            curSettleAmt = curSettleAmt.subtract(entryUnSettleAmt);
                            continue;
                        }
                        entry.set("e_unsettledamt", (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject mainObj : mainArr) {
                long id = mainObj.getLong("id");
                DynamicObjectCollection entrys = mainObj.getDynamicObjectCollection("entry");
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                    if (mainEntryIdSet.contains(entryId)) {
                        for (DynamicObject mainRow : mainRows) {
                            if (id != mainRow.getLong("id") || entryId != mainRow.getLong("entryid")) continue;
                            mainObj.set("exchangerate", (Object)mainRow.getBigDecimal("exchangerate"));
                            BigDecimal curSettleAmt = mainRow.getBigDecimal("curSettleAmt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set("e_unsettledamt", (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }

    private void processAsst(DynamicObject[] recArr, DynamicObject[] rows, Set<Long> entryIdSet, ManualSettleParam param) {
        if (param.isTotal()) {
            for (DynamicObject row : rows) {
                BigDecimal curSettleAmt = row.getBigDecimal("asst_cursettleamt");
                long id = row.getLong("asst_id");
                for (DynamicObject obj : recArr) {
                    if (id != obj.getLong("id")) continue;
                    obj.set("exchangerate", (Object)row.getBigDecimal("asst_exchangerate"));
                    DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entrys) {
                        BigDecimal entryUnSettleAmt = entry.getBigDecimal("e_unsettledamt");
                        if (RECBILL.equals(obj.getDataEntityType().getName()) && (!param.getOrgPk().equals(entry.get("e_settleorg.id")) || ObjectUtils.isEmpty((Object)entry.getDynamicObject("e_receivingtype")) || !entry.getDynamicObject("e_receivingtype").getBoolean("ispartreceivable"))) {
                            entry.set("e_unsettledamt", (Object)BigDecimal.ZERO);
                            continue;
                        }
                        if (curSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            curSettleAmt = curSettleAmt.subtract(entryUnSettleAmt);
                            continue;
                        }
                        entry.set("e_unsettledamt", (Object)curSettleAmt);
                        curSettleAmt = BigDecimal.ZERO;
                    }
                }
            }
        } else {
            for (DynamicObject obj : recArr) {
                long id = obj.getLong("id");
                DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entry");
                for (int i = entrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    long entryId = entry.getLong("id");
                    BigDecimal unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                    if (entryIdSet.contains(entryId)) {
                        for (DynamicObject row : rows) {
                            if (id != row.getLong("asst_id") || entryId != row.getLong("asst_entryid")) continue;
                            obj.set("exchangerate", (Object)row.getBigDecimal("asst_exchangerate"));
                            BigDecimal curSettleAmt = row.getBigDecimal("asst_cursettleamt");
                            int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                            curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                            entry.set("e_unsettledamt", (Object)curSettleAmt);
                        }
                        continue;
                    }
                    entrys.remove(i);
                }
            }
        }
    }
}

