/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.mservice.PremSettleService;
import kd.fi.ap.mservice.SettleServiceFactory;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class PremAutoSettleService
extends AbsAutoSettleService {
    private static final Log logger = LogFactory.getLog(PremAutoSettleService.class);
    private PremSettleService service = new PremSettleService();

    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        this.batchAutoSettle(new DynamicObject[]{obj}, isMain);
    }

    public void batchAutoSettle(DynamicObject[] objs, boolean isMain) throws KDBizException {
        if (isMain) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u4e1a\u52a1\u4e0d\u652f\u6301\u7531\u4e3b\u65b9\uff08\u4e0a\u6e38\u5355\u636e\uff09\u53d1\u8d77\u7684\u7ed3\u7b97\u3002", (String)"PremAutoSettleService_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setPremAutoSettle(true);
        scheme.setOnlyByBotp(true);
        DynamicObject[] mains = this.getMainObjs(objs);
        this.addSettleLock(mains, objs);
        this.service.settle(mains, objs, scheme, SettleTypeEnum.AUTO.getValue());
    }

    private DynamicObject[] getMainObjs(DynamicObject[] objs) {
        ArrayList<Long> billIds = new ArrayList<Long>(2);
        ArrayList<Long> entryIds = new ArrayList<Long>(2);
        for (DynamicObject obj : objs) {
            billIds.add(obj.getLong("id"));
            DynamicObjectCollection entry = obj.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                entryIds.add(row.getLong("id"));
            }
        }
        HashSet souBillIdSet = new HashSet(2);
        if (billIds.size() > 0) {
            Map sourceBillMap = BOTPNewHelper.loadNearSourceBillIds((String)"ap_finapbill", (String)"detailentry", (Long[])billIds.toArray(new Long[0]), (Long[])entryIds.toArray(new Long[0]), (String)"ap_finapbill");
            for (Map.Entry sourceBillIds : sourceBillMap.entrySet()) {
                souBillIdSet.addAll((Collection)sourceBillIds.getValue());
            }
        }
        if (souBillIdSet.size() > 0) {
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", souBillIdSet), new QFilter("billstatus", "=", (Object)"C"), new QFilter("detailentry.unsettleamt", "!=", (Object)0)};
            Object[] mainBills = FinApBillHandleHelper.load((QFilter[])filter);
            logger.info("\u4e3b\u65b9\u5bf9\u8c61" + Arrays.toString(mainBills));
            return mainBills;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u672c\u5355\u636e\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u5173\u8054\u5173\u7cfb\u3002", (String)"PremAutoSettleService_1", (String)"fi-ap-mservice", (Object[])new Object[0]));
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        return SettleServiceFactory.getService(settleRelation);
    }
}

