/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.mservice.SettleServiceFactory;
import kd.fi.ap.mservice.helper.SettleServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.FinArBillHandleHelper;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.service.writeback.bill.DisposerInfo;
import kd.fi.arapcommon.service.writeback.bill.FinApLockWBServiceHelper;
import kd.fi.arapcommon.service.writeback.bill.FinArLockWBServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.UnSettleParam;

public class RefundAndRenoteConfirmHelper {
    public static void payUnSettle(List<DynamicObject> settleRecords, Set<Long> payEntryIds) {
        ArrayList<DynamicObject> wholeAndNeedDeleteRecords = new ArrayList<DynamicObject>(settleRecords.size());
        ArrayList<DynamicObject> wholeAndNeedRedRecords = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> partAndNeedDeleteRecords = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> partAndNeedRedRecords = new ArrayList<DynamicObject>(8);
        RefundAndRenoteConfirmHelper.recordClassify(settleRecords, wholeAndNeedDeleteRecords, wholeAndNeedRedRecords, partAndNeedDeleteRecords, partAndNeedRedRecords, payEntryIds);
        RefundAndRenoteConfirmHelper.resolveWholeNeedDeleteRecord(wholeAndNeedDeleteRecords);
        RefundAndRenoteConfirmHelper.resolveWholeNeedRedRecord(wholeAndNeedRedRecords);
        RefundAndRenoteConfirmHelper.resolvePartNeedDeleteRecord(partAndNeedDeleteRecords, payEntryIds);
        RefundAndRenoteConfirmHelper.resolvePartNeedRedRecord(partAndNeedRedRecords, payEntryIds);
    }

    public static Date payRecSettle(Long recId, Set<Long> payIds, Set<Long> payEntryIds, Map<Long, BigDecimal> needSettleEntryMap) {
        QFilter filter;
        DynamicObject[] payRecSettleRecords;
        QFilter[] payFilter = new QFilter[]{new QFilter("id", "in", payIds), new QFilter("paymenttype.ispartpayment", "=", (Object)Boolean.TRUE)};
        DynamicObject[] payBills = PayBillHandleHelper.loadPay((QFilter[])payFilter);
        RefundAndRenoteConfirmHelper.resolvePayBill(payEntryIds, payBills);
        RefundAndRenoteConfirmHelper.repairPayBillNeedPayRecSettleAmt(needSettleEntryMap, payBills);
        List<Object> settleRecordIds = RefundAndRenoteConfirmHelper.resolvePayRecSettle(recId, payBills);
        Date globalSettleDate = new Date();
        if (settleRecordIds != null && settleRecordIds.size() > 0 && (payRecSettleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"id,settledate", (QFilter[])new QFilter[]{filter = new QFilter("id", "in", settleRecordIds)})).length > 0) {
            globalSettleDate = payRecSettleRecords[0].getDate("settledate");
        }
        RefundAndRenoteConfirmHelper.updateApPayRedSettleRecordSettleDate(payBills, globalSettleDate);
        payBills = PayBillHandleHelper.loadPay((QFilter[])payFilter);
        RefundAndRenoteConfirmHelper.resolvePayBill(payEntryIds, payBills);
        RefundAndRenoteConfirmHelper.repairPayBillNeedPaySelfSettleAmt(needSettleEntryMap, payBills);
        RefundAndRenoteConfirmHelper.resolvePaySelf(payBills, globalSettleDate);
        return globalSettleDate;
    }

    public static void writeBackFinBill(Set<Long> payIds, Map<Long, BigDecimal> needSettleEntryMap, boolean isConfirm) {
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"entry.id,entry.e_sourcebillid,entry.e_sourcebillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", payIds)});
        Set<Long> payEntryIds = needSettleEntryMap.keySet();
        HashSet<Long> sourceIds = new HashSet<Long>(8);
        RefundAndRenoteConfirmHelper.resolvePayBillEntry(payBills, payEntryIds, sourceIds);
        RefundAndRenoteConfirmHelper.resolveApBillDispose(payBills, needSettleEntryMap, payEntryIds, sourceIds, isConfirm);
        RefundAndRenoteConfirmHelper.resolveArBillDispose(payBills, needSettleEntryMap, payEntryIds, sourceIds, isConfirm);
    }

    private static void resolvePayBill(Set<Long> payEntryIds, DynamicObject[] payBills) {
        for (int i = payBills.length - 1; i >= 0; --i) {
            DynamicObject payBill = payBills[i];
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                Long entryId = entry.getLong("id");
                if (payEntryIds.contains(entryId)) continue;
                iterator.remove();
            }
        }
    }

    private static void repairPayBillNeedPayRecSettleAmt(Map<Long, BigDecimal> needSettleEntryMap, DynamicObject[] payBills) {
        for (int i = payBills.length - 1; i >= 0; --i) {
            DynamicObject payBill = payBills[i];
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("id");
                entry.set("e_unsettledamt", (Object)needSettleEntryMap.get(entryId));
            }
        }
    }

    private static void repairPayBillNeedPaySelfSettleAmt(Map<Long, BigDecimal> needSettleEntryMap, DynamicObject[] payBills) {
        for (int i = payBills.length - 1; i >= 0; --i) {
            DynamicObject payBill = payBills[i];
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("id");
                entry.set("e_unsettledamt", (Object)needSettleEntryMap.get(entryId).subtract(entry.getBigDecimal("e_settledamt")));
            }
        }
    }

    private static List<Object> resolvePayRecSettle(Long recId, DynamicObject[] payBills) {
        QFilter[] recFilter = new QFilter[]{new QFilter("id", "=", (Object)recId), new QFilter("receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE)};
        DynamicObject[] recBills = RecBillHandlerHelper.loadRec((QFilter[])recFilter);
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setSettle(true);
        scheme.setManual(true);
        scheme.setUnSettleByReturn(true);
        AbstractSettleTemplate service = SettleServiceFactory.getService(SettleRelationEnum.PAYRECSETTLE.getValue());
        service.settle(payBills, recBills, scheme, SettleTypeEnum.AUTO.getValue());
        return scheme.getRecordPks();
    }

    private static void updateApPayRedSettleRecordSettleDate(DynamicObject[] payBills, Date globalSettleDate) {
        ArrayList<String> settleRelations = new ArrayList<String>(2);
        settleRelations.add(SettleRelationEnum.APPAYSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.ARPAYSETTLE.getValue());
        QFilter filter = new QFilter("settlerelation", "in", settleRelations);
        List payBillIds = Arrays.stream(payBills).map(paybill -> paybill.getLong("id")).collect(Collectors.toList());
        filter.and("entry.billid", "in", payBillIds);
        filter.and("iswrittenoff", "=", (Object)Boolean.TRUE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] apPayRedSettleRecords = SettleRecordQueryHelper.getSettleRecords((String)"ap_settlerecord", (String)"id,settledate", (String)"cas_paybill", (Object[])payBillIds.toArray(), (QFilter)filter);
        if (apPayRedSettleRecords.length > 0) {
            for (DynamicObject apPayRedSettleRecord : apPayRedSettleRecords) {
                apPayRedSettleRecord.set("settledate", (Object)globalSettleDate);
            }
            SaveServiceHelper.save((DynamicObject[])apPayRedSettleRecords);
        }
    }

    private static void resolvePaySelf(DynamicObject[] payBills, Date globalSettleDate) {
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setSettle(true);
        scheme.setManual(true);
        scheme.setUnSettleByReturn(true);
        AbstractSettleTemplate service = SettleServiceFactory.getService(SettleRelationEnum.PAYSELF.getValue());
        service.settle(payBills, payBills, scheme, SettleTypeEnum.AUTO.getValue());
        List paySelfSettleRecordPks = scheme.getRecordPks();
        if (paySelfSettleRecordPks != null && paySelfSettleRecordPks.size() > 0) {
            DynamicObject[] paySelfSettleRecords;
            for (DynamicObject paySelfSettleRecord : paySelfSettleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"id,settledate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)paySelfSettleRecordPks)})) {
                paySelfSettleRecord.set("settledate", (Object)globalSettleDate);
            }
            SaveServiceHelper.save((DynamicObject[])paySelfSettleRecords);
        }
    }

    private static void resolveWholeNeedDeleteRecord(List<DynamicObject> wholeAndNeedDeleteRecords) {
        if (wholeAndNeedDeleteRecords.size() == 0) {
            return;
        }
        DynamicObject[] results = wholeAndNeedDeleteRecords.toArray(new DynamicObject[0]);
        Map map = SettleRecordOpHelper.classfySettleRecord((DynamicObject[])results);
        for (Map.Entry mapEntry : map.entrySet()) {
            AbstractSettleTemplate settleService = SettleServiceFactory.getService((String)mapEntry.getKey());
            UnSettleParam param = new UnSettleParam();
            param.setUnSettleByReturn(true);
            settleService.unSettle(((List)mapEntry.getValue()).toArray(new DynamicObject[0]), param);
        }
    }

    private static void resolveWholeNeedRedRecord(List<DynamicObject> wholeAndNeedUpdateRecords) {
        if (wholeAndNeedUpdateRecords.size() == 0) {
            return;
        }
        DynamicObject[] results = wholeAndNeedUpdateRecords.toArray(new DynamicObject[0]);
        List resultIds = Arrays.stream(results).map(result -> result.getLong("id")).collect(Collectors.toList());
        String apSettleRecordRedRuleId = "733772355079280640";
        List redSettleRecords = BOTPHelper.push((String)"ap_settlerecord", (String)"ap_settlerecord", (String)apSettleRecordRedRuleId, resultIds, (String)ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u7ea2\u51b2\u5931\u8d25\u3002", (String)"ApPaySettleApi_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_settlerecord", (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)saveResult);
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)auditResult);
        for (DynamicObject record : wholeAndNeedUpdateRecords) {
            record.set("hadwrittenoff", (Object)1);
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                entry.set("e_hadwrittenoff", (Object)1);
            }
        }
        SaveServiceHelper.update((DynamicObject[])results);
        Map map = SettleRecordOpHelper.classfySettleRecord((DynamicObject[])results);
        for (Map.Entry mapEntry : map.entrySet()) {
            AbstractSettleTemplate settleService = SettleServiceFactory.getService((String)mapEntry.getKey());
            UnSettleParam param = new UnSettleParam();
            param.setUnSettleByReturn(true);
            param.setRedSettleRecord(true);
            settleService.unSettle(((List)mapEntry.getValue()).toArray(new DynamicObject[0]), param);
        }
    }

    private static void resolvePartNeedDeleteRecord(List<DynamicObject> partAndNeedDeleteRecords, Set<Long> payEntryIds) {
        DynamicObject entry;
        BigDecimal tempSwapL;
        BigDecimal tempSettleLocalAmt;
        BigDecimal tempSettleAmt;
        Long asstBillEntryId;
        DynamicObject entry2;
        Iterator iterator;
        DynamicObjectCollection entries;
        if (partAndNeedDeleteRecords.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> partRecordsTemp = new ArrayList<DynamicObject>(partAndNeedDeleteRecords.size());
        CloneUtils clone = new CloneUtils(false, false);
        for (DynamicObject settleRecord : partAndNeedDeleteRecords) {
            partRecordsTemp.add((DynamicObject)clone.clone((IDataEntityBase)settleRecord));
        }
        for (DynamicObject partRecord : partAndNeedDeleteRecords) {
            entries = partRecord.getDynamicObjectCollection("entry");
            iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry2 = (DynamicObject)iterator.next();
                asstBillEntryId = entry2.getLong("billentryid");
                if (payEntryIds.contains(asstBillEntryId) || entry2.getBoolean("e_hadwrittenoff")) continue;
                iterator.remove();
            }
        }
        for (DynamicObject partRecord : partAndNeedDeleteRecords) {
            entries = partRecord.getDynamicObjectCollection("entry");
            iterator = entries.iterator();
            tempSettleAmt = BigDecimal.ZERO;
            tempSettleLocalAmt = BigDecimal.ZERO;
            tempSwapL = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                entry = (DynamicObject)iterator.next();
                tempSettleAmt = tempSettleAmt.add(entry.getBigDecimal("settleamt"));
                tempSettleLocalAmt = tempSettleLocalAmt.add(entry.getBigDecimal("localsettleamt"));
                tempSwapL = tempSwapL.add(entry.getBigDecimal("e_swappl"));
            }
            partRecord.set("totalsettleamt", (Object)tempSettleAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("totalsettleamt").signum())));
            partRecord.set("localtotalsettleamt", (Object)tempSettleLocalAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("localtotalsettleamt").signum())));
            partRecord.set("swappl", (Object)tempSwapL.abs().multiply(new BigDecimal(partRecord.getBigDecimal("swappl").signum())));
        }
        for (DynamicObject partRecord : partAndNeedDeleteRecords) {
            ArrayList<SettleRecordVO> srList = new ArrayList<SettleRecordVO>(1);
            ArrayList entryVOList = new ArrayList(1);
            SettleRecordVO settleRecordVO = SettleServiceHelper.converDyn2VO(partRecord);
            srList.add(settleRecordVO);
            entryVOList.addAll(settleRecordVO.getEntrys());
            SettleSchemeVO scheme = new SettleSchemeVO();
            scheme.setSettle(false);
            scheme.setUnSettleByReturn(true);
            scheme.setManual(SettleTypeEnum.MANUAL.getValue().equals(settleRecordVO.getSettleType()));
            scheme.setSchemeSettle(SettleTypeEnum.MATCH.getValue().equals(settleRecordVO.getSettleType()));
            if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRecordVO.getSettleRela())) {
                FinApBillHandleHelper.batchDisposeByMainBill(srList, (SettleSchemeVO)scheme);
            } else {
                FinArBillHandleHelper.batchDisposeByMainBill(srList, (SettleSchemeVO)scheme);
            }
            PayBillHandleHelper.disposeByAsstBill(entryVOList, (SettleSchemeVO)scheme);
        }
        for (DynamicObject partRecord : partRecordsTemp) {
            entries = partRecord.getDynamicObjectCollection("entry");
            iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry2 = (DynamicObject)iterator.next();
                asstBillEntryId = entry2.getLong("billentryid");
                if (!payEntryIds.contains(asstBillEntryId) || entry2.getBoolean("e_hadwrittenoff")) continue;
                iterator.remove();
            }
        }
        for (DynamicObject partRecord : partRecordsTemp) {
            entries = partRecord.getDynamicObjectCollection("entry");
            iterator = entries.iterator();
            tempSettleAmt = BigDecimal.ZERO;
            tempSettleLocalAmt = BigDecimal.ZERO;
            tempSwapL = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                entry = (DynamicObject)iterator.next();
                tempSettleAmt = tempSettleAmt.add(entry.getBigDecimal("settleamt"));
                tempSettleLocalAmt = tempSettleLocalAmt.add(entry.getBigDecimal("localsettleamt"));
                tempSwapL = tempSwapL.add(entry.getBigDecimal("e_swappl"));
            }
            partRecord.set("totalsettleamt", (Object)tempSettleAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("totalsettleamt").signum())));
            partRecord.set("localtotalsettleamt", (Object)tempSettleLocalAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("localtotalsettleamt").signum())));
            partRecord.set("swappl", (Object)tempSwapL.abs().multiply(new BigDecimal(partRecord.getBigDecimal("swappl").signum())));
        }
        SettleRecordOpHelper.updateSettleRecord((DynamicObject[])partRecordsTemp.toArray(new DynamicObject[0]));
    }

    private static void resolvePartNeedRedRecord(List<DynamicObject> partAndNeedRedRecords, Set<Long> payEntryIds) {
        Iterator iterator;
        DynamicObjectCollection entries;
        DynamicObject entry;
        if (partAndNeedRedRecords.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> partRecordsTemp = new ArrayList<DynamicObject>(partAndNeedRedRecords.size());
        CloneUtils clone = new CloneUtils(false, false);
        for (DynamicObject dynamicObject : partAndNeedRedRecords) {
            partRecordsTemp.add((DynamicObject)clone.clone((IDataEntityBase)dynamicObject));
        }
        ArrayList<Long> resultPks = new ArrayList<Long>(partAndNeedRedRecords.size());
        for (DynamicObject partRecord : partAndNeedRedRecords) {
            resultPks.add(partRecord.getLong("id"));
            DynamicObjectCollection entries2 = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator2 = entries2.iterator();
            while (iterator2.hasNext()) {
                DynamicObject entry2 = (DynamicObject)iterator2.next();
                Long asstBillEntryId = entry2.getLong("billentryid");
                if (payEntryIds.contains(asstBillEntryId)) continue;
                iterator2.remove();
            }
        }
        for (DynamicObject partRecord : partAndNeedRedRecords) {
            DynamicObjectCollection entries2 = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator3 = entries2.iterator();
            BigDecimal tempSettleAmt = BigDecimal.ZERO;
            BigDecimal tempSettleLocalAmt = BigDecimal.ZERO;
            BigDecimal tempSwapL = BigDecimal.ZERO;
            while (iterator3.hasNext()) {
                entry = (DynamicObject)iterator3.next();
                tempSettleAmt = tempSettleAmt.add(entry.getBigDecimal("settleamt"));
                tempSettleLocalAmt = tempSettleLocalAmt.add(entry.getBigDecimal("localsettleamt"));
                tempSwapL = tempSwapL.add(entry.getBigDecimal("e_swappl"));
            }
            partRecord.set("totalsettleamt", (Object)tempSettleAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("totalsettleamt").signum())));
            partRecord.set("localtotalsettleamt", (Object)tempSettleLocalAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("localtotalsettleamt").signum())));
            partRecord.set("swappl", (Object)tempSwapL.abs().multiply(new BigDecimal(partRecord.getBigDecimal("swappl").signum())));
        }
        ArrayList<SettleRecordVO> arrayList = new ArrayList<SettleRecordVO>(partAndNeedRedRecords.size());
        ArrayList entryVOList = new ArrayList(64);
        for (DynamicObject dynamicObject : partAndNeedRedRecords) {
            SettleRecordVO settleRecordVO = SettleServiceHelper.converDyn2VO(dynamicObject);
            arrayList.add(settleRecordVO);
            entryVOList.addAll(settleRecordVO.getEntrys());
            SettleSchemeVO scheme = new SettleSchemeVO();
            scheme.setSettle(false);
            scheme.setUnSettleByReturn(true);
            scheme.setManual(SettleTypeEnum.MANUAL.getValue().equals(settleRecordVO.getSettleType()));
            scheme.setSchemeSettle(SettleTypeEnum.MATCH.getValue().equals(settleRecordVO.getSettleType()));
            if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRecordVO.getSettleRela())) {
                FinApBillHandleHelper.batchDisposeByMainBill(arrayList, (SettleSchemeVO)scheme);
            } else {
                FinArBillHandleHelper.batchDisposeByMainBill(arrayList, (SettleSchemeVO)scheme);
            }
            PayBillHandleHelper.disposeByAsstBill(entryVOList, (SettleSchemeVO)scheme);
        }
        List redSettleRecords = BOTPHelper.push((String)"ap_settlerecord", (String)"ap_settlerecord", (String)"733772355079280640", resultPks, (String)ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u7ea2\u51b2\u5931\u8d25\u3002", (String)"ApPaySettleApi_0", (String)"fi-ap-mservice", (Object[])new Object[0]));
        for (DynamicObject redSettleRecord : redSettleRecords) {
            entries = redSettleRecord.getDynamicObjectCollection("entry");
            iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry = (DynamicObject)iterator.next();
                Long asstBillEntryId = entry.getLong("billentryid");
                if (payEntryIds.contains(asstBillEntryId)) continue;
                iterator.remove();
            }
        }
        for (DynamicObject redSettleRecord : redSettleRecords) {
            entries = redSettleRecord.getDynamicObjectCollection("entry");
            iterator = entries.iterator();
            BigDecimal tempSettleAmt = BigDecimal.ZERO;
            BigDecimal tempSettleLocalAmt = BigDecimal.ZERO;
            BigDecimal tempSwapL = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                DynamicObject entry3 = (DynamicObject)iterator.next();
                tempSettleAmt = tempSettleAmt.add(entry3.getBigDecimal("settleamt"));
                tempSettleLocalAmt = tempSettleLocalAmt.add(entry3.getBigDecimal("localsettleamt"));
                tempSwapL = tempSwapL.add(entry3.getBigDecimal("e_swappl"));
            }
            redSettleRecord.set("totalsettleamt", (Object)tempSettleAmt.abs().multiply(new BigDecimal(redSettleRecord.getBigDecimal("totalsettleamt").signum())));
            redSettleRecord.set("localtotalsettleamt", (Object)tempSettleLocalAmt.abs().multiply(new BigDecimal(redSettleRecord.getBigDecimal("localtotalsettleamt").signum())));
            redSettleRecord.set("swappl", (Object)tempSwapL.abs().multiply(new BigDecimal(redSettleRecord.getBigDecimal("swappl").signum())));
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("mutex_writeback", "false");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_settlerecord", (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)saveResult);
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)operateOption);
        OperationHelper.assertResult((OperationResult)submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)operateOption);
        OperationHelper.assertResult((OperationResult)auditResult);
        for (DynamicObject record : partRecordsTemp) {
            DynamicObjectCollection entries3 = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry4 : entries3) {
                Long asstBillEntryId = entry4.getLong("billentryid");
                if (!payEntryIds.contains(asstBillEntryId) || entry4.getBoolean("e_hadwrittenoff")) continue;
                entry4.set("e_hadwrittenoff", (Object)1);
            }
            boolean isFlag = true;
            for (DynamicObject entry5 : entries3) {
                boolean isHadWrittenOff = entry5.getBoolean("e_hadwrittenoff");
                if (isHadWrittenOff) continue;
                isFlag = false;
            }
            if (!isFlag) continue;
            record.set("hadwrittenoff", (Object)1);
        }
        SaveServiceHelper.update((DynamicObject[])partRecordsTemp.toArray(new DynamicObject[0]));
    }

    private static void recordClassify(List<DynamicObject> settleRecords, List<DynamicObject> wholeAndNeedDeleteRecords, List<DynamicObject> wholeAndNeedRedRecords, List<DynamicObject> partAndNeedDeleteRecords, List<DynamicObject> partAndNeedRedRecords, Set<Long> payEntryIds) {
        HashMap<Long, Date> currentDateMap = new HashMap<Long, Date>(1);
        boolean redAllSettleRecord = CommonSettleServiceHelper.isRedAllSettleRecord();
        for (DynamicObject result : settleRecords) {
            Date currentDate;
            long orgId;
            Date date;
            boolean isWhole = true;
            DynamicObjectCollection entrys = result.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                Long asstBillEntryId = entry.getLong("billentryid");
                if (payEntryIds.contains(asstBillEntryId)) continue;
                isWhole = false;
                break;
            }
            if ((date = (Date)currentDateMap.get(orgId = result.getLong("org.id"))) != null) {
                currentDate = date;
            } else {
                InitHelper init = new InitHelper(orgId, "ap_init");
                currentDate = init.getCurrentDate() != null ? init.getCurrentDate() : init.getStartDate();
                currentDateMap.put(orgId, currentDate);
            }
            if (redAllSettleRecord) {
                if (isWhole) {
                    wholeAndNeedRedRecords.add(result);
                    continue;
                }
                partAndNeedRedRecords.add(result);
                continue;
            }
            if (result.getBoolean("isvoucher") || DateUtils.getDiffDays((Date)result.getDate("settledate"), (Date)currentDate) > 0) {
                if (isWhole) {
                    wholeAndNeedRedRecords.add(result);
                    continue;
                }
                partAndNeedRedRecords.add(result);
                continue;
            }
            if (isWhole) {
                wholeAndNeedDeleteRecords.add(result);
                continue;
            }
            partAndNeedDeleteRecords.add(result);
        }
    }

    private static void resolvePayBillEntry(DynamicObject[] payBills, Set<Long> payEntryIds, Set<Long> sourceIds) {
        for (int i = payBills.length - 1; i >= 0; --i) {
            DynamicObject payBill = payBills[i];
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                Long entryId = entry.getLong("id");
                if (!payEntryIds.contains(entryId)) {
                    iterator.remove();
                    continue;
                }
                sourceIds.add(entry.getLong("e_sourcebillid"));
            }
        }
    }

    private static void resolveApBillDispose(DynamicObject[] payBills, Map<Long, BigDecimal> payEntryMap, Set<Long> payEntryIds, Set<Long> sourceIds, boolean isConfirm) {
        List disposeSelectors = FinApBillHandleHelper.getLockWBSelector();
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", disposeSelectors), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceIds.toArray())});
        if (apBills.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> apBillMap = new HashMap<Long, DynamicObject>(8);
        HashMap<Long, DynamicObject> apBillEntryMap = new HashMap<Long, DynamicObject>(8);
        int settleParam = ArApHelper.getApSettleParam((Object)apBills[0].getLong("org.id"));
        for (DynamicObject apBill : apBills) {
            apBillMap.put(apBill.getLong("id"), apBill);
            if (settleParam == 1) {
                DynamicObjectCollection detailEntries = apBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject detailEntry : detailEntries) {
                    apBillEntryMap.put(detailEntry.getLong("id"), detailEntry);
                }
                continue;
            }
            DynamicObjectCollection planEntries = apBill.getDynamicObjectCollection("planentity");
            for (DynamicObject planEntry : planEntries) {
                apBillEntryMap.put(planEntry.getLong("id"), planEntry);
            }
        }
        HashMap<Long, DisposerInfo> srcWriteBackFinApMap = new HashMap<Long, DisposerInfo>(64);
        for (DynamicObject payBill : payBills) {
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                BigDecimal priceTaxTotal;
                Long entryId = entry.getLong("id");
                Long sourceId = entry.getLong("e_sourcebillid");
                Long sourceEntryId = entry.getLong("e_sourcebillentryid");
                DynamicObject apBill = (DynamicObject)apBillMap.get(sourceId);
                BigDecimal disposeAmt = payEntryMap.get(entryId);
                if (apBill == null || disposeAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                if (settleParam == 1) {
                    DynamicObject detailEntry = (DynamicObject)apBillEntryMap.get(sourceEntryId);
                    priceTaxTotal = detailEntry.getBigDecimal("e_pricetaxtotal");
                    disposeAmt = disposeAmt.abs().multiply(new BigDecimal(priceTaxTotal.signum()));
                    if (isConfirm) {
                        detailEntry.set("lockedamt", (Object)detailEntry.getBigDecimal("lockedamt").subtract(disposeAmt));
                        detailEntry.set("unlockamt", (Object)detailEntry.getBigDecimal("unlockamt").add(disposeAmt));
                    } else {
                        detailEntry.set("lockedamt", (Object)detailEntry.getBigDecimal("lockedamt").add(disposeAmt));
                        detailEntry.set("unlockamt", (Object)detailEntry.getBigDecimal("unlockamt").subtract(disposeAmt));
                    }
                } else {
                    DynamicObject planEntry = (DynamicObject)apBillEntryMap.get(sourceEntryId);
                    priceTaxTotal = planEntry.getBigDecimal("planpricetax");
                    disposeAmt = disposeAmt.abs().multiply(new BigDecimal(priceTaxTotal.signum()));
                    if (isConfirm) {
                        planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").subtract(disposeAmt));
                        planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").add(disposeAmt));
                    } else {
                        planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(disposeAmt));
                        planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(disposeAmt));
                    }
                }
                DisposerInfo info = new DisposerInfo(sourceId, sourceEntryId, disposeAmt);
                srcWriteBackFinApMap.put(entryId, info);
            }
        }
        if (isConfirm) {
            FinApLockWBServiceHelper.inverseWriteBack(sourceIds, srcWriteBackFinApMap);
        } else {
            FinApLockWBServiceHelper.directWriteBack(sourceIds, srcWriteBackFinApMap);
        }
        SaveServiceHelper.save((DynamicObject[])apBillMap.values().toArray(new DynamicObject[0]));
    }

    private static void resolveArBillDispose(DynamicObject[] payBills, Map<Long, BigDecimal> payEntryMap, Set<Long> payEntryIds, Set<Long> sourceIds, boolean isConfirm) {
        List disposeSelectors = FinArBillHandleHelper.getLockWBSelector();
        DynamicObject[] arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", disposeSelectors), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceIds.toArray())});
        if (arBills.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> arBillMap = new HashMap<Long, DynamicObject>(8);
        HashMap<Long, DynamicObject> arBillEntryMap = new HashMap<Long, DynamicObject>(8);
        int settleParam = ArApHelper.getArSettleParam((Object)arBills[0].getLong("org.id"));
        for (DynamicObject arBill : arBills) {
            arBillMap.put(arBill.getLong("id"), arBill);
            Long orgId = arBill.getLong("org.id");
            if (ArApHelper.getArSettleParam((Object)orgId) == 1) {
                DynamicObjectCollection detailEntries = arBill.getDynamicObjectCollection("entry");
                for (DynamicObject detailEntry : detailEntries) {
                    arBillEntryMap.put(detailEntry.getLong("id"), detailEntry);
                }
                continue;
            }
            DynamicObjectCollection planEntries = arBill.getDynamicObjectCollection("planentity");
            for (DynamicObject planEntry : planEntries) {
                arBillEntryMap.put(planEntry.getLong("id"), planEntry);
            }
        }
        HashMap<Long, DisposerInfo> srcWriteBackFinArMap = new HashMap<Long, DisposerInfo>(64);
        for (DynamicObject payBill : payBills) {
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long entryId = entry.getLong("id");
                Long sourceId = entry.getLong("e_sourcebillid");
                Long sourceEntryId = entry.getLong("e_sourcebillentryid");
                DynamicObject arBill = (DynamicObject)arBillMap.get(sourceId);
                BigDecimal disposeAmt = payEntryMap.get(entryId);
                if (arBill == null || disposeAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                disposeAmt = disposeAmt.negate();
                if (settleParam == 1) {
                    DynamicObject detailEntry = (DynamicObject)arBillEntryMap.get(sourceEntryId);
                    if (isConfirm) {
                        detailEntry.set("e_lockedamt", (Object)detailEntry.getBigDecimal("e_lockedamt").subtract(disposeAmt));
                        detailEntry.set("e_unlockamt", (Object)detailEntry.getBigDecimal("e_unlockamt").add(disposeAmt));
                    } else {
                        detailEntry.set("e_lockedamt", (Object)detailEntry.getBigDecimal("e_lockedamt").add(disposeAmt));
                        detailEntry.set("e_unlockamt", (Object)detailEntry.getBigDecimal("e_unlockamt").subtract(disposeAmt));
                    }
                } else {
                    DynamicObject planEntry = (DynamicObject)arBillEntryMap.get(sourceEntryId);
                    if (isConfirm) {
                        planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").subtract(disposeAmt));
                        planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").add(disposeAmt));
                    } else {
                        planEntry.set("planlockedamt", (Object)planEntry.getBigDecimal("planlockedamt").add(disposeAmt));
                        planEntry.set("unplanlockamt", (Object)planEntry.getBigDecimal("unplanlockamt").subtract(disposeAmt));
                    }
                }
                DisposerInfo info = new DisposerInfo(sourceId, sourceEntryId, disposeAmt);
                srcWriteBackFinArMap.put(entryId, info);
            }
        }
        if (isConfirm) {
            FinArLockWBServiceHelper.inverseWriteBack(sourceIds, srcWriteBackFinArMap);
        } else {
            FinArLockWBServiceHelper.directWriteBack(sourceIds, srcWriteBackFinArMap);
        }
        SaveServiceHelper.save((DynamicObject[])arBillMap.values().toArray(new DynamicObject[0]));
    }
}

