/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.mservice.RefundAndRenoteConfirmHelper;
import kd.fi.ap.vo.PayRefundEntryInfo;
import kd.fi.ap.vo.RefundAndRenoteParam;
import kd.fi.arapcommon.api.param.AssignSettleParam;
import kd.fi.arapcommon.api.param.SettleDetailParam;
import kd.fi.arapcommon.api.param.SettleResult;
import kd.fi.arapcommon.api.settle.ISettleService;
import kd.fi.arapcommon.enums.SettleDetailTypeEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.freeze.RefundAndRenoteFreezeService;

public class RefundAndRenoteNewExecutor {
    private static final Log logger = LogFactory.getLog(RefundAndRenoteNewExecutor.class);
    private Long batchId = 0L;
    private Date globalSetleDate;

    public void confirm(RefundAndRenoteParam refundAndRenoteParam) {
        logger.info("RefundAndRenoteNewExecutor.confirm start");
        Long recBillId = refundAndRenoteParam.getRecId();
        Set payIds = refundAndRenoteParam.getPayInfos().stream().map(PayRefundEntryInfo::getPayId).collect(Collectors.toSet());
        ConcurrencyCtrlUtil.addCtrlInTX((String)"cas_paybill", (String)"refundandrenoteconfirm", payIds, (boolean)false);
        boolean exists = QueryServiceHelper.exists((String)"ap_refundrenote_record", (QFilter[])new QFilter[]{new QFilter("paybillid", "in", payIds), new QFilter("recbillid", "=", (Object)recBillId)});
        if (exists) {
            logger.info("refundRecords is not null, return");
            return;
        }
        this.executeApPayUnSettle(refundAndRenoteParam);
        this.globalSetleDate = this.executePayRecSettle(refundAndRenoteParam);
        this.executeApPaySettle();
        this.executeWriteBackFinOrApplyBill(refundAndRenoteParam);
        logger.info("RefundAndRenoteNewExecutor.confirm end");
    }

    private void executeApPayUnSettle(RefundAndRenoteParam refundAndRenoteParam) {
        logger.info("RefundAndRenoteNewExecutor.executeApPayUnSettle(ArPayUnSettle) start");
        Set<Long> payIds = refundAndRenoteParam.getPayInfos().stream().map(PayRefundEntryInfo::getPayId).collect(Collectors.toSet());
        List<DynamicObject> settleRecords = this.getSettleRecords(payIds);
        if (settleRecords.size() == 0) {
            return;
        }
        this.settleRecordRemove(settleRecords, refundAndRenoteParam.getPayInfos());
        if (settleRecords.size() == 0) {
            return;
        }
        this.insertRefundRecord(settleRecords, refundAndRenoteParam.getRecId(), refundAndRenoteParam.getPayInfos());
        HashSet<Long> payEntryIds = new HashSet<Long>(8);
        for (PayRefundEntryInfo payInfo : refundAndRenoteParam.getPayInfos()) {
            if (payInfo.getEntryRefundAmt().compareTo(BigDecimal.ZERO) == 0) continue;
            Long entryId = payInfo.getEntryId();
            payEntryIds.add(entryId);
        }
        RefundAndRenoteConfirmHelper.payUnSettle(settleRecords, payEntryIds);
        RefundAndRenoteFreezeService service = new RefundAndRenoteFreezeService();
        service.freeze(new HashSet<Long>(payEntryIds), true);
        logger.info("RefundAndRenoteNewExecutor.executeApPayUnSettle(ArPayUnSettle) end");
    }

    private Date executePayRecSettle(RefundAndRenoteParam refundAndRenoteParam) {
        logger.info("RefundAndRenoteNewExecutor.executePayRecSettle start");
        Long recId = refundAndRenoteParam.getRecId();
        List payInfos = refundAndRenoteParam.getPayInfos();
        HashSet<Long> payIds = new HashSet<Long>(1);
        HashSet<Long> payEntryIds = new HashSet<Long>(8);
        HashMap<Long, BigDecimal> needSettleEntryMap = new HashMap<Long, BigDecimal>(payInfos.size());
        for (PayRefundEntryInfo payInfo : payInfos) {
            payIds.add(payInfo.getPayId());
            payEntryIds.add(payInfo.getEntryId());
            needSettleEntryMap.put(payInfo.getEntryId(), payInfo.getEntryRefundAmt());
        }
        Date globalSettleDate = RefundAndRenoteConfirmHelper.payRecSettle(recId, payIds, payEntryIds, needSettleEntryMap);
        logger.info("RefundAndRenoteNewExecutor.executePayRecSettle end");
        return globalSettleDate;
    }

    private void executeApPaySettle() {
        DynamicObject[] payBills;
        BigDecimal unSettleAmt;
        DynamicObject planEntry;
        Iterator planEntries;
        BigDecimal unSettleAmt2;
        Object detailEntry2;
        DynamicObjectCollection detailEntries;
        logger.info("RefundAndRenoteNewExecutor.executeApPaySettle(executeArPaySettle) start");
        if (this.batchId == 0L) {
            return;
        }
        DynamicObject[] refundRecords = BusinessDataServiceHelper.load((String)"ap_refundrenote_record", (String)"org,settlerelation,finbillid,finbillentryid,paybillid,paybillentryid,oldsettleamt,newsettleamt,settletype,autosettletype", (QFilter[])new QFilter[]{new QFilter("batchid", "=", (Object)this.batchId)});
        if (refundRecords.length == 0) {
            return;
        }
        HashSet<Long> apBillIds = new HashSet<Long>(1);
        HashSet<Long> arBillIds = new HashSet<Long>(1);
        HashSet<Long> payBillIds = new HashSet<Long>(1);
        for (DynamicObject refundRecord : refundRecords) {
            String settleRelation = refundRecord.getString("settlerelation");
            if ("appaysettle".equals(settleRelation)) {
                apBillIds.add(refundRecord.getLong("finbillid"));
            } else {
                arBillIds.add(refundRecord.getLong("finbillid"));
            }
            payBillIds.add(refundRecord.getLong("paybillid"));
        }
        HashMap<Long, BigDecimal> finBillEntryIdToUnSettleAmt = new HashMap<Long, BigDecimal>(8);
        if (apBillIds.size() > 0) {
            DynamicObject[] apBills;
            for (DynamicObject apBill : apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,org,unsettleamt,unplansettleamt", (QFilter[])new QFilter[]{new QFilter("id", "in", apBillIds)})) {
                detailEntries = apBill.getDynamicObjectCollection("detailentry");
                for (Object detailEntry2 : detailEntries) {
                    unSettleAmt2 = detailEntry2.getBigDecimal("unsettleamt");
                    if (unSettleAmt2.compareTo(BigDecimal.ZERO) == 0) continue;
                    finBillEntryIdToUnSettleAmt.put(detailEntry2.getLong("id"), unSettleAmt2);
                }
                planEntries = apBill.getDynamicObjectCollection("planentity");
                detailEntry2 = planEntries.iterator();
                while (detailEntry2.hasNext()) {
                    planEntry = (DynamicObject)detailEntry2.next();
                    unSettleAmt = planEntry.getBigDecimal("unplansettleamt");
                    if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    finBillEntryIdToUnSettleAmt.put(planEntry.getLong("id"), unSettleAmt);
                }
            }
        }
        if (arBillIds.size() > 0) {
            DynamicObject[] arBills;
            for (DynamicObject arBill : arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,org,e_unsettleamt,unplansettleamt", (QFilter[])new QFilter[]{new QFilter("id", "in", arBillIds)})) {
                detailEntries = arBill.getDynamicObjectCollection("entry");
                for (Object detailEntry2 : detailEntries) {
                    unSettleAmt2 = detailEntry2.getBigDecimal("e_unsettleamt");
                    if (unSettleAmt2.compareTo(BigDecimal.ZERO) == 0) continue;
                    finBillEntryIdToUnSettleAmt.put(detailEntry2.getLong("id"), unSettleAmt2);
                }
                planEntries = arBill.getDynamicObjectCollection("planentity");
                detailEntry2 = planEntries.iterator();
                while (detailEntry2.hasNext()) {
                    planEntry = (DynamicObject)detailEntry2.next();
                    unSettleAmt = planEntry.getBigDecimal("unplansettleamt");
                    if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    finBillEntryIdToUnSettleAmt.put(planEntry.getLong("id"), unSettleAmt);
                }
            }
        }
        HashMap<Long, BigDecimal> payBillEntryIdToUnSettleAmt = new HashMap<Long, BigDecimal>(8);
        for (DynamicObject payBill : payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,e_unsettledamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIds)})) {
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                payBillEntryIdToUnSettleAmt.put(entry.getLong("id"), unSettleAmt);
            }
        }
        for (DynamicObject refundRecord : refundRecords) {
            long finBillEntryId = refundRecord.getLong("finbillentryid");
            long payBillEntryId = refundRecord.getLong("paybillentryid");
            BigDecimal finUnSettleAmt = (BigDecimal)finBillEntryIdToUnSettleAmt.get(finBillEntryId);
            BigDecimal payUnSettleAmt = (BigDecimal)payBillEntryIdToUnSettleAmt.get(payBillEntryId);
            if (finUnSettleAmt == null || payUnSettleAmt == null || finUnSettleAmt.compareTo(BigDecimal.ZERO) == 0 || payUnSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal oldSettleAmt = refundRecord.getBigDecimal("oldsettleamt");
            BigDecimal newSettleAmt = finUnSettleAmt.abs().compareTo(payUnSettleAmt.abs()) > 0 ? payUnSettleAmt.abs() : finUnSettleAmt.abs();
            if (newSettleAmt.compareTo(oldSettleAmt.abs()) > 0) {
                newSettleAmt = oldSettleAmt.abs();
            }
            refundRecord.set("newsettleamt", (Object)newSettleAmt.multiply(new BigDecimal(oldSettleAmt.signum())));
            finBillEntryIdToUnSettleAmt.put(finBillEntryId, finUnSettleAmt.subtract(newSettleAmt.multiply(new BigDecimal(finUnSettleAmt.signum()))));
            payBillEntryIdToUnSettleAmt.put(payBillEntryId, payUnSettleAmt.subtract(newSettleAmt.multiply(new BigDecimal(payUnSettleAmt.signum()))));
        }
        SaveServiceHelper.save((DynamicObject[])refundRecords);
        HashMap<Long, ArrayList<DynamicObject>> refundRecordGroupOrgMap = new HashMap<Long, ArrayList<DynamicObject>>(8);
        for (DynamicObject refundRecord : refundRecords) {
            ArrayList<DynamicObject> result = (ArrayList<DynamicObject>)refundRecordGroupOrgMap.get(refundRecord.getLong("org.id"));
            if (result == null) {
                result = new ArrayList<DynamicObject>(1);
                result.add(refundRecord);
                refundRecordGroupOrgMap.put(refundRecord.getLong("org.id"), result);
                continue;
            }
            result.add(refundRecord);
        }
        ArrayList settleRecordPks = new ArrayList(8);
        for (Map.Entry orgToRefundRecords : refundRecordGroupOrgMap.entrySet()) {
            ISettleService service;
            AssignSettleParam param;
            Long orgId = (Long)orgToRefundRecords.getKey();
            logger.info("RefundAndRenoteNewExecutor executeApPaySettle(ArPaySettle) orgid : " + orgId);
            List records = (List)orgToRefundRecords.getValue();
            ArrayList<SettleDetailParam> mainApDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> mainArDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> asstApToPayDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> asstArToPayDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> botpMainApDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> botpMainArDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> botpAsstApToPayDetailParam = new ArrayList<SettleDetailParam>(1);
            ArrayList<SettleDetailParam> botpAsstArToPayDetailParam = new ArrayList<SettleDetailParam>(1);
            for (DynamicObject refundRecord : records) {
                long recordId = refundRecord.getLong("id");
                String settleRelation = refundRecord.getString("settlerelation");
                long finBillId = refundRecord.getLong("finbillid");
                long finBillEntryId = refundRecord.getLong("finbillentryid");
                long payBillId = refundRecord.getLong("paybillid");
                long payBillEntryId = refundRecord.getLong("paybillentryid");
                BigDecimal needSettleAmt = refundRecord.getBigDecimal("newsettleamt");
                if (needSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                SettleDetailParam mainParam = new SettleDetailParam(finBillId, finBillEntryId, needSettleAmt, true);
                mainParam.setMatchFieldValue("matchId", (Object)recordId);
                mainParam.setMatchFieldValue("settletype", (Object)refundRecord.getString("settletype"));
                String autoSettleType = refundRecord.getString("autosettletype");
                mainParam.setMatchFieldValue("autosettletype", (Object)autoSettleType);
                SettleDetailParam asstParam = new SettleDetailParam(payBillId, payBillEntryId, needSettleAmt, true);
                asstParam.setMatchFieldValue("matchId", (Object)recordId);
                if ("appaysettle".equals(settleRelation)) {
                    if ("1".equals(autoSettleType)) {
                        botpMainApDetailParam.add(mainParam);
                        botpAsstApToPayDetailParam.add(asstParam);
                        continue;
                    }
                    mainApDetailParam.add(mainParam);
                    asstApToPayDetailParam.add(asstParam);
                    continue;
                }
                mainParam.setSettleAmt(needSettleAmt.negate());
                if ("1".equals(autoSettleType)) {
                    botpMainArDetailParam.add(mainParam);
                    botpAsstArToPayDetailParam.add(asstParam);
                    continue;
                }
                mainArDetailParam.add(mainParam);
                asstArToPayDetailParam.add(asstParam);
            }
            if (botpMainApDetailParam.size() > 0 && botpAsstApToPayDetailParam.size() > 0) {
                logger.info("RefundAndRenoteNewExecutor executeApPaySettle(botp)");
                param = this.buildAssignSettleParam(orgId, true, botpMainApDetailParam, botpAsstApToPayDetailParam);
                service = ArApServiceAPIFactory.getSettleService((String)"appaysettle");
                SettleResult settleResult = service.assignSettle(param);
                settleRecordPks.addAll(settleResult.getSettleRecordPKs());
            }
            if (mainApDetailParam.size() > 0 && asstApToPayDetailParam.size() > 0) {
                logger.info("RefundAndRenoteNewExecutor executeApPaySettle(not botp)");
                param = this.buildAssignSettleParam(orgId, false, mainApDetailParam, asstApToPayDetailParam);
                service = ArApServiceAPIFactory.getSettleService((String)"appaysettle");
                SettleResult settleResult = service.assignSettle(param);
                settleRecordPks.addAll(settleResult.getSettleRecordPKs());
            }
            if (botpMainArDetailParam.size() > 0 && botpAsstArToPayDetailParam.size() > 0) {
                logger.info("RefundAndRenoteNewExecutor executeArPaySettle(botp)");
                param = this.buildAssignSettleParam(orgId, true, botpMainArDetailParam, botpAsstArToPayDetailParam);
                service = ArApServiceAPIFactory.getSettleService((String)"arpaysettle");
                SettleResult settleResult = service.assignSettle(param);
                settleRecordPks.addAll(settleResult.getSettleRecordPKs());
            }
            if (mainArDetailParam.size() <= 0 || asstArToPayDetailParam.size() <= 0) continue;
            logger.info("RefundAndRenoteNewExecutor executeArPaySettle(not botp)");
            param = this.buildAssignSettleParam(orgId, false, mainArDetailParam, asstArToPayDetailParam);
            service = ArApServiceAPIFactory.getSettleService((String)"arpaysettle");
            SettleResult settleResult = service.assignSettle(param);
            settleRecordPks.addAll(settleResult.getSettleRecordPKs());
        }
        if (settleRecordPks.size() > 0) {
            DynamicObject[] settleRecords;
            for (DynamicObject settleRecord : settleRecords = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"id,settledate", (QFilter[])new QFilter[]{new QFilter("id", "in", settleRecordPks)})) {
                settleRecord.set("settledate", (Object)this.globalSetleDate);
            }
            SaveServiceHelper.save((DynamicObject[])settleRecords);
        }
        logger.info("RefundAndRenoteNewExecutor.executeApPaySettle(executeArPaySettle) end");
    }

    private AssignSettleParam buildAssignSettleParam(Long orgId, boolean isRefundByBotp, List<SettleDetailParam> mainParam, List<SettleDetailParam> asstParam) {
        AssignSettleParam param = new AssignSettleParam(orgId.longValue(), SettleTypeEnum.AUTO.getValue(), SettleDetailTypeEnum.BYENTRY.getValue());
        param.setRefundAndRenote(true);
        param.setMatchServiceClass("kd.fi.arapcommon.service.match.RefundAndRenoteSettleMatchService");
        param.setRefundByBotp(isRefundByBotp);
        param.setMainDetailParamList(mainParam);
        param.setAsstDetailParamList(asstParam);
        return param;
    }

    private void executeWriteBackFinOrApplyBill(RefundAndRenoteParam refundAndRenoteParam) {
        logger.info("RefundAndRenoteNewExecutor.executeWriteBackFinOrApplyBill start");
        Set<Long> payIds = refundAndRenoteParam.getPayInfos().stream().map(PayRefundEntryInfo::getPayId).collect(Collectors.toSet());
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"entry.id,entry.e_sourcebillid,entry.e_sourcebillentryid,sourcebilltype,billstatus,e_payableamt,e_refundamt", (QFilter[])new QFilter[]{new QFilter("id", "in", payIds)});
        HashMap<String, ArrayList<DynamicObject>> sourceBillTypeToPayBills = new HashMap<String, ArrayList<DynamicObject>>(1);
        for (DynamicObject payBill : payBills) {
            String sourcebilltype = payBill.getString("sourcebilltype");
            ArrayList<DynamicObject> groupPayBills = (ArrayList<DynamicObject>)sourceBillTypeToPayBills.get(sourcebilltype);
            if (groupPayBills == null) {
                groupPayBills = new ArrayList<DynamicObject>(payBills.length);
                groupPayBills.add(payBill);
                sourceBillTypeToPayBills.put(sourcebilltype, groupPayBills);
                continue;
            }
            groupPayBills.add(payBill);
        }
        logger.info("RefundAndRenoteNewExecutor.executeWriteBackFinOrApplyBill sourceBillTypeToPayBills.size = " + sourceBillTypeToPayBills.size());
        for (Map.Entry entry : sourceBillTypeToPayBills.entrySet()) {
            String sourceBillType = (String)entry.getKey();
            List value = (List)entry.getValue();
            if ("ap_payapply".equals(sourceBillType)) {
                Object payInfo22;
                logger.info("RefundAndRenoteNewExecutor.writeBackApplyBill start");
                List payInfos = refundAndRenoteParam.getPayInfos();
                HashMap needSettleEntryMap = new HashMap(payInfos.size());
                for (Object payInfo22 : payInfos) {
                    needSettleEntryMap.put(payInfo22.getEntryId(), payInfo22.getEntryRefundAmt());
                }
                ArrayList params = new ArrayList(8);
                payInfo22 = value.iterator();
                while (payInfo22.hasNext()) {
                    DynamicObject payBill = (DynamicObject)payInfo22.next();
                    DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
                    for (DynamicObject entry2 : entrys) {
                        HashMap<String, Object> param = new HashMap<String, Object>(6);
                        param.put("sourcepk", entry2.getLong("e_sourcebillid"));
                        param.put("sourceentrypk", entry2.getLong("e_sourcebillentryid"));
                        param.put("operate", "I".equals(payBill.getString("billstatus")) ? "refund" : "renote");
                        param.put("issuccess", true);
                        param.put("payableamt", entry2.getBigDecimal("e_payableamt"));
                        param.put("refundamt", needSettleEntryMap.get(entry2.getLong("id")) == null ? BigDecimal.ZERO : needSettleEntryMap.get(entry2.getLong("id")));
                        params.add(param);
                    }
                }
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"payO2OService", (String)"syncBill", (Object[])new Object[]{params});
                logger.info("RefundAndRenoteNewExecutor.writeBackApplyBill end");
                continue;
            }
            if (!"ap_finapbill".equals(sourceBillType) && !"ar_finarbill".equals(sourceBillType)) continue;
            logger.info("RefundAndRenoteNewExecutor.writeBackFinBill start");
            HashSet<Long> upFinPayBillIds = new HashSet<Long>(value.size());
            for (DynamicObject payBill : value) {
                upFinPayBillIds.add(payBill.getLong("id"));
            }
            List payInfos = refundAndRenoteParam.getPayInfos();
            Set<Long> payEntryIds = payInfos.stream().map(PayRefundEntryInfo::getEntryId).collect(Collectors.toSet());
            Map payEntryIdToFinEntryId = BOTPNewHelper.loadNearSourceRowIds((String)"cas_paybill", (String)"entry", (Long[])payIds.toArray(new Long[0]), (Long[])payEntryIds.toArray(new Long[0]), (String)sourceBillType);
            HashMap<Long, BigDecimal> needSettleEntryMap = new HashMap<Long, BigDecimal>(payInfos.size());
            for (PayRefundEntryInfo payInfo : payInfos) {
                if (!upFinPayBillIds.contains(payInfo.getPayId()) || payEntryIdToFinEntryId.get(payInfo.getEntryId()) == null) continue;
                needSettleEntryMap.put(payInfo.getEntryId(), payInfo.getEntryRefundAmt());
            }
            RefundAndRenoteConfirmHelper.writeBackFinBill(upFinPayBillIds, needSettleEntryMap, true);
            logger.info("RefundAndRenoteNewExecutor.writeBackFinBill end");
        }
        logger.info("RefundAndRenoteNewExecutor.executeWriteBackFinOrApplyBill end");
    }

    private void insertRefundRecord(List<DynamicObject> settleRecords, Long recId, List<PayRefundEntryInfo> payInfos) {
        HashMap<Long, Long> payEntryIdExistMap = new HashMap<Long, Long>(payInfos.size());
        for (PayRefundEntryInfo payInfo : payInfos) {
            if (payInfo.getEntryRefundAmt().compareTo(BigDecimal.ZERO) == 0) continue;
            Long entryId = payInfo.getEntryId();
            payEntryIdExistMap.put(entryId, entryId);
        }
        long batchId = ID.genLongId();
        this.batchId = batchId;
        Date currentDate = new Date();
        ArrayList<DynamicObject> refundRecords = new ArrayList<DynamicObject>(settleRecords.size());
        for (DynamicObject settleRecord : settleRecords) {
            long orgId = settleRecord.getLong("org.id");
            long mainBillId = settleRecord.getLong("mainbillid");
            long mainBillEntryId = settleRecord.getLong("mainbillentryid");
            String settleRelation = settleRecord.getString("settlerelation");
            String settletype = settleRecord.getString("settletype");
            String autosettletype = settleRecord.getString("autosettletype");
            Date settleDate = settleRecord.getDate("settledate");
            DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long asstBillId = entry.getLong("billid");
                long asstBillEntryId = entry.getLong("billentryid");
                if (payEntryIdExistMap.get(asstBillEntryId) == null) continue;
                DynamicObject refundRecord = BusinessDataServiceHelper.newDynamicObject((String)"ap_refundrenote_record");
                refundRecord.set("batchid", (Object)batchId);
                refundRecord.set("org", (Object)orgId);
                refundRecord.set("settlerelation", (Object)settleRelation);
                refundRecord.set("finbillid", (Object)mainBillId);
                refundRecord.set("finbillentryid", (Object)mainBillEntryId);
                refundRecord.set("paybillid", (Object)asstBillId);
                refundRecord.set("paybillentryid", (Object)asstBillEntryId);
                refundRecord.set("recbillid", (Object)recId);
                refundRecord.set("oldsettleamt", entry.get("settleamt"));
                refundRecord.set("settletype", (Object)settletype);
                refundRecord.set("autosettletype", (Object)autosettletype);
                refundRecord.set("createtime", (Object)currentDate);
                refundRecord.set("settledate", (Object)settleDate);
                refundRecords.add(refundRecord);
            }
        }
        SaveServiceHelper.save((DynamicObject[])refundRecords.toArray(new DynamicObject[0]));
    }

    private void settleRecordRemove(List<DynamicObject> settleRecords, List<PayRefundEntryInfo> payInfos) {
        HashMap<Long, Long> payEntryIdExistMap = new HashMap<Long, Long>(payInfos.size());
        for (PayRefundEntryInfo payInfo : payInfos) {
            if (payInfo.getEntryRefundAmt().compareTo(BigDecimal.ZERO) == 0) continue;
            Long entryId = payInfo.getEntryId();
            payEntryIdExistMap.put(entryId, entryId);
        }
        Iterator<DynamicObject> iterator = settleRecords.iterator();
        while (iterator.hasNext()) {
            DynamicObject settleRecord = iterator.next();
            DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
            boolean isExist = false;
            for (DynamicObject entry : entries) {
                long entryId = entry.getLong("billentryid");
                if (payEntryIdExistMap.get(entryId) == null) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            iterator.remove();
        }
    }

    private List<DynamicObject> getSettleRecords(Set<Long> payIds) {
        ArrayList<String> settleRelations = new ArrayList<String>(2);
        settleRelations.add(SettleRelationEnum.APPAYSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.ARPAYSETTLE.getValue());
        QFilter filter = new QFilter("settlerelation", "in", settleRelations);
        filter.and("entry.billid", "in", payIds);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecords = SettleRecordQueryHelper.getSettleRecords((String)"ap_settlerecord", (String)"id,org,settletype,settledate,settlerelation,mainbillid,mainbilltype,maincurrency,mainbillentryid,totalsettleamt,localtotalsettleamt,exchangerate,swappl,autosettletype,corebillid,corebillentryid,settleentry,billentity,mainpayableamt,settlerelation,iswrittenoff,hadwrittenoff,entry.billtype,entry.currency,entry.settleamt,entry.e_billentity,entry.billid,entry.billentryid,entry.e_swappl,entry.e_exchangerate,entry.e_settleentry,entry.e_hadwrittenoff,isvoucher,entry.payableamt,entry.localsettleamt,settletype", (String)"cas_paybill", (Object[])payIds.toArray(), (QFilter)filter);
        return Arrays.stream(settleRecords).collect(Collectors.toList());
    }
}

