/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.balance.BalanceQuerier;
import kd.fi.arapcommon.balance.BalanceType;
import kd.fi.arapcommon.util.DateUtils;

public class SupplierBalanceQueryService {
    public List<Map<String, Object>> queryBalance(List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> balanceList = new ArrayList<Map<String, Object>>(16);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        HashSet<Long> asstactIds = new HashSet<Long>(16);
        HashMap<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>(16);
        for (Map<String, Object> param : params) {
            Long orgId = (Long)param.get("org");
            orgIds.add(orgId);
            asstactIds.add((Long)param.get("asstact"));
        }
        Date standardCloseDate = DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)new Date(), (int)1), (boolean)false);
        List<String> balanceDimensions = this.getBalanceDimensions();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("asstact", "in", asstactIds));
        BalanceQuerier querier = new BalanceQuerier(BalanceType.AP_FIN);
        DataSet blDataSet = querier.queryBalance(orgIds, standardCloseDate, balanceDimensions, filters);
        while (blDataSet.hasNext()) {
            Row row = blDataSet.next();
            String currencyKey = row.getLong("org") + "_" + row.getLong("asstact") + "_" + row.getLong("currency");
            String baseCurrencyKey = row.getLong("org") + "_" + row.getLong("asstact");
            balanceMap.put(currencyKey, row.getBigDecimal("periodamt"));
            BigDecimal localPeriodAmt = (BigDecimal)balanceMap.get(baseCurrencyKey);
            if (localPeriodAmt == null) {
                balanceMap.put(baseCurrencyKey, row.getBigDecimal("localperiodamt"));
                continue;
            }
            balanceMap.put(baseCurrencyKey, localPeriodAmt.add(row.getBigDecimal("localperiodamt")));
        }
        for (Map<String, Object> param : params) {
            Long orgId = (Long)param.get("org");
            Long asstactId = (Long)param.get("asstact");
            Long currencyId = (Long)param.get("currency");
            String currencyKey = orgId + "_" + asstactId + "_" + currencyId;
            String baseCurrencyKey = orgId + "_" + asstactId;
            BigDecimal balanceAmt = balanceMap.getOrDefault(currencyKey, BigDecimal.ZERO);
            BigDecimal localBalanceAmt = balanceMap.getOrDefault(baseCurrencyKey, BigDecimal.ZERO);
            HashMap<String, Number> map = new HashMap<String, Number>(16);
            map.put("org", orgId);
            map.put("asstact", asstactId);
            map.put("currency", currencyId);
            map.put("balanceamt", balanceAmt);
            map.put("localbalanceamt", localBalanceAmt);
            balanceList.add(map);
        }
        return balanceList;
    }

    private List<String> getBalanceDimensions() {
        ArrayList<String> balanceDimensions = new ArrayList<String>(16);
        balanceDimensions.add("org");
        balanceDimensions.add("asstact");
        balanceDimensions.add("currency");
        balanceDimensions.add("basecurrency");
        return balanceDimensions;
    }
}

