/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.mservice.SettleServiceFactory;
import kd.fi.ap.mservice.TranspaySettleService;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.service.AbsAutoSettleService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class TranspayAutoSettleService
extends AbsAutoSettleService {
    private TranspaySettleService service = new TranspaySettleService();

    public void autoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        if (isMain) {
            String billNo = obj.getString("billno");
            throw new KDBizException(ResManager.loadKDString((String)"%s\uff1a\u8f6c\u4ed8\u4e1a\u52a1\u4e0d\u652f\u6301\u7531\u4e3b\u65b9\uff08\u4e0a\u6e38\u5355\u636e\uff09\u53d1\u8d77\u7684\u7ed3\u7b97\u3002", (String)"TranspayAutoSettleService_0", (String)"fi-ap-mservice", (Object[])new Object[]{billNo}));
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setTransferPay(true);
        scheme.setOnlyByBotp(true);
        DynamicObject[] assts = new DynamicObject[]{obj};
        DynamicObject[] mains = this.getMainObjs(obj);
        this.addSettleLock(mains, assts);
        this.service.settle(mains, assts, scheme, SettleTypeEnum.AUTO.getValue());
    }

    private DynamicObject[] getMainObjs(DynamicObject obj) {
        Set souBillIdSet = BOTPHelper.loadNearUpBillIdSet((String)"ap_finapbill", (String)"ap_finapbill", (Long[])new Long[]{obj.getLong("id")});
        if (souBillIdSet.size() > 0) {
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", (Object)souBillIdSet), new QFilter("billstatus", "=", (Object)"C"), new QFilter("detailentry.unsettleamt", "!=", (Object)0)};
            return FinApBillHandleHelper.load((QFilter[])filter);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u672c\u5355\u636e\u4e0e\u4e0a\u6e38\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u5173\u8054\u5173\u7cfb\u3002", (String)"TranspayAutoSettleService_1", (String)"fi-ap-mservice", (Object[])new Object[0]));
    }

    public AbstractSettleTemplate getSettleService(String settleRelation) {
        return SettleServiceFactory.getService(settleRelation);
    }
}

