/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.api.push;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.mservice.api.push.PushBusApBillServiceImpl;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.BillHeadAmtParam;
import kd.fi.arapcommon.api.param.CalculatorParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;

public class BusBillWoffServiceImpl
extends PushBusApBillServiceImpl {
    private String woffRuleId = "712748085842822144";

    public List<Object> assignBillPush(String sourEntity, List<AssignBillPushParam> paramList) {
        return this.assignBillPush(sourEntity, paramList, this.woffRuleId);
    }

    public List<Object> assignBillPush(String sourEntity, List<AssignBillPushParam> paramList, String ruleId) {
        this.checkParam(sourEntity, "", paramList, false);
        Set<Long> billIdSet = paramList.stream().map(assignBillPushParam -> assignBillPushParam.getSourBillId()).collect(Collectors.toSet());
        OperationResult woffOpResult = OperationServiceHelper.executeOperate((String)"batchwoff", (String)"ap_busbill", (Object[])billIdSet.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)woffOpResult);
        Map tarBusBillMap = BOTPHelper.findTargetBills((String)"ap_busbill", (Long[])billIdSet.toArray(new Long[0]));
        ArrayList<Object> result = new ArrayList<Object>(billIdSet.size());
        HashSet tarIds = (HashSet)tarBusBillMap.get("ap_busbill");
        if (!ObjectUtils.isEmpty((Object)tarIds)) {
            result = new ArrayList(tarIds);
        }
        return result;
    }

    public List<Object> assignBillEntryPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList) {
        return this.assignBillEntryPush(sourEntity, sourEntryEntity, paramList, this.woffRuleId);
    }

    public List<Object> assignBillEntryPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId) {
        return super.assignBillEntryPush(sourEntity, sourEntryEntity, paramList, this.woffRuleId);
    }

    protected void checkParam(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, boolean assignEntry) {
        super.checkParam(sourEntity, sourEntryEntity, paramList, assignEntry);
        if (assignEntry) {
            Set billIdSet = paramList.stream().map(assignBillPushParam -> assignBillPushParam.getSourBillId()).collect(Collectors.toSet());
            OperationResult result = OperationServiceHelper.executeOperate((String)"woff", (String)"ap_busbill", (Object[])billIdSet.toArray(), (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)result);
        }
    }

    protected List<Object> saveTargetBills(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId, List<DynamicObject> targetBills) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isselfwoff", "true");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)this.getTargetEntity(), (DynamicObject[])targetBills.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)saveResult);
        return saveResult.getSuccessPkIds();
    }

    @Override
    public String getServiceName() {
        return ServiceNameEnum.BUSAPWOFF.getValue();
    }

    protected Map<String, String> getPushArgsMap() {
        Map paramMap = super.getPushArgsMap();
        paramMap.put("isselfwoff", "true");
        return paramMap;
    }

    protected List<BillHeadAmtParam> reCalculateEntryField(List<DynamicObject> targetBills, List<AssignBillPushParam> paramList) {
        ArrayList<BillHeadAmtParam> billHeadAmtParamList = new ArrayList<BillHeadAmtParam>(targetBills.size());
        for (DynamicObject targetBill : targetBills) {
            BillHeadAmtParam billHeadAmtParam = new BillHeadAmtParam(targetBill.getLong("id"));
            DynamicObjectCollection targetBillEntries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            DynamicObject payproperty = targetBill.getDynamicObject(this.billModel.HEAD_PAYPROPERTY);
            boolean isBaseAmt = payproperty.getBoolean("isbasedonamt");
            for (DynamicObject targetBillEntry : targetBillEntries) {
                long srcEntryId = targetBillEntry.getLong("e_srcentryid");
                Optional<AssignBillPushParam> entryParamOptional = paramList.stream().filter(entryPushParam -> srcEntryId == entryPushParam.getSourBillEntryId()).findFirst();
                AssignBillPushParam entryPushParam2 = entryParamOptional.get();
                Map tarFieldValueMap = entryPushParam2.getTarFieldValueMap();
                Object islast = tarFieldValueMap.get("islast");
                if (islast == null || isBaseAmt) {
                    CalculatorParam calParam = this.genCalculatorParam(targetBill, targetBillEntry);
                    TaxUnitPriceCalculator calculator = null;
                    if (calParam.isIncludeTax() && !calParam.isPriceTotal()) {
                        BigDecimal taxUnitPrice = calParam.getTaxUnitPrice();
                        calculator = new TaxUnitPriceCalculator(calParam.getQty(), taxUnitPrice, calParam.getTaxRate(), calParam.getDiscountMode(), calParam.getDiscountRate(), calParam.getCurrencyPrecision(), calParam.getAdjustAmt(), calParam.getDiscountAmt());
                    } else if (!calParam.isIncludeTax() && !calParam.isPriceTotal()) {
                        BigDecimal unitPrice = calParam.getUnitPrice();
                        calculator = new UnitPriceCalculator(calParam.getQty(), unitPrice, calParam.getTaxRate(), calParam.getDiscountMode(), calParam.getDiscountRate(), calParam.getCurrencyPrecision(), calParam.getAdjustAmt(), calParam.getDiscountAmt());
                    } else if (!calParam.isIncludeTax() && calParam.isPriceTotal()) {
                        BigDecimal amount = calParam.getAmount();
                        calculator = new PriceTotalCalculator(calParam.getQty(), amount, calParam.getTaxRate(), calParam.getDiscountMode(), calParam.getDiscountRate(), calParam.getCurrencyPrecision(), calParam.getAdjustAmt(), calParam.getDiscountAmt());
                    } else if (calParam.isIncludeTax() && calParam.isPriceTotal()) {
                        BigDecimal priceTaxTotal = calParam.getPriceTaxTotal();
                        calculator = new PriceTaxTotalCalculator(calParam.getQty(), priceTaxTotal, calParam.getTaxRate(), calParam.getDiscountMode(), calParam.getDiscountRate(), calParam.getCurrencyPrecision(), calParam.getAdjustAmt(), calParam.getDiscountAmt());
                    }
                    PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, calParam.getExchangeRate(), calParam.getBaseCurrencyPrecision(), calParam.getQuotation());
                    localCalculator.calculate();
                    this.resetEntryAmtField(localCalculator, targetBillEntry, paramList);
                    billHeadAmtParam.setAmount(billHeadAmtParam.getAmount().add(localCalculator.getAmount()));
                    billHeadAmtParam.setAmountLocal(billHeadAmtParam.getAmountLocal().add(localCalculator.getAmountlocal()));
                    billHeadAmtParam.setPriceTaxTotal(billHeadAmtParam.getPriceTaxTotal().add(localCalculator.getPricetaxtotal()));
                    billHeadAmtParam.setPriceTaxTotalLocal(billHeadAmtParam.getPriceTaxTotalLocal().add(localCalculator.getPricetaxtotallocal()));
                    billHeadAmtParam.setTaxAmt(billHeadAmtParam.getTaxAmt().add(localCalculator.getTax()));
                    billHeadAmtParam.setTaxAmtLocal(billHeadAmtParam.getTaxAmtLocal().add(localCalculator.getTaxlocal()));
                    billHeadAmtParam.setAdjustAmt(billHeadAmtParam.getAdjustAmt().add(localCalculator.getAdjustamt()));
                    billHeadAmtParam.setAdjustAmtLocal(billHeadAmtParam.getAdjustAmtLocal().add(localCalculator.getAdjustamtlocal()));
                    continue;
                }
                billHeadAmtParam.setAmount(billHeadAmtParam.getAmount().add(targetBillEntry.getBigDecimal(this.billModel.E_AMOUNT)));
                billHeadAmtParam.setAmountLocal(billHeadAmtParam.getAmountLocal().add(targetBillEntry.getBigDecimal(this.billModel.E_LOCALAMT)));
                billHeadAmtParam.setPriceTaxTotal(billHeadAmtParam.getPriceTaxTotal().add(targetBillEntry.getBigDecimal(this.billModel.E_PRICETAXTOTAL)));
                billHeadAmtParam.setPriceTaxTotalLocal(billHeadAmtParam.getPriceTaxTotalLocal().add(targetBillEntry.getBigDecimal(this.billModel.E_PRICETAXTOTALLOC)));
                billHeadAmtParam.setTaxAmt(billHeadAmtParam.getTaxAmt().add(targetBillEntry.getBigDecimal(this.billModel.E_TAX)));
                billHeadAmtParam.setTaxAmtLocal(billHeadAmtParam.getTaxAmtLocal().add(targetBillEntry.getBigDecimal(this.billModel.E_TAXLOCALAMT)));
            }
            billHeadAmtParamList.add(billHeadAmtParam);
        }
        return billHeadAmtParamList;
    }

    protected void checkAfterPush(List<AssignBillPushParam> paramList, List<DynamicObject> targetBills) {
        for (DynamicObject targetBill : targetBills) {
            DynamicObject payproperty = targetBill.getDynamicObject(this.billModel.HEAD_PAYPROPERTY);
            Long sourceBillId = Long.valueOf(targetBill.getString(this.billModel.HEAD_SOURCEBILLID));
            boolean isBaseAmt = payproperty.getBoolean("isbasedonamt");
            boolean isIncludeTax = targetBill.getBoolean(this.billModel.HEAD_ISINCLUDETAX);
            boolean isPricetotal = targetBill.getBoolean(this.billModel.HEAD_ISPRICETOTAL);
            for (AssignBillPushParam param : paramList) {
                Long paramBillId = param.getSourBillId();
                if (sourceBillId.compareTo(paramBillId) != 0) continue;
                Map tarFieldValueMap = param.getTarFieldValueMap();
                Object priceTaxTotal = tarFieldValueMap.get(this.billModel.E_PRICETAXTOTAL);
                Object amount = tarFieldValueMap.get(this.billModel.E_AMOUNT);
                Object price = tarFieldValueMap.get(this.billModel.E_UNITPRICE);
                Object taxPrice = tarFieldValueMap.get(this.billModel.E_TAXUNITPRICE);
                if (isBaseAmt) {
                    BigDecimal qty;
                    if (tarFieldValueMap.get(this.billModel.E_QUANTITY) != null && (qty = (BigDecimal)tarFieldValueMap.get(this.billModel.E_QUANTITY)).abs().compareTo(BigDecimal.ONE) != 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u57fa\u51c6\u4e0b\uff0c\u51b2\u56de\u5355\u6570\u91cf\u53ea\u80fd\u4e3a1\u6216-1\u3002", (String)"PushBusApBillServiceImpl_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                    if (isIncludeTax) {
                        if (isPricetotal) {
                            if (priceTaxTotal != null) continue;
                            throw new KDBizException(ResManager.loadKDString((String)"\u5f55\u5165\u603b\u4ef7\u6253\u5f00\u3001\u5f55\u5165\u542b\u7a0e\u4ef7\u6253\u5f00\u9700\u4f20\u5165\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"PushBusApBillServiceImpl_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                        }
                        if (taxPrice != null) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f55\u5165\u603b\u4ef7\u6253\u5f00\u3001\u5f55\u5165\u542b\u7a0e\u4ef7\u5173\u95ed\u9700\u4f20\u5165\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PushBusApBillServiceImpl_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                    if (isPricetotal) {
                        if (amount != null) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f55\u5165\u603b\u4ef7\u6253\u5f00\u3001\u5f55\u5165\u542b\u7a0e\u4ef7\u5173\u95ed\u9700\u4f20\u5165\u91d1\u989d\u3002", (String)"PushBusApBillServiceImpl_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                    if (price != null) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f55\u5165\u603b\u4ef7\u5173\u95ed\u3001\u5f55\u5165\u542b\u7a0e\u4ef7\u5173\u95ed\u9700\u4f20\u5165\u5355\u4ef7\u3002", (String)"PushBusApBillServiceImpl_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                if (priceTaxTotal == null && amount == null) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u91cf\u57fa\u51c6\u90e8\u5206\u51b2\u56de\u53ea\u5141\u8bb8\u4fee\u6539\u6570\u91cf\u3002", (String)"PushBusApBillServiceImpl_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }
}

