/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.api.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.service.bus.ApWoffService;
import kd.fi.arapcommon.service.bus.WoffDetailInfo;

public class FinApService {
    public DynamicObject[] queryFinBills(List<WoffDetailInfo> woffDetailInfos) {
        Set finIds = woffDetailInfos.stream().map(WoffDetailInfo::getFinId).collect(Collectors.toSet());
        Set finBillNos = woffDetailInfos.stream().filter(woffDetailInfo -> ObjectUtils.isEmpty((Object)woffDetailInfo.getFinId())).map(WoffDetailInfo::getFinBillNo).collect(Collectors.toSet());
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObject[] finBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,billno,org.id,org.name,payproperty.isbasedonamt,bizdate,billtypeid,sourcebilltype,istanspay,ispremium,iswrittenoff,detailentry.id,detailentry.e_sourcebillid,detailentry.e_sourcebillentryid,detailentry.e_isallverify,detailentry.quantity,detailentry.e_pricetaxtotal,detailentry.e_pricetaxtotalbase,detailentry.linetype", (QFilter[])new QFilter[]{filter, new QFilter("id", "in", finIds)});
        if (finBillNos.size() > 0) {
            DynamicObject[] finBillCollsByBillNo = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,billno,org.id,org.name,payproperty.isbasedonamt,bizdate,billtypeid,sourcebilltype,istanspay,ispremium,iswrittenoff,detailentry.id,detailentry.e_sourcebillid,detailentry.e_sourcebillentryid,detailentry.e_isallverify,detailentry.quantity,detailentry.e_pricetaxtotal,detailentry.e_pricetaxtotalbase,detailentry.linetype", (QFilter[])new QFilter[]{filter, new QFilter("billno", "in", finBillNos)});
            ArrayList finBillColl = new ArrayList();
            finBillColl.addAll(Arrays.stream(finBills).collect(Collectors.toList()));
            finBillColl.addAll(Arrays.stream(finBillCollsByBillNo).collect(Collectors.toList()));
            finBills = finBillColl.toArray(new DynamicObject[0]);
        }
        return finBills;
    }

    public void finToWoffBus(List<WoffDetailInfo> woffDetailInfos, String woffRuleId) {
        DynamicObject[] finBills = this.queryFinBills(woffDetailInfos);
        ApWoffService woffService = new ApWoffService();
        woffService.wholeWoffBill(finBills, woffRuleId);
    }

    public void finToDelWoffBus(List<WoffDetailInfo> woffDetailInfos) {
        DynamicObject[] finBills = this.queryFinBills(woffDetailInfos);
        ApWoffService woffService = new ApWoffService();
        woffService.wholeDelWoffBill(finBills);
    }
}

