/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.appstart.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bplat.scmc.report.common.QueryParam;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.DataSetOutputHandle;
import kd.bplat.scmc.report.core.tpl.IOutputHandle;
import kd.bplat.scmc.report.util.ReportQuery;
import kd.fi.ap.mservice.appstart.helper.ReportQueryImplHelper;
import kd.fi.arapcommon.report.acctagev2.AcctageParam;
import kd.fi.arapcommon.vo.SumRptParam;
import kd.sdk.fi.arapcommon.param.ReportQueryParam;
import kd.sdk.fi.arapcommon.service.IArApReportQueryService;

public class ArApReportQueryServiceImpl
implements IArApReportQueryService {
    public DataSet query(ReportQueryParam queryParam) {
        Object reportType;
        Map principleProcessParam = queryParam.getPrincipleProcessParam();
        if (principleProcessParam != null && !principleProcessParam.isEmpty() && (reportType = principleProcessParam.get("reportType")) != null) {
            String reportName = (String)reportType;
            this.validatorByType(reportName, queryParam);
            this.handleByType(reportName, queryParam);
        }
        QueryParam param = new QueryParam();
        param.setCommonFs(queryParam.getCommonFs());
        DynamicObject conf = BusinessDataServiceHelper.loadSingle((Object)queryParam.getConfigId(), (String)"scmc_report_conf");
        param.setConf(conf);
        param.setCustomParam(queryParam.getCustomParam());
        param.setShowKeyCols(queryParam.getShowKeyCols());
        param.setShowQtyCols(queryParam.getShowQtyCols());
        param.setSumKeyCols(queryParam.getSumKeyCols());
        param.setShowTotalQty(queryParam.isShowTotalQty());
        ReportDataCtx reportDataCtx = ReportQuery.buildReportDataCtx((QueryParam)param);
        DataSetOutputHandle handle = new DataSetOutputHandle();
        ReportQuery.query((ReportDataCtx)reportDataCtx, (IOutputHandle)handle);
        return reportDataCtx.getCurrentJob().readDataSet(handle.getOutId());
    }

    private void validatorByType(String type, ReportQueryParam queryParam) {
        switch (type) {
            case "APSUM": 
            case "ARSUM": {
                List<String> result = ReportQueryImplHelper.validateReportQueryParam(queryParam);
                Map customParam = queryParam.getCustomParam();
                result.addAll(ReportQueryImplHelper.validateSumReportCustomParam(customParam));
                if (result.isEmpty()) break;
                throw new KDBizException(String.join((CharSequence)"\n", result));
            }
            case "APDETAIL": 
            case "ARDETAIL": {
                List<String> result = ReportQueryImplHelper.validateReportQueryParam(queryParam);
                Map customParam = queryParam.getCustomParam();
                result.addAll(ReportQueryImplHelper.validateSumReportCustomParam(customParam));
                if (result.isEmpty()) break;
                throw new KDBizException(String.join((CharSequence)"\n", result));
            }
            case "APACCTAGE": 
            case "ARACCTAGE": {
                List<String> result = ReportQueryImplHelper.validateReportQueryParam(queryParam);
                Map customParam = queryParam.getCustomParam();
                Map principleProcessParam = queryParam.getPrincipleProcessParam();
                result.addAll(ReportQueryImplHelper.validateAcctageReportCustomParam(customParam, principleProcessParam));
                if (result.isEmpty()) break;
                throw new KDBizException(String.join((CharSequence)"\n", result));
            }
        }
    }

    private void handleByType(String type, ReportQueryParam queryParam) {
        switch (type) {
            case "APSUM": 
            case "ARSUM": {
                HashSet<String> showQtyCols;
                HashSet<String> showKeyCols;
                Map customParam = queryParam.getCustomParam();
                boolean apSys = customParam.get("apSys") != null && (Boolean)customParam.get("apSys") != false;
                customParam.put("apSys", apSys);
                boolean showMainCurrency = customParam.get("showMainCurrency") != null && (Boolean)customParam.get("showMainCurrency") != false;
                customParam.put("showMainCurrency", showMainCurrency);
                if (queryParam.getConfigId() == null || queryParam.getConfigId() == 0L) {
                    queryParam.setConfigId(Long.valueOf(apSys ? 1401465251689417728L : 1419292205813630976L));
                }
                if ((showKeyCols = queryParam.getShowKeyCols()) == null || showKeyCols.isEmpty()) {
                    showKeyCols = new HashSet<String>(8);
                    showKeyCols.add("asstacttype");
                    showKeyCols.add("asstact");
                    showKeyCols.add("currency");
                    if (showMainCurrency) {
                        showKeyCols.add("basecurrency");
                    }
                    queryParam.setShowKeyCols(showKeyCols);
                }
                if ((showQtyCols = queryParam.getShowQtyCols()) == null || showQtyCols.isEmpty()) {
                    showQtyCols = new HashSet<String>(8);
                    showQtyCols.add("periodamt");
                    showQtyCols.add("finamt");
                    showQtyCols.add("balance");
                    showQtyCols.add("settleamt");
                    showQtyCols.add("cassettleamt");
                    showQtyCols.add("precasamt");
                    if (showMainCurrency) {
                        showQtyCols.add("localfinamt");
                        showQtyCols.add("localbalance");
                        showQtyCols.add("localsettleamt");
                        showQtyCols.add("localcassettleamt");
                        showQtyCols.add("localprecasamt");
                    }
                    queryParam.setShowKeyCols(showQtyCols);
                }
                SumRptParam sumRptParam = ReportQueryImplHelper.sumRptCustomParamExchange(customParam);
                customParam.clear();
                customParam.put(SumRptParam.class.getName(), sumRptParam);
                queryParam.setCustomParam(customParam);
                break;
            }
            case "APDETAIL": 
            case "ARDETAIL": {
                HashSet<String> showQtyCols;
                HashSet<String> showKeyCols;
                Map customParam = queryParam.getCustomParam();
                boolean apSys = customParam.get("apSys") != null && (Boolean)customParam.get("apSys") != false;
                customParam.put("apSys", apSys);
                boolean showMainCurrency = customParam.get("showMainCurrency") != null && (Boolean)customParam.get("showMainCurrency") != false;
                customParam.put("showMainCurrency", showMainCurrency);
                if (queryParam.getConfigId() == null || queryParam.getConfigId() == 0L) {
                    queryParam.setConfigId(Long.valueOf(apSys ? 1413869083333526528L : 1419292270816954368L));
                }
                if ((showKeyCols = queryParam.getShowKeyCols()) == null || showKeyCols.isEmpty()) {
                    showKeyCols = new HashSet<String>(8);
                    showKeyCols.add("asstacttype");
                    showKeyCols.add("asstact");
                    showKeyCols.add("currency");
                    if (showMainCurrency) {
                        showKeyCols.add("basecurrency");
                    }
                    queryParam.setShowKeyCols(showKeyCols);
                }
                if ((showQtyCols = queryParam.getShowQtyCols()) == null || showQtyCols.isEmpty()) {
                    showQtyCols = new HashSet<String>(8);
                    showQtyCols.add("finamt");
                    showQtyCols.add("balance");
                    showQtyCols.add("settleamt");
                    showQtyCols.add("cassettleamt");
                    showQtyCols.add("precasamt");
                    if (showMainCurrency) {
                        showQtyCols.add("localfinamt");
                        showQtyCols.add("localbalance");
                        showQtyCols.add("localsettleamt");
                        showQtyCols.add("localcassettleamt");
                        showQtyCols.add("localprecasamt");
                    }
                    queryParam.setShowKeyCols(showQtyCols);
                }
                SumRptParam sumRptParam = ReportQueryImplHelper.sumRptCustomParamExchange(customParam);
                customParam.clear();
                customParam.put(SumRptParam.class.getName(), sumRptParam);
                queryParam.setCustomParam(customParam);
                break;
            }
            case "APACCTAGE": 
            case "ARACCTAGE": {
                HashSet<String> showQtyCols;
                HashSet<String> showKeyCols;
                Map principleProcessParam = queryParam.getPrincipleProcessParam();
                boolean isAp = "true".equals(principleProcessParam.get("isAp"));
                Map customParam = queryParam.getCustomParam();
                boolean isShowLocalAmt = customParam.get("isShowLocalAmt") != null && (Boolean)customParam.get("isShowLocalAmt") != false;
                customParam.put("isShowLocalAmt", isShowLocalAmt);
                if (queryParam.getConfigId() == null || queryParam.getConfigId() == 0L) {
                    queryParam.setConfigId(Long.valueOf(isAp ? 1377003848144532480L : 1403488822460711936L));
                }
                if ((showKeyCols = queryParam.getShowKeyCols()) == null || showKeyCols.isEmpty()) {
                    showKeyCols = new HashSet<String>(8);
                    showKeyCols.add("asstacttype");
                    showKeyCols.add("asstact");
                    showKeyCols.add("currency");
                    if (isShowLocalAmt) {
                        showKeyCols.add("basecurrency");
                    }
                    queryParam.setShowKeyCols(showKeyCols);
                }
                if ((showQtyCols = queryParam.getShowQtyCols()) == null || showQtyCols.isEmpty()) {
                    showQtyCols = new HashSet<String>(8);
                    showQtyCols.add("pricetaxtotal");
                    showQtyCols.add("balance");
                    if (isShowLocalAmt) {
                        showQtyCols.add("balanceloc");
                        showQtyCols.add("pricetaxtotalloc");
                    }
                    queryParam.setShowKeyCols(showQtyCols);
                }
                AcctageParam acctageParam = ReportQueryImplHelper.acctageRptCustomParamExchange(customParam, principleProcessParam);
                customParam.clear();
                customParam.put(AcctageParam.class.getName(), acctageParam);
                queryParam.setCustomParam(customParam);
                break;
            }
        }
    }
}

