/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import kd.fi.ap.vo.CancelRefundAndRenoteParam;
import kd.fi.ap.vo.PayRefundEntryInfo;
import kd.fi.ap.vo.RefundAndRenoteParam;
import kd.fi.arapcommon.util.StdConfig;

public class RefundAndRenoteServiceHelper {
    public static boolean isExecuteNewLogic() {
        String isExecuteNewLogic = StdConfig.get((String)"isExecuteNewRefundAndRenote");
        return isExecuteNewLogic == null || "".equals(isExecuteNewLogic) || "true".equals(isExecuteNewLogic);
    }

    public static RefundAndRenoteParam confirmConvertParam(String paramJson) {
        JSONObject inputParam = JSON.parseObject((String)paramJson);
        RefundAndRenoteParam param = new RefundAndRenoteParam();
        String inputOperateKey = inputParam.getString("operate");
        Long inputRecId = inputParam.getLong("recId");
        JSONArray refundPayInfos = inputParam.getJSONArray("refundPayInfos");
        param.setOperateKey(inputOperateKey);
        param.setRecId(inputRecId);
        ArrayList<PayRefundEntryInfo> payInfos = new ArrayList<PayRefundEntryInfo>(refundPayInfos.size());
        for (Object refundPayInfo : refundPayInfos) {
            JSONObject payInfoJson = (JSONObject)refundPayInfo;
            Long payInfoId = payInfoJson.getLong("targetPk");
            JSONArray entryInfos = payInfoJson.getJSONArray("entryInfos");
            for (Object entryInfo : entryInfos) {
                JSONObject entry = (JSONObject)entryInfo;
                Long payInfoEntryId = entry.getLong("targetEntryPk");
                BigDecimal curEntryRefundAmt = entry.getBigDecimal("refundAmt");
                if (curEntryRefundAmt == null || curEntryRefundAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                PayRefundEntryInfo prEntryInfo = new PayRefundEntryInfo();
                prEntryInfo.setPayId(payInfoId);
                prEntryInfo.setEntryId(payInfoEntryId);
                prEntryInfo.setEntryRefundAmt(curEntryRefundAmt);
                payInfos.add(prEntryInfo);
            }
        }
        param.setPayInfos(payInfos);
        return param;
    }

    public static CancelRefundAndRenoteParam cancelConvertParam(String paramJson) {
        JSONObject inputParam = JSON.parseObject((String)paramJson);
        CancelRefundAndRenoteParam param = new CancelRefundAndRenoteParam();
        String inputOperateKey = inputParam.getString("operate");
        Long inputRecId = inputParam.getLong("recId");
        JSONArray refundPayInfos = inputParam.getJSONArray("refundPayInfos");
        param.setOperateKey(inputOperateKey);
        param.setRecId(inputRecId);
        ArrayList<PayRefundEntryInfo> payInfos = new ArrayList<PayRefundEntryInfo>(refundPayInfos.size());
        for (Object refundPayInfo : refundPayInfos) {
            JSONObject payInfoJson = (JSONObject)refundPayInfo;
            Long payInfoId = payInfoJson.getLong("targetPk");
            JSONArray entryInfos = payInfoJson.getJSONArray("entryInfos");
            for (Object entryInfo : entryInfos) {
                JSONObject entry = (JSONObject)entryInfo;
                Long payInfoEntryId = entry.getLong("targetEntryPk");
                BigDecimal curEntryRefundAmt = entry.getBigDecimal("refundAmt");
                if (curEntryRefundAmt == null || curEntryRefundAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                PayRefundEntryInfo prEntryInfo = new PayRefundEntryInfo();
                prEntryInfo.setPayId(payInfoId);
                prEntryInfo.setEntryId(payInfoEntryId);
                prEntryInfo.setEntryRefundAmt(curEntryRefundAmt.negate());
                payInfos.add(prEntryInfo);
            }
        }
        param.setPayInfos(payInfos);
        return param;
    }
}

