/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.ap.mservice.SettleServiceFactory;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.UnSettleParam;

@Deprecated
public class UnSettleByReturnHelper {
    @Deprecated
    public static void unSettleByReturn(long pk) {
        UnSettleByReturnHelper.unSettle4Main(pk, null);
        UnSettleByReturnHelper.unSettle4Asst(null, pk, null);
    }

    public static void unSettleByReturn(String entityName, long pk) {
        UnSettleByReturnHelper.unSettle4Main(pk, null);
        UnSettleByReturnHelper.unSettle4Asst(entityName, pk, null);
    }

    public static void unSettleByReturn(String entityName, long pk, Date bookDate) {
        UnSettleByReturnHelper.unSettle4Main(pk, bookDate);
        UnSettleByReturnHelper.unSettle4Asst(entityName, pk, bookDate);
    }

    private static void unSettle4Main(long pk, Date bookDate) {
        QFilter filter = new QFilter("mainbillid", "=", (Object)pk);
        DynamicObject[] results = UnSettleByReturnHelper.getSettleRecords(filter, "ap_settlerecord");
        if (results != null && results.length > 0) {
            UnSettleByReturnHelper.processWholeResults(results, bookDate);
        }
    }

    private static void unSettle4Asst(String entityName, long pk, Date bookDate) {
        AbstractSettleTemplate settle = null;
        QFilter filter = new QFilter("entry.billid", "=", (Object)pk);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] results = SettleRecordQueryHelper.getSettleRecords((String)"ap_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (String)entityName, (Object[])new Object[]{pk}, (QFilter)filter);
        if (results.length > 0) {
            DynamicObjectCollection entrys;
            ArrayList<DynamicObject> wholeResults = new ArrayList<DynamicObject>(results.length);
            ArrayList<DynamicObject> partResults = new ArrayList<DynamicObject>(results.length);
            for (DynamicObject result : results) {
                boolean wholeResult = true;
                entrys = result.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entrys) {
                    if (entry.getLong("billid") == pk) continue;
                    wholeResult = false;
                    break;
                }
                if (wholeResult) {
                    wholeResults.add(result);
                    continue;
                }
                partResults.add(result);
            }
            if (!wholeResults.isEmpty()) {
                DynamicObject[] wholeResultArr = wholeResults.toArray(new DynamicObject[0]);
                UnSettleByReturnHelper.processWholeResults(wholeResultArr, bookDate);
            }
            if (!partResults.isEmpty()) {
                ArrayList<Long> updateList = new ArrayList<Long>(results.length - 1);
                ArrayList<Long> updateEntryList = new ArrayList<Long>(results.length - 1);
                for (DynamicObject result : partResults) {
                    updateList.add(result.getLong("id"));
                    DynamicObjectCollection entrys2 = result.getDynamicObjectCollection("entry");
                    String settleType = result.getString("settletype");
                    String settleRelation = result.getString("settlerelation");
                    settle = UnSettleByReturnHelper.getSettleService(settleRelation);
                    ArrayList<SettleRecordEntryVO> entryVOList = new ArrayList<SettleRecordEntryVO>();
                    BigDecimal totalUnsettleAmt = BigDecimal.ZERO;
                    BigDecimal totalUnsettleLocalAmt = BigDecimal.ZERO;
                    BigDecimal totalUnSwappl = BigDecimal.ZERO;
                    for (int i = entrys2.size() - 1; i >= 0; --i) {
                        DynamicObject entry = (DynamicObject)entrys2.get(i);
                        if (entry.getLong("billid") != pk || entry.getBoolean("e_hadwrittenoff")) continue;
                        SettleRecordEntryVO entryVO = new SettleRecordEntryVO();
                        BigDecimal settleAmt = entry.getBigDecimal("settleamt");
                        BigDecimal settleLocalAmt = entry.getBigDecimal("localsettleamt");
                        BigDecimal swappl = entry.getBigDecimal("e_swappl");
                        if (SettleRelationEnum.ARSELF.getValue().equals(settleRelation) || SettleRelationEnum.RECSELF.getValue().equals(settleRelation) || SettleRelationEnum.APSELF.getValue().equals(settleRelation) || SettleRelationEnum.PAYSELF.getValue().equals(settleRelation)) {
                            totalUnsettleAmt = totalUnsettleAmt.add(settleAmt.abs());
                            totalUnsettleLocalAmt = totalUnsettleLocalAmt.add(settleLocalAmt.abs());
                        } else if (SettleRelationEnum.ARPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APRECSETTLE.getValue().equals(settleRelation)) {
                            totalUnsettleAmt = totalUnsettleAmt.subtract(settleAmt);
                            totalUnsettleLocalAmt = totalUnsettleLocalAmt.subtract(settleLocalAmt);
                        } else {
                            totalUnsettleAmt = totalUnsettleAmt.add(settleAmt);
                            totalUnsettleLocalAmt = totalUnsettleLocalAmt.add(settleLocalAmt);
                        }
                        totalUnSwappl = totalUnSwappl.add(swappl);
                        entryVO.setSettleAmt(settleAmt);
                        entryVO.setLocalSettleAmt(settleLocalAmt);
                        entryVO.setCurrencyId(entry.getLong("currency.id"));
                        entryVO.setBillId(entry.getLong("billid"));
                        entryVO.setBillEntryId(entry.getLong("billentryid"));
                        entryVO.setBillType(entry.getString("billtype"));
                        entryVO.setBillEntity(entry.getString("e_billentity"));
                        entryVO.setExchangeRate(entry.getBigDecimal("e_exchangerate"));
                        entryVO.setSettleType(settleType);
                        entryVO.setSettleEntry(entry.getInt("e_settleentry"));
                        updateEntryList.add(entry.getLong("billid"));
                        entryVOList.add(entryVO);
                        entrys2.remove((Object)entry);
                    }
                    SettleRecordVO resultVO = new SettleRecordVO();
                    resultVO.setMainBillId(result.getLong("mainbillid"));
                    resultVO.setMainBillEntryId(result.getLong("mainbillentryid"));
                    resultVO.setBillType(result.getString("mainbilltype"));
                    resultVO.setSettleType(settleType);
                    resultVO.setSettleRela(settleRelation);
                    resultVO.setTotalSettleAmt(totalUnsettleAmt);
                    resultVO.setLocalTotalSettleamt(totalUnsettleLocalAmt);
                    resultVO.setExchangeRate(result.getBigDecimal("exchangerate"));
                    resultVO.setCorebillId(result.getLong("corebillid"));
                    resultVO.setCorebillEntryId(result.getLong("corebillentryid"));
                    resultVO.setSettleEntry(result.getInt("settleentry"));
                    resultVO.setEntrys(entryVOList);
                    SettleSchemeVO scheme = new SettleSchemeVO();
                    scheme.setSettle(false);
                    scheme.setManual(SettleTypeEnum.MANUAL.getValue().equals(result.getString("settletype")));
                    scheme.setSchemeSettle(SettleTypeEnum.MATCH.getValue().equals(result.getString("settletype")));
                    settle.disposeMainBill(resultVO, scheme);
                    settle.disposeAsstBill(entryVOList, scheme);
                }
                if (updateList.size() > 0) {
                    List pushObjs = BOTPHelper.push((String)"ap_settlerecord", (String)"ap_settlerecord", (String)"733303037426151424", updateList);
                    for (int i = pushObjs.size() - 1; i >= 0; --i) {
                        DynamicObject obj = (DynamicObject)pushObjs.get(i);
                        entrys = obj.getDynamicObjectCollection("entry");
                        if (((DynamicObject)entrys.get(0)).getLong("billid") == pk) continue;
                        pushObjs.remove(i);
                    }
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("mutex_writeback", "false");
                    if (EmptyUtils.isNotEmpty((Object)bookDate)) {
                        option.setVariableValue("settleDate", DateUtils.formatString((Date)bookDate, (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_settlerecord", (DynamicObject[])pushObjs.toArray(new DynamicObject[0]), (OperateOption)option);
                    OperationHelper.assertResult((OperationResult)saveResult);
                    OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
                    OperationHelper.assertResult((OperationResult)submitResult);
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
                    OperationHelper.assertResult((OperationResult)auditResult);
                    UnSettleByReturnHelper.updateSettleRecordEntry(updateList, updateEntryList);
                }
            }
        }
    }

    private static DynamicObject[] getSettleRecords(QFilter filter, String entity) {
        if (!ObjectUtils.isEmpty((Object)filter)) {
            filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        }
        DynamicObject[] results = BusinessDataServiceHelper.load((String)entity, (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])filter.toArray());
        return results;
    }

    private static AbstractSettleTemplate getSettleService(String key) {
        return SettleServiceFactory.getService(key);
    }

    private static void updateSettleRecord(DynamicObject[] results) {
        if (!ObjectUtils.isEmpty((Object[])results)) {
            ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(results.length);
            ArrayList<Long> billIds = new ArrayList<Long>(results.length);
            for (int i = 0; i < results.length; ++i) {
                long billId = results[i].getLong("id");
                billIds.add(billId);
                SqlParameter[] param = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)billId)};
                paramsList.add(param);
            }
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ap_settlerecord", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, billIds)});){
                String entrySql = "update t_ap_settlerecordentry set fhadwrittenoff='1' where fid=?";
                String sql = "update t_ap_settlerecord set fhadwrittenoff='1' where fid=?";
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)entrySql, paramsList);
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, paramsList);
            }
        }
    }

    private static void updateSettleRecordEntry(List<Long> updateList, List<Long> updateEntryList) {
        if (!ObjectUtils.isEmpty(updateEntryList)) {
            ArrayList<SqlParameter[]> entryParamsList = new ArrayList<SqlParameter[]>(updateEntryList.size());
            for (int i = 0; i < updateEntryList.size(); ++i) {
                SqlParameter[] param = new SqlParameter[]{new SqlParameter(":fentryid", -5, (Object)updateEntryList.get(i))};
                entryParamsList.add(param);
            }
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ap_settlerecord", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, updateList)});){
                String sql = "update t_ap_settlerecordentry set fhadwrittenoff='1' where fentryid=?";
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, entryParamsList);
            }
        }
    }

    private static void processWholeResults(DynamicObject[] results, Date bookDate) {
        List resultIds = Arrays.stream(results).map(result -> result.getLong("id")).collect(Collectors.toList());
        String apSettleRecordRedRuleId = "733772355079280640";
        List redSettleRecords = BOTPHelper.push((String)"ap_settlerecord", (String)"ap_settlerecord", (String)apSettleRecordRedRuleId, resultIds);
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        if (EmptyUtils.isNotEmpty((Object)bookDate)) {
            option.setVariableValue("settleDate", DateUtils.formatString((Date)bookDate, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_settlerecord", (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)saveResult);
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ap_settlerecord", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_settlerecord", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)auditResult);
        UnSettleByReturnHelper.updateSettleRecord(results);
        Map map = SettleRecordOpHelper.classfySettleRecord((DynamicObject[])results);
        for (Map.Entry entry : map.entrySet()) {
            AbstractSettleTemplate service = UnSettleByReturnHelper.getSettleService((String)entry.getKey());
            UnSettleParam param = new UnSettleParam();
            param.setRedSettleRecord(true);
            param.setUnSettleByListOP(true);
            service.unSettle(((List)entry.getValue()).toArray(new DynamicObject[0]), param);
        }
    }
}

