/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.service.helper.CommonVerifyServiceHelper;
import kd.fi.arapcommon.service.helper.VerifyLogHelper;
import kd.fi.arapcommon.service.log.MserviceLogHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.VerifyRecordEntryVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public class VerifyServiceHelper {
    protected static final Log logger = LogFactory.getLog(VerifyServiceHelper.class);

    public static List<Object> saveVerifyRecord(DynamicObject[] results) {
        Map<Long, List<DynamicObject>> verifyRecordMap = Stream.of(results).collect(Collectors.groupingBy(verifyRecord -> verifyRecord.getLong("org.id")));
        for (Map.Entry<Long, List<DynamicObject>> map : verifyRecordMap.entrySet()) {
            List<DynamicObject> verifyRecords = map.getValue();
            Map verifySeqMap = CommonVerifyServiceHelper.getVerifySeqMap((DynamicObject[])verifyRecords.toArray(new DynamicObject[0]), (String)"ap_verifyrecord");
            for (DynamicObject verifyRecord2 : verifyRecords) {
                long mainBillId = verifyRecord2.getLong("billid");
                DynamicObjectCollection entry = verifyRecord2.getDynamicObjectCollection("entry");
                long asstBillId = ((DynamicObject)entry.get(0)).getLong("e_billid");
                verifyRecord2.set("verifyseq", verifySeqMap.get(mainBillId + "-" + asstBillId));
            }
        }
        long start = System.currentTimeMillis();
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ap_verifyrecord", (DynamicObject[])results, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)result);
        long end = System.currentTimeMillis();
        logger.info("save apverifyrecord spend " + (end - start));
        return result.getSuccessPkIds();
    }

    public static List<VerifyRecordVO> verify(List<BillVerifyVO> mainList, List<BillVerifyVO> asstList, SettleSchemeVO scheme, String verifyType) {
        ArrayList<VerifyRecordVO> resultList = new ArrayList<VerifyRecordVO>(64);
        Map<Long, Long> entryRowBotpMap = new HashMap<Long, Long>(64);
        Map<Long, Long> asstactIdToMasterIdMap = VerifyServiceHelper.buildMapForAsstactIdToMasterId(mainList, asstList);
        String isAsstActMatch = StdConfig.get((String)"verify.isAsstActMatch");
        HashMap<String, Boolean> billAsstMatchMap = new HashMap<String, Boolean>(8);
        if (scheme.isOnlyByBotp()) {
            String asstBill = asstList.get(0).getBillType();
            String entryType = asstList.get(0).getEntryEntityName();
            HashSet<Long> asstIds = new HashSet<Long>(asstList.size());
            ArrayList asstEntryIds = new ArrayList(asstList.size());
            for (BillVerifyVO asst : asstList) {
                asstIds.add(asst.getId());
                asstEntryIds.add(asst.getEntryId());
            }
            entryRowBotpMap = BOTPHelper.loadSourceRowIdsMap((String)asstBill, (String)entryType, (Long[])asstIds.toArray(new Long[0]), (Long[])asstEntryIds.toArray(new Long[0]), (String)mainList.get(0).getBillType());
        }
        block1: for (BillVerifyVO main : mainList) {
            ArrayList<BillVerifyVO> matchAsstList = new ArrayList<BillVerifyVO>(asstList.size());
            for (BillVerifyVO asst : asstList) {
                if (asst.getEntryUnSettleQty().compareTo(BigDecimal.ZERO) == 0 || !VerifyServiceHelper.isMatch(main, asst, scheme, entryRowBotpMap, asstactIdToMasterIdMap, billAsstMatchMap, isAsstActMatch)) continue;
                matchAsstList.add(asst);
            }
            if (matchAsstList.size() <= 0) continue;
            if ((scheme.isOnlyByBotp() || scheme.isOnlyByCoreBill()) && matchAsstList.size() == 1 && ((BillVerifyVO)matchAsstList.get(0)).isAllVerify()) {
                ArrayList<BillVerifyVO> mainAllVerifyList = new ArrayList<BillVerifyVO>();
                mainAllVerifyList.add(main);
                resultList.addAll(VerifyServiceHelper.allVerify(mainAllVerifyList, matchAsstList, scheme, verifyType));
                main.setEntryUnSettleQty(BigDecimal.ZERO);
                ((BillVerifyVO)matchAsstList.get(0)).setEntryUnSettleQty(BigDecimal.ZERO);
                continue;
            }
            for (BillVerifyVO asst : matchAsstList) {
                if (main.getEntryUnSettleQty().compareTo(BigDecimal.ZERO) == 0) continue block1;
                if (asst.getEntryUnSettleQty().compareTo(BigDecimal.ZERO) == 0) continue;
                VerifyRecordVO result = new VerifyRecordVO();
                ArrayList<BillVerifyVO> tempAsstList = new ArrayList<BillVerifyVO>(1);
                tempAsstList.add(asst);
                VerifyServiceHelper.buildVerifyRecord(main, tempAsstList, scheme, result, verifyType);
                resultList.add(result);
            }
        }
        return resultList;
    }

    private static Map<Long, Long> buildMapForAsstactIdToMasterId(List<BillVerifyVO> mainList, List<BillVerifyVO> asstList) {
        HashMap<Long, Long> asstactIdToMasterIdMap = new HashMap<Long, Long>(16);
        HashSet<Long> supplierIdSet = new HashSet<Long>(64);
        HashSet<Long> customerIdSet = new HashSet<Long>(64);
        for (BillVerifyVO main : mainList) {
            if ("bd_supplier".equals(main.getAsstActType())) {
                supplierIdSet.add(main.getAsstActId());
            }
            if (!"bd_customer".equals(main.getAsstActType())) continue;
            customerIdSet.add(main.getAsstActId());
        }
        for (BillVerifyVO asst : asstList) {
            if ("bd_supplier".equals(asst.getAsstActType())) {
                supplierIdSet.add(asst.getAsstActId());
            }
            if (!"bd_customer".equals(asst.getAsstActType())) continue;
            customerIdSet.add(asst.getAsstActId());
        }
        String selectField = "id,masterid";
        if (supplierIdSet.size() > 0) {
            DynamicObjectCollection supplierCollection = QueryServiceHelper.query((String)"bd_supplier", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIdSet)});
            asstactIdToMasterIdMap.putAll(supplierCollection.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("masterid"))));
        }
        if (customerIdSet.size() > 0) {
            DynamicObjectCollection customerCollection = QueryServiceHelper.query((String)"bd_customer", (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", customerIdSet)});
            asstactIdToMasterIdMap.putAll(customerCollection.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("masterid"))));
        }
        return asstactIdToMasterIdMap;
    }

    public static List<VerifyRecordVO> allVerify(List<BillVerifyVO> mainList, List<BillVerifyVO> asstList, SettleSchemeVO scheme, String verifyType) {
        ArrayList<VerifyRecordVO> resultList = new ArrayList<VerifyRecordVO>();
        BillVerifyVO main = mainList.get(0);
        VerifyRecordVO result = new VerifyRecordVO();
        result.setPrecision(main.getPrecision());
        result.setBasePrecision(main.getBasePrecision());
        result.setSettleDate(new Date());
        result.setCreatorId(RequestContext.get().getCurrUserId());
        result.setOrgId(main.getOrgId());
        result.setCurrencyId(main.getCurrencyId());
        result.setMaterialId(main.getEntryMaterialId());
        result.setMeasureunitId(Long.valueOf(main.getEntryMeasureUnitId()));
        result.setBaseunitId(Long.valueOf(main.getEntryBaseUnitId()));
        result.setBillNo(main.getBillNo());
        result.setBillDate(main.getBizdate());
        result.setBillType(main.getBillType());
        result.setQty(main.getEntryQty());
        BigDecimal mainVerifyQty = UnitConvertHelper.getBaseunitqty((BigDecimal)main.getEntryUnSettleQty(), (BigDecimal)BigDecimal.ONE, (DynamicObject)main.getEntryMeasureUnit());
        result.setVerifyQty(mainVerifyQty);
        BigDecimal convertRate = main.getUnitCoefficient();
        BigDecimal mainVerifyBaseQty = UnitConvertHelper.getBaseunitqty((BigDecimal)main.getEntryUnSettleQty(), (BigDecimal)convertRate, (DynamicObject)main.getEntryBaseUnit());
        result.setVerifyBaseQty(mainVerifyBaseQty);
        result.setMainPayableAmt(main.getEntryPayableAmt());
        result.setTotalSettleAmt(main.getPrice().multiply(main.getEntryUnSettleQty()).setScale((int)main.getPrecision(), RoundingMode.HALF_UP));
        result.setAsstActType(main.getAsstActType());
        result.setAsstActId(main.getAsstActId());
        result.setMainBillId(main.getId());
        result.setMainBillEntryId(main.getEntryId());
        result.setSettleType(verifyType);
        result.setBaseCurrencyId(main.getBaseCurrencyId());
        result.setQuotation(main.getQuotation());
        result.setExchangeRate(main.getExchangeRate());
        BigDecimal verifyTaxAmt = BigDecimal.ZERO;
        for (BillVerifyVO asst : asstList) {
            if (!VerifyServiceHelper.isAllVerifyMatch(main, asst)) continue;
            VerifyRecordEntryVO entryVO = new VerifyRecordEntryVO();
            result.getVrEntrys().add(entryVO);
            entryVO.setPrecision(asst.getPrecision());
            entryVO.setBasePrecision(asst.getBasePrecision());
            entryVO.setBillNum(asst.getBillNo());
            entryVO.setBillDate(asst.getBizdate());
            entryVO.setBillType(asst.getBillType());
            entryVO.setCurrencyId(asst.getCurrencyId());
            entryVO.setQty(asst.getEntryQty());
            BigDecimal asstVerifyQty = UnitConvertHelper.getBaseunitqty((BigDecimal)asst.getEntryUnSettleQty(), (BigDecimal)BigDecimal.ONE, (DynamicObject)asst.getEntryMeasureUnit());
            entryVO.setVerifyQty(asstVerifyQty);
            BigDecimal asstConvertRate = asst.getUnitCoefficient();
            BigDecimal asstVerifyBaseQty = UnitConvertHelper.getBaseunitqty((BigDecimal)asst.getEntryUnSettleQty(), (BigDecimal)asstConvertRate, (DynamicObject)asst.getEntryBaseUnit());
            entryVO.setVerifyBaseQty(asstVerifyBaseQty);
            entryVO.setPayableAmt(asst.getEntryPayableAmt());
            if (asst.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) == 0) {
                entryVO.setSettleAmt(asst.getPrice().multiply(asst.getEntryUnSettleQty()).setScale((int)asst.getPrecision(), RoundingMode.HALF_UP));
            } else {
                entryVO.setSettleAmt(asst.getEntryUnSettleAmt().setScale((int)asst.getPrecision(), RoundingMode.HALF_UP));
            }
            if ("ap_finapbill".equals(asst.getBillType())) {
                entryVO.setVerifyAmt(asst.getEntryPayableAmt());
            } else {
                entryVO.setVerifyAmt(asst.getPriceTax().multiply(asst.getEntryUnSettleQty()).setScale((int)asst.getPrecision(), RoundingMode.HALF_UP));
            }
            verifyTaxAmt = verifyTaxAmt.add(entryVO.getVerifyAmt());
            entryVO.setAsstActType(asst.getAsstActType());
            entryVO.setAsstActId(asst.getAsstActId());
            entryVO.setMaterielId(Long.valueOf(asst.getEntryMaterialId()));
            entryVO.setMeasureunitId(Long.valueOf(asst.getEntryMeasureUnitId()));
            entryVO.setBaseunitId(Long.valueOf(asst.getEntryBaseUnitId()));
            entryVO.setBillId(asst.getId());
            entryVO.setBillEntryId(asst.getEntryId());
            entryVO.setBaseCurrencyId(asst.getBaseCurrencyId());
            entryVO.setQuotation(asst.getQuotation());
            entryVO.setExchangeRate(asst.getExchangeRate());
            entryVO.setMainBillEntity(main.getMainBillEntity());
            entryVO.setMainBillNumber(main.getMainBillNumber());
            entryVO.setMainBillId(main.getMainBillId());
            entryVO.setMainBillEntryId(main.getMainBillEntryId());
            entryVO.setMainBillEntrySeq(main.getMainBillEntrySeq());
            entryVO.setConBillEntity(main.getConBillEntity());
            entryVO.setConBillNumber(main.getConBillNumber());
            entryVO.setConBillRowNum(main.getConBillRowNum());
            entryVO.setConBillId(main.getConBillId());
            entryVO.setConBillEntryId(main.getConBillEntryId());
        }
        if (VerifyServiceHelper.sameDirection(result.getVerifyQty(), verifyTaxAmt)) {
            result.setVerifyAmt(verifyTaxAmt);
        } else {
            result.setVerifyAmt(verifyTaxAmt.negate());
        }
        if (result.getVrEntrys() != null && result.getVrEntrys().size() > 0) {
            VerifyServiceHelper.resolveSwapPL(result);
            resultList.add(result);
        }
        return resultList;
    }

    private static boolean isMatch(BillVerifyVO main, BillVerifyVO asst, SettleSchemeVO scheme, Map<Long, Long> botpMap, Map<Long, Long> asstTypeToMasterIdMap, Map<String, Boolean> billAsstMatchMap, String isAsstActMatch) {
        boolean isMatch = false;
        if (main.getBillType().equals(asst.getBillType()) && VerifyServiceHelper.sameDirection(main.getEntryUnSettleQty(), asst.getEntryUnSettleQty())) {
            return false;
        }
        if (!main.getBillType().equals(asst.getBillType()) && !VerifyServiceHelper.sameDirection(main.getEntryUnSettleQty(), asst.getEntryUnSettleQty())) {
            return false;
        }
        if (scheme.isOnlyByBotp()) {
            long entryId = main.getEntryId();
            if (main.isPresent() && !asst.isPresent() || !main.isPresent() && asst.isPresent()) {
                return false;
            }
            boolean isMatchForOrgIdAndAsstActId = VerifyServiceHelper.isMatchForOrgIdAndAsstActId(main, asst, asstTypeToMasterIdMap, billAsstMatchMap);
            if (isMatchForOrgIdAndAsstActId) {
                if (entryId == asst.getEntrySouBillId()) {
                    isMatch = true;
                }
                if (!botpMap.isEmpty() && botpMap.containsKey(asst.getEntryId()) && botpMap.get(asst.getEntryId()) == entryId) {
                    isMatch = true;
                }
            }
        } else if (scheme.isOnlyByCoreBill()) {
            if (!ObjectUtils.isEmpty((Object)main.getEntryCoreBillNum()) && !main.getEntryCoreBillseq().equals("0") && main.getEntryCoreBillNum().equals(asst.getEntryCoreBillNum()) && main.getEntryCoreBillseq().equals(asst.getEntryCoreBillseq())) {
                boolean isMatchForOrgIdAndAsstActId = VerifyServiceHelper.isMatchForOrgIdAndAsstActId(main, asst, asstTypeToMasterIdMap, billAsstMatchMap);
                boolean isMaterialInfoMatch = VerifyServiceHelper.isMaterialInfoMatch(main, asst, isAsstActMatch);
                isMatch = main.getEntryMaterialId() == asst.getEntryMaterialId() && (main.isPresent() && asst.isPresent() || !main.isPresent() && !asst.isPresent()) && isMatchForOrgIdAndAsstActId && isMaterialInfoMatch;
            }
        } else if (scheme.isManual() && main.getEntryMaterialId() == asst.getEntryMaterialId() && (main.isPresent() && asst.isPresent() || !main.isPresent() && !asst.isPresent())) {
            isMatch = true;
        }
        return isMatch;
    }

    private static boolean isMatchForOrgIdAndAsstActId(BillVerifyVO main, BillVerifyVO asst, Map<Long, Long> asstTypeToMasterIdMap, Map<String, Boolean> billAsstMatchMap) {
        boolean orgMatch;
        boolean bl = orgMatch = main.getOrgId() == asst.getOrgId();
        if (!orgMatch) {
            return false;
        }
        if (main.getAsstActId() == asst.getAsstActId()) {
            return true;
        }
        String key = main.getAsstActId() + "" + asst.getAsstActId();
        Boolean asstMatch = billAsstMatchMap.get(key);
        if (asstMatch == null) {
            asstMatch = (Boolean)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0002", (Object)Boolean.TRUE, (Object[])new Object[]{main, asst, asstTypeToMasterIdMap});
            billAsstMatchMap.put(key, asstMatch);
        }
        return orgMatch && asstMatch != false;
    }

    private static boolean isMaterialInfoMatch(BillVerifyVO main, BillVerifyVO asst, String isAsstActMatch) {
        boolean isMatch = true;
        if (isAsstActMatch == null || "true".equals(isAsstActMatch)) {
            isMatch = main.getEntryMaterialVersion() == asst.getEntryMaterialVersion();
            isMatch = isMatch && main.getEntryMaterialAuxProp().equals(asst.getEntryMaterialAuxProp());
            isMatch = isMatch && main.getEntryMaterialConfigNumber() == asst.getEntryMaterialConfigNumber();
            isMatch = isMatch && main.getEntryMaterialTrackNumber() == asst.getEntryMaterialTrackNumber();
        }
        return isMatch;
    }

    private static boolean isAllVerifyMatch(BillVerifyVO main, BillVerifyVO asst) {
        boolean isMatch = false;
        if (main.getBillType().equals(asst.getBillType()) && VerifyServiceHelper.sameDirection(main.getEntryUnSettleQty(), asst.getEntryUnSettleQty())) {
            return false;
        }
        if (!main.getBillType().equals(asst.getBillType()) && !VerifyServiceHelper.sameDirection(main.getEntryUnSettleQty(), asst.getEntryUnSettleQty())) {
            return false;
        }
        if (main.getEntryMaterialId() == asst.getEntryMaterialId() && (main.isPresent() && asst.isPresent() || !main.isPresent() && !asst.isPresent())) {
            isMatch = true;
        }
        return isMatch;
    }

    private static void buildVerifyRecord(BillVerifyVO main, List<BillVerifyVO> matchAsstList, SettleSchemeVO scheme, VerifyRecordVO result, String verifyType) {
        BigDecimal mainCurVerifyBaseQty = BigDecimal.ZERO;
        BigDecimal mainVerifyBaseQtyCV = BigDecimal.ZERO;
        BigDecimal asstCurVerifyBaseQty = BigDecimal.ZERO;
        BigDecimal asstCurVerifyQty = BigDecimal.ZERO;
        BigDecimal asstCurVerifyAmt = BigDecimal.ZERO;
        BigDecimal verifyTaxAmt = BigDecimal.ZERO;
        BigDecimal convertRate = main.getUnitCoefficient();
        BigDecimal mainEUnVerifyQty = main.getEntryUnSettleQty();
        BigDecimal mainQty = main.getEntryQty();
        BigDecimal mainBaseQty = main.getBaseUnitQty();
        boolean isFinApBill = false;
        boolean isPurinBill = false;
        for (BillVerifyVO asst : matchAsstList) {
            BigDecimal mainUnVerifyQty = main.getEntryUnSettleQty();
            BigDecimal mainUnVerifyBaseQty = mainQty.compareTo(mainUnVerifyQty) == 0 ? mainBaseQty : mainUnVerifyQty.multiply(convertRate);
            if (mainUnVerifyQty.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal asstQty = asst.getEntryQty();
            BigDecimal asstUnVerifyQty = asst.getEntryUnSettleQty();
            if (asstUnVerifyQty.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal asstConvertRate = asst.getUnitCoefficient();
            BigDecimal asstUnVerifyBaseQty = asstQty.compareTo(asstUnVerifyQty) == 0 ? asst.getBaseUnitQty() : asstUnVerifyQty.multiply(asstConvertRate);
            asstCurVerifyBaseQty = main.getBillType().equals(asst.getBillType()) ? (mainUnVerifyBaseQty.abs().compareTo(asstUnVerifyBaseQty.abs()) >= 0 ? asstUnVerifyBaseQty : mainUnVerifyBaseQty.negate()) : (mainUnVerifyBaseQty.abs().compareTo(asstUnVerifyBaseQty.abs()) >= 0 ? asstUnVerifyBaseQty : mainUnVerifyBaseQty);
            asstCurVerifyQty = asstCurVerifyBaseQty.compareTo(asstUnVerifyBaseQty) == 0 ? asstUnVerifyQty : asstCurVerifyBaseQty.divide(asstConvertRate, 10, RoundingMode.HALF_UP);
            asstCurVerifyAmt = asst.getPrice().multiply(asstCurVerifyQty).setScale((int)asst.getPrecision(), RoundingMode.HALF_UP);
            BigDecimal tempMainVerifyBaseQty = BigDecimal.ZERO;
            if (mainUnVerifyQty.compareTo(BigDecimal.ZERO) > 0) {
                tempMainVerifyBaseQty = asstCurVerifyBaseQty.abs();
                mainVerifyBaseQtyCV = mainVerifyBaseQtyCV.add(tempMainVerifyBaseQty);
                mainCurVerifyBaseQty = mainCurVerifyBaseQty.add(UnitConvertHelper.getBaseunitqty((BigDecimal)tempMainVerifyBaseQty, (BigDecimal)BigDecimal.ONE, (DynamicObject)asst.getEntryBaseUnit()));
            } else {
                tempMainVerifyBaseQty = asstCurVerifyBaseQty.abs().negate();
                mainVerifyBaseQtyCV = mainVerifyBaseQtyCV.add(tempMainVerifyBaseQty);
                mainCurVerifyBaseQty = mainCurVerifyBaseQty.add(UnitConvertHelper.getBaseunitqty((BigDecimal)tempMainVerifyBaseQty, (BigDecimal)BigDecimal.ONE, (DynamicObject)asst.getEntryBaseUnit()));
            }
            VerifyRecordEntryVO entryVO = new VerifyRecordEntryVO();
            entryVO.setPrecision(asst.getPrecision());
            entryVO.setBasePrecision(asst.getBasePrecision());
            entryVO.setBillNum(asst.getBillNo());
            entryVO.setBillDate(asst.getBizdate());
            entryVO.setBillType(asst.getBillType());
            entryVO.setCurrencyId(asst.getCurrencyId());
            entryVO.setQty(asst.getEntryQty());
            entryVO.setVerifyBaseQty(UnitConvertHelper.getBaseunitqty((BigDecimal)asstCurVerifyBaseQty, (BigDecimal)BigDecimal.ONE, (DynamicObject)asst.getEntryBaseUnit()));
            entryVO.setVerifyQty(asstCurVerifyQty);
            entryVO.setPayableAmt(asst.getEntryPayableAmt());
            if (asstCurVerifyQty.compareTo(asstUnVerifyQty) == 0 && ("im_purinbill".equals(main.getBillType()) || "im_mdc_omcmplinbill".equals(main.getBillType()) || "im_mdc_ominbill".equals(main.getBillType()) || "im_purreceivebill".equals(main.getBillType())) && "ap_finapbill".equals(asst.getBillType())) {
                entryVO.setSettleAmt(asst.getEntryUnSettleAmt());
            } else if (asstCurVerifyQty.compareTo(asstUnVerifyQty) == 0 && "ap_finapbill".equals(main.getBillType()) && "ap_finapbill".equals(asst.getBillType())) {
                entryVO.setSettleAmt(asst.getEntryUnSettleAmt());
                isFinApBill = true;
            } else {
                BigDecimal tempVerifyAmt = asstCurVerifyAmt;
                entryVO.setSettleAmt(tempVerifyAmt);
                asst.setEntryUnSettleAmt(asst.getEntryUnSettleAmt().subtract(tempVerifyAmt));
            }
            if ("im_purinbill".equals(main.getBillType()) && "im_purinbill".equals(asst.getBillType()) || "im_mdc_omcmplinbill".equals(main.getBillType()) && "im_mdc_omcmplinbill".equals(asst.getBillType()) || "im_mdc_ominbill".equals(main.getBillType()) && "im_mdc_ominbill".equals(asst.getBillType())) {
                isPurinBill = true;
            }
            if ("ap_finapbill".equals(asst.getBillType()) && asstCurVerifyQty.compareTo(asst.getEntryQty()) == 0) {
                entryVO.setVerifyAmt(asst.getEntryPayableAmt());
            } else {
                entryVO.setVerifyAmt(asst.getPriceTax().multiply(asstCurVerifyQty).setScale((int)asst.getPrecision(), RoundingMode.HALF_UP));
            }
            verifyTaxAmt = verifyTaxAmt.add(entryVO.getVerifyAmt());
            entryVO.setAsstActType(asst.getAsstActType());
            entryVO.setAsstActId(asst.getAsstActId());
            entryVO.setMaterielId(Long.valueOf(asst.getEntryMaterialId()));
            entryVO.setMeasureunitId(Long.valueOf(asst.getEntryMeasureUnitId()));
            entryVO.setBaseunitId(Long.valueOf(asst.getEntryBaseUnitId()));
            entryVO.setBillId(asst.getId());
            entryVO.setBillEntryId(asst.getEntryId());
            entryVO.setBaseCurrencyId(asst.getBaseCurrencyId());
            entryVO.setQuotation(asst.getQuotation());
            entryVO.setExchangeRate(asst.getExchangeRate());
            entryVO.setMainBillEntity(main.getMainBillEntity());
            entryVO.setMainBillNumber(main.getMainBillNumber());
            entryVO.setMainBillId(main.getMainBillId());
            entryVO.setMainBillEntryId(main.getMainBillEntryId());
            entryVO.setMainBillEntrySeq(main.getMainBillEntrySeq());
            entryVO.setConBillEntity(main.getConBillEntity());
            entryVO.setConBillNumber(main.getConBillNumber());
            entryVO.setConBillRowNum(main.getConBillRowNum());
            entryVO.setConBillId(main.getConBillId());
            entryVO.setConBillEntryId(main.getConBillEntryId());
            result.getVrEntrys().add(entryVO);
            asst.setEntryUnSettleQty(asst.getEntryUnSettleQty().subtract(asstCurVerifyQty));
            main.setEntryUnSettleQty(main.getEntryUnSettleQty().subtract(tempMainVerifyBaseQty.divide(convertRate, 10, RoundingMode.HALF_UP)));
        }
        result.setPrecision(main.getPrecision());
        result.setBasePrecision(main.getBasePrecision());
        result.setSettleDate(new Date());
        result.setCreatorId(RequestContext.get().getCurrUserId());
        result.setOrgId(main.getOrgId());
        result.setCurrencyId(main.getCurrencyId());
        result.setMaterialId(main.getEntryMaterialId());
        result.setMeasureunitId(Long.valueOf(main.getEntryMeasureUnitId()));
        result.setBaseunitId(Long.valueOf(main.getEntryBaseUnitId()));
        result.setBillNo(main.getBillNo());
        result.setBillDate(main.getBizdate());
        result.setBillType(main.getBillType());
        result.setQty(main.getEntryQty());
        result.setVerifyBaseQty(mainCurVerifyBaseQty);
        BigDecimal mainVeiryQty = mainBaseQty.compareTo(mainCurVerifyBaseQty) == 0 ? mainQty : UnitConvertHelper.getUnitQty((BigDecimal)mainVerifyBaseQtyCV, (BigDecimal)convertRate, (DynamicObject)main.getEntryMeasureUnit());
        result.setVerifyQty(mainVeiryQty);
        result.setMainPayableAmt(main.getEntryPayableAmt());
        if (isFinApBill && mainVeiryQty.compareTo(mainEUnVerifyQty) == 0 || isPurinBill && mainVeiryQty.compareTo(main.getEntryQty()) == 0) {
            result.setTotalSettleAmt(main.getEntryUnSettleAmt());
        } else {
            result.setTotalSettleAmt(main.getPrice().multiply(mainVeiryQty).setScale((int)main.getPrecision(), RoundingMode.HALF_UP));
        }
        main.setEntryUnSettleAmt(main.getEntryUnSettleAmt().subtract(result.getTotalSettleAmt()));
        if (VerifyServiceHelper.sameDirection(mainVeiryQty, verifyTaxAmt)) {
            result.setVerifyAmt(verifyTaxAmt);
        } else {
            result.setVerifyAmt(verifyTaxAmt.negate());
        }
        result.setAsstActType(main.getAsstActType());
        result.setAsstActId(main.getAsstActId());
        result.setMainBillId(main.getId());
        result.setMainBillEntryId(main.getEntryId());
        result.setSettleType(verifyType);
        result.setBaseCurrencyId(main.getBaseCurrencyId());
        result.setQuotation(main.getQuotation());
        result.setExchangeRate(main.getExchangeRate());
        VerifyServiceHelper.resolveSwapPL(result);
    }

    public static void resolveSwapPL(VerifyRecordVO vo) {
        List vrEntrys = vo.getVrEntrys();
        VerifyRecordEntryVO asstEntry = (VerifyRecordEntryVO)vrEntrys.get(0);
        BigDecimal mainVerifyAmt = vo.getTotalSettleAmt();
        String mainQuotation = vo.getQuotation();
        String asstQuotation = asstEntry.getQuotation();
        int basePrecision = vo.getBasePrecision();
        BigDecimal mainExchangeRate = vo.getExchangeRate();
        BigDecimal asstExchangeRate = asstEntry.getExchangeRate();
        BigDecimal mainswapPL = mainQuotation.equals(asstQuotation) ? (mainQuotation.equals("1") ? mainVerifyAmt.divide(mainExchangeRate, basePrecision, RoundingMode.HALF_UP).subtract(mainVerifyAmt.divide(asstExchangeRate, basePrecision, RoundingMode.HALF_UP)) : mainVerifyAmt.multiply(mainExchangeRate).setScale(basePrecision, RoundingMode.HALF_UP).subtract(mainVerifyAmt.multiply(asstExchangeRate).setScale(basePrecision, RoundingMode.HALF_UP))) : (mainQuotation.equals("1") ? mainVerifyAmt.divide(mainExchangeRate, basePrecision, RoundingMode.HALF_UP).subtract(mainVerifyAmt.multiply(asstExchangeRate).setScale(basePrecision, RoundingMode.HALF_UP)) : mainVerifyAmt.multiply(mainExchangeRate).setScale(basePrecision, RoundingMode.HALF_UP).subtract(mainVerifyAmt.divide(asstExchangeRate, basePrecision, RoundingMode.HALF_UP)));
        vo.setSwapPL(mainswapPL);
        asstEntry.setSwapPL(mainswapPL.negate());
    }

    public static VerifyRecordVO converDyn2VO(DynamicObject result) {
        VerifyRecordVO recordVO = new VerifyRecordVO();
        recordVO.setOrgId(result.getLong("org.id"));
        recordVO.setBillType(result.getString("billtype"));
        recordVO.setMainBillId(result.getLong("billid"));
        recordVO.setMainBillEntryId(result.getLong("billentryid"));
        recordVO.setQty(result.getBigDecimal("qty"));
        recordVO.setMeasureunitId(Long.valueOf(result.getLong("measureunit.id")));
        recordVO.setVerifyQty(result.getBigDecimal("verifyqty"));
        recordVO.setVerifyBaseQty(result.getBigDecimal("verifybaseqty"));
        recordVO.setMainPayableAmt(result.getBigDecimal("payableamount"));
        recordVO.setTotalSettleAmt(result.getBigDecimal("verifyamount"));
        recordVO.setVerifyAmt(result.getBigDecimal("verifytaxamount"));
        recordVO.setSettleType(result.getString("verifytype"));
        DynamicObjectCollection collection = result.getDynamicObjectCollection("entry");
        for (DynamicObject obj : collection) {
            VerifyRecordEntryVO entryVO = new VerifyRecordEntryVO();
            entryVO.setBillType(obj.getString("e_billtype"));
            entryVO.setBillId(obj.getLong("e_billid"));
            entryVO.setBillEntryId(obj.getLong("e_billentryid"));
            entryVO.setQty(obj.getBigDecimal("e_qty"));
            entryVO.setMeasureunitId(Long.valueOf(obj.getLong("e_measureunit.id")));
            entryVO.setVerifyQty(obj.getBigDecimal("e_verifyqty"));
            entryVO.setVerifyBaseQty(obj.getBigDecimal("e_verifybaseqty"));
            entryVO.setPayableAmt(obj.getBigDecimal("e_payableamount"));
            entryVO.setSettleAmt(obj.getBigDecimal("e_verifyamount"));
            entryVO.setVerifyAmt(obj.getBigDecimal("e_verifytaxamount"));
            recordVO.getVrEntrys().add(entryVO);
        }
        return recordVO;
    }

    public static DynamicObject[] converVO2Dyn(List<VerifyRecordVO> resultList) {
        DynamicObject[] resultArr = new DynamicObject[resultList.size()];
        DynamicObjectType dt = null;
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(8);
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            VerifyRecordVO vo = resultList.get(i);
            DynamicObject org = (DynamicObject)orgMap.get(vo.getOrgId());
            if (org == null) {
                org = BusinessDataServiceHelper.loadSingleFromCache((Object)vo.getOrgId(), (String)"bos_org");
                orgMap.put(vo.getOrgId(), org);
            }
            DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"ap_verifyrecord");
            result.set("billno", (Object)vo.getBillNo());
            result.set("billstatus", (Object)"C");
            result.set("billtype", (Object)vo.getBillType());
            result.set("billdate", (Object)vo.getBillDate());
            result.set("material", (Object)vo.getMaterialId());
            result.set("measureunit", (Object)vo.getMeasureunitId());
            result.set("baseunit", (Object)vo.getBaseunitId());
            result.set("qty", (Object)vo.getQty());
            result.set("verifyqty", (Object)vo.getVerifyQty());
            result.set("verifybaseqty", (Object)vo.getVerifyBaseQty());
            result.set("asstacttype", (Object)vo.getAsstActType());
            result.set("asstact", (Object)vo.getAsstActId());
            result.set("org", (Object)org);
            result.set("currency", (Object)vo.getCurrencyId());
            result.set("payableamount", (Object)vo.getMainPayableAmt());
            result.set("verifyseq", (Object)vo.getSettleSeq());
            result.set("createtime", (Object)vo.getSettleDate());
            result.set("creator", (Object)vo.getCreatorId());
            result.set("verifytype", (Object)vo.getSettleType());
            result.set("verifyrelation", (Object)vo.getSettleRela());
            result.set("billid", (Object)vo.getMainBillId());
            result.set("billentryid", (Object)vo.getMainBillEntryId());
            result.set("basecurrency", (Object)vo.getBaseCurrencyId());
            String mainquotation = vo.getQuotation();
            BigDecimal mainexchangeRate = vo.getExchangeRate();
            int mainbasePrecision = vo.getBasePrecision();
            BigDecimal totalSettleAmt = vo.getTotalSettleAmt();
            BigDecimal verifyAmt = vo.getVerifyAmt();
            result.set("quotation", (Object)mainquotation);
            result.set("exchangerate", (Object)mainexchangeRate);
            result.set("swappl", (Object)vo.getSwapPL());
            result.set("verifyamount", (Object)totalSettleAmt);
            result.set("verifytaxamount", (Object)verifyAmt);
            BigDecimal localVerAmt = QuotationHelper.getLocamtByQuotation((String)mainquotation, (BigDecimal)totalSettleAmt, (BigDecimal)mainexchangeRate, (int)mainbasePrecision);
            BigDecimal localVertaxAmt = QuotationHelper.getLocamtByQuotation((String)mainquotation, (BigDecimal)verifyAmt, (BigDecimal)mainexchangeRate, (int)mainbasePrecision);
            result.set("localverifyamt", (Object)localVerAmt);
            result.set("localverifytaxamt", (Object)localVertaxAmt);
            if (dt == null) {
                EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)result.getDataEntityType().getName()).findProperty("entry");
                dt = prop.getDynamicCollectionItemPropertyType();
            }
            List entrys = vo.getVrEntrys();
            for (VerifyRecordEntryVO entry : entrys) {
                DynamicObject resultEntry = new DynamicObject(dt);
                resultEntry.set("e_billno", (Object)entry.getBillNum());
                resultEntry.set("e_billtype", (Object)entry.getBillType());
                resultEntry.set("e_billdate", (Object)entry.getBillDate());
                resultEntry.set("e_asstacttype", (Object)entry.getAsstActType());
                resultEntry.set("e_asstact", (Object)entry.getAsstActId());
                resultEntry.set("e_description", (Object)entry.getDescription());
                resultEntry.set("e_currency", (Object)entry.getCurrencyId());
                resultEntry.set("e_material", (Object)entry.getMaterielId());
                resultEntry.set("e_measureunit", (Object)entry.getMeasureunitId());
                resultEntry.set("e_baseunit", (Object)entry.getBaseunitId());
                resultEntry.set("e_qty", (Object)entry.getQty());
                resultEntry.set("e_payableamount", (Object)entry.getPayableAmt());
                resultEntry.set("e_verifyqty", (Object)entry.getVerifyQty());
                resultEntry.set("e_verifybaseqty", (Object)entry.getVerifyBaseQty());
                resultEntry.set("e_billid", (Object)entry.getBillId());
                resultEntry.set("e_billentryid", (Object)entry.getBillEntryId());
                resultEntry.set("e_basecurrency", (Object)entry.getBaseCurrencyId());
                String quotation = entry.getQuotation();
                int basePrecision = entry.getBasePrecision();
                BigDecimal exchangeRate = entry.getExchangeRate();
                BigDecimal settleAmt = entry.getSettleAmt();
                BigDecimal vertaxAmt = entry.getVerifyAmt();
                resultEntry.set("e_quotation", (Object)quotation);
                resultEntry.set("e_exchangerate", (Object)exchangeRate);
                resultEntry.set("e_verifyamount", (Object)settleAmt);
                BigDecimal eLocalVerAmt = QuotationHelper.getLocamtByQuotation((String)quotation, (BigDecimal)settleAmt, (BigDecimal)exchangeRate, (int)basePrecision);
                resultEntry.set("e_localverifyamt", (Object)eLocalVerAmt);
                resultEntry.set("e_verifytaxamount", (Object)vertaxAmt);
                BigDecimal elocalVertaxAmt = QuotationHelper.getLocamtByQuotation((String)quotation, (BigDecimal)vertaxAmt, (BigDecimal)exchangeRate, (int)basePrecision);
                resultEntry.set("e_localverifytaxamt", (Object)elocalVertaxAmt);
                resultEntry.set("e_swappl", (Object)entry.getSwapPL());
                result.getDynamicObjectCollection("entry").add((Object)resultEntry);
            }
            resultArr[i] = result;
        }
        return resultArr;
    }

    public static Map<String, List<DynamicObject>> classfyByRelation(DynamicObject[] entities) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(entities.length);
        for (DynamicObject entity : entities) {
            Set keySet = map.keySet();
            String verifyRelation = entity.getString("verifyrelation");
            List objList = null;
            objList = keySet.contains(verifyRelation) ? (List)map.get(verifyRelation) : new ArrayList();
            objList.add(entity);
            map.put(verifyRelation, objList);
        }
        return map;
    }

    @Deprecated
    public static void invokeDisposeScmc(List<Map<String, Object>> disposeList, boolean isSettle) {
        if (disposeList != null && disposeList.size() > 0) {
            VerifyLogHelper.logInvokeScmcParam(disposeList, (boolean)isSettle);
            try (TXHandle tx = TX.requiresNew((String)"verifyinvokeScmc");){
                try {
                    if (isSettle) {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"APVerify", (Object[])new Object[]{disposeList});
                    } else {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"APUnVerify", (Object[])new Object[]{disposeList});
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void invokeDisposeMdc(List<Map<String, Object>> disposeList, boolean isSettle) {
        if (disposeList != null && disposeList.size() > 0) {
            VerifyLogHelper.logInvokeScmcParam(disposeList, (boolean)isSettle);
            String serviceName = "MdcOminWriteOffService";
            String omInbillkey = VerifyServiceHelper.getOmInBillKey();
            if ("im_mdc_omcmplinbill".equals(omInbillkey)) {
                serviceName = "MdcOmCmplInWriteOffService";
            }
            try (TXHandle tx = TX.requiresNew((String)"verifyinvokeMdc");){
                try {
                    if (isSettle) {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)serviceName, (String)"OminVerify", (Object[])new Object[]{disposeList});
                    } else {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)serviceName, (String)"OminUnVerify", (Object[])new Object[]{disposeList});
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static boolean sameDirection(BigDecimal a, BigDecimal b) {
        return a.compareTo(BigDecimal.ZERO) * b.compareTo(BigDecimal.ZERO) >= 0;
    }

    public static Set<String> getVerifyBillTypeNum() {
        HashSet<String> billTypeSet = new HashSet<String>(8);
        billTypeSet.add("ApFin_pur_BT_S");
        billTypeSet.add("ap_finapbill_asset_BT_S");
        billTypeSet.add("ApFin_service_BT_S");
        billTypeSet.add("ApFin_product_BT_S");
        billTypeSet.add("ApFin_fee_BT_S");
        String billTypes = StdConfig.get((String)"verify.apbilltype");
        if (StringUtils.isNotEmpty((String)billTypes)) {
            String[] billTypeArr;
            for (String billType : billTypeArr = billTypes.split(",")) {
                billTypeSet.add(billType);
            }
        }
        billTypeSet.remove("ApFin_borr_BT_S");
        billTypeSet.remove("ApFin_other_BT_S");
        billTypeSet.remove("ApFin_purfee_BT_S");
        billTypeSet.remove("ApFin_salefee_BT_S");
        return billTypeSet;
    }

    public static Set<String> getExcludeBillTypeNum() {
        HashSet<String> billTypeSet = new HashSet<String>(8);
        billTypeSet.add("ApFin_borr_BT_S");
        billTypeSet.add("ApFin_other_BT_S");
        billTypeSet.add("ApFin_purfee_BT_S");
        billTypeSet.add("ApFin_salefee_BT_S");
        return billTypeSet;
    }

    public static Set<Long> getMainBillIdsByCoreBill(String mainEntity, DynamicObject[] apBills) {
        HashSet<String> coreBillNoSet = new HashSet<String>(64);
        HashSet<Integer> coreBillEntrySeqSet = new HashSet<Integer>(64);
        HashMap coreBillTypeMap = new HashMap(8);
        for (DynamicObject obj : apBills) {
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entries) {
                String coreBillType;
                String coreBillno = entry.getString("corebillno");
                if (ObjectUtils.isEmpty((Object)coreBillno)) continue;
                coreBillNoSet.add(coreBillno);
                int coreSeq = entry.getInt("corebillentryseq");
                if (coreSeq != 0) {
                    coreBillEntrySeqSet.add(coreSeq);
                }
                if (ObjectUtils.isEmpty((Object)(coreBillType = entry.getString("corebilltype")))) continue;
                Set coreBillNoTmpSet = (Set)coreBillTypeMap.get(coreBillType);
                if (coreBillNoTmpSet != null) {
                    coreBillNoTmpSet.add(coreBillno);
                    continue;
                }
                HashSet<String> tempSet = new HashSet<String>(8);
                tempSet.add(coreBillno);
                coreBillTypeMap.put(coreBillType, tempSet);
            }
        }
        HashSet<Long> mainBillIds = new HashSet<Long>(8);
        if (coreBillNoSet.size() > 0 && coreBillEntrySeqSet.size() > 0) {
            QFilter filter = new QFilter("billentry.mainbillnumber", "in", coreBillNoSet);
            filter.and("billentry.mainbillentryseq", "in", coreBillEntrySeqSet);
            filter.and("billstatus", "=", (Object)"C");
            filter.and("billentry.logisticsbill", "=", (Object)Boolean.FALSE);
            filter.and("billentry.unverifyqty", "<>", (Object)BigDecimal.ZERO);
            if ("im_purinbill".equals(mainEntity)) {
                QFilter isnotVmiDomianFilter = new QFilter("biztype.domain", "<>", (Object)"6");
                QFilter virtualBillFilter = new QFilter("isvirtualbill", "=", (Object)Boolean.TRUE);
                QFilter isnotvirtualBillFilter = new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE);
                QFilter vmiFilter = isnotVmiDomianFilter.and(isnotvirtualBillFilter);
                filter.and(vmiFilter.or(virtualBillFilter));
            }
            QFilter commonFilter = ArApXDBHelper.getPurInBillXDBFilter((String)mainEntity, coreBillTypeMap);
            filter.and(commonFilter);
            List pks = QueryServiceHelper.queryPrimaryKeys((String)mainEntity, (QFilter[])new QFilter[]{filter}, (String)"biztime,billno", (int)-1);
            mainBillIds = new HashSet(pks);
        }
        return mainBillIds;
    }

    public static String getOmInBillKey() {
        String omInbillkey = StdConfig.get((String)"mdcinbillkey");
        return EmptyUtils.isEmpty((Object)omInbillkey) ? "im_mdc_omcmplinbill" : "im_mdc_ominbill";
    }

    public static void invokeDisposeScmc(List<VerifyRecordVO> voList, List<Map<String, Object>> disposeList, SettleSchemeVO scheme) {
        if (disposeList != null && disposeList.size() > 0) {
            boolean isSettle = scheme.isSettle();
            VerifyLogHelper.logInvokeScmcParam(disposeList, (boolean)isSettle);
            if (ECServiceHelper.isVerifyImOpened()) {
                logger.info("apinvokeDisposeScmc-consistency-true");
                long uniqueKey = DB.genGlobalLongId();
                for (Map<String, Object> dispose : disposeList) {
                    dispose.put("uniquekey", uniqueKey);
                }
                CommonParam ecParam = new CommonParam();
                ecParam.put((Object)"disposeList", disposeList);
                Set mainIdList = voList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
                HashSet asstIdList = new HashSet(voList.size());
                for (VerifyRecordVO vr : voList) {
                    List vrEntrys = vr.getVrEntrys();
                    Set asstIds = vrEntrys.stream().map(SettleRecordEntryVO::getBillId).collect(Collectors.toSet());
                    asstIdList.addAll(asstIds);
                }
                ArrayList businessInfo = new ArrayList(voList.size());
                businessInfo.addAll(mainIdList);
                businessInfo.addAll(asstIdList);
                if (isSettle) {
                    List recordPks = scheme.getRecordPks();
                    businessInfo.addAll(recordPks);
                    ECServiceHelper.beginAndRegisterWithBusInfo((String)"ap_verify", (String)"ap_verify_wbpur", (String)"fi", (String)"ap", (String)"ApVerifyWBPurEC", (Param)ecParam, (String)"", businessInfo);
                } else {
                    ECServiceHelper.beginAndRegister((String)"ap_unverify", (String)"ap_unverify_wbpur", (String)"fi", (String)"ap", (String)"ApUnVerifyWBPurEC", (Param)ecParam, (String)"");
                }
            } else {
                logger.info("apinvokeDisposeScmc-consistency-false");
                try (TXHandle tx = TX.requiresNew((String)"verifyinvokeScmc");){
                    try {
                        if (isSettle) {
                            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"APVerify", (Object[])new Object[]{disposeList});
                        } else {
                            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"APUnVerify", (Object[])new Object[]{disposeList});
                        }
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    public static void invokeDisposeScm(List<Map<String, Object>> disposeList, SettleSchemeVO scheme) {
        Boolean isCQConfig = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
        if (!isCQConfig.booleanValue()) {
            return;
        }
        if ("false".equals(StdConfig.get((String)"fi_feature_wbsmcpur"))) {
            return;
        }
        if (disposeList != null && disposeList.size() > 0) {
            boolean isSettle = scheme.isSettle();
            VerifyLogHelper.logInvokeScmcParam(disposeList, (boolean)isSettle);
            Object entity = disposeList.get(0).get("entity");
            Set pks = disposeList.stream().map(row -> row.get("pk")).collect(Collectors.toSet());
            List suppcollaPKs = QueryServiceHelper.queryPrimaryKeys((String)entity.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", pks), new QFilter("supplier.issuppcolla", "=", (Object)Boolean.TRUE)}, (String)"", (int)-1);
            if (ObjectUtils.isEmpty((Object)suppcollaPKs)) {
                logger.info("apinvokeDisposeScm-suppcollaPKs-empty");
                return;
            }
            ArrayList<Map<String, Object>> disposeSuppcollaList = new ArrayList<Map<String, Object>>(8);
            for (Map<String, Object> row2 : disposeList) {
                Iterator pk = row2.get("pk");
                if (!suppcollaPKs.contains(pk)) continue;
                disposeSuppcollaList.add(row2);
            }
            logger.info("apinvokeDisposeScm-consistency-true");
            long uniqueKey = DB.genGlobalLongId();
            for (Map map : disposeSuppcollaList) {
                map.put("uniquekey", uniqueKey);
            }
            CommonParam ecParam = new CommonParam();
            ecParam.put((Object)"isverify", (Object)isSettle);
            ecParam.put((Object)"disposelist", disposeSuppcollaList);
            if (isSettle) {
                ECServiceHelper.beginAndRegister((String)"ap_verify", (String)"ap_verify_wbsmcpur", (String)"scm", (String)"pur", (String)"IVerifyService", (Param)ecParam, (String)"");
            } else {
                ECServiceHelper.beginAndRegister((String)"ap_unverify", (String)"ap_unverify_wbsmcpur", (String)"scm", (String)"pur", (String)"IVerifyService", (Param)ecParam, (String)"");
            }
        }
    }

    public static void verifyInvokeCal(List<Object> verifyRecordPks) {
        if (ObjectUtils.isEmpty(verifyRecordPks)) {
            return;
        }
        if (ECServiceHelper.isVerifyCalOpened()) {
            logger.info("apverifyInvokeCal-consistency-true");
            CommonParam param = new CommonParam();
            param.put((Object)"verifyRecordPks", verifyRecordPks);
            ECServiceHelper.beginAndRegister((String)"ap_verify", (String)"ap_verify_invokecal", (String)"fi", (String)"ap", (String)"ApVerifyInvokeCalEC", (Param)param, (String)"");
        } else {
            logger.info("apverifyInvokeCal-consistency-false");
            DynamicObject[] vrDatas = BusinessDataServiceHelper.load((String)"ap_verifyrecord", (String)"id,billid,verifyseq,billentryid,billtype,billno,verifyqty,billstatus,createtime,auditor,modifytime,auditdate,org,entry.e_billid,entry.e_billentryid,entry.e_billno,entry.e_billtype", (QFilter[])new QFilter[]{new QFilter("id", "in", verifyRecordPks)});
            ThreadPools.executeOnceIncludeRequestContext((String)"invoke.apVerify", () -> {
                logger.info("ap-invoke fi-cal-CalBizService");
                Object logPk = MserviceLogHelper.insertFailMsLog4VerifyCal((String)"apverify-cal", (Object[])new Object[]{"PURWRITEOFF", null, vrDatas});
                logger.info("ap-insertFailMsLog4VerifyCal success");
                try {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{"PURWRITEOFF", null, vrDatas});
                    logger.info("ap fi-cal-CalBizService success");
                    MserviceLogHelper.updateMserviceLogSuccess((Object)logPk);
                }
                catch (Exception e) {
                    logger.info("ap CalBizService-exception");
                    logger.error((Throwable)e);
                    MserviceLogHelper.updateExceptionInfo((Object)logPk, (String)e.toString());
                }
            });
        }
    }

    public static String getFinApSelector() {
        return "id,billno,bizdate,currency,basecurrency,asstacttype,asstact,quotation,exchangerate,e_pricetaxtotal,material,actprice,corebillno,corebillentryseq,measureunit,e_baseunit,e_materialversion,org.id,amount,e_baseunitqty,e_assistantattr,e_unitconvertrate,quantity,verifyquantity,actpricetax,e_amount,unverifyamount,unverifyquantity,verifyamount,e_unverifyamount,e_sourcebillentryid,ispresent,e_isallverify,billtypeid,spectype,configuredcode,tracknumber";
    }

    public static String getPurSelector() {
        return "id,org,invscheme.transceivertype,billno,settlecurrency,currency,quotation,exchangerate,billtype,biztime,supplier,billentry.actualprice,billentry.actualtaxprice,billentry.id,billentry.material,billentry.qty,billentry.amount,billentry.ispresent,billentry.mainbillnumber,billentry.baseqty,billentry.unverifyqty,billentry.unit,billentry.baseunit,billentry.entrysettleorg,billentry.mainbillentryseq,billentry.srcbillentryid,billentry.mversion,billentry.material.masterid.modelnum,billentry.auxpty,billentry.configuredcode,billentry.tracknumber,billentry.invoicesupplier";
    }
}

