/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.kdtx.ec;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.mservice.RefundAndRenoteNewExecutor;
import kd.fi.ap.mservice.helper.RefundAndRenoteServiceHelper;
import kd.fi.ap.mservice.helper.RefundAndRenoteWriteBackHelper;
import kd.fi.ap.vo.PayRefundEntryInfo;
import kd.fi.ap.vo.RefundAndRenoteParam;
import kd.fi.arapcommon.kdtx.ec.service.DefaultECServiceIdempotentProperties;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.Result;

public class RefundAndRenoteECService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(RefundAndRenoteECService.class);

    protected DtxResponse doExecute(Object param, Object o1) {
        logger.info("RefundAndRenoteECService execute start");
        try (TXHandle tx = TX.required();){
            try {
                CommonParam ecParam = (CommonParam)param;
                String paramJson = (String)ecParam.get((Object)"paramJson");
                RefundAndRenoteParam refundAndRenoteParam = RefundAndRenoteServiceHelper.confirmConvertParam(paramJson);
                logger.info("RefundAndRenoteECService.execute param convert result:" + JSON.toJSONString((Object)refundAndRenoteParam));
                boolean isExecuteNewLogic = RefundAndRenoteServiceHelper.isExecuteNewLogic();
                if (isExecuteNewLogic) {
                    this.executeNewLogic(refundAndRenoteParam);
                } else {
                    this.executeOldLogic(refundAndRenoteParam);
                }
            }
            catch (Throwable e) {
                logger.error("RefundAndRenoteECService error:" + e);
                tx.markRollback();
                throw e;
            }
        }
        logger.info("RefundAndRenoteECService execute end");
        return null;
    }

    private void executeNewLogic(RefundAndRenoteParam refundAndRenoteParam) {
        new RefundAndRenoteNewExecutor().confirm(refundAndRenoteParam);
    }

    private void executeOldLogic(RefundAndRenoteParam refundAndRenoteParam) {
        String sourcebilltype;
        Result apDisposeLockResult;
        Long recBillId = refundAndRenoteParam.getRecId();
        Set payIds = refundAndRenoteParam.getPayInfos().stream().map(PayRefundEntryInfo::getPayId).collect(Collectors.toSet());
        Long payBillId = (Long)payIds.iterator().next();
        DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)recBillId, (String)"cas_recbill");
        BigDecimal refundAmt = recBill.getBigDecimal("actrecamt");
        BigDecimal actRecAmtFee = refundAmt.add(recBill.getBigDecimal("fee"));
        BigDecimal actpayamt = payBill.getBigDecimal("actpayamt");
        Boolean isfullrefund = Boolean.TRUE;
        if (actRecAmtFee.compareTo(actpayamt) != 0) {
            isfullrefund = Boolean.FALSE;
        }
        Boolean isSettle = Boolean.FALSE;
        DynamicObject payType = payBill.getDynamicObject("paymenttype");
        if (payType != null && payType.getBoolean("ispartpayment")) {
            isSettle = Boolean.TRUE;
        }
        if (isSettle.booleanValue()) {
            Result apPayUnSettleResult = RefundAndRenoteWriteBackHelper.cancelSettle(payBill);
            this.isResultFail(apPayUnSettleResult);
            apDisposeLockResult = RefundAndRenoteWriteBackHelper.payRecSettle(payBill, recBill);
            this.isResultFail(apDisposeLockResult);
            if (!isfullrefund.booleanValue()) {
                Result apPaySettleResult = RefundAndRenoteWriteBackHelper.apPaySettle(payBill);
                this.isResultFail(apPaySettleResult);
            }
        }
        if (StringUtils.isNotEmpty((String)(sourcebilltype = payBill.getString("sourcebilltype")))) {
            if (!"ap_finapbill".equals(sourcebilltype) && !"ar_finarbill".equals(sourcebilltype)) {
                RefundAndRenoteWriteBackHelper.writeBackApply(payBill);
            } else {
                apDisposeLockResult = RefundAndRenoteWriteBackHelper.writerBackAP(payBill);
                this.isResultFail(apDisposeLockResult);
            }
        }
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultECServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }

    private void isResultFail(Result result) {
        if (!"0".equals(result.getCode())) {
            throw new KDBizException(result.getErrorInfo());
        }
    }
}

