/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.ap.mservice.PayRecManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PaidSettleTestChecker;
import kd.fi.arapcommon.unittest.framework.check.ReceivedSettleTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PaidBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.ReceivedBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PaidBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.ReceivedBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.BillRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.EntryRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AP012_001_PayRecManualSettleSameUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u4ed8\u6b3e\u51b2\u6536\u6b3e-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testPayRec_001_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"PayRecMSettle_CasPay_001_1", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"PayRecMSettle_CasRec_001_1", (DynamicObject)org, entryInfoRecList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        PayRecManualSettleService service = new PayRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{payBill.getLong("id")};
        Object[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForSettleForTestPayRec_001_1(mainIds, (Long[])asstIds);
        OperationResult cancelRecRusult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelRecRusult);
        this.checkForUnSettleForTestPayRec_001_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u4ed8\u6b3e\u51b2\u6536\u6b3e-\u6574\u5355-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d")
    @Test
    public void testPayRec_001_2() throws InterruptedException {
        DynamicObject[] payBills;
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(1);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"PayRecMSettle_CasPay_001_2", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"PayRecMSettle_CasRec_001_2_0", (DynamicObject)org, entryInfoRecList);
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"PayRecMSettle_CasRec_001_2_1", (DynamicObject)org, entryInfoRecList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)payBill, (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ArrayList<BillRowVO> asstBills = new ArrayList<BillRowVO>(2);
        BillRowVO rowModel = new BillRowVO(recBill, BigDecimal.valueOf(50L));
        BillRowVO rowModel0 = new BillRowVO(recBill1, BigDecimal.valueOf(50L));
        asstBills.add(rowModel);
        asstBills.add(rowModel0);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(asstBills, (boolean)false);
        PayRecManualSettleService service = new PayRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Object[] mainIds = new Long[]{payBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id"), recBill1.getLong("id")};
        this.checkForSettleForTestPayRec_001_2((Long[])mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestPayRec_001_2((Long[])mainIds, asstIds);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestPayRec_001_2((Long[])mainIds, asstIds);
        OperationResult cancelPayRusult = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelPayRusult);
        Thread.sleep(20000L);
        this.checkForUnSettleForTestPayRec_001_2((Long[])mainIds, asstIds);
        for (DynamicObject bill : payBills = CasPayBillTestDataProvider.loadData((Long[])mainIds)) {
            bill.set("billstatus", (Object)"D");
        }
        SaveServiceHelper.save((DynamicObject[])payBills);
        service.manualSettle(mainRows, asstRows, param);
        this.checkForSettleForTestPayRec_001_2((Long[])mainIds, asstIds);
        OperationResult cancelRecRusult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])new Long[]{asstIds[0]}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelRecRusult);
        this.checkForUnSettleForTestPayRec_001_2_0((Long[])mainIds, asstIds, asstIds[0]);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u4ed8\u6b3e\u51b2\u6536\u6b3e-\u5206\u5f55-\u4e00\u5bf9\u591a-\u76f8\u540c\u91d1\u989d")
    @Test
    public void testPayRec_001_3() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        DynamicObject payBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"PayRecMSettle_CasPay_001_3", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"PayRecMSettle_CasRec_001_3_0", (DynamicObject)org, entryInfoRecList);
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((String)"PayRecMSettle_CasRec_001_3_1", (DynamicObject)org, entryInfoRecList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry((DynamicObject)payBill, (DynamicObject)((DynamicObject)payBill.getDynamicObjectCollection("entry").get(0)), (BigDecimal)BigDecimal.valueOf(100L), (boolean)false);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        EntryRowVO row1 = new EntryRowVO(recBill, (DynamicObject)recBill.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        EntryRowVO row2 = new EntryRowVO(recBill1, (DynamicObject)recBill1.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(50L));
        asstBills.add(row1);
        asstBills.add(row2);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        PayRecManualSettleService service = new PayRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(false);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{payBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id"), recBill1.getLong("id")};
        this.checkForSettleForTestPayRec_001_3(mainIds, asstIds);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u4ed8\u6b3e(\u9884\u4ed8)\u51b2\u6536\u6b3e(\u9884\u6536)-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testPayRec_001_4() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<PaidBillDataDetailVO> entryInfoPayList = new ArrayList<PaidBillDataDetailVO>(1);
        entryInfoPayList.add(PaidBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)));
        entryInfoPayList.add(PaidBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)));
        DynamicObject paidBill = PaidBillTestDataProvider.buildByEntryPriceTaxTotal((String)"PayRecMSettle_Paid_001_5_0", (DynamicObject)org, entryInfoPayList);
        ArrayList<ReceivedBillDataDetailVO> entryInfoRecList = new ArrayList<ReceivedBillDataDetailVO>(1);
        entryInfoRecList.add(ReceivedBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)));
        entryInfoRecList.add(ReceivedBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)));
        DynamicObject receivedBill = ReceivedBillTestDataProvider.buildByEntryPriceTaxTotal((String)"PayRecMSettle_Rece_001_5_0", (DynamicObject)org, entryInfoRecList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)paidBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)receivedBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        PayRecManualSettleService service = new PayRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{paidBill.getLong("id")};
        Long[] asstIds = new Long[]{receivedBill.getLong("id")};
        this.checkForSettleForTestPayRec_001_4(mainIds, asstIds);
    }

    private void checkForSettleForTestPayRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        DynamicObjectCollection entries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestPayRec_001_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestPayRec_001_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestPayRec_001_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasPayBillTestChecker.validateInitialCasPayBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForUnSettleForTestPayRec_001_2_0(Long[] mainIds, Long[] asstIds, Long cancelRecAsstId) {
        DynamicObject[] needCheckAsstBills;
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        DynamicObjectCollection entries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject entry = (DynamicObject)entries.get(0);
        CasPayBillTestChecker.validateCasPayBillLockAndSettleAmt((DynamicObject)entry, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        for (DynamicObject needCheckAsstBill : needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds)) {
            Long asstBillId = needCheckAsstBill.getLong("id");
            if (asstBillId.equals(cancelRecAsstId)) {
                CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
                continue;
            }
            CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        }
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)false);
        KDAssert.assertEquals((boolean)true, (settleRecords.length == 1 ? 1 : 0) != 0);
        DynamicObject settleRecord = settleRecords[0];
        SettleRecordTestChecker.checkSettleAmt((DynamicObject)settleRecord, (BigDecimal)BigDecimal.valueOf(50L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestPayRec_001_3(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestPayRec_001_4(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = PaidBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        DynamicObjectCollection entries = needCheckMainBill.getDynamicObjectCollection("entry");
        DynamicObject entry0 = (DynamicObject)entries.get(0);
        PaidSettleTestChecker.checkEntry((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L));
        DynamicObject entry1 = (DynamicObject)entries.get(1);
        PaidSettleTestChecker.checkEntry((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(50L));
        DynamicObject[] needCheckAsstBills = ReceivedBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        entries = needCheckAsstBill.getDynamicObjectCollection("entry");
        entry0 = (DynamicObject)entries.get(0);
        ReceivedSettleTestChecker.checkEntry((DynamicObject)entry0, (BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(0L));
        entry1 = (DynamicObject)entries.get(1);
        ReceivedSettleTestChecker.checkEntry((DynamicObject)entry1, (BigDecimal)BigDecimal.valueOf(50L), (BigDecimal)BigDecimal.valueOf(0L));
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }
}

