/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.ap.mservice.ApRecManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.BillRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AP012_002_ApRecManualSettleDiffUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u4ed8\u9000\u6b3e-\u5f02\u5e01\u522b-\u8ba1\u5212\u884c-\u6574\u5355-\u4e00\u5bf9\u4e00-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testApRec_002_1() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(1));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)).setSeq(2));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((String)"ApRec_Diff_MS_Ap_002_1", (DynamicObject)org, entryInfoApList);
        CasRecBillDataVO recInfo = CasRecBillDataVO.New().setBillNo("ApRec_Diff_MS_Rec_002_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(2));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recInfo, entryInfoRecList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(200L), (boolean)false);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)recBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        ApRecManualSettleService service = new ApRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Object[] asstIds = new Long[]{recBill.getLong("id")};
        this.checkForSettleForTestApRec_002_1(mainIds, (Long[])asstIds);
        OperationResult cancelRecRusult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (Object[])asstIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)cancelRecRusult);
        this.checkForUnSettleForTestApRec_002_1(mainIds, (Long[])asstIds);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u4ed8\u9000\u6b3e-\u5f02\u5e01\u522b-\u7269\u6599\u884c-\u6574\u5355-\u4e00\u5bf9\u591a-\u4e0d\u540c\u91d1\u989d")
    @Test
    public void testApRec_002_2() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(1);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(200L)).setQuantity(BigDecimal.valueOf(-1L)));
        DynamicObject apBill = FinApBillTestDataProvider.buildByPriceAndQuantity((String)"ApRec_Diff_MS_Ap_002_2_0", (DynamicObject)org, entryInfoApList);
        CasRecBillDataVO recInfo = CasRecBillDataVO.New().setBillNo("ApRec_Diff_MS_Rec_002_2_1").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        CasRecBillDataVO recInfo1 = CasRecBillDataVO.New().setBillNo("ApRec_Diff_MS_Rec_002_2_2").setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyUSD().getLong("id"))).setExchangerate(BigDecimal.valueOf(2L)).setOrg(org);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(50L)).setSeq(1));
        DynamicObject recBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recInfo, entryInfoRecList);
        DynamicObject recBill1 = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recInfo1, entryInfoRecList);
        DynamicObject[] mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)apBill, (BigDecimal)BigDecimal.valueOf(200L), (boolean)false);
        ArrayList<BillRowVO> asstBills = new ArrayList<BillRowVO>(2);
        BillRowVO rowModel = new BillRowVO(recBill, BigDecimal.valueOf(50L));
        BillRowVO rowModel0 = new BillRowVO(recBill1, BigDecimal.valueOf(50L));
        asstBills.add(rowModel);
        asstBills.add(rowModel0);
        DynamicObject[] asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal(asstBills, (boolean)false);
        ApRecManualSettleService service = new ApRecManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setTotal(true);
        param.setDiffCurrencySettle(true);
        Long orgId = org.getLong("id");
        param.setOrgPk((Object)orgId);
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)orgId));
        service.manualSettle(mainRows, asstRows, param);
        Long[] mainIds = new Long[]{apBill.getLong("id")};
        Long[] asstIds = new Long[]{recBill.getLong("id"), recBill1.getLong("id")};
        this.checkForSettleForTestApRec_002_2(mainIds, asstIds);
        Set settleRecordIds = ManualSettleUnitTestHelper.getSettleRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unSettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unSettleResult);
        this.checkForUnSettleForTestApRec_002_2(mainIds, asstIds);
    }

    private void checkForSettleForTestApRec_002_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)false);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(-100L));
    }

    private void checkForUnSettleForTestApRec_002_1(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForSettleForTestApRec_002_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData((Long[])mainIds, (Long[])asstIds, (boolean)false);
        DynamicObject settleRecord0 = settleRecords[0];
        SettleRecordTestChecker.checkSwapL((DynamicObject)settleRecord0, (BigDecimal)BigDecimal.valueOf(0L));
    }

    private void checkForUnSettleForTestApRec_002_2(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateInitialApFin((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill);
        DynamicObject needCheckAsstBill0 = needCheckAsstBills[1];
        CasRecBillTestChecker.validateInitialBill((DynamicObject)needCheckAsstBill0);
        SettleRecordTestChecker.checkNotExist((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }
}

