/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.ap.mservice.ApSchemeSettleService;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.CasRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.scene.process.settle.SchemeSettleUnitTestHelper;
import org.junit.Test;

public class AP013_001_SchemeSettleUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u4ed8\u4ed8\u6b3e")
    @Test
    public void testApPay() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        DynamicObject mainBill = FinApBillTestDataProvider.buildByPriceAndQuantity((String)"ApPaySchemeSettle_FinAp", (DynamicObject)org, entryInfoApList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        CasPayBillDataVO billInfo = CasPayBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("ApPaySchemeSettle_CasPay").setOrg(org).setAsstactId(Long.valueOf(mainBill.getDynamicObject("asstact").getLong("id")));
        DynamicObject asstBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)billInfo, entryInfoPayList);
        DynamicObject scheme = SchemeSettleUnitTestHelper.buildScheme((DynamicObject)org, (String)SettleRelationEnum.APPAYSETTLE.getValue(), (String)mainBill.getString("billno"), (String)asstBill.getString("billno"), (boolean)false);
        ApSchemeSettleService service = new ApSchemeSettleService();
        service.schemeSettle(scheme);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        this.checkForApPay(mainIds, asstIds);
        SchemeSettleUnitTestHelper.deleteScheme((DynamicObject)scheme);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u4ed8\u51b2\u5e94\u6536")
    @Test
    public void testApAr() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        FinApBillDataVO billMainInfo = new FinApBillDataVO();
        billMainInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("ApArSchemeSettle_FinAp").setOrg(org).setSupplier(BaseDataTestProvider.getCoordinationSupplier());
        DynamicObject mainBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)billMainInfo, entryInfoApList);
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(2);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        FinArBillDataVO billInfo = FinArBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("ApArSchemeSettle_FinAr").setOrg(org).setCustomer(BaseDataTestProvider.getCoordinationCustomer());
        DynamicObject asstBill = FinArBillTestDataProvider.buildByPriceAndQuantity((FinArBillDataVO)billInfo, entryInfoArList);
        DynamicObject scheme = SchemeSettleUnitTestHelper.buildScheme((DynamicObject)org, (String)SettleRelationEnum.APARSETTLE.getValue(), (String)mainBill.getString("billno"), (String)asstBill.getString("billno"), (boolean)false);
        ApSchemeSettleService service = new ApSchemeSettleService();
        service.schemeSettle(scheme);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        this.checkForApAr(mainIds, asstIds);
        SchemeSettleUnitTestHelper.deleteScheme((DynamicObject)scheme);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u4ed8\u7ea2\u84dd\u5bf9\u51b2")
    @Test
    public void testApSelf() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        FinApBillDataVO billMainInfo = new FinApBillDataVO();
        billMainInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("ApSelfSchemeSettle_FinAp_1").setOrg(org);
        DynamicObject mainBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)billMainInfo, entryInfoApList);
        ArrayList<FinApBillDataDetailVO> entryInfoApList1 = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList1.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)));
        entryInfoApList1.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(-1L)));
        FinApBillDataVO billAsstInfo = new FinApBillDataVO();
        billAsstInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("ApSelfSchemeSettle_FinAp_2").setOrg(org).setSupplier(mainBill.getDynamicObject("asstact"));
        DynamicObject asstBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)billAsstInfo, entryInfoApList1);
        DynamicObject scheme = SchemeSettleUnitTestHelper.buildScheme((DynamicObject)org, (String)SettleRelationEnum.APSELF.getValue(), (String)mainBill.getString("billno"), (String)asstBill.getString("billno"), (boolean)false);
        ApSchemeSettleService service = new ApSchemeSettleService();
        service.schemeSettle(scheme);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        this.checkForApSelf(mainIds, asstIds);
        SchemeSettleUnitTestHelper.deleteScheme((DynamicObject)scheme);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u4ed8\u6b3e\u7ea2\u84dd\u5bf9\u51b2")
    @Test
    public void testPaySelf() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        DynamicObject mainBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)"PaySelfSchemeSettle_CasPay_1", (DynamicObject)org, entryInfoPayList);
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList0 = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList0.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-100L)).setSeq(1));
        entryInfoPayList0.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(-100L)).setSeq(2));
        CasPayBillDataVO billInfo = CasPayBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("PaySelfSchemeSettle_CasPay_2").setOrg(org).setAsstactId(Long.valueOf(mainBill.getLong("payee")));
        DynamicObject asstBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)billInfo, entryInfoPayList0);
        DynamicObject scheme = SchemeSettleUnitTestHelper.buildScheme((DynamicObject)org, (String)SettleRelationEnum.PAYSELF.getValue(), (String)mainBill.getString("billno"), (String)asstBill.getString("billno"), (boolean)false);
        ApSchemeSettleService service = new ApSchemeSettleService();
        service.schemeSettle(scheme);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        this.checkForPaySelf(mainIds, asstIds);
        SchemeSettleUnitTestHelper.deleteScheme((DynamicObject)scheme);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u4ed8\u6b3e\u51b2\u6536\u6b3e")
    @Test
    public void testPayRec() {
        DynamicObject org = BaseDataTestProvider.getPlanInitOrg();
        ArrayList<CasPayBillDataDetailVO> entryInfoPayList = new ArrayList<CasPayBillDataDetailVO>(2);
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoPayList.add(CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        CasPayBillDataVO billInfo = CasPayBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("PayRecSchemeSettle_CasPay").setOrg(org).setAsstactId(Long.valueOf(BaseDataTestProvider.getCoordinationSupplier().getLong("id")));
        DynamicObject mainBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((CasPayBillDataVO)billInfo, entryInfoPayList);
        ArrayList<CasRecBillDataDetailVO> entryInfoRecList = new ArrayList<CasRecBillDataDetailVO>(2);
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(1));
        entryInfoRecList.add(CasRecBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(100L)).setSeq(2));
        CasRecBillDataVO recInfo = CasRecBillDataVO.New().setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setExchangerate(BigDecimal.ONE).setBillNo("PayRecSchemeSettle_CasRec").setOrg(org).setAsstact(BaseDataTestProvider.getCoordinationCustomer());
        DynamicObject asstBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal((CasRecBillDataVO)recInfo, entryInfoRecList);
        DynamicObject scheme = SchemeSettleUnitTestHelper.buildScheme((DynamicObject)org, (String)SettleRelationEnum.PAYRECSETTLE.getValue(), (String)mainBill.getString("billno"), (String)asstBill.getString("billno"), (boolean)false);
        ApSchemeSettleService service = new ApSchemeSettleService();
        service.schemeSettle(scheme);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        this.checkForPayRec(mainIds, asstIds);
        SchemeSettleUnitTestHelper.deleteScheme((DynamicObject)scheme);
    }

    private void checkForApPay(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForApAr(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinArBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinArBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForApSelf(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = FinApBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckMainBill, (boolean)true, (boolean)false);
        DynamicObject[] needCheckAsstBills = FinApBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        FinApBillTestChecker.validateFinishApFin((DynamicObject)needCheckAsstBill, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForPaySelf(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasPayBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }

    private void checkForPayRec(Long[] mainIds, Long[] asstIds) {
        DynamicObject[] needCheckMainBills = CasPayBillTestDataProvider.loadData((Long[])mainIds);
        DynamicObject needCheckMainBill = needCheckMainBills[0];
        CasPayBillTestChecker.validateFinishCasPayBill((DynamicObject)needCheckMainBill);
        DynamicObject[] needCheckAsstBills = CasRecBillTestDataProvider.loadData((Long[])asstIds);
        DynamicObject needCheckAsstBill = needCheckAsstBills[0];
        CasRecBillTestChecker.validateFinishBill((DynamicObject)needCheckAsstBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])mainIds, (Long[])asstIds, (boolean)false);
    }
}

