/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.unittest.scene.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.ap.mservice.ApPayManualSettleService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasPayBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasPayBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.scene.process.settle.EntryRowVO;
import kd.fi.arapcommon.unittest.scene.process.settle.ManualSettleUnitTestHelper;
import kd.fi.arapcommon.vo.ManualSettleParam;
import org.junit.Test;

public class AP016_010_ApFin2PayTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deletePayBills = Arrays.asList("AP016_010_payBill_5", "AP016_010_payBill_7");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("ap_016", 1);
        SystemParameterHelper.setSystemParameter((boolean)false, (long)BaseDataTestProvider.getDetailInitOrg().getLong("id"), paramMap);
        SystemParameterHelper.setSystemParameter((boolean)false, (long)BaseDataTestProvider.getPlanInitOrg().getLong("id"), paramMap);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355\uff08\u7269\u6599\u884c,\u4eba\u6c11\u5e01\uff0c\u63d0\u4ea4\u6001\u53c2\u6570\u6253\u5f00\uff0c\u6e90\u5355\u548c\u8f6c\u4ed8\u5355\u5408\u5e76\u4ed8\u6b3e\uff09")
    @Test
    public void ApFinUnitTest_010_4() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApBill((boolean)false, (boolean)true, (boolean)false, (boolean)true, (String)"AP016_010_apfin_4");
        long finBillId = finBill.getLong("id");
        long transBillId = this.produceAuditTransBill(finBill);
        CasPayBillTestHelper.fullPushPayBill((String)"ap_finapbill", Collections.singletonList(finBillId), (String)"AP016_010_payBill_5");
        DynamicObject transBill = BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill");
        this.executeManualSettle(transBill, "AP016_010_payBill_6", true);
        transBill = BusinessDataServiceHelper.loadSingle((Object)transBillId, (String)"ap_finapbill");
        FinApBillTestChecker.validateFinApFullLockData((DynamicObject)transBill);
        FinApBillTestChecker.validateApFinHeadSettleStatus((DynamicObject)transBill, (String)"settled");
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{transBillId}, (OperateOption)OperateOption.create());
        FinApBillTestChecker.validateFinishApFin((long)finBillId, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])new Long[]{finBillId}, (Long[])new Long[]{transBillId}, (boolean)false);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355\uff08\u8ba1\u5212\u884c,\u4eba\u6c11\u5e01\uff0c\u63d0\u4ea4\u6001\u53c2\u6570\u6253\u5f00\uff0c\u6e90\u5355\u548c\u8d28\u4fdd\u91d1\u5408\u5e76\u4ed8\u6b3e\uff09")
    @Test
    public void ApFinUnitTest_010_5() {
        DynamicObject finBill = FinApBillTestDataProvider.createFinApPremiumBill((String)"AP016_010_apfin_5", (boolean)false, (boolean)true);
        long finBillId = finBill.getLong("id");
        long premiumBillId = FinApBillTestHelper.getPremiumBillId((long)finBillId);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"submit", (String)"ap_finapbill", (Object[])new Long[]{premiumBillId}, (OperateOption)option);
        CasPayBillTestHelper.fullPushPayBill((String)"ap_finapbill", Collections.singletonList(finBillId), (String)"AP016_010_payBill_7");
        DynamicObject premiumBill = BusinessDataServiceHelper.loadSingle((Object)premiumBillId, (String)"ap_finapbill");
        this.executeManualSettle(premiumBill, "AP016_010_payBill_8", false);
        FinApBillTestChecker.validateFinishApFin((long)premiumBillId, (boolean)true, (boolean)false);
        OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{premiumBillId}, (OperateOption)option);
        FinApBillTestChecker.validateFinishApFin((long)finBillId, (boolean)true, (boolean)false);
        SettleRecordTestChecker.checkSettleAmtAndJournal((Long[])new Long[]{finBillId}, (Long[])new Long[]{premiumBillId}, (boolean)false);
    }

    private void executeManualSettle(DynamicObject mainBill, String payBillNo, boolean flag) {
        DynamicObject[] asstRows;
        DynamicObject[] mainRows;
        DynamicObject org = mainBill.getDynamicObject("org");
        CasPayBillDataDetailVO detailVO = CasPayBillDataDetailVO.New().setPriceTaxTotal(BigDecimal.valueOf(500L));
        DynamicObject casPayBill = CasPayBillTestDataProvider.buildByEntryPriceTaxTotal((String)payBillNo, (DynamicObject)org, Collections.singletonList(detailVO));
        ApPayManualSettleService service = new ApPayManualSettleService();
        ManualSettleParam param = new ManualSettleParam();
        param.setAsstAndCurSame(false);
        param.setOrgPk((Object)org.getLong("id"));
        param.setSettleEntryParam(ArApHelper.getApSettleParam((Object)org.getLong("id")));
        ArrayList<EntryRowVO> mainBills = new ArrayList<EntryRowVO>(2);
        ArrayList<EntryRowVO> asstBills = new ArrayList<EntryRowVO>(2);
        if (flag) {
            param.setTotal(false);
            EntryRowVO row = new EntryRowVO(mainBill, (DynamicObject)mainBill.getDynamicObjectCollection("detailentry").get(0), BigDecimal.valueOf(15L));
            EntryRowVO row1 = new EntryRowVO(mainBill, (DynamicObject)mainBill.getDynamicObjectCollection("detailentry").get(1), BigDecimal.valueOf(30L));
            mainBills.add(row);
            mainBills.add(row1);
            EntryRowVO row3 = new EntryRowVO(casPayBill, (DynamicObject)casPayBill.getDynamicObjectCollection("entry").get(0), BigDecimal.valueOf(45L));
            asstBills.add(row3);
            mainRows = ManualSettleUnitTestHelper.buildMainRowsByEntry(mainBills, (boolean)false);
            asstRows = ManualSettleUnitTestHelper.buildAsstRowsByEntry(asstBills, (boolean)false);
        } else {
            param.setTotal(true);
            mainRows = ManualSettleUnitTestHelper.buildMainRowsByTotal((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
            asstRows = ManualSettleUnitTestHelper.buildAsstRowsByTotal((DynamicObject)casPayBill, (BigDecimal)BigDecimal.valueOf(150L), (boolean)false);
        }
        service.manualSettle(mainRows, asstRows, param);
    }

    private long produceAuditTransBill(DynamicObject finBill) {
        FinApBillTestHelper.searchOneRowDataByBillNo((AbstractJUnitTestPlugIn)this, (String)finBill.getString("billno"));
        FinApBillTestHelper.turnPayByRow((AbstractJUnitTestPlugIn)this);
        return FinApBillTestHelper.getTransBillId((long)finBill.getLong("id"));
    }
}

