/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.unittest.scene.verify;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.ap.mservice.verify.ApOminManualVrifyService;
import kd.fi.ap.mservice.verify.ApPurManualVrifyService;
import kd.fi.ap.mservice.verify.ApSelfManualVerifyService;
import kd.fi.ap.vo.ManualVerifyParam;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.OmInBillDataTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurInBillDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurReceiveBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.OmInBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.OmInBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.PurReceiveBillDataDetailVo;
import kd.fi.arapcommon.unittest.framework.entity.PurReceiveBillDataVo;
import kd.fi.arapcommon.unittest.framework.helper.PurReceiveBillTestHelper;
import kd.fi.arapcommon.unittest.scene.process.verify.FinApManualVerifyBuilder;
import kd.fi.arapcommon.unittest.scene.process.verify.ManualVerifyUnitTestHelper;
import kd.fi.arapcommon.unittest.scene.process.verify.PurBillManualVerifyBuilder;
import org.junit.Test;

public class Ap014_001_ManualVerifyIndirectUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    private static final long SLEEP_TIME = 10000L;

    @TestMethod(value=1)
    @DisplayName(value="\u5165\u5e93\u6838\u9500")
    @Test
    public void testPurAp_1() throws InterruptedException {
        PurInBillDataVO mainInfo = PurInBillDataVO.New().setBillNo("PurAp_MV_Pur_Ind_001").setBillStatus("C").setExchangeRate(BigDecimal.valueOf(1L)).setQuotation("0");
        ArrayList<PurInBillDataDetailVO> mainEntryList = new ArrayList<PurInBillDataDetailVO>(2);
        mainEntryList.add(PurInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(1L)).setQuantity(BigDecimal.valueOf(60L)).setSeq(1));
        DynamicObject mainBill = PurInBillDataTestProvider.buildByEntryPriceAndQty((PurInBillDataVO)mainInfo, mainEntryList);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainBill});
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        FinApBillDataVO finBillInfo = new FinApBillDataVO();
        finBillInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.valueOf(2L)).setPricetaxTotal(new BigDecimal(60)).setBillNo("PurAp_MV_AP_Ind_001").setOrg(org);
        ArrayList<FinApBillDataDetailVO> asstEntryList = new ArrayList<FinApBillDataDetailVO>(2);
        asstEntryList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(1L)).setQuantity(BigDecimal.valueOf(60L)).setSeq(1));
        DynamicObject asstBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)finBillInfo, asstEntryList);
        DynamicObject[] mainRows = ManualVerifyUnitTestHelper.buildMainRows((List)PurBillManualVerifyBuilder.build((String)"im_purinbill", (long)mainBill.getLong("id")), (boolean)false);
        DynamicObject[] asstRows = ManualVerifyUnitTestHelper.buildAsstRows((List)FinApManualVerifyBuilder.build((long)asstBill.getLong("id")), (boolean)false);
        ApPurManualVrifyService service = new ApPurManualVrifyService();
        ManualVerifyParam param = new ManualVerifyParam();
        param.setOrgId(org.getLong("id"));
        param.setVerifyRelation(VerifyRelationEnum.APPURIN.getValue());
        param.setSupplierId(mainBill.getLong("supplier.id"));
        param.setAllVerify(false);
        service.manualVerify(mainRows, asstRows, param);
        Thread.sleep(10000L);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        mainBill = PurInBillDataTestProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        Long mainBillId = mainBill.getLong("id");
        Long mainENtryId = ((DynamicObject)mainBill.getDynamicObjectCollection("billentry").get(0)).getLong("id");
        Long asstBillId = asstBill.getLong("id");
        Long asstENtryId = ((DynamicObject)asstBill.getDynamicObjectCollection("detailentry").get(0)).getLong("id");
        VerifyRecordTestChecker.verifyRecordCheck((long)mainBillId, (long)mainENtryId, (long)asstBillId, (long)asstENtryId, (BigDecimal)BigDecimal.valueOf(60L), (BigDecimal)BigDecimal.valueOf(60L), (boolean)false);
        this.checkSwapPl(mainBill, asstBill);
        PurInBillTestChecker.entryCheckByQty((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(60L), (int)0);
        FinApBillTestChecker.validateFinishApFin((DynamicObject)asstBill, (boolean)false, (boolean)true);
        Thread.sleep(10000L);
        Set verifyRecordIds = ManualVerifyUnitTestHelper.getVerifyRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unResult = OperationServiceHelper.executeOperate((String)"unverify", (String)"ap_verifyrecord", (Object[])verifyRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unResult);
        Thread.sleep(10000L);
        mainBill = PurInBillDataTestProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        VerifyRecordTestChecker.checkVerifyRecordExists((long)mainBill.getLong("id"), (long)asstBill.getLong("id"), (boolean)false, (boolean)false);
        PurInBillTestChecker.entryCheckByQty((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(0L), (int)0);
        FinApBillTestChecker.validateInitialApFin((DynamicObject)asstBill);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u9000\u5e93\u6838\u9500")
    @Test
    public void testPurAp_2() throws InterruptedException {
        PurInBillDataVO mainInfo = PurInBillDataVO.New().setBillNo("PurAp_MV_Pur_004").setBillStatus("C").setBizTypeNumber("1101").setInvSchemeNumber("1101").setExchangeRate(BigDecimal.ONE).setQuotation("0");
        ArrayList<PurInBillDataDetailVO> mainEntryList = new ArrayList<PurInBillDataDetailVO>(1);
        mainEntryList.add(PurInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(1L)).setQuantity(BigDecimal.valueOf(-60L)).setSeq(1));
        DynamicObject mainBill = PurInBillDataTestProvider.buildByEntryPriceAndQty((PurInBillDataVO)mainInfo, mainEntryList);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainBill});
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        FinApBillDataVO finBillInfo = new FinApBillDataVO();
        finBillInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.valueOf(2L)).setPricetaxTotal(new BigDecimal(60)).setBillNo("PurAp_MV_AP_Ind_002").setOrg(org);
        ArrayList<FinApBillDataDetailVO> asstEntryList = new ArrayList<FinApBillDataDetailVO>(2);
        asstEntryList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(1L)).setQuantity(BigDecimal.valueOf(-60L)).setSeq(1));
        DynamicObject asstBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)finBillInfo, asstEntryList);
        DynamicObject[] mainRows = ManualVerifyUnitTestHelper.buildMainRows((List)PurBillManualVerifyBuilder.build((String)"im_purinbill", (long)mainBill.getLong("id")), (boolean)false);
        DynamicObject[] asstRows = ManualVerifyUnitTestHelper.buildAsstRows((List)FinApManualVerifyBuilder.build((long)asstBill.getLong("id")), (boolean)false);
        ApPurManualVrifyService service = new ApPurManualVrifyService();
        ManualVerifyParam param = new ManualVerifyParam();
        param.setOrgId(org.getLong("id"));
        param.setVerifyRelation(VerifyRelationEnum.APPURRETURN.getValue());
        param.setSupplierId(mainBill.getLong("supplier.id"));
        param.setAllVerify(false);
        service.manualVerify(mainRows, asstRows, param);
        Thread.sleep(10000L);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        mainBill = PurInBillDataTestProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        Long mainBillId = mainBill.getLong("id");
        Long mainENtryId = ((DynamicObject)mainBill.getDynamicObjectCollection("billentry").get(0)).getLong("id");
        Long asstBillId = asstBill.getLong("id");
        Long asstENtryId = ((DynamicObject)asstBill.getDynamicObjectCollection("detailentry").get(0)).getLong("id");
        VerifyRecordTestChecker.verifyRecordCheck((long)mainBillId, (long)mainENtryId, (long)asstBillId, (long)asstENtryId, (BigDecimal)BigDecimal.valueOf(-60L), (BigDecimal)BigDecimal.valueOf(-60L), (boolean)false);
        this.checkSwapPl(mainBill, asstBill);
        PurInBillTestChecker.entryCheckByQty((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(-60L), (int)0);
        FinApBillTestChecker.validateFinishApFin((DynamicObject)asstBill, (boolean)false, (boolean)true);
        Thread.sleep(10000L);
        Set verifyRecordIds = ManualVerifyUnitTestHelper.getVerifyRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unResult = OperationServiceHelper.executeOperate((String)"unverify", (String)"ap_verifyrecord", (Object[])verifyRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unResult);
        Thread.sleep(10000L);
        mainBill = PurInBillDataTestProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        VerifyRecordTestChecker.checkVerifyRecordExists((long)mainBill.getLong("id"), (long)asstBill.getLong("id"), (boolean)false, (boolean)false);
        PurInBillTestChecker.entryCheckByQty((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(0L), (int)0);
        FinApBillTestChecker.validateInitialApFin((DynamicObject)asstBill);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u53d1\u7968\u7ea2\u51b2")
    @Test
    public void testApSelf_3() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        FinApBillDataVO finBillInfo = new FinApBillDataVO();
        finBillInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.valueOf(2L)).setPricetaxTotal(new BigDecimal(60)).setBillNo("ApSelf_MV_Ap_003_1").setOrg(org);
        ArrayList<FinApBillDataDetailVO> asstEntryList = new ArrayList<FinApBillDataDetailVO>(2);
        asstEntryList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(1L)).setQuantity(BigDecimal.valueOf(60L)).setSeq(1));
        DynamicObject mainBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)finBillInfo, asstEntryList);
        FinApBillDataVO finBillInfo1 = new FinApBillDataVO();
        finBillInfo1.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.valueOf(2L)).setPricetaxTotal(new BigDecimal(-60)).setBillNo("ApSelf_MV_Ap_003_2").setOrg(org);
        ArrayList<FinApBillDataDetailVO> asstEntryList1 = new ArrayList<FinApBillDataDetailVO>(1);
        asstEntryList1.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(1L)).setQuantity(BigDecimal.valueOf(-60L)).setSeq(1));
        DynamicObject asstBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)finBillInfo1, asstEntryList1);
        DynamicObject[] mainRows = ManualVerifyUnitTestHelper.buildMainRows((List)FinApManualVerifyBuilder.build((long)mainBill.getLong("id")), (boolean)false);
        DynamicObject[] asstRows = ManualVerifyUnitTestHelper.buildAsstRows((List)FinApManualVerifyBuilder.build((long)asstBill.getLong("id")), (boolean)false);
        ApSelfManualVerifyService service = new ApSelfManualVerifyService();
        ManualVerifyParam param = new ManualVerifyParam();
        param.setOrgId(org.getLong("id"));
        param.setVerifyRelation(VerifyRelationEnum.APFINSELF.getValue());
        param.setAllVerify(false);
        service.manualVerify(mainRows, asstRows, param);
        Thread.sleep(10000L);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        mainBill = FinApBillTestDataProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        Long mainBillId = mainBill.getLong("id");
        Long mainENtryId = ((DynamicObject)mainBill.getDynamicObjectCollection("detailentry").get(0)).getLong("id");
        Long asstBillId = asstBill.getLong("id");
        Long asstENtryId = ((DynamicObject)asstBill.getDynamicObjectCollection("detailentry").get(0)).getLong("id");
        VerifyRecordTestChecker.verifyRecordCheck((long)mainBillId, (long)mainENtryId, (long)asstBillId, (long)asstENtryId, (BigDecimal)BigDecimal.valueOf(60L), (BigDecimal)BigDecimal.valueOf(-60L), (boolean)false);
        this.checkSwapPl(mainBill, asstBill);
        FinApBillTestChecker.validateFinishApFin((DynamicObject)mainBill, (boolean)false, (boolean)true);
        FinApBillTestChecker.validateFinishApFin((DynamicObject)asstBill, (boolean)false, (boolean)true);
        Thread.sleep(10000L);
        Set verifyRecordIds = ManualVerifyUnitTestHelper.getVerifyRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unResult = OperationServiceHelper.executeOperate((String)"unverify", (String)"ap_verifyrecord", (Object[])verifyRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unResult);
        Thread.sleep(10000L);
        mainBill = FinApBillTestDataProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        VerifyRecordTestChecker.checkVerifyRecordExists((long)mainBill.getLong("id"), (long)asstBill.getLong("id"), (boolean)false, (boolean)false);
        FinApBillTestChecker.validateInitialApFin((DynamicObject)mainBill);
        FinApBillTestChecker.validateInitialApFin((DynamicObject)asstBill);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6536\u8d27\u6838\u9500")
    @Test
    public void testPurAp_4() throws InterruptedException {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        PurReceiveBillDataVo purRecDataVo = PurReceiveBillTestHelper.getPushPurInBillDataVo();
        purRecDataVo.setBillNo("PurAp_MV_PurRec_010");
        purRecDataVo.setExchangeRate(BigDecimal.ONE);
        purRecDataVo.setBillStatus("C");
        purRecDataVo.setOrg(org);
        ArrayList<PurReceiveBillDataDetailVo> mainEntryList = new ArrayList<PurReceiveBillDataDetailVo>(2);
        PurReceiveBillDataDetailVo purRecDetailVO = new PurReceiveBillDataDetailVo();
        purRecDetailVO.setQuantity(BigDecimal.valueOf(60L));
        purRecDetailVO.setPrice(BigDecimal.valueOf(1L));
        mainEntryList.add(purRecDetailVO);
        DynamicObject mainBill = PurReceiveBillTestDataProvider.buildByEntryPriceAndQty((PurReceiveBillDataVo)purRecDataVo, mainEntryList);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainBill});
        FinApBillDataVO finBillInfo = new FinApBillDataVO();
        finBillInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.valueOf(2L)).setPricetaxTotal(new BigDecimal(60)).setBillNo("PurAp_MV_Ap_ind_010").setOrg(org);
        ArrayList<FinApBillDataDetailVO> asstEntryList = new ArrayList<FinApBillDataDetailVO>(2);
        asstEntryList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(1L)).setQuantity(BigDecimal.valueOf(60L)).setSeq(1));
        DynamicObject asstBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)finBillInfo, asstEntryList);
        DynamicObject[] mainRows = ManualVerifyUnitTestHelper.buildMainRows((List)PurBillManualVerifyBuilder.build((String)"im_purreceivebill", (long)mainBill.getLong("id")), (boolean)false);
        DynamicObject[] asstRows = ManualVerifyUnitTestHelper.buildAsstRows((List)FinApManualVerifyBuilder.build((long)asstBill.getLong("id")), (boolean)false);
        ApPurManualVrifyService service = new ApPurManualVrifyService();
        ManualVerifyParam param = new ManualVerifyParam();
        param.setOrgId(org.getLong("id"));
        param.setVerifyRelation(VerifyRelationEnum.APPURRECED.getValue());
        param.setSupplierId(mainBill.getLong("supplier.id"));
        param.setAllVerify(false);
        service.manualVerify(mainRows, asstRows, param);
        Thread.sleep(10000L);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        mainBill = PurReceiveBillTestDataProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        Long mainBillId = mainBill.getLong("id");
        Long mainENtryId = ((DynamicObject)mainBill.getDynamicObjectCollection("billentry").get(0)).getLong("id");
        Long asstBillId = asstBill.getLong("id");
        Long asstENtryId = ((DynamicObject)asstBill.getDynamicObjectCollection("detailentry").get(0)).getLong("id");
        VerifyRecordTestChecker.verifyRecordCheck((long)mainBillId, (long)mainENtryId, (long)asstBillId, (long)asstENtryId, (BigDecimal)BigDecimal.valueOf(60L), (BigDecimal)BigDecimal.valueOf(60L), (boolean)false);
        PurInBillTestChecker.entryCheckByQty((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(60L), (int)0);
        FinApBillTestChecker.validateFinishApFin((DynamicObject)asstBill, (boolean)false, (boolean)true);
        Thread.sleep(10000L);
        Set verifyRecordIds = ManualVerifyUnitTestHelper.getVerifyRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unResult = OperationServiceHelper.executeOperate((String)"unverify", (String)"ap_verifyrecord", (Object[])verifyRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unResult);
        Thread.sleep(10000L);
        mainBill = PurReceiveBillTestDataProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        VerifyRecordTestChecker.checkVerifyRecordExists((long)mainBill.getLong("id"), (long)asstBill.getLong("id"), (boolean)false, (boolean)false);
        PurInBillTestChecker.entryCheckByQty((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(0L), (int)0);
        FinApBillTestChecker.validateInitialApFin((DynamicObject)asstBill);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u59d4\u5916\u5165\u5e93\u6838\u9500")
    @Test
    public void testApOmin_5() throws InterruptedException {
        OmInBillDataVO mainInfo = OmInBillDataVO.New().setBillNo("ApOmin_MV_Omin_ind_011").setBillStatus("C");
        ArrayList<OmInBillDataDetailVO> mainEntryList = new ArrayList<OmInBillDataDetailVO>(1);
        mainEntryList.add(OmInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(1L)).setQuantity(BigDecimal.valueOf(60L)).setSeq(1));
        DynamicObject mainBill = OmInBillDataTestDataProvider.buildByEntryPriceAndQty((OmInBillDataVO)mainInfo, mainEntryList);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainBill});
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        FinApBillDataVO finBillInfo = new FinApBillDataVO();
        finBillInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.valueOf(2L)).setPricetaxTotal(new BigDecimal(60)).setBillNo("ApOmin_MV_Ap_ind_01").setOrg(org);
        ArrayList<FinApBillDataDetailVO> asstEntryList = new ArrayList<FinApBillDataDetailVO>(1);
        asstEntryList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(1L)).setQuantity(BigDecimal.valueOf(60L)).setSeq(1));
        DynamicObject asstBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)finBillInfo, asstEntryList);
        DynamicObject[] mainRows = ManualVerifyUnitTestHelper.buildMainRows((List)PurBillManualVerifyBuilder.build((String)"im_mdc_ominbill", (long)mainBill.getLong("id")), (boolean)false);
        DynamicObject[] asstRows = ManualVerifyUnitTestHelper.buildAsstRows((List)FinApManualVerifyBuilder.build((long)asstBill.getLong("id")), (boolean)false);
        ApOminManualVrifyService service = new ApOminManualVrifyService();
        ManualVerifyParam param = new ManualVerifyParam();
        param.setOrgId(org.getLong("id"));
        param.setVerifyRelation(VerifyRelationEnum.APOMIN.getValue());
        param.setSupplierId(mainBill.getLong("supplier.id"));
        param.setAllVerify(false);
        service.manualVerify(mainRows, asstRows, param);
        Thread.sleep(10000L);
        Long[] mainIds = new Long[]{mainBill.getLong("id")};
        Long[] asstIds = new Long[]{asstBill.getLong("id")};
        mainBill = OmInBillDataTestDataProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        Long mainBillId = mainBill.getLong("id");
        Long mainENtryId = ((DynamicObject)mainBill.getDynamicObjectCollection("billentry").get(0)).getLong("id");
        Long asstBillId = asstBill.getLong("id");
        Long asstENtryId = ((DynamicObject)asstBill.getDynamicObjectCollection("detailentry").get(0)).getLong("id");
        VerifyRecordTestChecker.verifyRecordCheck((long)mainBillId, (long)mainENtryId, (long)asstBillId, (long)asstENtryId, (BigDecimal)BigDecimal.valueOf(60L), (BigDecimal)BigDecimal.valueOf(60L), (boolean)false);
        PurInBillTestChecker.entryCheckByQty((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(60L), (int)0);
        FinApBillTestChecker.validateFinishApFin((DynamicObject)asstBill, (boolean)false, (boolean)true);
        Thread.sleep(10000L);
        Set verifyRecordIds = ManualVerifyUnitTestHelper.getVerifyRecordIds((Long[])mainIds, (Long[])asstIds, (boolean)false);
        OperationResult unResult = OperationServiceHelper.executeOperate((String)"unverify", (String)"ap_verifyrecord", (Object[])verifyRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unResult);
        Thread.sleep(10000L);
        mainBill = OmInBillDataTestDataProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        VerifyRecordTestChecker.checkVerifyRecordExists((long)mainBill.getLong("id"), (long)asstBill.getLong("id"), (boolean)false, (boolean)false);
        PurInBillTestChecker.entryCheckByQty((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(0L), (int)0);
        FinApBillTestChecker.validateInitialApFin((DynamicObject)asstBill);
    }

    @TestMethod(value=6)
    @DisplayName(value="\u59d4\u5916\u9000\u5e93\u6838\u9500")
    @Test
    public void testApOmin_6() throws InterruptedException {
        OmInBillDataVO mainInfo = OmInBillDataVO.New().setBillNo("ApOmin_MV_Omin_ind_003").setBillStatus("C").setBizTypeNumber("1101").setInvSchemeNumber("1101");
        ArrayList<OmInBillDataDetailVO> mainEntryList = new ArrayList<OmInBillDataDetailVO>(2);
        mainEntryList.add(OmInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(1L)).setQuantity(BigDecimal.valueOf(-60L)).setSeq(1));
        DynamicObject mainBill = OmInBillDataTestDataProvider.buildByEntryPriceAndQty((OmInBillDataVO)mainInfo, mainEntryList);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainBill});
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        FinApBillDataVO finBillInfo = new FinApBillDataVO();
        finBillInfo.setCurrency(Long.valueOf(BaseDataTestProvider.getCurrencyCNY().getLong("id"))).setQuotation("1").setExchangerate(BigDecimal.valueOf(2L)).setPricetaxTotal(new BigDecimal(60)).setBillNo("ApOmin_MV_Ap_ind_003").setOrg(org);
        ArrayList<FinApBillDataDetailVO> asstEntryList = new ArrayList<FinApBillDataDetailVO>(1);
        asstEntryList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(1L)).setQuantity(BigDecimal.valueOf(-60L)).setSeq(1));
        DynamicObject asstBill = FinApBillTestDataProvider.buildByPriceAndQuantity((FinApBillDataVO)finBillInfo, asstEntryList);
        DynamicObject[] mainRows = ManualVerifyUnitTestHelper.buildMainRows((List)PurBillManualVerifyBuilder.build((String)"im_mdc_ominbill", (long)mainBill.getLong("id")), (boolean)false);
        DynamicObject[] asstRows = ManualVerifyUnitTestHelper.buildAsstRows((List)FinApManualVerifyBuilder.build((long)asstBill.getLong("id")), (boolean)false);
        ApOminManualVrifyService service = new ApOminManualVrifyService();
        ManualVerifyParam param = new ManualVerifyParam();
        param.setOrgId(org.getLong("id"));
        param.setVerifyRelation(VerifyRelationEnum.APOMINRETURN.getValue());
        param.setSupplierId(mainBill.getLong("supplier.id"));
        param.setAllVerify(false);
        service.manualVerify(mainRows, asstRows, param);
        Thread.sleep(10000L);
        Object[] mainIds = new Long[]{mainBill.getLong("id")};
        mainBill = OmInBillDataTestDataProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        Long mainBillId = mainBill.getLong("id");
        Long mainENtryId = ((DynamicObject)mainBill.getDynamicObjectCollection("billentry").get(0)).getLong("id");
        Long asstBillId = asstBill.getLong("id");
        Long asstENtryId = ((DynamicObject)asstBill.getDynamicObjectCollection("detailentry").get(0)).getLong("id");
        VerifyRecordTestChecker.verifyRecordCheck((long)mainBillId, (long)mainENtryId, (long)asstBillId, (long)asstENtryId, (BigDecimal)BigDecimal.valueOf(-60L), (BigDecimal)BigDecimal.valueOf(-60L), (boolean)false);
        PurInBillTestChecker.entryCheckByQty((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(-60L), (int)0);
        FinApBillTestChecker.validateFinishApFin((DynamicObject)asstBill, (boolean)false, (boolean)true);
        Thread.sleep(10000L);
        OperationResult unAuditRusult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_mdc_ominbill", (Object[])mainIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult((OperationResult)unAuditRusult);
        Thread.sleep(10000L);
        mainBill = OmInBillDataTestDataProvider.loadSingle((Long)mainBill.getLong("id"));
        asstBill = FinApBillTestDataProvider.loadSingle((Long)asstBill.getLong("id"));
        VerifyRecordTestChecker.checkVerifyRecordExists((long)mainBill.getLong("id"), (long)asstBill.getLong("id"), (boolean)false, (boolean)false);
        PurInBillTestChecker.entryCheckByQty((DynamicObject)mainBill, (BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.valueOf(0L), (int)0);
        FinApBillTestChecker.validateInitialApFin((DynamicObject)asstBill);
    }

    private static String getVerifyRecordSelects() {
        return "org,billid,billno,billtype,billentryid,swappl,e_swappl,qty,measureunit,verifyqty,verifybaseqty,payableamount,verifyamount,verifytype,verifyrelation,e_billtype,e_qty,e_measureunit,e_verifyqty,e_verifybaseqty,e_payableamount,e_verifyamount,e_billid,e_billno,e_billentryid,currency,e_currency,e_verifytaxamount,verifytaxamount,e_writtenoffremark,e_iswrittenoff,e_hadwrittenoff";
    }

    private void checkSwapPl(DynamicObject mainBill, DynamicObject asstBill) {
        long mainBillId = mainBill.getLong("id");
        long asstBillId = asstBill.getLong("id");
        String entity = "ap_verifyrecord";
        DynamicObject[] verifyRecords = BusinessDataServiceHelper.load((String)entity, (String)Ap014_001_ManualVerifyIndirectUnitTest.getVerifyRecordSelects(), (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)mainBillId), new QFilter("entry.e_billid", "=", (Object)asstBillId)});
        KDAssert.assertEquals((String)"\u672a\u751f\u6210\u6838\u9500\u8bb0\u5f55", (boolean)true, (verifyRecords.length > 0 ? 1 : 0) != 0);
        DynamicObject baseCurrency = asstBill.getDynamicObject("basecurrency");
        int precision = baseCurrency.getInt("amtprecision");
        BigDecimal mainExchangeRate = mainBill.getBigDecimal("exchangerate");
        BigDecimal asstExchangeRate = asstBill.getBigDecimal("exchangerate");
        for (DynamicObject verifyRecord : verifyRecords) {
            String asstQuotation;
            BigDecimal mainVerifyAmt = verifyRecord.getBigDecimal("verifytaxamount");
            String mainQuotation = mainBill.getString("quotation");
            BigDecimal expectSwaPL = mainQuotation.equals(asstQuotation = asstBill.getString("quotation")) ? ("0".equals(mainQuotation) ? mainVerifyAmt.multiply(mainExchangeRate).setScale(precision, RoundingMode.HALF_UP).subtract(mainVerifyAmt.multiply(asstExchangeRate.setScale(precision, RoundingMode.HALF_UP))) : mainVerifyAmt.divide(mainExchangeRate, precision, RoundingMode.HALF_UP).subtract(mainVerifyAmt.divide(asstExchangeRate, precision, RoundingMode.HALF_UP))) : ("0".equals(mainQuotation) ? mainVerifyAmt.multiply(mainExchangeRate).setScale(precision, RoundingMode.HALF_UP).subtract(mainVerifyAmt.divide(asstExchangeRate, precision, RoundingMode.HALF_UP)) : mainVerifyAmt.divide(mainExchangeRate, precision, RoundingMode.HALF_UP).subtract(mainVerifyAmt.multiply(asstExchangeRate.setScale(precision, RoundingMode.HALF_UP))));
            DynamicObject entry = (DynamicObject)verifyRecord.getDynamicObjectCollection("entry").get(0);
            KDAssert.assertEquals((String)"\u4e3b\u65b9\u6c47\u5151\u635f\u76ca\u6709\u8bef", (Object)expectSwaPL, (Object)verifyRecord.getBigDecimal("swappl").setScale(precision));
        }
    }
}

