/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ApInvoiceSynchroUpgradePlugin
implements IUpgradeService {
    public Map<String, Object> beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return resultMap;
        }
        boolean success = true;
        String log = "Synchrostutas Upgrade SUCCESS!";
        String info = "Synchrostutas Upgrade SUCCESS!";
        try {
            this.upgrade();
        }
        catch (Exception e) {
            info = log = ArApHelper.getStackTraceMessage((Throwable)e);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        return resultMap;
    }

    private void upgrade() {
        Date newDate = new Date();
        QFilter filter = new QFilter("receivedate", ">=", (Object)DateUtils.getMinMonthDate((Date)newDate));
        filter.and(new QFilter("receivedate", "<=", (Object)newDate));
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,synstatus,changesynstatustime,serialno", (QFilter[])new QFilter[]{filter});
        Map<Long, DynamicObject> invoiceMap = Arrays.stream(invoices).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        for (DynamicObject invoice : invoices) {
            invoice.set("synstatus", (Object)"notsynchro");
            invoice.set("changesynstatustime", (Object)new Date());
        }
        Map targetBillIdMap = BOTPHelper.findDirtTargetBillIds((String)"ap_invoice", (Long[])invoiceMap.keySet().toArray(new Long[0]), (String)"ap_finapbill", (String)"ap_finapbill");
        if (targetBillIdMap.size() != 0) {
            HashSet allApBillId = new HashSet(targetBillIdMap.size());
            for (Map.Entry setEntry : targetBillIdMap.entrySet()) {
                allApBillId.addAll((Collection)setEntry.getValue());
            }
            DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,isvoucher", (QFilter[])new QFilter[]{new QFilter("id", "in", allApBillId)});
            Map<Long, DynamicObject> apBillMap = Arrays.stream(apBills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            block2: for (Map.Entry setEntry : targetBillIdMap.entrySet()) {
                DynamicObject invoice = invoiceMap.get(setEntry.getKey());
                for (Long apBillId : (Set)setEntry.getValue()) {
                    DynamicObject apBill = apBillMap.get(apBillId);
                    if (!EmptyUtils.isNotEmpty((Object)invoice.getString("serialno")) || !Boolean.TRUE.equals(apBill.getBoolean("isvoucher"))) continue;
                    invoice.set("synstatus", (Object)"waitsynchro");
                    invoice.set("changesynstatustime", (Object)new Date());
                    continue block2;
                }
            }
        }
        if (invoices.length != 0) {
            SaveServiceHelper.update((DynamicObject[])invoices);
        }
    }
}

