/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.balance.BalanceRebuildService;
import kd.fi.arapcommon.helper.ArApHelper;

public class ApJournalAsstactUpgradePlugin
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap<String, Object> resultMap;
        block19: {
            if (ArApHelper.queryApIsNotInit()) {
                HashMap<String, Object> resultMap2 = new HashMap<String, Object>(4);
                resultMap2.put("info", "is not need Upgrade");
                resultMap2.put("success", Boolean.TRUE);
                return new UpgradeResult(resultMap2);
            }
            resultMap = new HashMap<String, Object>(4);
            boolean success = true;
            try {
                DynamicObject[] customers;
                DynamicObject[] suppliers;
                HashSet<Long> asstactIds = new HashSet<Long>(16);
                QFilter filter = new QFilter("id", "<>", (Object)"masterid", true);
                for (DynamicObject supplier : suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{filter})) {
                    asstactIds.add(supplier.getLong("id"));
                }
                for (DynamicObject customer : customers = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{filter})) {
                    asstactIds.add(customer.getLong("id"));
                }
                if (ObjectUtils.isEmpty(asstactIds)) break block19;
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        this.upgrade(asstactIds);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                String log;
                String info = log = ArApHelper.getStackTraceMessage((Throwable)e);
                resultMap.put("success", success);
                resultMap.put("log", log);
                resultMap.put("el", "");
                resultMap.put("info", info);
            }
        }
        return new UpgradeResult(resultMap);
    }

    private void upgrade(Set<Long> asstactIds) {
        QFilter asstactIdFilter = new QFilter("asstact", "in", asstactIds);
        ArrayList<Long> batchIds = new ArrayList<Long>(10000);
        try (DataSet journalIds = QueryServiceHelper.queryDataSet((String)"journal.loadIds", (String)"ap_journal", (String)"id", (QFilter[])new QFilter[]{asstactIdFilter}, null);){
            for (Row journalId : journalIds) {
                batchIds.add(journalId.getLong("id"));
                if (batchIds.size() != 10000) continue;
                this.doUpgrade(batchIds);
                batchIds.clear();
            }
        }
        if (!batchIds.isEmpty()) {
            this.doUpgrade(batchIds);
        }
    }

    private void doUpgrade(List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        Object[] journals = BusinessDataServiceHelper.load((String)"ap_journal", (String)"org,asstacttype,asstact,bizdate", (QFilter[])new QFilter[]{idFilter});
        if (ObjectUtils.isEmpty((Object[])journals)) {
            return;
        }
        ArrayList<Object> journalstoUpdate = new ArrayList<Object>(64);
        for (Object journal2 : journals) {
            long masterId;
            long id;
            DynamicObject asstact = journal2.getDynamicObject("asstact");
            if (asstact == null || (id = asstact.getLong("id")) == (masterId = asstact.getLong("masterid"))) continue;
            journal2.set("asstact", (Object)masterId);
            journalstoUpdate.add(journal2);
        }
        if (ObjectUtils.isEmpty(journalstoUpdate)) {
            return;
        }
        SaveServiceHelper.update((DynamicObject[])journalstoUpdate.toArray(new DynamicObject[0]));
        Map<Long, List<DynamicObject>> groupbyJournals = journalstoUpdate.stream().sorted(Comparator.comparing(journal -> journal.getDate("bizdate"), Comparator.nullsLast(Date::compareTo))).collect(Collectors.groupingBy(journal -> journal.getLong("org.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : groupbyJournals.entrySet()) {
            Long orgId = entry.getKey();
            List<DynamicObject> journalList = entry.getValue();
            Date bizDate = journalList.get(0).getDate("bizdate");
            if (bizDate == null) continue;
            BalanceRebuildService service = new BalanceRebuildService(orgId, bizDate, "ap");
            service.rebuild();
        }
    }
}

