/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.woff.info.BusEntryInfo;

public class ApWoffAmtUpgradePlugin
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        String log = "ApWoffAmt Upgrade SUCCESS!";
        String info = "ApWoffAmt Upgrade SUCCESS!";
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        try {
            this.upgrade();
        }
        catch (Exception e) {
            info = log = this.getStackTraceMessage(e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", info);
        }
        return new UpgradeResult(resultMap);
    }

    private void upgrade() {
        this.initUpgrade();
        this.quantityUpgrade();
        this.amtUpgrade();
    }

    private void initUpgrade() {
        String entrySql = "update t_ap_busbillentry set funwoffqty = fquantity,funwoffamt = fpricetaxtotal,funwofflocamt = fpricetaxtotalbase where fiswriteoff = 0";
        DB.execute((DBRoute)DBRouteConst.AP, (String)entrySql);
        String headSql = "update t_ap_busbill set funwoffamt = fpricetaxtotal,funwofflocamt = fpricetaxtotalbase";
        DB.execute((DBRoute)DBRouteConst.AP, (String)headSql);
        DynamicObject stdConfig = BusinessDataServiceHelper.newDynamicObject((String)"ap_stdconfig");
        stdConfig.set("key", (Object)"upgradeDate");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        stdConfig.set("value", (Object)sdf.format(date));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stdConfig});
    }

    private void quantityUpgrade() {
        String sql;
        QFilter qf = new QFilter("isadjust", "=", (Object)Boolean.TRUE);
        qf.and("payproperty.isbasedonamt", "=", (Object)Boolean.FALSE);
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"e_srcentryid, e_pricetaxtotal, e_pricetaxtotalbase, e_quantity", (QFilter[])new QFilter[]{qf});
        HashMap<Long, BusEntryInfo> woffMap = new HashMap<Long, BusEntryInfo>();
        for (DynamicObject woffBill : woffBills) {
            DynamicObject[] entries = woffBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long srcentryid = entry.getLong("e_srcentryid");
                BusEntryInfo busEntryInfo = (BusEntryInfo)woffMap.get(srcentryid);
                if (busEntryInfo == null) {
                    busEntryInfo = new BusEntryInfo();
                    busEntryInfo.setSrcEntryPk(srcentryid.longValue());
                    busEntryInfo.setRecAmount(entry.getBigDecimal("e_pricetaxtotal"));
                    busEntryInfo.setRecLocAmt(entry.getBigDecimal("e_pricetaxtotalbase"));
                    busEntryInfo.setQuantity(entry.getBigDecimal("e_quantity"));
                    woffMap.put(srcentryid, busEntryInfo);
                    continue;
                }
                busEntryInfo.setRecAmount(busEntryInfo.getRecAmount().add(entry.getBigDecimal("e_pricetaxtotal")));
                busEntryInfo.setRecLocAmt(busEntryInfo.getRecLocAmt().add(entry.getBigDecimal("e_pricetaxtotalbase")));
                busEntryInfo.setQuantity(busEntryInfo.getQuantity().add(entry.getBigDecimal("e_quantity")));
            }
        }
        QFilter qf2 = new QFilter("entry.id", "in", woffMap.keySet());
        DynamicObject[] srcBusbills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"e_pricetaxtotal, e_pricetaxtotalbase, e_quantity", (QFilter[])new QFilter[]{qf2});
        ArrayList<Object[]> entryParamList = new ArrayList<Object[]>(100);
        ArrayList<Object[]> headParamList = new ArrayList<Object[]>(100);
        for (DynamicObject srcBusbill : srcBusbills) {
            BigDecimal headWoffPricetaxtotal = BigDecimal.ZERO;
            BigDecimal headWoffPricetaxtotalbase = BigDecimal.ZERO;
            DynamicObjectCollection entries = srcBusbill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                BusEntryInfo busEntryInfo = (BusEntryInfo)woffMap.get((Long)entry.getPkValue());
                if (busEntryInfo == null) continue;
                BigDecimal unWoffQuantity = entry.getBigDecimal("e_quantity").add(busEntryInfo.getQuantity());
                BigDecimal unWoffPricetaxtotal = entry.getBigDecimal("e_pricetaxtotal").add(busEntryInfo.getRecAmount());
                BigDecimal unWoffPricetaxtotalbase = entry.getBigDecimal("e_pricetaxtotalbase").add(busEntryInfo.getRecLocAmt());
                entryParamList.add(new Object[]{unWoffQuantity, unWoffPricetaxtotal, unWoffPricetaxtotalbase, entry.getPkValue()});
                headWoffPricetaxtotal = headWoffPricetaxtotal.add(busEntryInfo.getRecAmount());
                headWoffPricetaxtotalbase = headWoffPricetaxtotalbase.add(busEntryInfo.getRecLocAmt());
            }
            headParamList.add(new Object[]{headWoffPricetaxtotal, headWoffPricetaxtotalbase, srcBusbill.getPkValue()});
        }
        if (!entryParamList.isEmpty()) {
            sql = "update t_ap_busbillentry set funwoffqty = ?,funwoffamt = ?,funwofflocamt = ? where fentryid = ?";
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, entryParamList);
        }
        if (!headParamList.isEmpty()) {
            sql = "update t_ap_busbill set funwoffamt = funwoffamt + ?,funwofflocamt = funwofflocamt + ? where fid = ?";
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, headParamList);
        }
    }

    private void amtUpgrade() {
        String sql;
        QFilter qf = new QFilter("isadjust", "=", (Object)Boolean.TRUE);
        qf.and("payproperty.isbasedonamt", "=", (Object)Boolean.TRUE);
        DynamicObject[] woffBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"e_srcentryid, e_pricetaxtotal, e_pricetaxtotalbase, e_quantity", (QFilter[])new QFilter[]{qf});
        HashMap<Long, BusEntryInfo> woffMap = new HashMap<Long, BusEntryInfo>();
        for (DynamicObject woffBill : woffBills) {
            DynamicObject[] entries = woffBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long srcentryid = entry.getLong("e_srcentryid");
                BusEntryInfo busEntryInfo = (BusEntryInfo)woffMap.get(srcentryid);
                if (busEntryInfo == null) {
                    busEntryInfo = new BusEntryInfo();
                    busEntryInfo.setSrcEntryPk(srcentryid.longValue());
                    busEntryInfo.setRecAmount(entry.getBigDecimal("e_pricetaxtotal"));
                    busEntryInfo.setRecLocAmt(entry.getBigDecimal("e_pricetaxtotalbase"));
                    woffMap.put(srcentryid, busEntryInfo);
                    continue;
                }
                busEntryInfo.setRecAmount(busEntryInfo.getRecAmount().add(entry.getBigDecimal("e_pricetaxtotal")));
                busEntryInfo.setRecLocAmt(busEntryInfo.getRecLocAmt().add(entry.getBigDecimal("e_pricetaxtotalbase")));
            }
        }
        QFilter qf2 = new QFilter("entry.id", "in", woffMap.keySet());
        DynamicObject[] srcBusbills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"e_pricetaxtotal, e_pricetaxtotalbase, e_quantity", (QFilter[])new QFilter[]{qf2});
        ArrayList<Object[]> entryParamList = new ArrayList<Object[]>(100);
        ArrayList<Object[]> headParamList = new ArrayList<Object[]>(100);
        for (DynamicObject srcBusbill : srcBusbills) {
            BigDecimal headWoffPricetaxtotal = BigDecimal.ZERO;
            BigDecimal headWoffPricetaxtotalbase = BigDecimal.ZERO;
            DynamicObjectCollection entries = srcBusbill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                BusEntryInfo busEntryInfo = (BusEntryInfo)woffMap.get((Long)entry.getPkValue());
                if (busEntryInfo == null) continue;
                BigDecimal woffQuantity = BigDecimal.ONE;
                if (entry.getBigDecimal("e_pricetaxtotal").compareTo(BigDecimal.ZERO) < 0) {
                    woffQuantity = BigDecimal.valueOf(-1L);
                }
                BigDecimal unWoffPricetaxtotal = entry.getBigDecimal("e_pricetaxtotal").add(busEntryInfo.getRecAmount());
                BigDecimal unWoffPricetaxtotalbase = entry.getBigDecimal("e_pricetaxtotalbase").add(busEntryInfo.getRecLocAmt());
                if (unWoffPricetaxtotal.compareTo(BigDecimal.ZERO) == 0) {
                    woffQuantity = BigDecimal.ZERO;
                }
                entryParamList.add(new Object[]{woffQuantity, unWoffPricetaxtotal, unWoffPricetaxtotalbase, entry.getPkValue()});
                headWoffPricetaxtotal = headWoffPricetaxtotal.add(busEntryInfo.getRecAmount());
                headWoffPricetaxtotalbase = headWoffPricetaxtotalbase.add(busEntryInfo.getRecLocAmt());
            }
            headParamList.add(new Object[]{headWoffPricetaxtotal, headWoffPricetaxtotalbase, srcBusbill.getPkValue()});
        }
        if (!entryParamList.isEmpty()) {
            sql = "update t_ap_busbillentry set funwoffqty = ?,funwoffamt = ?,funwofflocamt = ? where fentryid = ?";
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, entryParamList);
        }
        if (!headParamList.isEmpty()) {
            sql = "update t_ap_busbill set funwoffamt = funwoffamt + ?,funwofflocamt = funwofflocamt + ? where fid = ?";
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, headParamList);
        }
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

