/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArApExecControlUpdatePlugin
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        try {
            this.doUpgrade();
        }
        catch (Exception e) {
            String log;
            String info = log = ArApHelper.getStackTraceMessage((Throwable)e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", info);
        }
        return new UpgradeResult(resultMap);
    }

    private void doUpgrade() {
        this.banExecControl();
    }

    private void banExecControl() {
        String querySTDConfigSql = "SELECT FKEY,FVALUE FROM T_AP_STDCONFIG WHERE FKEY in ('AllEntriesIsDrawValidator','verify.isAsstActMatch')";
        DataSet dataSet = DB.queryDataSet((String)"ArApExecControlUpdatePlugin", (DBRoute)new DBRoute("ap"), (String)querySTDConfigSql);
        String isDrawValidator = null;
        String isAsstActMatch = null;
        for (Row row : dataSet) {
            String key = row.getString("FKEY");
            String value = row.getString("FVALUE");
            if ("AllEntriesIsDrawValidator".equals(key)) {
                isDrawValidator = value;
            }
            if (!"verify.isAsstActMatch".equals(key)) continue;
            isAsstActMatch = value;
        }
        dataSet.close();
        ArrayList<String> banNumber = new ArrayList<String>(16);
        if ("false".equals(isDrawValidator)) {
            banNumber.addAll(Arrays.asList("SZJK-PRE-0006", "SZJK-PRE-0007", "SZJK-PRE-0008", "SZJK-PRE-0009", "SZJK-PRE-0010", "SZJK-PRE-0011", "SZJK-PRE-0012", "SZJK-PRE-0013"));
        }
        if ("false".equals(isAsstActMatch)) {
            banNumber.addAll(Arrays.asList("SZJK-PRE-0001", "SZJK-PRE-0002"));
        }
        if (EmptyUtils.isNotEmpty(banNumber)) {
            ArrayList<Object[]> updateExecControlParams = new ArrayList<Object[]>(16);
            for (String number : banNumber) {
                Object[] param = new Object[]{number};
                updateExecControlParams.add(param);
            }
            String updateSql = "UPDATE T_ARAP_EXECCONTROL SET FENABLE='0' WHERE FNUMBER = ?";
            DB.executeBatch((DBRoute)new DBRoute("ap"), (String)updateSql, updateExecControlParams);
        }
    }
}

