/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

public class AssignDataUpgradePlugin
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(AssignDataUpgradePlugin.class);
    private BigDecimal usedAmt;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        String log = "Assign Upgrade SUCCESS!";
        String info = "Assign Upgrade SUCCESS!";
        resultMap.put("log", log);
        resultMap.put("info", info);
        try {
            this.upgrade(resultMap);
        }
        catch (Exception e) {
            info = log = this.getStackTraceMessage(e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", info);
        }
        return new UpgradeResult(resultMap);
    }

    private void upgrade(Map<String, Object> resultMap) {
        Throwable throwable;
        TXHandle tx;
        try {
            tx = TX.requiresNew((String)"initData");
            throwable = null;
            try {
                this.initData();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (Exception e) {
            resultMap.put("log", this.getStackTraceMessage(e));
            resultMap.put("el", "");
            resultMap.put("info", this.getStackTraceMessage(e));
        }
        try {
            tx = TX.requiresNew((String)"autoUpgrade");
            throwable = null;
            try {
                this.autoUpgrade();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (Exception e) {
            resultMap.put("log", this.getStackTraceMessage(e));
            resultMap.put("el", "");
            resultMap.put("info", this.getStackTraceMessage(e));
        }
        try {
            tx = TX.requiresNew((String)"assignFinUpgrade");
            throwable = null;
            try {
                this.assignFinUpgrade();
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (Exception e) {
            resultMap.put("log", this.getStackTraceMessage(e));
            resultMap.put("el", "");
            resultMap.put("info", this.getStackTraceMessage(e));
        }
        try {
            tx = TX.requiresNew((String)"assignFinUpgrade");
            throwable = null;
            try {
                this.assignInvUpgrade();
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (Exception e) {
            resultMap.put("log", this.getStackTraceMessage(e));
            resultMap.put("el", "");
            resultMap.put("info", this.getStackTraceMessage(e));
        }
    }

    private void initData() {
        String initInvoiceSql = "update T_AP_INVOICE set funrelatedamt = fpricetaxtotal";
        DB.execute((DBRoute)DBRouteConst.AP, (String)initInvoiceSql);
        String initInvEntrySql = "update T_AP_INVOICEENTRY set frelatedamt = 0, funrelatedamt = fpricetaxtotal";
        DB.execute((DBRoute)DBRouteConst.AP, (String)initInvEntrySql);
        String queryFinSql = "select fid,fpricetaxtotal from T_AP_FINAPBILL";
        DataSet dataSetFin = DB.queryDataSet((String)"AP.QUERYSETFINTOTAL", (DBRoute)DBRouteConst.AP, (String)queryFinSql);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<Long> finPk = new ArrayList<Long>();
        for (Row row : dataSetFin) {
            Object[] param = new Object[]{row.getBigDecimal("fpricetaxtotal"), row.getLong("fid")};
            paramList.add(param);
            finPk.add(row.getLong("fid"));
        }
        if (!ObjectUtils.isEmpty(paramList)) {
            String updateFinSql = "update T_AP_FINAPBILL_E  set funinvoicedamt = ? where fid = ? ;";
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateFinSql, paramList);
        }
        if (!ObjectUtils.isEmpty(finPk)) {
            String queryFinEntrySql = "select fentryid,fpricetaxtotal from T_AP_FINAPBILLDETAILENTRY where fid in (" + StringUtils.join(finPk, (String)",") + ")";
            DataSet entryDataSet = DB.queryDataSet((String)"AP.QUERYSETFINENTRY", (DBRoute)DBRouteConst.AP, (String)queryFinEntrySql);
            ArrayList<Object[]> paramEntryList = new ArrayList<Object[]>();
            for (Row row : entryDataSet) {
                Object[] param = new Object[]{row.getBigDecimal("fpricetaxtotal"), row.getLong("fentryid")};
                paramEntryList.add(param);
            }
            if (!ObjectUtils.isEmpty(paramEntryList)) {
                String updateFinEntrySql = "update T_AP_FINAPBILLDETAILENTRY_E  set funinvoicedamt = ? where fentryid = ?";
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateFinEntrySql, paramEntryList);
            }
        }
    }

    private void assignInvUpgrade() {
        ArrayList finList = new ArrayList();
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>();
        QFilter qf4Assign = new QFilter("isrefinv", "=", (Object)Boolean.TRUE);
        qf4Assign.and(new QFilter("inventry.invid", "!=", (Object)0));
        DynamicObject[] finbills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"isrefinv, pricetaxtotal, detailentry.e_pricetaxtotal, inventry.invid", (QFilter[])new QFilter[]{qf4Assign});
        ArrayList<Long> invPks = new ArrayList<Long>();
        for (DynamicObject finbill : finbills) {
            DynamicObject[] invoices;
            finbill.set("isrefinv", (Object)Boolean.FALSE);
            invPks.clear();
            for (DynamicObject inventry : finbill.getDynamicObjectCollection("inventry")) {
                invPks.add(inventry.getLong("invid"));
            }
            for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"isreffin, pricetaxtotal, entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)invPks.toArray())})) {
                invoice.set("isreffin", (Object)Boolean.FALSE);
                BigDecimal deductAmt = invoice.getBigDecimal("pricetaxtotal");
                BigDecimal usedAmt = BigDecimal.ZERO;
                BigDecimal c_usedAmt = this.deductFinBill4assignInv(deductAmt, finbill);
                if (c_usedAmt.compareTo(BigDecimal.ZERO) != 0) {
                    DynamicObjectCollection invEntrys = finbill.getDynamicObjectCollection("inventry");
                    DynamicObject invEntry = new DynamicObject(invEntrys.getDynamicObjectType());
                    invEntry.set("invid", invoice.getPkValue());
                    invEntrys.add((Object)invEntry);
                    String queryFinSql = "select funinvoicedamt from T_AP_FINAPBILL_E where fid = ?;";
                    String updateFinSql = "update T_AP_FINAPBILL_E  set funinvoicedamt = ? where fid = ? ;";
                    BigDecimal uninvoicedamt = this.DBquery4Amt(queryFinSql, finbill.getPkValue(), "funinvoicedamt");
                    uninvoicedamt = uninvoicedamt.subtract(c_usedAmt);
                    this.DBUpdate(updateFinSql, new Object[]{uninvoicedamt, finbill.getPkValue()});
                    String updateFinInvEntrySql = "update t_ap_finapbillinventry  set fusedamt = ? where fid = ? and finvid = ?;";
                    this.DBUpdate(updateFinInvEntrySql, new Object[]{c_usedAmt, finbill.getPkValue(), invoice.getPkValue()});
                    usedAmt = usedAmt.add(c_usedAmt);
                }
                if (usedAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                this.deductInvoice4assignInv(usedAmt, invoice);
                invoiceList.add(invoice);
            }
        }
        if (!finList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])finList.toArray(new DynamicObject[0]));
        }
        if (!invoiceList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[0]));
        }
    }

    private void deductInvoice4assignInv(BigDecimal usedAmt, DynamicObject invoice) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        BigDecimal decompAmt = usedAmt;
        for (DynamicObject detail : invoice.getDynamicObjectCollection("entry")) {
            BigDecimal e_relatedamt;
            BigDecimal e_unrelatedamt;
            BigDecimal applyAmt = detail.getBigDecimal("e_pricetaxtotal");
            if (applyAmt.abs().compareTo(decompAmt.abs()) >= 0) {
                e_unrelatedamt = applyAmt.subtract(decompAmt);
                e_relatedamt = detail.getBigDecimal("e_pricetaxtotal").subtract(e_unrelatedamt);
                paramList.add(new Object[]{e_unrelatedamt, e_relatedamt, detail.getPkValue()});
                break;
            }
            if (applyAmt.abs().compareTo(decompAmt.abs()) >= 0) continue;
            e_unrelatedamt = applyAmt.subtract(applyAmt);
            e_relatedamt = detail.getBigDecimal("e_pricetaxtotal").subtract(e_unrelatedamt);
            paramList.add(new Object[]{e_unrelatedamt, e_relatedamt, detail.getPkValue()});
            decompAmt = decompAmt.subtract(applyAmt);
        }
        String updateEntrySql = "update T_AP_INVOICEENTRY  set funrelatedamt = ?,frelatedamt = ?  where fentryid = ?;";
        DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateEntrySql, paramList);
        String updateSql = "update T_AP_INVOICE  set funrelatedamt = ? where fid = ?;";
        DB.execute((DBRoute)DBRouteConst.AP, (String)updateSql, (Object[])new Object[]{invoice.getBigDecimal("pricetaxtotal").subtract(usedAmt), invoice.getPkValue()});
    }

    private BigDecimal deductFinBill4assignInv(BigDecimal deductAmt, DynamicObject finbill) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        BigDecimal usedAmt = BigDecimal.ZERO;
        Iterator iterator = finbill.getDynamicObjectCollection("detailentry").iterator();
        while (iterator.hasNext()) {
            BigDecimal e_invoicedamt;
            BigDecimal e_uninvoicedamt;
            String queryFinSql = "select funinvoicedamt from T_AP_FINAPBILLDETAILENTRY_E where fentryid = ?";
            DynamicObject detail = (DynamicObject)iterator.next();
            BigDecimal applyAmt = this.DBquery4Amt(queryFinSql, detail.getPkValue(), "funinvoicedamt");
            if (applyAmt.abs().compareTo(deductAmt.abs()) >= 0) {
                e_uninvoicedamt = applyAmt.subtract(deductAmt);
                e_invoicedamt = detail.getBigDecimal("e_pricetaxtotal").subtract(e_uninvoicedamt);
                paramList.add(new Object[]{e_uninvoicedamt, e_invoicedamt, detail.getPkValue()});
                usedAmt = usedAmt.add(deductAmt);
                break;
            }
            if (applyAmt.abs().compareTo(deductAmt.abs()) >= 0) continue;
            e_uninvoicedamt = applyAmt.subtract(applyAmt);
            e_invoicedamt = detail.getBigDecimal("e_pricetaxtotal").subtract(e_uninvoicedamt);
            paramList.add(new Object[]{e_uninvoicedamt, e_invoicedamt, detail.getPkValue()});
            deductAmt = deductAmt.subtract(applyAmt);
            usedAmt = usedAmt.add(applyAmt);
        }
        String updateFinEntrySql = "update T_AP_FINAPBILLDETAILENTRY_E  set funinvoicedamt = ?,finvoicedamt = ? where fentryid = ?";
        DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateFinEntrySql, paramList);
        return usedAmt;
    }

    private void assignFinUpgrade() {
        DynamicObject[] invoicies;
        ArrayList invList = new ArrayList();
        ArrayList<DynamicObject> finList = new ArrayList<DynamicObject>();
        QFilter qf4Assign = new QFilter("isreffin", "=", (Object)Boolean.TRUE);
        qf4Assign.and(new QFilter("finentry.finid", "!=", (Object)0));
        for (DynamicObject invoice : invoicies = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"isreffin, pricetaxtotal, entry.e_pricetaxtotal, finentry.finid", (QFilter[])new QFilter[]{qf4Assign})) {
            DynamicObject[] finbills;
            invoice.set("isreffin", (Object)Boolean.FALSE);
            ArrayList<Long> finPks = new ArrayList<Long>();
            DynamicObjectCollection finentries = invoice.getDynamicObjectCollection("finentry");
            for (DynamicObject finentry : finentries) {
                finPks.add(finentry.getLong("finid"));
            }
            for (DynamicObject finbill : finbills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"isrefinv, pricetaxtotal, detailentry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("id", "in", finPks)})) {
                finbill.set("isrefinv", (Object)Boolean.FALSE);
                BigDecimal deductAmt = finbill.getBigDecimal("pricetaxtotal");
                this.usedAmt = BigDecimal.ZERO;
                BigDecimal relatedAmt = this.deductInvoice4assignFin(deductAmt, invoice);
                if (relatedAmt.compareTo(BigDecimal.ZERO) != 0) {
                    DynamicObjectCollection invEntrys = invoice.getDynamicObjectCollection("finentry");
                    DynamicObject invEntry = new DynamicObject(invEntrys.getDynamicObjectType());
                    invEntry.set("finid", finbill.getPkValue());
                    invEntrys.add((Object)invEntry);
                    String queryFinSql = "select funrelatedamt from t_ap_invoice where fid = ?;";
                    relatedAmt = this.DBquery4Amt(queryFinSql, invoice.getPkValue(), "funrelatedamt").subtract(this.usedAmt);
                    String updateInvSql = "update T_AP_INVOICE set funrelatedamt = ? where fid = ?;";
                    this.DBUpdate(updateInvSql, new Object[]{relatedAmt, invoice.getPkValue()});
                    String updateInvFinEntrySql = "update t_ap_invoicefinentry set fusedamt = ? where fid = ? and ffinid = ?;";
                    this.DBUpdate(updateInvFinEntrySql, new Object[]{this.usedAmt, invoice.getPkValue(), finbill.getPkValue()});
                }
                if (this.usedAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                this.deductFinBill4assignFin(this.usedAmt, finbill);
                finList.add(finbill);
            }
        }
        if (!invList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])invList.toArray(new DynamicObject[0]));
        }
        if (!finList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])finList.toArray(new DynamicObject[0]));
        }
    }

    private void autoUpgrade() {
        QFilter qf = new QFilter("sourcebilltype", "=", (Object)"ap_invoice");
        Object[] finapbills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"isrefinv, detailentry.e_pricetaxtotal", (QFilter[])new QFilter[]{qf});
        ArrayList<Long> finpks = new ArrayList<Long>(finapbills.length);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (Object finapbill : finapbills) {
            finpks.add(finapbill.getLong("id"));
            finapbill.set("isrefinv", (Object)Boolean.FALSE);
            DynamicObjectCollection entries = finapbill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entries) {
                paramList.add(new Object[]{entry.getBigDecimal("e_pricetaxtotal"), entry.getPkValue()});
            }
        }
        if (!ObjectUtils.isEmpty(finpks)) {
            String updateFinSql = "update T_AP_FINAPBILL_E  set funinvoicedamt = 0 where fid in (" + StringUtils.join(finpks, (String)",") + ") ;";
            DB.execute((DBRoute)DBRouteConst.AP, (String)updateFinSql);
            String updateFinEntrySql = "update T_AP_FINAPBILLDETAILENTRY_E  set funinvoicedamt = 0,finvoicedamt = ? where  fentryid = ?;";
            if (!paramList.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateFinEntrySql, paramList);
            }
            HashSet invPks = new HashSet(finpks.size());
            for (Long finpk : finpks) {
                try {
                    Map findSourceBills = BOTPHelper.findSourceBills((String)"ap_finapbill", (Long)finpk);
                    Object[] invoicies = (Object[])findSourceBills.get("ap_invoice");
                    if (ObjectUtils.isEmpty((Object)invoicies)) continue;
                    invPks.addAll(invoicies);
                }
                catch (Exception e) {
                    logger.error(finpk.toString());
                    logger.error(e.getMessage());
                }
            }
            if (invPks.isEmpty()) {
                return;
            }
            Object[] invoicies = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"isreffin, entry.e_pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("id", "in", invPks)});
            ArrayList<Long> invoicePks = new ArrayList<Long>(invoicies.length);
            ArrayList<Object[]> paramInvList = new ArrayList<Object[]>();
            for (DynamicObject dynamicObject : invoicies) {
                dynamicObject.set("isreffin", (Object)Boolean.FALSE);
                invoicePks.add(dynamicObject.getLong("id"));
                for (DynamicObject entry : dynamicObject.getDynamicObjectCollection("entry")) {
                    paramInvList.add(new Object[]{entry.getBigDecimal("e_pricetaxtotal"), entry.getPkValue()});
                }
            }
            String updateInvSql = "update T_AP_INVOICE  set funrelatedamt = 0 where fid in (" + StringUtils.join(invoicePks, (String)",") + ");";
            DB.execute((DBRoute)DBRouteConst.AP, (String)updateInvSql);
            String updateInvEntrySql = "update T_AP_INVOICEENTRY  set funrelatedamt = 0,frelatedamt = ? where  fentryid = ?;";
            if (!paramInvList.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateInvEntrySql, paramInvList);
            }
            if (!ObjectUtils.isEmpty((Object[])finapbills)) {
                SaveServiceHelper.save((DynamicObject[])finapbills);
            }
            if (!ObjectUtils.isEmpty((Object[])invoicies)) {
                SaveServiceHelper.save((DynamicObject[])invoicies);
            }
        }
    }

    private BigDecimal deductInvoice4assignFin(BigDecimal deductAmt, DynamicObject invbill) {
        ArrayList<Object[]> paramFinList = new ArrayList<Object[]>();
        BigDecimal relatedAmt = BigDecimal.ZERO;
        for (DynamicObject entry : invbill.getDynamicObjectCollection("entry")) {
            BigDecimal unrelatedamt;
            String queryFinSql = "select funrelatedamt from t_ap_invoiceentry where fentryid = ?";
            BigDecimal applyAmt = this.DBquery4Amt(queryFinSql, entry.getPkValue(), "funrelatedamt");
            BigDecimal relatedamt = BigDecimal.ZERO;
            if (applyAmt.abs().compareTo(deductAmt.abs()) >= 0) {
                unrelatedamt = applyAmt.subtract(deductAmt);
                relatedamt = entry.getBigDecimal("e_pricetaxtotal").subtract(unrelatedamt);
                paramFinList.add(new Object[]{unrelatedamt, relatedamt, entry.getPkValue()});
                this.usedAmt = this.usedAmt.add(deductAmt);
                deductAmt = BigDecimal.ZERO;
            } else if (applyAmt.abs().compareTo(deductAmt.abs()) < 0) {
                unrelatedamt = applyAmt.subtract(applyAmt);
                relatedamt = entry.getBigDecimal("e_pricetaxtotal").subtract(unrelatedamt);
                paramFinList.add(new Object[]{unrelatedamt, relatedamt, entry.getPkValue()});
                deductAmt = deductAmt.subtract(applyAmt);
                this.usedAmt = this.usedAmt.add(applyAmt);
            }
            relatedAmt = relatedAmt.add(relatedamt);
        }
        String updateInvEntrySql = "update T_AP_INVOICEENTRY set funrelatedamt = ?, frelatedamt = ? where fentryid = ?;";
        DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateInvEntrySql, paramFinList);
        return relatedAmt;
    }

    private void deductFinBill4assignFin(BigDecimal usedAmt, DynamicObject finbill) {
        BigDecimal decompAmt = usedAmt;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (DynamicObject detail : finbill.getDynamicObjectCollection("detailentry")) {
            BigDecimal e_invoicedamt;
            BigDecimal e_uninvoicedamt;
            BigDecimal applyAmt = detail.getBigDecimal("e_pricetaxtotal");
            if (applyAmt.abs().compareTo(decompAmt.abs()) >= 0) {
                e_uninvoicedamt = applyAmt.subtract(decompAmt);
                e_invoicedamt = applyAmt.subtract(e_uninvoicedamt);
                paramList.add(new Object[]{e_uninvoicedamt, e_invoicedamt, detail.getPkValue()});
                break;
            }
            if (applyAmt.abs().compareTo(decompAmt.abs()) >= 0) continue;
            e_uninvoicedamt = applyAmt.subtract(applyAmt);
            e_invoicedamt = applyAmt.subtract(e_uninvoicedamt);
            paramList.add(new Object[]{e_uninvoicedamt, e_invoicedamt, detail.getPkValue()});
            decompAmt = decompAmt.subtract(applyAmt);
        }
        String updateFinEntrySql = "update T_AP_FINAPBILLDETAILENTRY_E  set funinvoicedamt = ?,finvoicedamt = ?  where fentryid = ?";
        DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateFinEntrySql, paramList);
        BigDecimal h_uninvoicedamt = finbill.getBigDecimal("pricetaxtotal").subtract(usedAmt);
        String updateFinSql = "update T_AP_FINAPBILL_E  set funinvoicedamt = ?  where fid = ?";
        DB.execute((DBRoute)DBRouteConst.AP, (String)updateFinSql, (Object[])new Object[]{h_uninvoicedamt, finbill.getPkValue()});
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }

    private BigDecimal DBquery4Amt(String querySql, Object pkValue, String string) {
        DataSet dataSet = DB.queryDataSet((String)"AP.QUERYSETFINTOTAL", (DBRoute)DBRouteConst.AP, (String)querySql, (Object[])new Object[]{pkValue});
        BigDecimal applyAmt = BigDecimal.ZERO;
        for (Row row : dataSet) {
            applyAmt = row.getBigDecimal(string);
        }
        return applyAmt;
    }

    private void DBUpdate(String updateSql, Object[] objects) {
        DB.execute((DBRoute)DBRouteConst.AP, (String)updateSql, (Object[])objects);
    }
}

