/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.vo.MaterialRow;

public class BaseUnitQtyUpgrade
implements IUpgradeService {
    private Map<String, BigDecimal> convertRateMap = new HashMap<String, BigDecimal>(8);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        String log = "BaseUnitQty Upgrade SUCCESS!";
        String info = "BaseUnitQty Upgrade SUCCESS!";
        resultMap.put("success", success);
        resultMap.put("log", log);
        resultMap.put("el", "");
        resultMap.put("info", info);
        try {
            this.upgrade();
        }
        catch (Exception e) {
            info = log = this.getStackTraceMessage(e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", info);
        }
        return new UpgradeResult(resultMap);
    }

    private void upgrade() {
        DynamicObject[] finbills;
        HashMap<String, MaterialRow> rowMap = new HashMap<String, MaterialRow>(10);
        QFilter qf = new QFilter("billsrctype", "=", (Object)"1");
        for (DynamicObject finbill : finbills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"detailentry.material,detailentry.measureunit,detailentry.e_unitconvertrate,detailentry.e_baseunitqty,detailentry.quantity", (QFilter[])new QFilter[]{qf})) {
            DynamicObjectCollection entries = finbill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entries) {
                DynamicObject material = entry.getDynamicObject("material");
                if (ObjectUtils.isEmpty((Object)material)) continue;
                DynamicObject baseunit = material.getDynamicObject("baseunit");
                DynamicObject measureUnit = entry.getDynamicObject("measureunit");
                long materialID = (Long)material.getPkValue();
                long measureUnitID = (Long)measureUnit.getPkValue();
                String key = materialID + "-" + measureUnitID;
                MaterialRow row = null;
                if (!rowMap.containsKey(key)) {
                    row = this.buildMaterialRow(material, baseunit, measureUnitID);
                    rowMap.put(key, row);
                } else {
                    row = (MaterialRow)rowMap.get(key);
                }
                entry.set("e_unitconvertrate", (Object)row.getUnitCoefficient());
                BigDecimal quantity = entry.getBigDecimal("quantity");
                entry.set("e_baseunitqty", (Object)row.getUnitCoefficient().multiply(quantity));
            }
        }
        SaveServiceHelper.save((DynamicObject[])finbills);
    }

    private MaterialRow buildMaterialRow(DynamicObject material, DynamicObject baseunit, long measureUnitPk) {
        MaterialRow row = new MaterialRow();
        row.setMaterialPk(((Long)material.getPkValue()).longValue());
        row.setSpecType(material.getString("modelnum"));
        row.setBaseUnitPk(baseunit != null ? (Long)baseunit.getPkValue() : measureUnitPk);
        row.setMeasureUnitPk(measureUnitPk);
        BigDecimal convertRate = this.getConvertRate(row.getMaterialPk(), row.getMeasureUnitPk(), row.getBaseUnitPk());
        row.setUnitCoefficient(convertRate != null ? convertRate : BigDecimal.ONE);
        DynamicObject taxrate = material.getDynamicObject("taxrate");
        if (!ObjectUtils.isEmpty((Object)taxrate)) {
            row.setTaxRatePk(((Long)taxrate.getPkValue()).longValue());
        }
        return row;
    }

    private BigDecimal getConvertRate(Long materialId, Long srcUnitId, Long desUnitId) {
        String key = materialId + "_" + srcUnitId + "_" + desUnitId;
        BigDecimal value = this.convertRateMap.get(key);
        if (value != null) {
            return value;
        }
        BigDecimal unitRateConv = UnitConvertHelper.getUnitRateConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        this.convertRateMap.put(key, unitRateConv);
        return unitRateConv;
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

