/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;

public class BillJournalMapperUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit() && ArApHelper.queryArIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        try {
            this.upgrade();
        }
        catch (Exception e) {
            String log;
            String info = log = this.getStackTraceMessage(e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", info);
        }
        return new UpgradeResult(resultMap);
    }

    private void upgrade() {
        int arSize;
        List extFields = BaseDataHelper.getExtProperty((String)"ap_settlerecord");
        List<IDataEntityProperty> apJournalFields = this.getProperties("ap_journal");
        ArrayList<String> apProperties = new ArrayList<String>(extFields.size());
        for (String extField : extFields) {
            for (IDataEntityProperty apJournalField : apJournalFields) {
                if (!extField.equals(apJournalField.getName())) continue;
                apProperties.add(extField);
            }
        }
        List<IDataEntityProperty> arJournalFields = this.getProperties("ar_journal");
        ArrayList<String> arProperties = new ArrayList<String>(extFields.size());
        for (String extField : extFields) {
            for (IDataEntityProperty arJournalField : arJournalFields) {
                if (!extField.equals(arJournalField.getName())) continue;
                arProperties.add(extField);
            }
        }
        LinkedList<Object[]> updateParams = new LinkedList<Object[]>();
        int apSize = apProperties.size();
        if (apSize > 0) {
            ArrayList<String> billEntities = new ArrayList<String>(5);
            billEntities.add("ap_finapbill");
            billEntities.add("ap_busbill");
            billEntities.add("ap_paidbill");
            billEntities.add("ap_settlerecord");
            billEntities.add("cas_paybill");
            long[] ids = DB.genLongIds((String)"ap_billjoumapper", (int)(apProperties.size() * 5));
            int index = 0;
            for (String property : apProperties) {
                for (int i = 0; i < 5; ++i) {
                    Object[] param = new Object[]{ids[index], "ap", billEntities.get(i), property, "ap_journal", property};
                    updateParams.add(param);
                    ++index;
                }
            }
        }
        if ((arSize = arProperties.size()) > 0) {
            ArrayList<String> billEntities = new ArrayList<String>(5);
            billEntities.add("ar_finarbill");
            billEntities.add("ar_busbill");
            billEntities.add("ar_receivedbill");
            billEntities.add("ar_settlerecord");
            billEntities.add("cas_recbill");
            long[] ids = DB.genLongIds((String)"ap_billjoumapper", (int)(arProperties.size() * 5));
            int index = 0;
            for (String property : arProperties) {
                for (int i = 0; i < 5; ++i) {
                    Object[] param = new Object[]{ids[index], "ar", billEntities.get(i), property, "ar_journal", property};
                    updateParams.add(param);
                    ++index;
                }
            }
        }
        String sql = "insert into t_ap_billjoumapper(fid, fapp, fbillentity, fbillkey, fjournalentity, fjournalkey) values (?, ?, ?, ?, ?, ?)";
        if (!ObjectUtils.isEmpty(updateParams)) {
            DB.executeBatch((DBRoute)new DBRoute("ap"), (String)sql, updateParams);
        }
    }

    private List<IDataEntityProperty> getProperties(String entityKey) {
        MainEntityType journalEntityDataType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        ArrayList<IDataEntityProperty> props = new ArrayList<IDataEntityProperty>();
        DataEntityPropertyCollection properties = journalEntityDataType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)prop)._collectionItemPropertyType.getProperties();
                for (IDataEntityProperty eProp : entryProperties) {
                    props.add(eProp);
                }
                continue;
            }
            props.add(prop);
        }
        return props;
    }

    private String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

