/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.ap.mservice.upgrade.NewBusApBookDateUpgradePlugin;
import kd.fi.ap.mservice.upgrade.NewFinApBookDateUpgradePlugin;
import kd.fi.arapcommon.helper.ArApHelper;

public class BookDateUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        NewFinApBookDateUpgradePlugin finUpgradePlugin = new NewFinApBookDateUpgradePlugin();
        UpgradeResult upgradeResult = finUpgradePlugin.beforeExecuteSqlWithResult(ver, iteration, dbKey, sqlFileName);
        if (!upgradeResult.isSuccess()) {
            return upgradeResult;
        }
        NewBusApBookDateUpgradePlugin busUpgradePlugin = new NewBusApBookDateUpgradePlugin();
        return busUpgradePlugin.beforeExecuteSqlWithResult(ver, iteration, dbKey, sqlFileName);
    }

    private void upgradeFinBills() {
        String queryFinBillSql = "SELECT FID,FBIZDATE FROM T_AP_FINAPBILL WHERE FBILLSTATUS = 'C' AND FBOOKDATE IS NULL";
        DataSet finBills = DB.queryDataSet((String)"ap.BookDateUpgradePlugin", (DBRoute)new DBRoute("ap"), (String)queryFinBillSql);
        LinkedList<Object[]> updateFinBillParams = new LinkedList<Object[]>();
        for (Row finBill : finBills) {
            Object[] param = new Object[]{finBill.getDate("FBIZDATE"), finBill.getLong("FID")};
            updateFinBillParams.add(param);
        }
        String updateSql = "UPDATE T_AP_FINAPBILL SET FBOOKDATE=? WHERE FID=?";
        if (!ObjectUtils.isEmpty(updateFinBillParams)) {
            DB.executeBatch((DBRoute)new DBRoute("ap"), (String)updateSql, updateFinBillParams);
        }
    }

    private void upgradeBusBills() {
        String queryBusBillSql = "SELECT FID,FBIZDATE FROM T_AP_BUSBILL WHERE FBILLSTATUS = 'C' AND FBOOKDATE IS NULL";
        DataSet busBills = DB.queryDataSet((String)"ap.BookDateUpgradePlugin", (DBRoute)new DBRoute("ap"), (String)queryBusBillSql);
        LinkedList<Object[]> updateBusBillParams = new LinkedList<Object[]>();
        for (Row busBill : busBills) {
            Object[] param = new Object[]{busBill.getDate("FBIZDATE"), busBill.getLong("FID")};
            updateBusBillParams.add(param);
        }
        String updateSql = "UPDATE T_AP_BUSBILL SET FBOOKDATE=? WHERE FID=?";
        if (!ObjectUtils.isEmpty(updateBusBillParams)) {
            DB.executeBatch((DBRoute)new DBRoute("ap"), (String)updateSql, updateBusBillParams);
        }
    }

    public String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

