/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.service.upgrade.AbstractUpgradeHandle;

public class BusApAllocatedFieldUpgradeHandle
extends AbstractUpgradeHandle {
    private final Log logger = LogFactory.getLog(BusApAllocatedFieldUpgradeHandle.class);
    private Map<Long, Boolean> orgIdAndIsTaxMap = new HashMap<Long, Boolean>(64);

    protected void initUpgradeArgs() {
        String sql = "select b.fcalorgid\u3000as fcalorgid, a.fsupporttaxamt as fsupporttaxamt from t_cal_calpolicy a inner join t_cal_costaccount b on  b.fismainaccount = ? and a.fid = b.fcalpolicyid";
        DataSet accountDataSet = DB.queryDataSet((String)"FinApTaxDeductionUpgradePlugin", (DBRoute)new DBRoute("cal"), (String)sql, (Object[])new Object[]{Character.valueOf('1')});
        for (Row account : accountDataSet) {
            Long orgId = account.getLong("fcalorgid");
            if (orgId == 0L) continue;
            this.orgIdAndIsTaxMap.putIfAbsent(orgId, account.getBoolean("fsupporttaxamt"));
        }
    }

    protected void upgrade(List<Long> billIds) {
        String selectBusEntryIdSql = "select fentryid from t_ap_busbillentry where fid in (" + StringUtils.join((Object[])billIds.toArray(), (String)",") + ")";
        DataSet busEntryIdSqlSet = DB.queryDataSet((String)"selectBusIdSql", (DBRoute)DBRouteConst.AP, (String)selectBusEntryIdSql);
        HashSet<Long> entryIdSet = new HashSet<Long>(8);
        for (Row row : busEntryIdSqlSet) {
            Long fentrid = row.getLong("fentryid");
            entryIdSet.add(fentrid);
            if (entryIdSet.size() != this.UPGRADE_ENTRY_NUMBER) continue;
            this.batchUpgrade(entryIdSet);
            entryIdSet.clear();
        }
        if (entryIdSet.size() > 0) {
            this.batchUpgrade(entryIdSet);
        }
    }

    private void batchUpgrade(Set<Long> entryIdSet) {
        Set casIdSet;
        String selectBusSql = "select a.fid as fid, a.forgid as forgid,b.fisallocate as fisallocate,b.fintercostamt as fintercostamt,b.fentryid as fentryid, b.flocalamt as flocalamt from t_ap_busbillentry b inner join t_ap_busbill a on a.fid = b.fid  inner join t_ap_busbillentry_e c on c.fentryid = b.fentryid where c.fallocatedamt + c.funallocatedamt = 0 and b.fentryid in (" + StringUtils.join((Object[])entryIdSet.toArray(), (String)",") + ")";
        DataSet busSet = DB.queryDataSet((String)"selectBusSql", (DBRoute)DBRouteConst.AP, (String)selectBusSql);
        HashSet<Long> isNotAllocateEntryIdSet = new HashSet<Long>(entryIdSet.size());
        HashSet<Long> isAllocateEntryIdSet = new HashSet<Long>(entryIdSet.size());
        HashMap<Long, BigDecimal> entryIdBusAmtMap = new HashMap<Long, BigDecimal>(entryIdSet.size());
        ArrayList<Long> busEntryIdList = new ArrayList<Long>(8);
        HashMap<Long, BigDecimal> entryIdAndInterCostAmt = new HashMap<Long, BigDecimal>(8);
        HashMap<Long, Long> entryIdAndOrgId = new HashMap<Long, Long>(8);
        for (Row row : busSet) {
            Long orgId = row.getLong("forgid");
            Boolean isAllocate = row.getBoolean("fisallocate");
            BigDecimal interCostAmt = row.getBigDecimal("fintercostamt");
            Long entryId = row.getLong("fentryid");
            busEntryIdList.add(entryId);
            entryIdAndInterCostAmt.put(entryId, interCostAmt);
            entryIdAndOrgId.put(entryId, orgId);
            if (!isAllocate.booleanValue() || BigDecimal.ZERO.compareTo(interCostAmt) == 0) {
                isNotAllocateEntryIdSet.add(entryId);
            }
            if (isAllocate.booleanValue()) {
                isAllocateEntryIdSet.add(entryId);
            }
            BigDecimal amount = row.getBigDecimal("flocalamt");
            entryIdBusAmtMap.put(entryId, amount);
        }
        HashMap<Long, BigDecimal> entryIdVeriyAmtMap = new HashMap<Long, BigDecimal>(entryIdSet.size());
        if (!ObjectUtils.isEmpty(isNotAllocateEntryIdSet)) {
            String selectRecordSql = "select fbillentryid,fshareamount from t_cal_feerecordentry where fbilltypeid = '688833926805888000' and fbillentryid in (" + StringUtils.join((Object[])isNotAllocateEntryIdSet.toArray(), (String)",") + ")";
            DataSet calRecordSet = DB.queryDataSet((String)"selectRecordSql", (DBRoute)DBRouteConst.CAL, (String)selectRecordSql);
            calRecordSet = calRecordSet.groupBy(new String[]{"fbillentryid"}).sum("fshareamount").finish();
            for (Row row : calRecordSet) {
                Long busApEntryId = row.getLong("fbillentryid");
                BigDecimal verifyAmt = row.getBigDecimal("fshareamount");
                entryIdVeriyAmtMap.put(busApEntryId, verifyAmt);
            }
        }
        HashMap casEntryIdFieldMap = new HashMap(entryIdSet.size());
        Map busEntryIdCasEntryIdMap = BOTPHelper.loadTargetRowIdsMap((String)"ap_busbill", (String)"entry", (Long[])isNotAllocateEntryIdSet.toArray(new Long[0]), (String)"cal_costestimatebill");
        if (!ObjectUtils.isEmpty((Object)busEntryIdCasEntryIdMap) && !ObjectUtils.isEmpty(casIdSet = busEntryIdCasEntryIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()))) {
            String selectCostSql = "select fentryid,festimateamount,festimatetaxamount from t_cal_costesbillexpense where fentryid in (" + StringUtils.join((Object[])casIdSet.toArray(), (String)",") + ")";
            DataSet costSet = DB.queryDataSet((String)"selectRecordSql", (DBRoute)DBRouteConst.CAL, (String)selectCostSql);
            for (Row row : costSet) {
                Long casEntryId = row.getLong("fentryid");
                BigDecimal estimateAmt = row.getBigDecimal("festimateamount");
                BigDecimal estimateTaxAmt = row.getBigDecimal("festimatetaxamount");
                HashMap<String, BigDecimal> casFieldMap = new HashMap<String, BigDecimal>(entryIdSet.size());
                casFieldMap.put("estimateAmt", estimateAmt);
                casFieldMap.put("estimateTaxAmt", estimateTaxAmt);
                casEntryIdFieldMap.put(casEntryId, casFieldMap);
            }
        }
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(entryIdSet.size());
        for (Long entryId : busEntryIdList) {
            BigDecimal estimateTaxAmt;
            BigDecimal estimateAmt;
            Map casFieldMap;
            Boolean isTax;
            Object[] params = new Object[3];
            Long orgId = (Long)entryIdAndOrgId.get(entryId);
            BigDecimal interCostAmt = (BigDecimal)entryIdAndInterCostAmt.get(entryId);
            BigDecimal busApLocAmt = (BigDecimal)entryIdBusAmtMap.get(entryId);
            if (isAllocateEntryIdSet.contains(entryId)) {
                if (BigDecimal.ZERO.compareTo(interCostAmt) == 0) {
                    BigDecimal verifyAmt = (BigDecimal)entryIdVeriyAmtMap.get(entryId);
                    if (verifyAmt == null) {
                        Set casEntryIdSet = (Set)busEntryIdCasEntryIdMap.get(entryId);
                        if (!ObjectUtils.isEmpty((Object)busEntryIdCasEntryIdMap) && !ObjectUtils.isEmpty((Object)casEntryIdSet)) {
                            isTax = this.orgIdAndIsTaxMap.get(orgId);
                            if (isTax == null || !isTax.booleanValue()) {
                                for (Long casEntryId : casEntryIdSet) {
                                    casFieldMap = (Map)casEntryIdFieldMap.get(casEntryId);
                                    estimateAmt = (BigDecimal)casFieldMap.get("estimateAmt");
                                    if (verifyAmt == null) {
                                        verifyAmt = estimateAmt;
                                        continue;
                                    }
                                    verifyAmt = verifyAmt.add(estimateAmt);
                                }
                            } else {
                                for (Long casEntryId : casEntryIdSet) {
                                    casFieldMap = (Map)casEntryIdFieldMap.get(casEntryId);
                                    estimateTaxAmt = (BigDecimal)casFieldMap.get("estimateTaxAmt");
                                    if (verifyAmt == null) {
                                        verifyAmt = estimateTaxAmt;
                                        continue;
                                    }
                                    verifyAmt = verifyAmt.add(estimateTaxAmt);
                                }
                            }
                        } else {
                            verifyAmt = busApLocAmt;
                        }
                    }
                    params[0] = verifyAmt;
                    params[1] = BigDecimal.ZERO;
                    params[2] = entryId;
                } else {
                    params[0] = interCostAmt;
                    params[1] = BigDecimal.ZERO;
                    params[2] = entryId;
                }
                updateParams.add(params);
                continue;
            }
            if (BigDecimal.ZERO.compareTo(interCostAmt) == 0) {
                Set casEntryIdSet = (Set)busEntryIdCasEntryIdMap.get(entryId);
                if (!ObjectUtils.isEmpty((Object)busEntryIdCasEntryIdMap) && !ObjectUtils.isEmpty((Object)casEntryIdSet)) {
                    BigDecimal verifyAmt = BigDecimal.ZERO;
                    isTax = this.orgIdAndIsTaxMap.get(orgId);
                    if (isTax == null || !isTax.booleanValue()) {
                        for (Long casEntryId : casEntryIdSet) {
                            casFieldMap = (Map)casEntryIdFieldMap.get(casEntryId);
                            estimateAmt = (BigDecimal)casFieldMap.get("estimateAmt");
                            verifyAmt = verifyAmt.add(estimateAmt);
                        }
                    } else {
                        for (Long casEntryId : casEntryIdSet) {
                            casFieldMap = (Map)casEntryIdFieldMap.get(casEntryId);
                            estimateTaxAmt = (BigDecimal)casFieldMap.get("estimateTaxAmt");
                            verifyAmt = verifyAmt.add(estimateTaxAmt);
                        }
                    }
                    params[0] = BigDecimal.ZERO;
                    params[1] = verifyAmt;
                    params[2] = entryId;
                } else {
                    params[0] = BigDecimal.ZERO;
                    params[1] = busApLocAmt;
                    params[2] = entryId;
                }
            } else {
                params[0] = BigDecimal.ZERO;
                params[1] = interCostAmt;
                params[2] = entryId;
            }
            updateParams.add(params);
        }
        String updateSql = "update t_ap_busbillentry_e set fallocatedamt = ?, funallocatedamt = ? where fentryid = ?";
        try (TXHandle tx = TX.requiresNew((String)"updateBusAllocatedAmt");){
            try {
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateSql, updateParams);
            }
            catch (Throwable t) {
                tx.markRollback();
                this.logger.error("-----BusApAllocatedFieldUpgradeHandle upgrade allocateamt failed ----", t);
            }
        }
    }
}

