/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.service.upgrade.AbstractUpgradeHandle;

public class FinApAllocatedFieldUpgradeHandle
extends AbstractUpgradeHandle {
    private final Log logger = LogFactory.getLog(FinApAllocatedFieldUpgradeHandle.class);

    protected void upgrade(List<Long> billIds) {
        String selectFinEntryIdSql = "select fentryid from t_ap_finapbilldetailentry where fid in (" + StringUtils.join((Object[])billIds.toArray(), (String)",") + ")";
        DataSet finEntryIdSet = DB.queryDataSet((String)"selectFinEntryIdSql", (DBRoute)DBRouteConst.AP, (String)selectFinEntryIdSql);
        HashSet<Long> entryIdSet = new HashSet<Long>(1024);
        for (Row row : finEntryIdSet) {
            Long entryId = row.getLong("fentryid");
            entryIdSet.add(entryId);
            if (entryIdSet.size() != this.UPGRADE_ENTRY_NUMBER) continue;
            this.batchUpgrade(entryIdSet);
            entryIdSet.clear();
        }
        if (entryIdSet.size() > 0) {
            this.batchUpgrade(entryIdSet);
        }
    }

    private void batchUpgrade(Set<Long> entryIdSet) {
        String selectFinSql = "select a.fisallocate as fisallocate,a.fintercostamt as fintercostamt,a.fentryid as fentryid,a.famountbase as famountbase from t_ap_finapbilldetailentry a inner join t_ap_finapbilldetailentry_e b on a.fentryid = b.fentryid  where b.fallocatedamt + b.funallocatedamt = 0 and a.fentryid in (" + StringUtils.join((Object[])entryIdSet.toArray(), (String)",") + ")";
        DataSet finSet = DB.queryDataSet((String)"selectFinSql", (DBRoute)DBRouteConst.AP, (String)selectFinSql);
        HashSet<Long> isNotAllocateEntryIdSet = new HashSet<Long>(entryIdSet.size());
        HashSet<Long> isAllocateEntryIdSet = new HashSet<Long>(entryIdSet.size());
        HashMap<Long, BigDecimal> entryIdFinAmtMap = new HashMap<Long, BigDecimal>(entryIdSet.size());
        ArrayList<Long> finEntryIdList = new ArrayList<Long>(8);
        HashMap<Long, BigDecimal> entryIdAndInterCostAmt = new HashMap<Long, BigDecimal>(8);
        for (Row row : finSet) {
            Boolean isAllocate = row.getBoolean("fisallocate");
            BigDecimal interCostAmt = row.getBigDecimal("fintercostamt");
            Long entryId = row.getLong("fentryid");
            finEntryIdList.add(entryId);
            entryIdAndInterCostAmt.put(entryId, interCostAmt);
            if (!isAllocate.booleanValue() || BigDecimal.ZERO.compareTo(interCostAmt) == 0) {
                isNotAllocateEntryIdSet.add(entryId);
            }
            if (isAllocate.booleanValue()) {
                isAllocateEntryIdSet.add(entryId);
            }
            BigDecimal amount = row.getBigDecimal("famountbase");
            entryIdFinAmtMap.put(entryId, amount);
        }
        HashMap<Long, BigDecimal> entryIdVeriyAmtMap = new HashMap<Long, BigDecimal>(entryIdSet.size());
        if (!ObjectUtils.isEmpty(isNotAllocateEntryIdSet)) {
            String selectRecordSql = "select fbillentryid,fshareamount from t_cal_feerecordentry where fbilltypeid = '688848270033699840' and fbillentryid in (" + StringUtils.join((Object[])isNotAllocateEntryIdSet.toArray(), (String)",") + ")";
            DataSet calRecordSet = DB.queryDataSet((String)"selectRecordSql", (DBRoute)DBRouteConst.CAL, (String)selectRecordSql);
            calRecordSet = calRecordSet.groupBy(new String[]{"fbillentryid"}).sum("fshareamount").finish();
            for (Row row : calRecordSet) {
                Long finApEntryId = row.getLong("fbillentryid");
                BigDecimal verifyAmt = row.getBigDecimal("fshareamount");
                entryIdVeriyAmtMap.put(finApEntryId, verifyAmt);
            }
        }
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(entryIdSet.size());
        for (Long entryId : finEntryIdList) {
            BigDecimal verifyAmt;
            Object[] params = new Object[3];
            BigDecimal interCostAmt = (BigDecimal)entryIdAndInterCostAmt.get(entryId);
            BigDecimal finApLocAmt = (BigDecimal)entryIdFinAmtMap.get(entryId);
            if (isAllocateEntryIdSet.contains(entryId)) {
                if (BigDecimal.ZERO.compareTo(interCostAmt) == 0) {
                    verifyAmt = (BigDecimal)entryIdVeriyAmtMap.get(entryId);
                    if (verifyAmt == null) {
                        verifyAmt = finApLocAmt;
                    }
                    params[0] = verifyAmt;
                    params[1] = BigDecimal.ZERO;
                    params[2] = entryId;
                } else {
                    params[0] = interCostAmt;
                    params[1] = BigDecimal.ZERO;
                    params[2] = entryId;
                }
                updateParams.add(params);
                continue;
            }
            if (BigDecimal.ZERO.compareTo(interCostAmt) == 0) {
                verifyAmt = (BigDecimal)entryIdVeriyAmtMap.get(entryId);
                if (verifyAmt == null) {
                    verifyAmt = BigDecimal.ZERO;
                }
                params[0] = verifyAmt;
                params[1] = finApLocAmt.subtract(verifyAmt);
                params[2] = entryId;
            } else {
                verifyAmt = (BigDecimal)entryIdVeriyAmtMap.get(entryId);
                if (verifyAmt == null) {
                    verifyAmt = BigDecimal.ZERO;
                }
                params[0] = verifyAmt;
                params[1] = interCostAmt.subtract(verifyAmt);
                params[2] = entryId;
            }
            updateParams.add(params);
        }
        String updateSql = "update t_ap_finapbilldetailentry_e set fallocatedamt = ?, funallocatedamt = ? where fentryid = ?";
        try (TXHandle tx = TX.requiresNew((String)"updateFinAllocatedAmt");){
            try {
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateSql, updateParams);
            }
            catch (Throwable t) {
                tx.markRollback();
                this.logger.error("-----FinApAllocatedFieldUpgradeHandle upgrade allocateamt failed ----", t);
            }
        }
    }
}

