/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinApTaxDeductionUpgradePlugin
implements IUpgradeService {
    private static final int MAX_PROCESSNUMBER = 10000;
    private Set<Long> orgIds = new HashSet<Long>(64);
    private Object[] orgIdPara = null;
    private Set<Long> partakeVerifyIds = new HashSet<Long>(32);
    private Object[] partakeVerifyPara = null;
    private Set<Long> unPartakeVerifyIds = new HashSet<Long>(32);
    private Object[] unPartakeVerifyPara = null;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        boolean success = true;
        try {
            this.doUpgrade();
        }
        catch (Exception e) {
            String log = ArApHelper.getStackTraceMessage((Throwable)e);
            resultMap.put("success", success);
            resultMap.put("log", log);
            resultMap.put("el", "");
            resultMap.put("info", log);
        }
        return new UpgradeResult(resultMap);
    }

    private void doUpgrade() {
        this.prepareFilterData();
        if (EmptyUtils.isEmpty((Object)this.orgIdPara) || this.orgIds.isEmpty() || EmptyUtils.isEmpty((Object)this.partakeVerifyPara) || EmptyUtils.isEmpty((Object)this.unPartakeVerifyPara)) {
            return;
        }
        this.upgradeInVerifyFinBill();
        this.upgradeOutVerifyFinBill();
        this.upgradeAdjustSrcBill();
    }

    private void upgradeInVerifyFinBill() {
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-180);
        ArrayList<Comparable<Character>> queryArgs = new ArrayList<Comparable<Character>>(2 + this.orgIds.size() + this.partakeVerifyIds.size());
        queryArgs.add(Character.valueOf('0'));
        queryArgs.add(beginDate);
        queryArgs.addAll(this.orgIds);
        queryArgs.addAll(this.partakeVerifyIds);
        String queryFinApSql = "select a.fid from t_ap_finapbill a left join t_ap_finapbillinventry b on a.fid = b.fid  where b.fid is null and a.fistaxdeduction=? and a.fbizdate > ? and a.forgid in (" + StringUtils.join((Object[])this.orgIdPara, (char)',') + ')' + " and a.fbilltypeid in (" + StringUtils.join((Object[])this.partakeVerifyPara, (char)',') + ')';
        DataSet allFinDataSet = DB.queryDataSet((String)"FinApTaxDeductionUpgradePlugin", (DBRoute)DBRoute.of((String)"ap"), (String)queryFinApSql, (Object[])queryArgs.toArray());
        ArrayList<Long> needUpdateFinIds = new ArrayList<Long>(64);
        for (Row finRow : allFinDataSet) {
            needUpdateFinIds.add(finRow.getLong("fid"));
            if (needUpdateFinIds.size() != 10000) continue;
            this.updateFin(needUpdateFinIds);
            needUpdateFinIds.clear();
        }
        if (!needUpdateFinIds.isEmpty()) {
            this.updateFin(needUpdateFinIds);
        }
    }

    private void upgradeOutVerifyFinBill() {
        String queryExpenseSql = "select a.FExpenseItemID from T_ER_ExpenseItemBill a left join t_er_billType b on a.FBillTypeID = b.fid where b.fnumber = ? and b.fenable = ?";
        DataSet expenseDataSet = DB.queryDataSet((String)"FinApTaxDeductionUpgradePlugin", (DBRoute)DBRoute.of((String)"sys"), (String)queryExpenseSql, (Object[])new Object[]{"cal_costrecord_subentity", Character.valueOf('1')});
        if (!expenseDataSet.hasNext()) {
            return;
        }
        HashSet<Long> expenseIds = new HashSet<Long>(64);
        for (Row expenseRow : expenseDataSet) {
            expenseIds.add(expenseRow.getLong("FExpenseItemID"));
        }
        ArrayList pram = new ArrayList(64);
        expenseIds.forEach(expenseId -> pram.add("?"));
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-180);
        ArrayList<Comparable<Character>> queryArgs = new ArrayList<Comparable<Character>>(2 + this.orgIds.size() + this.partakeVerifyIds.size() + pram.size());
        queryArgs.add(Character.valueOf('0'));
        queryArgs.add(beginDate);
        queryArgs.addAll(this.orgIds);
        queryArgs.addAll(this.unPartakeVerifyIds);
        queryArgs.addAll(expenseIds);
        String queryFinApSql = "select a.fid from t_ap_finapbill a left join t_ap_finapbilldetailentry b on a.fid = b.fid  left join t_ap_finapbillinventry c on a.fid = c.fid where c.fid is null and a.fid = b.fid and a.fistaxdeduction = ? and a.fbizdate > ? and a.forgid in (" + StringUtils.join((Object[])this.orgIdPara, (char)',') + ')' + " and a.fbilltypeid in ( " + StringUtils.join((Object[])this.unPartakeVerifyPara, (char)',') + ')' + " and b.fexpenseitemid in (" + StringUtils.join((Object[])pram.toArray(), (char)',') + ')';
        DataSet allFinDataSet = DB.queryDataSet((String)"FinApTaxDeductionUpgradePlugin", (DBRoute)DBRoute.of((String)"ap"), (String)queryFinApSql, (Object[])queryArgs.toArray());
        ArrayList<Long> needUpdateFinIds = new ArrayList<Long>(64);
        for (Row finRow : allFinDataSet) {
            needUpdateFinIds.add(finRow.getLong("fid"));
            if (needUpdateFinIds.size() != 10000) continue;
            this.updateFin(needUpdateFinIds);
            needUpdateFinIds.clear();
        }
        if (!needUpdateFinIds.isEmpty()) {
            this.updateFin(needUpdateFinIds);
        }
    }

    private void upgradeAdjustSrcBill() {
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-180);
        String queryAdjustSql = "select fid,fsourcebillid from t_ap_finapbill where fbilltypeid = ? and fbizdate > ? and fsourcebillid != 0";
        DataSet adjustDataSet = DB.queryDataSet((String)"FinApTaxDeductionUpgradePlugin", (DBRoute)DBRoute.of((String)"ap"), (String)queryAdjustSql, (Object[])new Object[]{535203350950479872L, beginDate});
        HashMap<Long, Long> adjustBillMap = new HashMap<Long, Long>(64);
        for (Row adjustRow : adjustDataSet) {
            adjustBillMap.put(adjustRow.getLong("fid"), adjustRow.getLong("fsourcebillid"));
        }
        if (adjustBillMap.isEmpty()) {
            return;
        }
        HashSet srcBillIds = new HashSet(adjustBillMap.values());
        Object[] ids = new Object[srcBillIds.size()];
        for (int j = 0; j < srcBillIds.size(); ++j) {
            ids[j] = Character.valueOf('?');
        }
        String querySrcBillSql = "select fid,fistaxdeduction from t_ap_finapbill where fid in (" + StringUtils.join((Object[])ids, (char)',') + ')';
        DataSet srcBillDataSet = DB.queryDataSet((String)"FinApTaxDeductionUpgradePlugin", (DBRoute)DBRoute.of((String)"ap"), (String)querySrcBillSql, (Object[])srcBillIds.toArray());
        HashMap<Long, Boolean> adjustSrcDeductionMap = new HashMap<Long, Boolean>(srcBillIds.size());
        for (Object adjustSrcRow : srcBillDataSet) {
            adjustSrcDeductionMap.put(adjustSrcRow.getLong("fid"), adjustSrcRow.getBoolean("fistaxdeduction"));
        }
        HashMap adjustDeductionMap = new HashMap(srcBillIds.size());
        for (Map.Entry entry : adjustBillMap.entrySet()) {
            Boolean isTaxDeduction = (Boolean)adjustSrcDeductionMap.get(entry.getValue());
            if (isTaxDeduction == null) continue;
            adjustDeductionMap.put(entry.getKey(), isTaxDeduction);
        }
        if (adjustDeductionMap.isEmpty()) {
            return;
        }
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(adjustDeductionMap.size());
        for (Map.Entry entrySet : adjustDeductionMap.entrySet()) {
            Object[] param = new Object[]{Character.valueOf(Boolean.TRUE.equals(entrySet.getValue()) ? (char)'1' : '0'), entrySet.getKey()};
            updateFinBillParams.add(param);
            if (updateFinBillParams.size() != 10000) continue;
            this.executeBatch(updateFinBillParams);
            updateFinBillParams.clear();
        }
        if (!updateFinBillParams.isEmpty()) {
            this.executeBatch(updateFinBillParams);
        }
    }

    private void executeBatch(List<Object[]> updateFinBillParams) {
        if (updateFinBillParams == null || updateFinBillParams.isEmpty()) {
            return;
        }
        String updateSql = "UPDATE T_AP_FINAPBILL SET FISTAXDEDUCTION=? WHERE fid=?";
        DB.executeBatch((DBRoute)new DBRoute("ap"), (String)updateSql, updateFinBillParams);
    }

    private void prepareFilterData() {
        String sql = "select b.fcalorgid from t_cal_calpolicy a left join t_cal_costaccount b on a.fsupporttaxamt=? and b.fismainaccount = ? and a.fid = b.fcalpolicyid";
        DataSet accountDataSet = DB.queryDataSet((String)"FinApTaxDeductionUpgradePlugin", (DBRoute)new DBRoute("cal"), (String)sql, (Object[])new Object[]{Character.valueOf('0'), Character.valueOf('1')});
        for (Row account : accountDataSet) {
            Long orgId = account.getLong("fcalorgid");
            if (orgId == 0L) continue;
            this.orgIds.add(orgId);
        }
        this.orgIdPara = new Object[this.orgIds.size()];
        for (int i = 0; i < this.orgIds.size(); ++i) {
            this.orgIdPara[i] = Character.valueOf('?');
        }
        Set<String> verifyBillTypeNum = VerifyServiceHelper.getVerifyBillTypeNum();
        if (verifyBillTypeNum != null && !verifyBillTypeNum.isEmpty()) {
            int i;
            DataSet billTypeDataSet = DB.queryDataSet((String)"FinApTaxDeductionUpgradePlugin", (DBRoute)new DBRoute("sys"), (String)"select fid,fnumber from T_BAS_BILLTYPE where fbillformid = ? ", (Object[])new Object[]{"ap_finapbill"});
            for (Row billTypeRow : billTypeDataSet) {
                long typeId = billTypeRow.getLong("fid");
                if (typeId == 535203350950479872L) continue;
                if (verifyBillTypeNum.contains(billTypeRow.getString("fnumber"))) {
                    this.partakeVerifyIds.add(typeId);
                    continue;
                }
                this.unPartakeVerifyIds.add(typeId);
            }
            this.partakeVerifyPara = new Object[this.partakeVerifyIds.size()];
            for (i = 0; i < this.partakeVerifyIds.size(); ++i) {
                this.partakeVerifyPara[i] = Character.valueOf('?');
            }
            this.unPartakeVerifyPara = new Object[this.unPartakeVerifyIds.size()];
            for (i = 0; i < this.unPartakeVerifyIds.size(); ++i) {
                this.unPartakeVerifyPara[i] = Character.valueOf('?');
            }
        }
    }

    private void updateFin(List<Long> needUpdateBillIds) {
        if (needUpdateBillIds == null || needUpdateBillIds.isEmpty()) {
            return;
        }
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(needUpdateBillIds.size());
        for (Long billId : needUpdateBillIds) {
            Object[] param = new Object[]{billId};
            updateFinBillParams.add(param);
        }
        String updateSql = "UPDATE T_AP_FINAPBILL SET FISTAXDEDUCTION='1' WHERE FID=?";
        DB.executeBatch((DBRoute)new DBRoute("ap"), (String)updateSql, updateFinBillParams);
    }
}

