/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.DateUtils;

public class VerifyRecordFarmUpgradePlugin
implements IUpgradeService {
    private static final int MAX_PROCESSNUMBER = 10000;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (ArApHelper.queryApIsNotInit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("info", "is not need Upgrade");
            resultMap.put("success", Boolean.TRUE);
            return new UpgradeResult(resultMap);
        }
        String log = "";
        try (TXHandle txHandle = TX.required();){
            try {
                this.upgradeVerifyRecords();
            }
            catch (Exception e) {
                txHandle.markRollback();
                log = this.getStackTraceMessage(e);
            }
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    public void upgradeVerifyRecords() {
        Date beginDate = DateUtils.getNextDay((Date)new Date(), (int)-180);
        ArrayList<Date> finDeQueryArgs = new ArrayList<Date>(2);
        finDeQueryArgs.add(beginDate);
        String finSql = "select a.fid,b.fentryid,a.fistaxdeduction from t_ap_finapbill a,t_ap_finapbilldetailentry b where a.fid = b.fid and fbizdate > ? and b.fverifyquantity != 0";
        DataSet finDeductionSet = DB.queryDataSet((String)"FinApTaxDeductionUpgradePlugin", (DBRoute)new DBRoute("fi"), (String)finSql, (Object[])finDeQueryArgs.toArray());
        HashSet<Long> finDeductionIds = new HashSet<Long>(64);
        HashSet<Long> finDeductionEntryIds = new HashSet<Long>(64);
        HashSet<Long> finNoDeductionIds = new HashSet<Long>(64);
        HashSet<Long> finNODeductionEntryIds = new HashSet<Long>(64);
        for (Row finRow : finDeductionSet) {
            Long finId = finRow.getLong("fid");
            Long finEntryId = finRow.getLong("fentryid");
            String isTaxDeduction = finRow.getString("fistaxdeduction");
            if ("1".equals(isTaxDeduction)) {
                finDeductionIds.add(finId);
                finDeductionEntryIds.add(finEntryId);
                if (finDeductionEntryIds.size() != 10000) continue;
                this.updateFinVr(finDeductionIds, finDeductionEntryIds, true);
                finDeductionIds.clear();
                finDeductionEntryIds.clear();
                continue;
            }
            finNoDeductionIds.add(finId);
            finNODeductionEntryIds.add(finEntryId);
            if (finNODeductionEntryIds.size() != 10000) continue;
            this.updateFinVr(finNoDeductionIds, finNODeductionEntryIds, false);
            finNoDeductionIds.clear();
            finNODeductionEntryIds.clear();
        }
        if (!finDeductionEntryIds.isEmpty()) {
            this.updateFinVr(finDeductionIds, finDeductionEntryIds, true);
        }
        if (!finNODeductionEntryIds.isEmpty()) {
            this.updateFinVr(finNoDeductionIds, finNODeductionEntryIds, false);
        }
        ArrayList<Object> purQueryArgs = new ArrayList<Object>(2);
        purQueryArgs.add(beginDate);
        purQueryArgs.add("im_purinbill");
        HashSet<Long> mainVrIds = new HashSet<Long>(64);
        String mainVrsql = "select fid from t_ap_verifyrecord where fverifydate > ? and fbilltype = ?";
        DataSet imMainVrs = DB.queryDataSet((String)"ImpurVerifyDeductionUpgradePlugin", (DBRoute)new DBRoute("fi"), (String)mainVrsql, (Object[])purQueryArgs.toArray());
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (Row mainRow : imMainVrs) {
            mainVrIds.add(mainRow.getLong("fid"));
            if (mainVrIds.size() != 10000) continue;
            this.updatePurVr(mainVrIds, entryIds, true);
            mainVrIds.clear();
        }
        if (!mainVrIds.isEmpty()) {
            this.updatePurVr(mainVrIds, entryIds, true);
        }
        String asstVrSql = "select b.fid,b.fentryid from t_ap_verifyrecord a,t_ap_verifyrecordentry b where a.fid = b.fid and a.fverifydate > ? and b.fbilltype = ?";
        DataSet imAsstVrs = DB.queryDataSet((String)"ImpurVerifyDeductionUpgradePlugin", (DBRoute)new DBRoute("fi"), (String)asstVrSql, (Object[])purQueryArgs.toArray());
        HashSet<Long> asstVrIds = new HashSet<Long>(64);
        for (Row asstRow : imAsstVrs) {
            asstVrIds.add(asstRow.getLong("fid"));
            entryIds.add(asstRow.getLong("fentryid"));
            if (asstVrIds.size() != 10000) continue;
            this.updatePurVr(asstVrIds, entryIds, false);
            entryIds.clear();
            asstVrIds.clear();
        }
        if (!asstVrIds.isEmpty()) {
            this.updatePurVr(asstVrIds, entryIds, false);
        }
    }

    private void updatePurVr(Set<Long> ids, Set<Long> entryIds, boolean isMain) {
        if (ids.size() == 0) {
            return;
        }
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(ids.size());
        if (isMain) {
            for (Long l : ids) {
                Object[] param = new Object[]{l};
                updateFinBillParams.add(param);
            }
            Throwable throwable = null;
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ap_verifyrecord", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, ids)});){
                String updateSql = "update t_ap_verifyrecord set fverifyintercostamt=fverifylocalamt where fid = ?";
                DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateSql, updateFinBillParams);
            }
            catch (Throwable param) {
                Throwable throwable2 = param;
                throw param;
            }
        }
        for (Long l : entryIds) {
            Object[] param = new Object[]{l};
            updateFinBillParams.add(param);
        }
        Throwable throwable = null;
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ap_verifyrecordentry", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, ids)});){
            String updateSql = "update t_ap_verifyrecordentry set fverifyintercostamt=fverifyamount where fentryid = ?";
            DB.executeBatch((DBRoute)new DBRoute("fi"), (String)updateSql, updateFinBillParams);
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            throw throwable3;
        }
    }

    public void updateFinVr(Set<Long> finDeductionIds, Set<Long> finDeductionEntryIds, boolean isDeduction) {
        if (finDeductionIds.size() == 0 || finDeductionEntryIds.size() == 0) {
            return;
        }
        Object[] ids = finDeductionIds.toArray();
        Object[] entryIds = finDeductionEntryIds.toArray();
        String updateSql = "";
        String updateEntrySql = "";
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ap_verifyrecord", (HintCondition[])new HintCondition[]{new HintCondition("fbillid", FilterType.in_range, (Object)ids)});){
            updateSql = isDeduction ? "update t_ap_verifyrecord set fverifyintercostamt=fverifylocalamt where fbillid in(" + StringUtils.join((Object[])ids, (char)',') + ')' + "and fbillentryid in(" + StringUtils.join((Object[])entryIds, (char)',') + ')' : "update t_ap_verifyrecord set fverifyintercostamt=flocalverifytaxamt where  fbillid in(" + StringUtils.join((Object[])ids, (char)',') + ')' + "and fbillentryid in(" + StringUtils.join((Object[])entryIds, (char)',') + ')';
            DB.execute((DBRoute)new DBRoute("fi"), (String)updateSql);
        }
        ctx = ShardingHintContext.createAndSet((String)"t_ap_verifyrecordentry", (HintCondition[])new HintCondition[]{new HintCondition("fbillid", FilterType.in_range, (Object)ids)});
        var9_9 = null;
        try {
            updateEntrySql = isDeduction ? "update t_ap_verifyrecordentry set fverifyintercostamt=fverifyamount where fbillid in(" + StringUtils.join((Object[])ids, (char)',') + ')' + "and fbillentryid in(" + StringUtils.join((Object[])entryIds, (char)',') + ')' : "update t_ap_verifyrecordentry set fverifyintercostamt=flocalverifytaxamt where fbillid in(" + StringUtils.join((Object[])ids, (char)',') + ')' + "and fbillentryid in(" + StringUtils.join((Object[])entryIds, (char)',') + ')';
            DB.execute((DBRoute)new DBRoute("fi"), (String)updateEntrySql);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (ctx != null) {
                if (var9_9 != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    ctx.close();
                }
            }
        }
    }

    public String getStackTraceMessage(Exception e) {
        return ArApHelper.getStackTraceMessage((Throwable)e);
    }
}

