/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.VerifyRecordEntryVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public abstract class AbstractApVerifyService
extends AbstractVerifyTemplate {
    protected List<BillVerifyVO> getAsstListVO(DynamicObject[] assts) {
        ArrayList<BillVerifyVO> asstList = new ArrayList<BillVerifyVO>();
        for (DynamicObject asst : assts) {
            DynamicObjectCollection asstEntrys = asst.getDynamicObjectCollection("detailentry");
            for (DynamicObject asstEntry : asstEntrys) {
                BigDecimal unVerifyQty = asstEntry.getBigDecimal("unverifyquantity");
                if (unVerifyQty.compareTo(BigDecimal.ZERO) == 0) continue;
                BillVerifyVO vo = new BillVerifyVO();
                vo.setId(asst.getLong("id"));
                vo.setOrgId(asst.getLong("org.id"));
                vo.setBillNo(asst.getString("billno"));
                vo.setBillType("ap_finapbill");
                vo.setBizdate(asst.getDate("bizdate"));
                long entryId = asstEntry.getLong("id");
                vo.setEntryId(entryId);
                vo.setCurrencyId(asst.getLong("currency.id"));
                vo.setEntryPayableAmt(asstEntry.getBigDecimal("e_pricetaxtotal"));
                vo.setAsstActType(asst.getString("asstacttype"));
                vo.setAsstActId(asst.getLong("asstact.id"));
                vo.setEntryCoreBillNum(asstEntry.getString("corebillno"));
                vo.setEntryCoreBillseq(asstEntry.getString("corebillentryseq"));
                vo.setEntrySettledAmt(asstEntry.getBigDecimal("verifyamount"));
                vo.setEntryUnSettleAmt(asstEntry.getBigDecimal("e_unverifyamount"));
                vo.setEntryMaterialId(asstEntry.getLong("material.id"));
                vo.setEntryMeasureUnitId(asstEntry.getLong("measureunit.id"));
                vo.setEntryMeasureUnit(asstEntry.getDynamicObject("measureunit"));
                vo.setEntryQty(asstEntry.getBigDecimal("quantity"));
                vo.setBaseUnitQty(asstEntry.getBigDecimal("e_baseunitqty"));
                vo.setEntrySettledQty(asstEntry.getBigDecimal("verifyquantity"));
                vo.setEntryUnSettleQty(asstEntry.getBigDecimal("unverifyquantity"));
                vo.setUnitCoefficient(asstEntry.getBigDecimal("e_unitconvertrate"));
                vo.setEntryBaseUnitId(asstEntry.getLong("e_baseunit.id"));
                vo.setEntryBaseUnit(asstEntry.getDynamicObject("e_baseunit"));
                vo.setEntrySouBillId(asstEntry.getLong("e_sourcebillentryid"));
                vo.setPresent(asstEntry.getBoolean("ispresent"));
                vo.setPrice(asstEntry.getBigDecimal("actprice"));
                vo.setBaseCurrencyId(asst.getLong("basecurrency.id"));
                vo.setQuotation(asst.getString("quotation"));
                vo.setExchangeRate(asst.getBigDecimal("exchangerate"));
                vo.setPriceTax(asstEntry.getBigDecimal("actpricetax"));
                vo.setPrecision(Integer.valueOf(asst.getInt("currency.amtprecision")));
                vo.setBasePrecision(Integer.valueOf(asst.getInt("basecurrency.amtprecision")));
                vo.setAllVerify(asstEntry.getBoolean("e_isallverify"));
                vo.setEntryEntityName(asstEntry.getDataEntityType().getName());
                vo.setEntryMaterialVersion(asstEntry.getLong("e_materialversion.id"));
                vo.setEntryMaterialSpecType(asstEntry.getString("spectype") != null ? asstEntry.getString("spectype") : "");
                vo.setEntryMaterialAuxProp(asstEntry.getString("e_assistantattr") != null ? asstEntry.getString("e_assistantattr") : "");
                vo.setEntryMaterialConfigNumber(asstEntry.getLong("configuredcode.id"));
                vo.setEntryMaterialTrackNumber(asstEntry.getLong("tracknumber.id"));
                asstList.add(vo);
            }
        }
        return asstList;
    }

    protected List<VerifyRecordVO> doVerify(List<BillVerifyVO> mainList, List<BillVerifyVO> asstList, SettleSchemeVO scheme, String settleType) {
        scheme.setSettle(true);
        if (scheme.isAllVerify()) {
            return VerifyServiceHelper.allVerify(mainList, asstList, scheme, settleType);
        }
        return VerifyServiceHelper.verify(mainList, asstList, scheme, settleType);
    }

    protected void afterVerify(List<VerifyRecordVO> resultList, SettleSchemeVO scheme) {
        if (resultList != null && resultList.size() > 0) {
            String settleRelation = this.getSettleRelation();
            if (VerifyRelationEnum.PURWRITTENOFF.getValue().equals(settleRelation) || VerifyRelationEnum.PURRETURNWRITTENOFF.getValue().equals(settleRelation) || VerifyRelationEnum.PURRECEDWRITTENOFF.getValue().equals(settleRelation)) {
                scheme.setRedVerifyRecord(true);
            } else {
                scheme.setRedVerifyRecord(false);
            }
            for (VerifyRecordVO result : resultList) {
                result.setSettleRela(settleRelation);
            }
            DynamicObject[] resultArr = VerifyServiceHelper.converVO2Dyn(resultList);
            List<Object> pks = null;
            if (resultArr != null && resultArr.length > 0) {
                pks = VerifyServiceHelper.saveVerifyRecord(resultArr);
                logger.info("---\u6838\u9500\u8bb0\u5f55\u4fdd\u5b58\u6210\u529f---");
            }
            ArrayList<VerifyRecordEntryVO> entryList = new ArrayList<VerifyRecordEntryVO>();
            for (VerifyRecordVO result : resultList) {
                entryList.addAll(result.getVrEntrys());
            }
            scheme.setRecordPks(pks);
            this.disposeAsstBill(entryList, scheme);
            this.disposeMainBill(resultList, scheme);
            if (pks != null && pks.size() > 0 && !VerifyRelationEnum.APPURRECED.getValue().equals(settleRelation) && !this.getUninvokeCalRelations().contains(settleRelation)) {
                VerifyServiceHelper.verifyInvokeCal(pks);
            }
        }
    }

    private List<String> getUninvokeCalRelations() {
        LinkedList<String> relations = new LinkedList<String>();
        relations.add(VerifyRelationEnum.APFINSELF.getValue());
        relations.add(VerifyRelationEnum.FINAPWRITTENOFF.getValue());
        if ("im_mdc_omcmplinbill".equals(VerifyServiceHelper.getOmInBillKey())) {
            relations.add(VerifyRelationEnum.APOMIN.getValue());
            relations.add(VerifyRelationEnum.APOMINRETURN.getValue());
            relations.add(VerifyRelationEnum.OMINSELF.getValue());
        }
        return relations;
    }

    protected VerifyRecordVO converDyn2VO(DynamicObject result) {
        return VerifyServiceHelper.converDyn2VO(result);
    }

    protected void disposeAsstBill(List<VerifyRecordEntryVO> entryList, SettleSchemeVO scheme) {
        HashSet<Long> billIdSet = new HashSet<Long>(entryList.size());
        for (VerifyRecordEntryVO entryVo : entryList) {
            billIdSet.add(entryVo.getBillId());
        }
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,billno,verifystatus,unverifyamount,exchangerate,amount,detailentry.id,detailentry.e_amount,detailentry.verifyamount,detailentry.e_unverifyamount,detailentry.verifyquantity,detailentry.unverifyquantity,detailentry.corebilltype,detailentry.corebillno,detailentry.corebillid,detailentry.corebillentryseq,detailentry.corebillentryid,detailentry.e_conbillentity,detailentry.e_conbillnumber,detailentry.e_conbillrownum,detailentry.e_conbillid,detailentry.e_conbillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(apBills.length);
        HashMap<Long, DynamicObject> billEntryMap = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject bill : apBills) {
            billMap.put(bill.getLong("id"), bill);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entries) {
                billEntryMap.put(entry.getLong("id"), entry);
            }
        }
        apBills = null;
        boolean isSettle = scheme.isSettle();
        for (VerifyRecordEntryVO entryVO : entryList) {
            boolean flag;
            long billId = entryVO.getBillId();
            long billEntryId = entryVO.getBillEntryId();
            BigDecimal settleAmt = entryVO.getSettleAmt();
            if (!isSettle) {
                settleAmt = settleAmt.negate();
            }
            DynamicObject bill = (DynamicObject)billMap.get(billId);
            DynamicObject asstEntry = (DynamicObject)billEntryMap.get(billEntryId);
            if (asstEntry == null) continue;
            BigDecimal settleamt = entryVO.getSettleAmt();
            BigDecimal verifyQty = entryVO.getVerifyQty();
            BigDecimal unverifyamount = bill.getBigDecimal("unverifyamount");
            BigDecimal entryAmount = asstEntry.getBigDecimal("e_amount");
            BigDecimal verifyquantity = asstEntry.getBigDecimal("verifyquantity");
            BigDecimal unverifyquantity = asstEntry.getBigDecimal("unverifyquantity");
            BigDecimal verifyamount = asstEntry.getBigDecimal("verifyamount");
            BigDecimal e_unverifyamount = asstEntry.getBigDecimal("e_unverifyamount");
            if (scheme.isSettle()) {
                verifyquantity = verifyquantity.add(verifyQty);
                if ((unverifyquantity = unverifyquantity.subtract(verifyQty)).compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.subtract(settleamt);
                    e_unverifyamount = BigDecimal.ZERO;
                    verifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.subtract(settleamt);
                    verifyamount = verifyamount.add(settleamt);
                }
            } else {
                verifyquantity = verifyquantity.subtract(verifyQty);
                unverifyquantity = unverifyquantity.add(verifyQty);
                if (verifyquantity.compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = BigDecimal.ZERO;
                    e_unverifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = verifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.add(settleamt);
                }
            }
            bill.set("unverifyamount", (Object)unverifyamount);
            asstEntry.set("verifyquantity", (Object)verifyquantity);
            asstEntry.set("unverifyquantity", (Object)unverifyquantity);
            asstEntry.set("verifyamount", (Object)verifyamount);
            asstEntry.set("e_unverifyamount", (Object)e_unverifyamount);
            boolean bl = flag = scheme.isManual() && scheme.isSettle() && (VerifyRelationEnum.APPURIN.getValue().equals(this.getSettleRelation()) || VerifyRelationEnum.APPURRECED.getValue().equals(this.getSettleRelation()) || VerifyRelationEnum.APPURRETURN.getValue().equals(this.getSettleRelation()));
            if (flag && asstEntry.getLong("corebillid") == 0L && asstEntry.getLong("corebillentryid") == 0L) {
                asstEntry.set("corebilltype", (Object)entryVO.getMainBillEntity());
                asstEntry.set("corebillno", (Object)entryVO.getMainBillNumber());
                asstEntry.set("corebillid", (Object)entryVO.getMainBillId());
                asstEntry.set("corebillentryseq", (Object)entryVO.getMainBillEntrySeq());
                asstEntry.set("corebillentryid", (Object)entryVO.getMainBillEntryId());
            }
            if (!flag || asstEntry.getLong("e_conbillid") != 0L || !StringUtils.isEmpty((String)asstEntry.getString("e_conbillnumber"))) continue;
            asstEntry.set("e_conbillentity", (Object)entryVO.getConBillEntity());
            asstEntry.set("e_conbillnumber", (Object)entryVO.getConBillNumber());
            asstEntry.set("e_conbillrownum", (Object)entryVO.getConBillRowNum());
            asstEntry.set("e_conbillid", (Object)entryVO.getConBillId());
            asstEntry.set("e_conbillentryid", (Object)entryVO.getConBillEntryId());
        }
        if (!ObjectUtils.isEmpty(billMap)) {
            for (DynamicObject bill : billMap.values()) {
                bill.set("verifystatus", (Object)FinApBillHandleHelper.getBillVerifyStatus((DynamicObject)bill));
            }
        }
        Collection objColl = billMap.values();
        SaveServiceHelper.save((DynamicObject[])objColl.toArray(new DynamicObject[0]));
        OpLogServiceHelper.addLog((String)(isSettle ? "verify" : "unverify"), (Object)scheme, (DynamicObject[])objColl.toArray(new DynamicObject[0]), (boolean)false);
    }

    protected String getCalPara() {
        return "PURUNWRITEOFF";
    }
}

