/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.verify;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.mservice.verify.ApPurAutoVerifyService;
import kd.fi.ap.mservice.verify.ApPurRecedVerifyService;
import kd.fi.arapcommon.enums.VerifyModeEnum;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class ApPurRecedAutoVerifyService
extends ApPurAutoVerifyService {
    private static final Log logger = LogFactory.getLog(ApPurRecedAutoVerifyService.class);
    protected static final String MAIN_PURINBILL = "im_purreceivebill";

    public ApPurRecedAutoVerifyService() {
    }

    public ApPurRecedAutoVerifyService(String purEntity, Set<Long> botpIds) {
        this.purEntity = purEntity;
        this.botpIds = botpIds;
    }

    @Override
    public void autoVerify(DynamicObject[] objArr, boolean isMain) throws KDBizException {
        DynamicObject[] assts;
        DynamicObject[] mains;
        SettleSchemeVO scheme = new SettleSchemeVO();
        if (isMain) {
            mains = objArr;
            assts = this.getAsstObjs(objArr, scheme);
        } else {
            assts = objArr;
            mains = this.getMainObjs(objArr, scheme);
        }
        this.autoVerify(mains, assts, scheme);
    }

    @Override
    public void autoVerify(Set<Long> mainIds, Set<Long> asstIds, SettleSchemeVO scheme) {
        if (ObjectUtils.isEmpty(mainIds) || ObjectUtils.isEmpty(asstIds) || ObjectUtils.isEmpty((Object)scheme)) {
            logger.info("ApPurRecedAutoVerifyService autoVerify param is null;return;");
            return;
        }
        DynamicObject[] mains = BusinessDataServiceHelper.load((String)this.purEntity, (String)this.getMainSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", mainIds)});
        DynamicObject[] assts = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)this.getAsstSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", asstIds)});
        this.autoVerify(mains, assts, scheme);
    }

    private void autoVerify(DynamicObject[] mains, DynamicObject[] assts, SettleSchemeVO scheme) {
        if (mains != null && assts != null && mains.length > 0 && assts.length > 0) {
            this.getService(0).verify(mains, assts, scheme, VerifyModeEnum.AUTO.getValue());
        }
    }

    @Override
    protected AbstractVerifyTemplate getService(int direction) {
        return new ApPurRecedVerifyService();
    }
}

