/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.mservice.verify.ApPurinVerifyService;
import kd.fi.arapcommon.enums.VerifyModeEnum;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public class ApSelfVerifyService
extends ApPurinVerifyService {
    protected static final Log logger = LogFactory.getLog(ApPurinVerifyService.class);

    public void autoVerifyById(List<Long> mainIds, List<Long> asstIds) {
        if (mainIds == null) {
            mainIds = new ArrayList<Long>(1);
        }
        if (asstIds == null) {
            asstIds = new ArrayList<Long>(1);
        }
        DynamicObject[] mains = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)VerifyServiceHelper.getFinApSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", mainIds)});
        DynamicObject[] assts = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)VerifyServiceHelper.getFinApSelector(), (QFilter[])new QFilter[]{new QFilter("id", "in", asstIds)});
        if (mains == null || assts == null || mains.length <= 0 || assts.length > 0) {
            // empty if block
        }
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setOnlyByBotp(true);
        this.verify(mains, assts, scheme, VerifyModeEnum.AUTO.getValue());
    }

    @Override
    protected List<BillVerifyVO> getMainListVO(DynamicObject[] mains) {
        logger.info("\u6838\u9500\u4e3b\u65b9id\u662f\uff1a" + mains[0].getLong("id"));
        ArrayList<BillVerifyVO> finApBillList = new ArrayList<BillVerifyVO>();
        for (DynamicObject finApBill : mains) {
            DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                BigDecimal unVerifyQty = row.getBigDecimal("unverifyquantity");
                BigDecimal convertRate = row.getBigDecimal("e_unitconvertrate");
                if (unVerifyQty.compareTo(BigDecimal.ZERO) == 0 || convertRate.compareTo(BigDecimal.ZERO) == 0) continue;
                BillVerifyVO vo = new BillVerifyVO();
                vo.setId(finApBill.getLong("id"));
                vo.setOrgId(finApBill.getLong("org.id"));
                vo.setBillNo(finApBill.getString("billno"));
                vo.setBillType("ap_finapbill");
                vo.setBizdate(finApBill.getDate("bizdate"));
                vo.setEntryId(row.getLong("id"));
                vo.setCurrencyId(finApBill.getLong("currency.id"));
                vo.setEntryPayableAmt(row.getBigDecimal("e_pricetaxtotal"));
                vo.setAsstActType(finApBill.getString("asstacttype"));
                vo.setAsstActId(finApBill.getLong("asstact.id"));
                vo.setEntryCoreBillNum(row.getString("corebillno"));
                vo.setEntryCoreBillseq(row.getString("corebillentryseq"));
                vo.setEntrySettledAmt(row.getBigDecimal("verifyamount"));
                vo.setEntryUnSettleAmt(row.getBigDecimal("e_unverifyamount"));
                vo.setEntryMaterialId(row.getLong("material.id"));
                vo.setEntryMeasureUnitId(row.getLong("measureunit.id"));
                vo.setEntryMeasureUnit(row.getDynamicObject("measureunit"));
                vo.setEntryQty(row.getBigDecimal("quantity"));
                vo.setBaseUnitQty(row.getBigDecimal("e_baseunitqty"));
                vo.setEntrySettledQty(row.getBigDecimal("verifyquantity"));
                vo.setEntryUnSettleQty(row.getBigDecimal("unverifyquantity"));
                vo.setUnitCoefficient(convertRate);
                vo.setEntryBaseUnitId(row.getLong("e_baseunit.id"));
                vo.setEntryBaseUnit(row.getDynamicObject("e_baseunit"));
                vo.setEntrySouBillId(row.getLong("e_sourcebillentryid"));
                vo.setPresent(row.getBoolean("ispresent"));
                vo.setPrice(row.getBigDecimal("actprice"));
                vo.setBaseCurrencyId(finApBill.getLong("basecurrency.id"));
                vo.setQuotation(finApBill.getString("quotation"));
                vo.setExchangeRate(finApBill.getBigDecimal("exchangerate"));
                vo.setPriceTax(row.getBigDecimal("actpricetax"));
                vo.setPrecision(Integer.valueOf(finApBill.getInt("currency.amtprecision")));
                vo.setBasePrecision(Integer.valueOf(finApBill.getInt("basecurrency.amtprecision")));
                vo.setAllVerify(row.getBoolean("e_isallverify"));
                vo.setEntryEntityName(row.getDataEntityType().getName());
                finApBillList.add(vo);
            }
        }
        return finApBillList;
    }

    @Override
    protected List<BillVerifyVO> getAsstListVO(DynamicObject[] assts) {
        return this.getMainListVO(assts);
    }

    @Override
    protected void disposeMainBill(List<VerifyRecordVO> voList, SettleSchemeVO scheme) {
        HashSet<Long> billIdSet = new HashSet<Long>(voList.size());
        for (VerifyRecordVO vo : voList) {
            billIdSet.add(vo.getMainBillId());
        }
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,billno,verifystatus,unverifyamount,exchangerate,amount,detailentry.id,detailentry.e_amount,detailentry.verifyamount,detailentry.e_unverifyamount,detailentry.verifyquantity,detailentry.unverifyquantity", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)});
        HashMap<Long, DynamicObject> apBillMap = new HashMap<Long, DynamicObject>(apBills.length);
        for (DynamicObject bill : apBills) {
            apBillMap.put(bill.getLong("id"), bill);
        }
        apBills = null;
        boolean isSettle = scheme.isSettle();
        for (VerifyRecordVO vo : voList) {
            long billId = vo.getMainBillId();
            long billEntryId = vo.getMainBillEntryId();
            BigDecimal settleAmt = vo.getTotalSettleAmt();
            if (!isSettle) {
                settleAmt = settleAmt.negate();
            }
            DynamicObject bill = (DynamicObject)apBillMap.get(billId);
            DynamicObject asstEntry = null;
            DynamicObjectCollection collection = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detailentry : collection) {
                if (billEntryId != detailentry.getLong("id")) continue;
                asstEntry = detailentry;
                break;
            }
            if (asstEntry == null) continue;
            BigDecimal settleamt = vo.getTotalSettleAmt();
            BigDecimal verifyQty = vo.getVerifyQty();
            BigDecimal unverifyamount = bill.getBigDecimal("unverifyamount");
            BigDecimal verifyquantity = asstEntry.getBigDecimal("verifyquantity");
            BigDecimal entryAmount = asstEntry.getBigDecimal("e_amount");
            BigDecimal unverifyquantity = asstEntry.getBigDecimal("unverifyquantity");
            BigDecimal verifyamount = asstEntry.getBigDecimal("verifyamount");
            BigDecimal e_unverifyamount = asstEntry.getBigDecimal("e_unverifyamount");
            if (scheme.isSettle()) {
                verifyquantity = verifyquantity.add(verifyQty);
                if ((unverifyquantity = unverifyquantity.subtract(verifyQty)).compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.subtract(settleamt);
                    e_unverifyamount = BigDecimal.ZERO;
                    verifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.subtract(settleamt);
                    verifyamount = verifyamount.add(settleamt);
                }
            } else {
                verifyquantity = verifyquantity.subtract(verifyQty);
                unverifyquantity = unverifyquantity.add(verifyQty);
                if (verifyquantity.compareTo(BigDecimal.ZERO) == 0) {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = BigDecimal.ZERO;
                    e_unverifyamount = entryAmount;
                } else {
                    unverifyamount = unverifyamount.add(settleamt);
                    verifyamount = verifyamount.subtract(settleamt);
                    e_unverifyamount = e_unverifyamount.add(settleamt);
                }
            }
            bill.set("unverifyamount", (Object)unverifyamount);
            asstEntry.set("verifyquantity", (Object)verifyquantity);
            asstEntry.set("unverifyquantity", (Object)unverifyquantity);
            asstEntry.set("verifyamount", (Object)verifyamount);
            asstEntry.set("e_unverifyamount", (Object)e_unverifyamount);
            bill.set("verifystatus", (Object)FinApBillHandleHelper.getBillVerifyStatus((DynamicObject)bill));
        }
        Collection objColl = apBillMap.values();
        SaveServiceHelper.save((DynamicObject[])objColl.toArray(new DynamicObject[0]));
        OpLogServiceHelper.addLog((String)(isSettle ? "verify" : "unverify"), (Object)scheme, (DynamicObject[])objColl.toArray(new DynamicObject[0]), (boolean)false);
    }

    @Override
    protected String getSettleRelation() {
        return VerifyRelationEnum.APFINSELF.getValue();
    }
}

