/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.mservice.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.mservice.verify.ApPurManualVrifyService;
import kd.fi.ap.vo.ManualVerifyParam;
import kd.fi.arapcommon.vo.BillVerifyVO;

public class OminSelfManualVerifyService
extends ApPurManualVrifyService {
    @Override
    protected List<BillVerifyVO> getMainVOList(DynamicObject[] mainRows, ManualVerifyParam manualParam) {
        ArrayList<BillVerifyVO> mainList = new ArrayList<BillVerifyVO>();
        HashSet<Long> mainBillIdSet = new HashSet<Long>(mainRows.length);
        HashSet<Long> mainEntryIdSet = new HashSet<Long>(mainRows.length);
        for (DynamicObject main : mainRows) {
            mainBillIdSet.add(main.getLong("main_id"));
            mainEntryIdSet.add(main.getLong("main_entryid"));
        }
        String selector = "id,billentry.id,billentry.qty,billentry.ispresent,billentry.amountandtax,billentry.unverifyqty,billentry.actualtaxprice,billentry.baseqty";
        String orderBy = "biztime,billentry.material";
        String omInbillkey = VerifyServiceHelper.getOmInBillKey();
        DataSet mainDS = QueryServiceHelper.queryDataSet((String)"manual_reloadmain", (String)omInbillkey, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIdSet), new QFilter("billstatus", "=", (Object)"C"), new QFilter("billentry.id", "in", mainEntryIdSet)}, (String)orderBy);
        if (mainDS.hasNext()) {
            for (Row dataSetRow : mainDS) {
                for (DynamicObject mainRow : mainRows) {
                    long entryId = mainRow.getLong("main_entryid");
                    if (entryId != dataSetRow.getLong("billentry.id")) continue;
                    BillVerifyVO vo = new BillVerifyVO();
                    vo.setOrgId(manualParam.getOrgId());
                    vo.setAsstActId(manualParam.getSupplierId());
                    vo.setAsstActType("bd_supplier");
                    vo.setId(mainRow.getLong("main_id"));
                    vo.setBillNo(mainRow.getString("main_billno"));
                    vo.setCurrencyId(mainRow.getLong("main_currency.id"));
                    vo.setBizdate(mainRow.getDate("main_bizdate"));
                    vo.setPrice(mainRow.getBigDecimal("main_unitprice"));
                    vo.setEntryUnSettleQty(mainRow.getBigDecimal("main_curverifyamt"));
                    vo.setEntryId(entryId);
                    vo.setEntryMaterialId(mainRow.getLong("main_material.id"));
                    vo.setUnitCoefficient(mainRow.getBigDecimal("main_convertrate"));
                    vo.setEntryMeasureUnitId(mainRow.getLong("main_measureunit.id"));
                    vo.setEntryMeasureUnit(mainRow.getDynamicObject("main_measureunit"));
                    vo.setEntryBaseUnitId(mainRow.getLong("main_baseunit.id"));
                    vo.setEntryBaseUnit(mainRow.getDynamicObject("main_baseunit"));
                    vo.setEntryQty(dataSetRow.getBigDecimal("billentry.qty"));
                    vo.setBaseUnitQty(dataSetRow.getBigDecimal("billentry.baseqty"));
                    vo.setEntryPayableAmt(dataSetRow.getBigDecimal("billentry.amountandtax"));
                    BigDecimal curVerifyQty = mainRow.getBigDecimal("main_curverifyqty");
                    BigDecimal remainQty = dataSetRow.getBigDecimal("billentry.unverifyqty");
                    if (remainQty.compareTo(curVerifyQty) < 0) {
                        curVerifyQty = remainQty;
                    }
                    vo.setEntryUnSettleQty(curVerifyQty);
                    vo.setBillType(omInbillkey);
                    vo.setPresent(dataSetRow.getBoolean("billentry.ispresent").booleanValue());
                    vo.setQuotation(mainRow.getString("main_quotation"));
                    vo.setExchangeRate(mainRow.getBigDecimal("main_exchangerate"));
                    vo.setBaseCurrencyId(mainRow.getLong("main_basecurrency.id"));
                    vo.setPriceTax(dataSetRow.getBigDecimal("billentry.actualtaxprice"));
                    vo.setPrecision(Integer.valueOf(mainRow.getInt("main_currency.amtprecision")));
                    vo.setBasePrecision(Integer.valueOf(mainRow.getInt("main_basecurrency.amtprecision")));
                    vo.setEntryEntityName(mainRow.getDataEntityType().getName());
                    vo.setEntryMaterialVersion(mainRow.getLong("main_materialversion.id"));
                    vo.setEntryMaterialSpecType(mainRow.getString("main_modelnum"));
                    vo.setEntryMaterialAuxProp(mainRow.getString("main_assistantattr"));
                    vo.setEntryMaterialConfigNumber(mainRow.getLong("main_configuredcode.id"));
                    vo.setEntryMaterialTrackNumber(mainRow.getLong("main_tracknumber.id"));
                    mainList.add(vo);
                }
            }
        }
        return mainList;
    }

    @Override
    protected List<BillVerifyVO> getAsstVOList(DynamicObject[] asstRows, ManualVerifyParam manualParam) {
        ArrayList<BillVerifyVO> asstList = new ArrayList<BillVerifyVO>();
        HashSet<Long> asstBillIdSet = new HashSet<Long>(asstRows.length);
        HashSet<Long> asstEntryIdSet = new HashSet<Long>(asstRows.length);
        for (DynamicObject asst : asstRows) {
            asstBillIdSet.add(asst.getLong("asst_id"));
            asstEntryIdSet.add(asst.getLong("asst_entryid"));
        }
        String selector = "id,billentry.id,billentry.qty,billentry.baseqty,billentry.ispresent,billentry.amountandtax,billentry.unverifyqty,billentry.actualtaxprice";
        String orderBy = "biztime,billentry.material";
        String omInbillkey = VerifyServiceHelper.getOmInBillKey();
        DataSet asstDS = QueryServiceHelper.queryDataSet((String)"manual_reloadmain", (String)omInbillkey, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", asstBillIdSet), new QFilter("billstatus", "=", (Object)"C"), new QFilter("billentry.id", "in", asstEntryIdSet)}, (String)orderBy);
        if (asstDS.hasNext()) {
            for (Row dataSetRow : asstDS) {
                for (DynamicObject asstRow : asstRows) {
                    long entryId = asstRow.getLong("asst_entryid");
                    if (entryId != dataSetRow.getLong("billentry.id")) continue;
                    BillVerifyVO vo = new BillVerifyVO();
                    vo.setOrgId(manualParam.getOrgId());
                    vo.setAsstActId(manualParam.getSupplierId());
                    vo.setAsstActType("bd_supplier");
                    vo.setId(asstRow.getLong("asst_id"));
                    vo.setBillNo(asstRow.getString("asst_billno"));
                    vo.setCurrencyId(asstRow.getLong("asst_currency.id"));
                    vo.setBizdate(asstRow.getDate("asst_bizdate"));
                    vo.setPrice(asstRow.getBigDecimal("asst_unitprice"));
                    vo.setEntryUnSettleQty(asstRow.getBigDecimal("asst_curverifyamt"));
                    vo.setEntryId(entryId);
                    vo.setEntryMaterialId(asstRow.getLong("asst_material.id"));
                    vo.setUnitCoefficient(asstRow.getBigDecimal("asst_convertrate"));
                    vo.setEntryMeasureUnitId(asstRow.getLong("asst_measureunit.id"));
                    vo.setEntryMeasureUnit(asstRow.getDynamicObject("asst_measureunit"));
                    vo.setEntryBaseUnitId(asstRow.getLong("asst_baseunit.id"));
                    vo.setEntryBaseUnit(asstRow.getDynamicObject("asst_baseunit"));
                    vo.setEntryQty(dataSetRow.getBigDecimal("billentry.qty"));
                    vo.setBaseUnitQty(dataSetRow.getBigDecimal("billentry.baseqty"));
                    vo.setEntryPayableAmt(dataSetRow.getBigDecimal("billentry.amountandtax"));
                    BigDecimal curVerifyQty = asstRow.getBigDecimal("asst_curverifyqty");
                    BigDecimal remainQty = dataSetRow.getBigDecimal("billentry.unverifyqty");
                    if (remainQty.abs().compareTo(curVerifyQty.abs()) < 0) {
                        curVerifyQty = remainQty;
                    }
                    vo.setEntryUnSettleQty(curVerifyQty);
                    vo.setBillType(omInbillkey);
                    vo.setPresent(dataSetRow.getBoolean("billentry.ispresent").booleanValue());
                    vo.setBaseCurrencyId(asstRow.getLong("asst_basecurrency.id"));
                    vo.setQuotation(asstRow.getString("asst_quotation"));
                    vo.setExchangeRate(asstRow.getBigDecimal("asst_exchangerate"));
                    vo.setPriceTax(dataSetRow.getBigDecimal("billentry.actualtaxprice"));
                    vo.setPrecision(Integer.valueOf(asstRow.getInt("asst_currency.amtprecision")));
                    vo.setBasePrecision(Integer.valueOf(asstRow.getInt("asst_basecurrency.amtprecision")));
                    vo.setEntryEntityName(asstRow.getDataEntityType().getName());
                    asstList.add(vo);
                }
            }
        }
        return asstList;
    }
}

