/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.report.acctage;

import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.acctage.PreAcctageHelper;
import kd.fi.arapcommon.report.acctage.PreAcctageRptParam;
import kd.fi.arapcommon.util.DataSetUtils;

public class PrePayAcctageListDataRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(PrePayAcctageListDataRpt.class);

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        try {
            DataSet queryData = this.queryData(queryParam);
            return queryData;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    private DataSet queryData(ReportQueryParam queryParam) throws Exception {
        PreAcctageRptParam paidBillParam = PreAcctageHelper.setCommonParam((ReportQueryParam)queryParam, (String)"ap_paidbill");
        DataSet paidBillData = this.queryBillData(paidBillParam);
        PreAcctageRptParam casPayParam = PreAcctageHelper.setCommonParam((ReportQueryParam)queryParam, (String)"cas_paybill");
        DataSet casPayData = this.queryBillData(casPayParam);
        DataSet unionDataSet = DataSetUtils.union((DataSet)paidBillData, (DataSet)casPayData);
        DataSet finalResult = unionDataSet.filter("balance <> 0");
        SumParam statisticalSumParam = paidBillParam.getStatisticalSumParam();
        if (statisticalSumParam != null && !paidBillParam.isShowbybill()) {
            finalResult = DataSetUtils.sumAndSelectField((DataSet)finalResult, (SumParam)statisticalSumParam);
        }
        if (paidBillParam.isAutoSum()) {
            finalResult = DataSetUtils.sumAndSelectField((DataSet)finalResult, Arrays.asList(paidBillParam.getSumParam(), paidBillParam.getTotalSumParam()));
        }
        return finalResult;
    }

    private DataSet queryBillData(PreAcctageRptParam param) {
        DataSet billDataSet = PreAcctageHelper.queryBill((PreAcctageRptParam)param);
        DataSet settleRecordsDataSet = PreAcctageHelper.loadSettleRecord((PreAcctageRptParam)param);
        JoinDataSet dataSet = billDataSet.join(settleRecordsDataSet, JoinType.LEFT).on("id", "mainbillid");
        List selectedFields = DataSetUtils.getSelectedFields((DataSet)billDataSet, (String[])new String[]{"balance", "localbalance"});
        selectedFields.add("case when totalsettleamt=null then balance else balance+totalsettleamt end as balance");
        if (param.isShowlocalamt()) {
            selectedFields.add("case when localtotalsettleamt=null then localbalance else localbalance+localtotalsettleamt end as localbalance");
        }
        DataSet rowDataSet = dataSet.select(selectedFields.toArray(new String[0]), new String[0]).finish();
        DataSet dataSetRes = PreAcctageHelper.divideAmountIntoGroup((DataSet)rowDataSet, (PreAcctageRptParam)param);
        if (param.isShowbybill()) {
            dataSetRes = dataSetRes.addField(String.valueOf(0), "sumlevel");
        }
        return dataSetRes;
    }
}

