/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.service.AdjExchService;
import kd.fi.arapcommon.service.BalanceService;
import kd.fi.arapcommon.service.CloseRecordService;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class AntiClosePeriodOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<DynamicObject> inits = new ArrayList<DynamicObject>();
        AdjExchService adjExchService = new AdjExchService("ap");
        HashMap<Long, DynamicObject> orgAndCurPeriod = new HashMap<Long, DynamicObject>(e.getDataEntities().length);
        for (DynamicObject param : e.getDataEntities()) {
            long orgPk = param.getDynamicObject("org").getLong("id");
            Long periodPk = param.getLong("curperiod");
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodPk, (String)"bd_period");
            InitHelper helper = new InitHelper(orgPk, "ap_init");
            DynamicObject init = BusinessDataServiceHelper.loadSingle((Object)helper.getInitId(), (String)"ap_init");
            orgAndCurPeriod.put(orgPk, init.getDynamicObject("curperiod"));
            StringBuilder error = new StringBuilder();
            if (this.anitCheck(init, period.getInt("number"), error) & this.adjExchCheck(adjExchService, init, period, error)) {
                init.set("curperiod", (Object)period);
                inits.add(init);
                Date closeDate = DateUtils.getNextDay((Date)period.getDate("begindate"), (int)-1);
                CloseRecordService closeRecordService = new CloseRecordService("ap");
                closeRecordService.deleteCloseRecordByAntiClose(Long.valueOf(orgPk), closeDate);
                BalanceService balanceService = new BalanceService("ap");
                balanceService.deleteBalanceByClose(Long.valueOf(orgPk), closeDate);
                continue;
            }
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setPkValue(init.getPkValue());
            errorInfo.setMessage(error.toString());
            errorInfo.setErrorLevel(ErrorLevel.FatalError.name());
            this.operationResult.addErrorInfo(errorInfo);
            this.operationResult.setSuccess(false);
        }
        if (!inits.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])inits.toArray(new DynamicObject[0]));
            block1: for (DynamicObject init : inits) {
                DynamicObject org = init.getDynamicObject("org");
                DynamicObject period = init.getDynamicObject("curperiod");
                DynamicObject deletePeriod = (DynamicObject)orgAndCurPeriod.get(org.getPkValue());
                int targetPeriodNumber = period.getInt("number");
                int deletePeriodNumber = deletePeriod.getInt("number");
                while (deletePeriodNumber > targetPeriodNumber) {
                    adjExchService.cancelAdj(org, deletePeriod, Boolean.FALSE);
                    if (!EmptyUtils.isNotEmpty((Object)(deletePeriod = PeriodHelper.getPrevPeriod((long)deletePeriod.getLong("id"))))) continue block1;
                    deletePeriodNumber = deletePeriod.getInt("number");
                }
            }
        }
        e.setDataEntities(inits.toArray(new DynamicObject[0]));
    }

    private boolean anitCheck(DynamicObject init, int selectNumber, StringBuilder error) {
        String periodName;
        boolean anitclose = true;
        long curnumber = init.getDynamicObject("curperiod").getLong("number");
        long startnumber = init.getDynamicObject("startperiod").getLong("number");
        String orgName = init.getDynamicObject("org").getLocaleString("name").getLocaleValue();
        if ((long)selectNumber > curnumber) {
            periodName = BusinessDataServiceHelper.loadSingleFromCache((Object)init.getDynamicObject("curperiod").getPkValue(), (String)"bd_period").getLocaleString("name").getLocaleValue();
            error.append(String.format(ResManager.loadKDString((String)"%1$s\u5f53\u524d\u671f\u95f4\u4e3a%2$s\u53cd\u7ed3\u8d26\u5931\u8d25\u3002\n", (String)"AntiClosePeriodOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), orgName, periodName));
            anitclose = false;
        }
        if ((long)selectNumber < startnumber) {
            periodName = BusinessDataServiceHelper.loadSingleFromCache((Object)init.getDynamicObject("startperiod").getPkValue(), (String)"bd_period").getLocaleString("name").getLocaleValue();
            error.append(String.format(ResManager.loadKDString((String)"%1$s\u542f\u7528\u671f\u95f4\u4e3a%2$s\u53cd\u7ed3\u8d26\u5931\u8d25\u3002\n", (String)"AntiClosePeriodOp_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), orgName, periodName));
            anitclose = false;
        }
        if ((long)selectNumber == curnumber) {
            error.append(orgName);
            error.append(ResManager.loadKDString((String)"\u53cd\u7ed3\u8d26\u671f\u95f4\u4e3a\u5f53\u524d\u671f\u95f4\uff0c\u65e0\u9700\u53cd\u7ed3\u8d26\u3002\n", (String)"AntiClosePeriodOp_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            anitclose = false;
        }
        return anitclose;
    }

    private boolean adjExchCheck(AdjExchService adjExchService, DynamicObject init, DynamicObject targetPeriod, StringBuilder error) {
        DynamicObject org = init.getDynamicObject("org");
        DynamicObject period = init.getDynamicObject("curperiod");
        ArrayList errorMessages = new ArrayList(8);
        boolean passCheck = true;
        if (EmptyUtils.isEmpty((Object)period)) {
            passCheck = false;
            error.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u83b7\u53d6\u5f53\u524d\u671f\u95f4\u5931\u8d25\u3002", (String)"AntiClosePeriodOp_6", (String)"fi-ap-opplugin", (Object[])new Object[]{org.getString("name")}));
        } else {
            int targetPeriodNumber = targetPeriod.getInt("number");
            int currentPeriodNumber = period.getInt("number");
            while (currentPeriodNumber > targetPeriodNumber) {
                errorMessages.clear();
                errorMessages.addAll(adjExchService.cancelAdjValidate(org, period));
                if (EmptyUtils.isNotEmpty(errorMessages)) {
                    passCheck = false;
                    error.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u671f\u95f4\uff1a%2$s\u3002", (String)"AntiClosePeriodOp_5", (String)"fi-ap-opplugin", (Object[])new Object[0]), org.getString("name"), period.getString("name")));
                    for (String errorMessage : errorMessages) {
                        error.append(errorMessage);
                    }
                    error.append('\n');
                }
                if (!EmptyUtils.isNotEmpty((Object)(period = PeriodHelper.getPrevPeriod((long)period.getLong("id"))))) break;
                currentPeriodNumber = period.getInt("number");
            }
        }
        return passCheck;
    }
}

