/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.helper.FinApBillHelper;
import kd.fi.ap.mservice.ApExpenseCostService;
import kd.fi.ap.validator.ApBusBillImportValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.ApFarmTaxAmtHelper;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.BusWoffBillQtyExcessValidator;
import kd.fi.arapcommon.validator.FarmTaxValidator;
import kd.fi.arapcommon.validator.SupplierandMaterial4VmiValidator;

public class ApBusBillSaveOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(ApBusBillSaveOp.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private final String[] filedKeys = new String[]{"pricetaxtotal", "pricetaxtotalbase", "amount", "localamt", "tax", "taxlocamt", "unwoffamt", "unwofflocamt", "unwoffnotaxamt", "unwoffnotaxlocamt", "unwofftax", "unwofftaxlocal", "invoicedamt", "invoicedlocamt", "uninvoicedamt", "uninvoicedlocamt"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if (!"true".equals(isAppend)) {
            e.addValidator((AbstractValidator)new ApBusBillImportValidator());
        }
        e.addValidator((AbstractValidator)new SupplierandMaterial4VmiValidator());
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new FarmTaxValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        e.addValidator((AbstractValidator)new BusWoffBillQtyExcessValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        TaxHelper.recordTaxLog((DynamicObject[])e.getDataEntities(), (boolean)false);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] busApBills = e.getDataEntities();
        BookDateHelper.billSavesetBookDate((DynamicObject[])busApBills, (boolean)false);
        ApFarmTaxAmtHelper.setBusDecuAmt((DynamicObject[])busApBills);
        this.putUnallocatedAmt(busApBills);
        List sipplierBills = Arrays.stream(busApBills).filter(s -> ("1".equals(s.getString("billsrctype")) || "3".equals(s.getString("billsrctype"))) && "bd_supplier".equals(s.getString("asstacttype"))).collect(Collectors.toList());
        if (sipplierBills != null && sipplierBills.size() > 0) {
            FinApBillHelper.setImptsuppliers(sipplierBills, (String)"entry");
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        logger.info("ApBusBillSaveOp.beginOperationTransaction appendHeadAmt start");
        this.appendHeadAmt(datas);
        logger.info("ApBusBillSaveOp.beginOperationTransaction appendHeadAmt end");
        ArApDataRepairHelper.repairBusApDatas((DynamicObject[])datas);
        this.updateSrcRevaluation(datas);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        ApExpenseCostService exService = new ApExpenseCostService();
        Map expenseFiledMap = exService.ExpenseIdsByBotp(e.getDataEntities());
        if (expenseFiledMap != null && expenseFiledMap.size() > 0) {
            this.saveExpenseFiled(e.getDataEntities(), expenseFiledMap);
        }
    }

    private void updateSrcRevaluation(DynamicObject[] datas) {
        ArrayList<Long> billIds = new ArrayList<Long>(datas.length);
        ArrayList<Long> srcBillIds = new ArrayList<Long>(datas.length);
        for (DynamicObject bill : datas) {
            if (!bill.getBoolean("isrevaluation") || bill.getBoolean("isadjust")) continue;
            billIds.add(bill.getLong("id"));
            srcBillIds.add(bill.getLong("revaluasrcbusbillid"));
        }
        if (billIds.size() == 0 || srcBillIds.size() == 0) {
            return;
        }
        boolean existsBill = QueryServiceHelper.exists((String)"ap_busbill", billIds.get(0));
        if (!existsBill) {
            DynamicObject[] srcBusBills;
            QFilter idFilter = new QFilter("id", "in", srcBillIds);
            QFilter revaluationFilter = new QFilter("hadrevaluation", "=", (Object)Boolean.FALSE);
            QFilter woffFilter = new QFilter("isadjust", "=", (Object)Boolean.FALSE);
            for (DynamicObject srcBusBill : srcBusBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"id,hadrevaluation", (QFilter[])new QFilter[]{idFilter, revaluationFilter, woffFilter})) {
                srcBusBill.set("hadrevaluation", (Object)Boolean.TRUE);
            }
            SaveServiceHelper.update((DynamicObject[])srcBusBills);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendHeadAmt(DynamicObject[] datas) {
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if ("true".equals(isAppend)) {
            try {
                lock.lock();
                for (DynamicObject data : datas) {
                    String amtJson = (String)ConfigCache.get((String)"appendentryrows", (String)data.getString("id"), String.class);
                    Map<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>(16);
                    if (amtJson != null) {
                        amtMap = (Map)SerializationUtils.fromJsonString((String)amtJson, Map.class);
                        for (String filedKey : this.filedKeys) {
                            data.set(filedKey, (Object)data.getBigDecimal(filedKey).add(amtMap.getOrDefault(filedKey, BigDecimal.ZERO)));
                        }
                    }
                    this.buildAmtMap(amtMap, data);
                    ConfigCache.put((String)"appendentryrows", (String)data.getString("id"), (Object)SerializationUtils.toJsonString(amtMap));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void buildAmtMap(Map<String, BigDecimal> amtMap, DynamicObject data) {
        for (String filedKey : this.filedKeys) {
            amtMap.put(filedKey, data.getBigDecimal(filedKey));
        }
    }

    private void putUnallocatedAmt(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (!dataEntity.getBoolean("isadjust")) continue;
            DynamicObjectCollection detailentries = dataEntity.getDynamicObjectCollection("entry");
            for (DynamicObject entry : detailentries) {
                BigDecimal interCostAmt = entry.getBigDecimal("intercostamt");
                if (BigDecimal.ZERO.compareTo(interCostAmt) == 0) {
                    entry.set("e_unallocatedamt", (Object)entry.getBigDecimal("e_localamt"));
                    continue;
                }
                entry.set("e_unallocatedamt", (Object)interCostAmt);
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List props = e.getFieldKeys();
        props.add("asstacttype");
        props.add("asstact");
        props.add("biztype");
        props.add("org");
        props.add("e_material");
        props.add("sourcebilltype");
        props.add("sourcebillid");
        props.add("isselfwoff");
        props.add("billsrctype");
        props.add("entry.e_material");
        props.add("entry.e_measureunit");
        props.add("entry.configuredcode");
        props.add("bizdate");
        props.add("isperiod");
        props.add("isincludetax");
        props.add("billno");
        props.add("bookdate");
        props.add("e_localamt");
        props.add("e_pricetaxtotalbase");
        props.add("basecurrency");
        props.add("curdeductibleamt");
        props.add("intercostamt");
        props.add("e_unallocatedamt");
        props.add("deductiblerate");
        props.add("e_farmproducts");
        props.add("isrevaluation");
        props.add("revaluasrcbusbillid");
        props.add("e_taxlocalamt");
        props.add("e_taxrate");
        props.add("exchangerate");
        props.add("unwoffnotaxamt");
        props.add("amount");
        props.add("localamt");
        props.add("unwoffnotaxlocamt");
        props.add("unwofftax");
        props.add("tax");
        props.add("unwofftaxlocal");
        props.add("taxlocamt");
        props.add("localamt");
        props.add("pricetaxtotalbase");
        props.add("pricetaxtotal");
        props.add("unwofflocamt");
        props.add("unwoffamt");
        props.add("uninvoicedlocamt");
        props.add("uninvoicedamt");
        props.add("invoicedlocamt");
        props.add("invoicedamt");
        props.add("e_unwoffnotaxamt");
        props.add("e_amount");
        props.add("e_unwoffnotaxlocamt");
        props.add("e_unwofftax");
        props.add("e_unwofftaxlocal");
        props.add("e_tax");
        props.add("e_uninvnotaxamt");
        props.add("e_uninvnotaxlocalamt");
        props.add("e_discountlocalamt");
        props.add("e_discountamount");
        props.add("e_pricetaxtotal");
        props.add("e_unwofflocamt");
        props.add("e_unwoffamt");
        props.add("e_uninvoicedlocamt");
        props.add("e_uninvoicedamt");
        props.add("settlementtype");
        props.add("entry.e_ispresent");
        props.add("entry.e_taxunitprice");
        props.add("invoicebiztype");
        props.add("entry.e_unitprice");
        props.add("payproperty");
        props.add("isadjust");
        props.add("receivingsupplierid");
        props.add("entry.e_invoicesupplierid");
        props.add("entry.e_deliversupplierid");
        props.add("billtype");
    }

    private void saveExpenseFiled(DynamicObject[] entities, Map<Long, String> expenseFiledMap) {
        DynamicObject[] busBills;
        Set billIdSet = Arrays.stream(entities).map(t -> t.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject apBill : busBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"entry.e_expensebillids_tag,entry.e_material", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)})) {
            DynamicObjectCollection entrys = apBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                entry.set("e_expensebillids_tag", (Object)expenseFiledMap.get(entry.getLong("id")));
            }
        }
        SaveServiceHelper.save((DynamicObject[])busBills);
    }
}

