/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.ap.mservice.ApExpenseCostService;
import kd.fi.ap.validator.BillToleranceValidator;
import kd.fi.ap.validator.BusApBillSubmitAmountValidator;
import kd.fi.ap.validator.BusPaymentSecuritySubmitCtrlService;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.ApFarmTaxAmtHelper;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.opplugin.BillAppStatusValidator;
import kd.fi.arapcommon.opplugin.MustInputValidator;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.util.AllocationUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.FarmTaxValidator;
import kd.fi.arapcommon.validator.MtoValidator;

public class ApBusBillSubmitOp
extends ArapBaseOp {
    private static final int rowCountOneBatch = 2000;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillAppStatusValidator());
        e.addValidator((AbstractValidator)new MustInputValidator());
        if (SystemParameterHelper.isForceValidateAmt()) {
            e.addValidator((AbstractValidator)new BusApBillSubmitAmountValidator());
        }
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new MtoValidator());
        e.addValidator((AbstractValidator)new FarmTaxValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List selectors = e.getFieldKeys();
        selectors.add("isperiod");
        selectors.add("bizdate");
        selectors.add("isadjust");
        selectors.add("isselfwoff");
        selectors.add("sourcebillid");
        selectors.add("isexpensealloc");
        selectors.add("iswholealloc");
        selectors.add("a_allocationper");
        selectors.add("a_allocationamt");
        selectors.add("a_localamt");
        selectors.add("allocationentry");
        selectors.add("amount");
        selectors.add("basecurrency");
        selectors.add("currency");
        selectors.add("billsrctype");
        selectors.add("allocatebyper");
        selectors.add("isincludetax");
        selectors.add("e_unitprice");
        selectors.add("e_taxunitprice");
        selectors.add("e_quantity");
        selectors.add("e_tax");
        selectors.add("e_amount");
        selectors.add("e_discountamount");
        selectors.add("e_pricetaxtotal");
        selectors.add("localamt");
        selectors.add("sourcebilltype");
        selectors.add("entry");
        selectors.add("e_ispresent");
        selectors.add("biztype");
        if (SystemParameterHelper.isForceValidateAmt()) {
            selectors.addAll(BusApBillSubmitAmountValidator.getRequiredFields());
        }
        selectors.add("payproperty");
        selectors.add("linetype");
        selectors.add("bookdate");
        selectors.add("e_corebillno");
        selectors.add("corebillid");
        selectors.add("corebillentryid");
        selectors.add("configuredcode");
        selectors.add("tracknumber");
        selectors.add("e_localamt");
        selectors.add("e_pricetaxtotalbase");
        selectors.add("e_pricetaxtotal");
        selectors.add("basecurrency");
        selectors.add("curdeductibleamt");
        selectors.add("intercostamt");
        selectors.add("deductiblerate");
        selectors.add("e_farmproducts");
        selectors.add("isperiod");
        selectors.add("e_material");
        selectors.add("localamt");
        selectors.add("taxlocamt");
        selectors.add("tax");
        selectors.add("pricetaxtotalbase");
        selectors.add("pricetaxtotal");
        selectors.add("unwofflocamt");
        selectors.add("unwoffamt");
        selectors.add("uninvoicedlocamt");
        selectors.add("uninvoicedamt");
        selectors.add("e_taxlocalamt");
        selectors.add("e_discountlocalamt");
        selectors.add("e_unwofflocamt");
        selectors.add("e_unwoffamt");
        selectors.add("e_uninvoicedlocamt");
        selectors.add("e_uninvoicedamt");
        selectors.add("e_unitcoefficient");
        selectors.add("e_baseunitqty");
        selectors.add("e_baseunit");
        selectors.add("e_quantity");
        selectors.add("e_measureunit");
        selectors.add("e_unallocatedamt");
        selectors.add("isrevaluation");
        selectors.add("revaluasrcbusbillid");
        selectors.add("e_costcenter");
        selectors.add("org");
        selectors.add("isrevaluation");
        selectors.add("hadrevaluation");
        selectors.add("writeoffbusiness");
        selectors.add("e_measureunit");
        selectors.add("e_srcentryid");
        selectors.add("exchangerate");
        selectors.add("e_taxlocalamt");
        selectors.add("e_taxrate");
        selectors.add("invoicebiztype");
        selectors.add("unwoffnotaxamt");
        selectors.add("unwoffnotaxlocamt");
        selectors.add("unwofftax");
        selectors.add("unwofftaxlocal");
        selectors.add("e_unwoffnotaxamt");
        selectors.add("e_unwoffnotaxlocamt");
        selectors.add("e_unwofftax");
        selectors.add("e_unwofftaxlocal");
        selectors.add("e_uninvnotaxamt");
        selectors.add("e_uninvnotaxlocalamt");
        selectors.add("entry.linetype");
        selectors.add("billstatus");
        selectors.add("exratetable");
        selectors.add("asstacttype");
        selectors.add("asstact");
        selectors.add("e_expensebillids");
        selectors.add("e_expensebillids_tag");
        selectors.add("billtype");
        selectors.add("e_srcbillid");
        selectors.add("e_corebilltype");
        selectors.add("entry.e_corebillentryseq");
        selectors.add("entry.seq");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject data : datas = e.getDataEntities()) {
            if (!StringUtils.isEmpty((String)data.getString("billsrctype")) || !StringUtils.isNotEmpty((String)data.getString("sourcebilltype"))) continue;
            data.set("billsrctype", (Object)BillSrcTypeEnum.AUTO.getValue());
        }
        BookDateHelper.setBookDate((DynamicObject[])datas, (boolean)false);
        ApFarmTaxAmtHelper.setBusDecuAmt((DynamicObject[])datas);
        this.putUnallocatedAmt(datas);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject dataEntity = e.getDataEntities()[0];
        boolean adjustBill = dataEntity.getBoolean("isadjust");
        if (!adjustBill) {
            super.afterExecuteOperationTransaction(e);
            return;
        }
        String opKey = e.getOperationKey();
        OpLogServiceHelper.addLog((String)opKey, (DynamicObject[])e.getDataEntities(), (boolean)false);
        boolean selfWoff = dataEntity.getBoolean("isselfwoff");
        if (selfWoff) {
            return;
        }
        List sourceBillIds = Arrays.asList(e.getDataEntities()).stream().map(entity -> entity.getLong("sourcebillid")).filter(id -> id.compareTo(0L) > 0).collect(Collectors.toList());
        if (EmptyUtils.isEmpty(sourceBillIds)) {
            return;
        }
        OpLogServiceHelper.addLog((String)"auto-woff", (Object)ResManager.loadKDString((String)"\u6682\u4ed8\u5e94\u4ed8\u5355\u81ea\u52a8\u51b2\u56de", (String)"ApBusBillSubmitOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), sourceBillIds, (String)"ap_busbill");
        TaxHelper.recordTaxLog((DynamicObject[])e.getDataEntities(), (boolean)false);
        this.removeCache(e.getDataEntities());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.repairBusApData(e.getDataEntities());
        AllocationUtils.calculateAndSetAllocDifference((DynamicObject[])e.getDataEntities());
        this.revalDisPoseSrcBus(e.getDataEntities());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        ApExpenseCostService exService = new ApExpenseCostService();
        Map expenseFiledMap = exService.ExpenseIdsByBotp(e.getDataEntities());
        if (expenseFiledMap != null && expenseFiledMap.size() > 0) {
            this.saveExpenseFiled(e.getDataEntities(), expenseFiledMap);
        }
        BillToleranceValidator.coreBillPriceValidator(e.getDataEntities());
        try (TraceSpan span = Tracer.create((String)"paymentsecurity", (String)"beginOperationTransaction");){
            BusPaymentSecuritySubmitCtrlService service = new BusPaymentSecuritySubmitCtrlService();
            service.execute(e.getDataEntities());
        }
        List result = (List)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0100", null, (Object[])e.getDataEntities());
        if (result != null && result.size() > 0) {
            throw new KDBizException(org.apache.commons.lang.StringUtils.join((Collection)result, (String)"\n"));
        }
    }

    private void putUnallocatedAmt(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection detailentries = dataEntity.getDynamicObjectCollection("entry");
            for (DynamicObject entry : detailentries) {
                BigDecimal interCostAmt = entry.getBigDecimal("intercostamt");
                if (BigDecimal.ZERO.compareTo(interCostAmt) == 0) {
                    entry.set("e_unallocatedamt", (Object)entry.getBigDecimal("e_localamt"));
                    continue;
                }
                entry.set("e_unallocatedamt", (Object)interCostAmt);
            }
        }
    }

    private void repairBusApData(DynamicObject[] entities) {
        this.locAmountFieldCorrection(entities);
        this.noTaxFieldCorrection(entities);
        ArApHelper.baseUnitQtyCorrection((DynamicObject[])entities, (String)"ap_busbill");
        ArApDataRepairHelper.repairBusApDatas((DynamicObject[])entities);
    }

    private void locAmountFieldCorrection(DynamicObject[] entities) {
        for (DynamicObject bill : entities) {
            BigDecimal rate = bill.getBigDecimal("exchangerate");
            if (rate.compareTo(BigDecimal.ONE) != 0) continue;
            bill.set("localamt", (Object)bill.getBigDecimal("amount"));
            bill.set("taxlocamt", (Object)bill.getBigDecimal("tax"));
            bill.set("pricetaxtotalbase", (Object)bill.getBigDecimal("pricetaxtotal"));
            bill.set("unwofflocamt", (Object)bill.getBigDecimal("unwoffamt"));
            bill.set("uninvoicedlocamt", (Object)bill.getBigDecimal("uninvoicedamt"));
            for (DynamicObject entry : bill.getDynamicObjectCollection("entry")) {
                entry.set("e_taxlocalamt", (Object)entry.getBigDecimal("e_tax"));
                entry.set("e_discountlocalamt", (Object)entry.getBigDecimal("e_discountamount"));
                entry.set("e_localamt", (Object)entry.getBigDecimal("e_amount"));
                entry.set("e_pricetaxtotalbase", (Object)entry.getBigDecimal("e_pricetaxtotal"));
                entry.set("e_unwofflocamt", (Object)entry.getBigDecimal("e_unwoffamt"));
                entry.set("e_uninvoicedlocamt", (Object)entry.getBigDecimal("e_uninvoicedamt"));
            }
        }
    }

    private void noTaxFieldCorrection(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            bill.set("unwoffnotaxamt", (Object)bill.getBigDecimal("amount"));
            bill.set("unwoffnotaxlocamt", (Object)bill.getBigDecimal("localamt"));
            bill.set("unwofftax", (Object)bill.getBigDecimal("tax"));
            bill.set("unwofftaxlocal", (Object)bill.getBigDecimal("taxlocamt"));
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                entry.set("e_unwoffnotaxamt", (Object)entry.getBigDecimal("e_amount"));
                entry.set("e_unwoffnotaxlocamt", (Object)entry.getBigDecimal("e_localamt"));
                entry.set("e_unwofftax", (Object)entry.getBigDecimal("e_tax"));
                entry.set("e_unwofftaxlocal", (Object)entry.getBigDecimal("e_taxlocalamt"));
                entry.set("e_uninvnotaxamt", (Object)entry.getBigDecimal("e_amount"));
                entry.set("e_uninvnotaxlocalamt", (Object)entry.getBigDecimal("e_localamt"));
            }
        }
    }

    private void revalDisPoseSrcBus(DynamicObject[] dataEntities) {
        ArrayList<Long> billIds = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> srcBillIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject bill : dataEntities) {
            if (!bill.getBoolean("isrevaluation") || bill.getBoolean("isadjust")) continue;
            billIds.add(bill.getLong("id"));
            srcBillIds.add(bill.getLong("revaluasrcbusbillid"));
        }
        if (billIds.size() == 0 || srcBillIds.size() == 0) {
            return;
        }
        boolean existsBill = QueryServiceHelper.exists((String)"ap_busbill", billIds.get(0));
        if (!existsBill) {
            DynamicObject[] srcBusBills;
            QFilter idFilter = new QFilter("id", "in", srcBillIds);
            QFilter revaluationFilter = new QFilter("hadrevaluation", "=", (Object)Boolean.FALSE);
            QFilter woffFilter = new QFilter("isadjust", "=", (Object)Boolean.FALSE);
            for (DynamicObject srcBusBill : srcBusBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"id,hadrevaluation", (QFilter[])new QFilter[]{idFilter, revaluationFilter, woffFilter})) {
                srcBusBill.set("hadrevaluation", (Object)Boolean.TRUE);
            }
            SaveServiceHelper.update((DynamicObject[])srcBusBills);
        }
    }

    private void removeCache(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (2000 >= dataEntity.getDynamicObjectCollection("entry").size()) continue;
            ConfigCache.remove((String)"appendentryrows", (String)dataEntity.getString("id"));
        }
    }

    private void saveExpenseFiled(DynamicObject[] entities, Map<Long, String> expenseFiledMap) {
        DynamicObject[] busBills;
        Set billIdSet = Arrays.stream(entities).map(t -> t.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject apBill : busBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"entry.e_expensebillids_tag,entry.e_material", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)})) {
            DynamicObjectCollection entrys = apBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                entry.set("e_expensebillids_tag", (Object)expenseFiledMap.get(entry.getLong("id")));
            }
        }
        SaveServiceHelper.save((DynamicObject[])busBills);
    }
}

