/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.validator.ApRevalBusBillUnAuditValidator;
import kd.fi.ap.validator.BusApBillUnAuditPushValidator;
import kd.fi.ap.validator.validatorService.ApValidatorService;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.service.helper.BusBillServiceHelper;
import kd.fi.arapcommon.validator.PeriodAuditOrUnauditValidator;

public class ApBusBillUnauditOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(ApBusBillUnauditOp.class);
    private List<DynamicObject> calCheck = new ArrayList<DynamicObject>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("org");
        lst.add("isadjust");
        lst.add("sourcebillid");
        lst.add("srcfinbillid");
        lst.add("e_quantity");
        lst.add("e_srcentryid");
        lst.add("e_srcbillid");
        lst.add("bizdate");
        lst.add("bookdate");
        lst.add("isperiod");
        lst.add("isrevaluation");
        lst.add("revaluasrcbusbillid");
        lst.add("isverifybusiness");
        lst.add("hadrevaluation");
        lst.add("srcfinbillid");
        lst.add("billno");
        lst.add("billsrctype");
        lst.add("entry.e_prepaid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PeriodAuditOrUnauditValidator());
        e.addValidator((AbstractValidator)new ApRevalBusBillUnAuditValidator());
        e.addValidator((AbstractValidator)new BusApBillUnAuditPushValidator());
        e.addValidator(new AbstractValidator(){

            /*
             * WARNING - void declaration
             */
            public void validate() {
                void var10_19;
                ExtendedDataEntity[] singleEntries;
                ArrayList<Long> billIdList = new ArrayList<Long>(this.dataEntities.length);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Long l = (Long)dataEntity.getBillPkId();
                    billIdList.add(l);
                }
                Map batchDirtTargetBillMap = BOTPHelper.findDirtTargetBillMap((String)this.entityKey, (Long[])billIdList.toArray(new Long[0]));
                HashSet costBillIds = new HashSet(8);
                Set batchEntries = batchDirtTargetBillMap.entrySet();
                for (Map.Entry entry : batchEntries) {
                    Map singleTarBillMap = (Map)entry.getValue();
                    if (singleTarBillMap == null || singleTarBillMap.isEmpty()) continue;
                    singleEntries = singleTarBillMap.entrySet();
                    for (Map.Entry entry2 : singleEntries) {
                        String tarBillEntity = (String)entry2.getKey();
                        if (!"cal_costestimatebill".equals(tarBillEntity)) continue;
                        Set tarBillIds = (Set)entry2.getValue();
                        costBillIds.addAll(tarBillIds);
                    }
                }
                DynamicObject[] costBills = null;
                if (!costBillIds.isEmpty()) {
                    costBills = BusinessDataServiceHelper.load((String)"cal_costestimatebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", costBillIds), new QFilter("billstatus", "<>", (Object)"A")});
                }
                HashMap<Long, ExtendedDataEntity> hashMap = new HashMap<Long, ExtendedDataEntity>();
                ApValidatorService vService = new ApValidatorService();
                singleEntries = this.dataEntities;
                int n = singleEntries.length;
                boolean bl = false;
                while (var10_19 < n) {
                    ExtendedDataEntity dataEntity = singleEntries[var10_19];
                    String errorMessageOther = vService.closeAccountValidate(dataEntity, "ap_busbill", "bookdate");
                    if (!"".equals(errorMessageOther)) {
                        this.addErrorMessage(dataEntity, errorMessageOther);
                    } else {
                        Long billId = (Long)dataEntity.getBillPkId();
                        Map singleTarBillMap = (Map)batchDirtTargetBillMap.get(billId);
                        if (singleTarBillMap != null) {
                            Set singleEntries2 = singleTarBillMap.entrySet();
                            block4: for (Map.Entry singleEntry : singleEntries2) {
                                DynamicObject entry;
                                String singleTarEntity = (String)singleEntry.getKey();
                                if (costBills != null && "cal_costestimatebill".equals(singleTarEntity)) {
                                    ApBusBillUnauditOp.this.calCheck.add(dataEntity.getDataEntity());
                                    hashMap.put(billId, dataEntity);
                                    Set singleTarBillIds = (Set)singleEntry.getValue();
                                    for (DynamicObject costBill : costBills) {
                                        long costBillId = costBill.getLong("id");
                                        if (!singleTarBillIds.contains(costBillId)) continue;
                                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u5b58\u5728\u975e\u6682\u5b58\u6001\u7684\u8d39\u7528\u6682\u4f30\u5355\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ApBusBillUnauditOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                                        continue block4;
                                    }
                                    continue;
                                }
                                DynamicObjectCollection entryColl = dataEntity.getDataEntity().getDynamicObjectCollection("entry");
                                boolean isPrePaid = false;
                                Iterator iterator = entryColl.iterator();
                                while (iterator.hasNext() && !(isPrePaid = (entry = (DynamicObject)iterator.next()).getBoolean("e_prepaid"))) {
                                }
                                if (isPrePaid) break;
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ApBusBillUnauditOp_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                                break;
                            }
                        }
                    }
                    ++var10_19;
                }
                logger.info("ApBusBillUnauditOp onAddValidators calCheck size : " + ApBusBillUnauditOp.this.calCheck.size());
                if (ApBusBillUnauditOp.this.calCheck.size() > 0) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("entrykey", "entry");
                    Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCheckService", (String)"doService", (Object[])new Object[]{"COSTESTIMATEDELETE", param, ApBusBillUnauditOp.this.calCheck.toArray(new DynamicObject[ApBusBillUnauditOp.this.calCheck.size()])});
                    if (result != null && !result.isEmpty()) {
                        String string = (String)result.get("error");
                        if (!ObjectUtils.isEmpty((Object)string)) {
                            for (Map.Entry entry : hashMap.entrySet()) {
                                this.addErrorMessage((ExtendedDataEntity)entry.getValue(), string);
                            }
                        }
                        for (Map.Entry entry : result.entrySet()) {
                            Object key = entry.getKey();
                            ExtendedDataEntity dataEntity = (ExtendedDataEntity)hashMap.get(key);
                            this.addErrorMessage(dataEntity, (String)entry.getValue());
                        }
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] busBills = e.getDataEntities();
        this.deleteOtherBusArBill(busBills);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] busBills = e.getDataEntities();
        BusBillServiceHelper.getInstance().antiWriteOff(busBills, false);
        logger.info("ApBusBillUnauditOp afterExecuteOperationTransaction calCheck size : " + this.calCheck.size());
        if (this.calCheck.size() > 0) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("entrykey", "entry");
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{"COSTESTIMATEDELETE", param, this.calCheck.toArray(new DynamicObject[this.calCheck.size()])});
        }
        ArrayList<String> srcBusBillIds = new ArrayList<String>(busBills.length);
        DynamicObject[] woffBills = new DynamicObject[]{};
        for (DynamicObject busBill : busBills) {
            boolean isRevalua = busBill.getBoolean("isrevaluation");
            boolean isadjust = busBill.getBoolean("isadjust");
            if (!isRevalua || isadjust) continue;
            Long srcBillId = busBill.getLong("revaluasrcbusbillid");
            srcBusBillIds.add(srcBillId.toString());
        }
        if (srcBusBillIds.size() > 0) {
            QFilter idFilter = new QFilter("sourcebillid", "in", srcBusBillIds);
            QFilter woffFilter = new QFilter("isadjust", "=", (Object)Boolean.TRUE);
            QFilter revaluaFilter = new QFilter("isrevaluation", "=", (Object)Boolean.TRUE);
            woffBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"id,isadjust,srcfinbillid,entry.e_srcbillid", (QFilter[])new QFilter[]{idFilter, woffFilter, revaluaFilter});
        }
        if (woffBills.length > 0) {
            BusBillServiceHelper.getInstance().antiWriteOff(woffBills, false);
        }
    }

    private void deleteOtherBusArBill(DynamicObject[] busBills) {
        Set pks = Arrays.stream(busBills).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
        QFilter qf = new QFilter("sourcebilltype", "=", (Object)"ap_busbill");
        qf.and(new QFilter("sourcebillid", "in", pks.stream().map(String::valueOf).collect(Collectors.toList())));
        qf.and(new QFilter("billtype.number", "=", (Object)"ar_busbill_other_BT_S"));
        qf.and(new QFilter("billstatus", "=", (Object)"A"));
        DynamicObjectCollection busArColl = QueryServiceHelper.query((String)"ar_busbill", (String)"id", (QFilter[])new QFilter[]{qf});
        if (!ObjectUtils.isEmpty((Object)busArColl)) {
            List busArPks = ArApHelper.getPks((Object)busArColl);
            OperateOption option = OperateOption.create();
            OperationServiceHelper.executeOperate((String)"delete", (String)"ar_busbill", (Object[])busArPks.toArray(), (OperateOption)option);
        }
    }
}

