/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.ap.opplugin.ApBaseBillOp;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.validator.PayApplyInvoiceValidator;
import kd.fi.ap.validator.SupplierPayHoldValidator;
import kd.fi.arapcommon.validator.PayApplyExcessValidator;

public class ApplyPayAuditOp
extends ApBaseBillOp {
    private static final Log log = LogFactory.getLog(ApplyPayAuditOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        log.info("ApplyPayAuditOp.onAddValidators start");
        e.addValidator((AbstractValidator)new SupplierPayHoldValidator());
        e.addValidator((AbstractValidator)new PayApplyExcessValidator());
        e.addValidator((AbstractValidator)new PayApplyInvoiceValidator());
        log.info("ApplyPayAuditOp.onAddValidators end");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        log.info("ApplyPayAuditOp.beginOperationTransaction start");
        DynamicObject[] entities = e.getDataEntities();
        this.locAmountFieldCorrection(entities);
        log.info("ApplyPayAuditOp.beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        log.info("ApplyPayAuditOp.endOperationTransaction start");
        this.invoiceUpdateInvoiceStatus(e.getDataEntities());
        log.info("ApplyPayAuditOp.endOperationTransaction end");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] payApplys;
        super.afterExecuteOperationTransaction(e);
        log.info("ApplyPayAuditOp.afterExecuteOperationTransaction start");
        for (DynamicObject payApply : payApplys = e.getDataEntities()) {
            try {
                this.pushBillToPurPayApply(payApply);
            }
            catch (Exception exc) {
                log.info(exc.getMessage());
            }
        }
        log.info("ApplyPayAuditOp.afterExecuteOperationTransaction end");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("applyamount");
        lst.add("settleorg");
        lst.add("approvalamount");
        lst.add("paystatus");
        lst.add("billstatus");
        lst.add("e_paidamt");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("e_approvedamt");
        lst.add("e_asstacttype");
        lst.add("e_asstact");
        lst.add("e_approvedseleamt");
        lst.add("settleorg");
        lst.add("aprseleamount");
        lst.add("exchangerate");
        lst.add("entry.seq");
        lst.add("entry_lk");
        lst.add("entry_lk_sbillid");
        lst.add("entry_lk_sid");
        lst.add("entry.e_corebillid");
        lst.add("entry.e_corebillno");
        lst.add("entry.e_corebillentryid");
        lst.add("entry.e_corebilltype");
        lst.add("entry.e_paymenttype");
        lst.add("inventry.i_srctype");
        lst.add("inventry.invid");
        lst.add("inventry.i_serialno");
        lst.add("entry.e_paymenttype");
        lst.add("entry.e_asstacttype");
        lst.add("entry.e_approvedseleamt");
        lst.add("entry.e_asstact");
        lst.add("isprepayinvoice");
        lst.add("sourcebilltype");
        lst.add("aprseleamount");
        lst.add("billstatus");
        lst.add("settleorg");
        lst.add("settlecurrency");
        lst.add("billtype");
        lst.add("i_asstactname");
        lst.add("inventry.seq");
    }

    private void invoiceUpdateInvoiceStatus(DynamicObject[] entities) {
        HashSet<Long> needUpdateInvStatusIds = new HashSet<Long>(8);
        for (DynamicObject applyBill : entities) {
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                needUpdateInvStatusIds.add(invRow.getLong("invid"));
            }
        }
        InvoiceHelper.updateInvoiceStatus((Long[])needUpdateInvStatusIds.toArray(new Long[0]));
    }

    private void pushBillToPurPayApply(DynamicObject payApply) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Boolean isCQConfig = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"isCQConfig", (Object[])new Object[0]);
        if (!isCQConfig.booleanValue()) {
            return;
        }
        List<Object> entryIds = this.getSuppCollaEntries(payApply);
        if (ObjectUtils.isEmpty(entryIds)) {
            return;
        }
        param.put("entryids", entryIds);
        param.put("id", payApply.getLong("id"));
        DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"pushBillToPurPayApply", (Object[])new Object[]{param});
    }

    private List<Object> getSuppCollaEntries(DynamicObject payApply) {
        DynamicObjectCollection entries = payApply.getDynamicObjectCollection("entry");
        HashMap<Long, Long> map = new HashMap<Long, Long>(entries.size());
        HashMap finalMap = new HashMap(entries.size());
        ArrayList<Object> entryIds = new ArrayList<Object>(entries.size());
        for (DynamicObject entry2 : entries) {
            if (!"bd_supplier".equals(entry2.getString("e_asstacttype"))) continue;
            long entryId = entry2.getLong("id");
            DynamicObject asstact = entry2.getDynamicObject("e_asstact");
            if (ObjectUtils.isEmpty((Object)asstact)) {
                return new ArrayList<Object>();
            }
            long asstactId = asstact.getLong("id");
            map.put(entryId, asstactId);
        }
        ArrayList asstactIds = new ArrayList(map.size());
        map.entrySet().stream().forEach(entry -> asstactIds.add(entry.getValue()));
        Map suppliers = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,issuppcolla", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        for (Map.Entry entrySet : suppliers.entrySet()) {
            DynamicObject supplier = (DynamicObject)entrySet.getValue();
            if (supplier.getBoolean("issuppcolla")) continue;
            Long supplierId = supplier.getLong("id");
            asstactIds.removeAll(new ArrayList<Long>(Collections.singletonList(supplierId)));
        }
        map.entrySet().stream().filter(entry -> asstactIds.stream().anyMatch(id -> id.equals(entry.getValue()))).forEach(entry -> {
            Long cfr_ignored_0 = (Long)finalMap.put(entry.getKey(), entry.getValue());
        });
        for (Long key : finalMap.keySet()) {
            entryIds.add(key);
        }
        return entryIds;
    }

    private void locAmountFieldCorrection(DynamicObject[] entities) {
        for (DynamicObject bill : entities) {
            BigDecimal rate = bill.getBigDecimal("exchangerate");
            if (rate.compareTo(BigDecimal.ONE) != 0) continue;
            bill.set("aprseleamount", (Object)bill.getBigDecimal("approvalamount"));
            for (DynamicObject entry : bill.getDynamicObjectCollection("entry")) {
                entry.set("e_approvedseleamt", (Object)entry.getBigDecimal("e_approvedamt"));
            }
        }
    }
}

