/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.enums.ApplypaystatusEnum;
import kd.fi.ap.validator.ApplyPayClosePayValidator;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.MutexLockHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ApplyPayClosePayOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ApplyPayClosePayOp.class);

    public void initialize(InitOperationArgs e) {
        super.initialize(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("exchangerate");
        lst.add("applyamount");
        lst.add("approvalamount");
        lst.add("paystatus");
        lst.add("billstatus");
        lst.add("e_paidamt");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
        lst.add("e_corebillid");
        lst.add("e_corebillentryid");
        lst.add("e_approvedamt");
        lst.add("e_approvedseleamt");
        lst.add("lockedamt");
        lst.add("settleorg");
        lst.add("e_closestatus");
        lst.add("isprepayinvoice");
        lst.add("inventry.i_srctype");
        lst.add("inventry.invid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        ApplyPayClosePayValidator v = new ApplyPayClosePayValidator();
        e.addValidator((AbstractValidator)v);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        Set applyBillIds = Arrays.stream(entities).map(row -> row.getLong("id")).collect(Collectors.toSet());
        MutexLockHelper.requireMutex((String)"ap_payapply", applyBillIds, (String)"closepay", (String)ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u4ed8\u6b3e\u7533\u8bf7\u5355\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ApplyPayClosePayOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        try {
            Map paramMap = this.getOption().getVariables();
            String selectrows = (String)paramMap.get("selectrows");
            logger.info("selectrows:" + selectrows);
            for (DynamicObject appBill : entities) {
                DynamicObjectCollection entrys = appBill.getDynamicObjectCollection("entry");
                if (ObjectUtils.isEmpty((Object)selectrows)) {
                    appBill.set("billstatus", (Object)"D");
                    for (Iterator entry : entrys) {
                        entry.set("e_closestatus", "B");
                    }
                } else {
                    Iterator entry;
                    List selectrowList = (List)SerializationUtils.fromJsonString((String)selectrows, List.class);
                    appBill.set("billstatus", (Object)"D");
                    entry = entrys.iterator();
                    while (entry.hasNext()) {
                        DynamicObject entry2 = (DynamicObject)entry.next();
                        if (selectrowList.contains(entry2.getLong("id"))) {
                            entry2.set("e_closestatus", (Object)"B");
                        }
                        if (!"A".equals(entry2.getString("e_closestatus"))) continue;
                        appBill.set("billstatus", (Object)"E");
                    }
                }
                String payStatus = appBill.getString("paystatus");
                String billstatus = appBill.getString("billstatus");
                if (!ApplypaystatusEnum.Unpaid.getValue().equals(payStatus) || !"D".equals(billstatus)) continue;
                appBill.set("paystatus", (Object)ApplypaystatusEnum.Norequired.getValue());
            }
            if (EmptyUtils.isNotEmpty((Object)entities)) {
                SaveServiceHelper.save((DynamicObject[])entities);
                Object[] ids = Arrays.stream(entities).map(DataEntityBase::getPkValue).toArray(Object[]::new);
                OperateOption option = OperateOption.create();
                option.setVariableValue("mutex_writeback", "false");
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"savewb", (String)"ap_payapply", (Object[])ids, (OperateOption)option);
                OperationHelper.assertResult((OperationResult)saveResult);
            }
            this.releaseInvoice(entities);
        }
        finally {
            MutexLockHelper.batchRelease((String)"ap_payapply", applyBillIds, (String)"closepay");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    private void releaseInvoice(DynamicObject[] dataEntities) {
        HashMap<Long, Set> apply4InvoiceMap = new HashMap<Long, Set>(8);
        for (DynamicObject applyBill : dataEntities) {
            DynamicObjectCollection entry;
            long payRowNumber;
            if (!"D".equals(applyBill.getString("billstatus")) || (payRowNumber = (entry = applyBill.getDynamicObjectCollection("entry")).stream().filter(applyRow -> applyRow.getBigDecimal("e_paidamt").compareTo(BigDecimal.ZERO) != 0).count()) != 0L) continue;
            Long applyId = applyBill.getLong("id");
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                Set deleteInvoiceIds = apply4InvoiceMap.getOrDefault(applyId, new HashSet(8));
                deleteInvoiceIds.add(invRow.getLong("invid"));
                apply4InvoiceMap.put(applyId, deleteInvoiceIds);
            }
        }
        if (apply4InvoiceMap.isEmpty()) {
            return;
        }
        InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
        deleteParam.setBillClose(true).setBill4InvoiceMap(apply4InvoiceMap);
        IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.APPLYDELETEINVROW.getValue());
        deleteService.deleteInvoiceRow(deleteParam);
    }
}

