/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.enums.ApplypaystatusEnum;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ApplyPayUnClosePayOp
extends AbstractOperationServicePlugIn {
    public void initialize(InitOperationArgs e) {
        super.initialize(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("exchangerate");
        lst.add("applyamount");
        lst.add("approvalamount");
        lst.add("paystatus");
        lst.add("billstatus");
        lst.add("e_paidamt");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
        lst.add("e_corebillid");
        lst.add("e_corebillentryid");
        lst.add("e_approvedamt");
        lst.add("e_approvedseleamt");
        lst.add("lockedamt");
        lst.add("settleorg");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] entities;
        super.endOperationTransaction(e);
        for (DynamicObject appBill : entities = e.getDataEntities()) {
            BigDecimal payAmount = this.getPayAmount(appBill);
            if (payAmount.compareTo(BigDecimal.ZERO) == 0) {
                appBill.set("paystatus", (Object)ApplypaystatusEnum.Alreadypay.getValue());
            } else if (payAmount.compareTo(appBill.getBigDecimal("approvalamount")) == 0) {
                appBill.set("paystatus", (Object)ApplypaystatusEnum.Unpaid.getValue());
            } else {
                appBill.set("paystatus", (Object)ApplypaystatusEnum.Inpayment.getValue());
            }
            appBill.set("billstatus", (Object)"C");
        }
        if (EmptyUtils.isNotEmpty((Object)entities)) {
            SaveServiceHelper.save((DynamicObject[])entities);
            Object[] ids = Arrays.stream(entities).map(DataEntityBase::getPkValue).toArray(Object[]::new);
            OperateOption option = OperateOption.create();
            option.setVariableValue("mutex_writeback", "false");
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_payapply", (Object[])ids, (OperateOption)option);
            OperationHelper.assertResult((OperationResult)saveResult);
        }
    }

    private BigDecimal getPayAmount(DynamicObject appBill) {
        BigDecimal amount = BigDecimal.ZERO;
        DynamicObjectCollection entry = appBill.getDynamicObjectCollection("entry");
        for (DynamicObject dynamicObject : entry) {
            amount = amount.add(dynamicObject.getBigDecimal("e_approvedamt").subtract(dynamicObject.getBigDecimal("e_paidamt")));
        }
        return amount;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }
}

