/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.writeback.helper.PremiumWBFinBillServiceHelper;

public class FinAPBillNoprotocolDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinAPBillNoprotocolDeleteOp.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        logger.info("FinAPBillNoprotocolDeleteOp.endOperationTransaction start");
        logger.info("FinAPBillNoprotocolDeleteOp.endOperationTransaction premiumDeleteDispose start");
        this.premiumDeleteDispose(bills);
        logger.info("FinAPBillNoprotocolDeleteOp.endOperationTransaction premiumDeleteDispose end");
        logger.info("FinAPBillNoprotocolDeleteOp.endOperationTransaction start");
    }

    private void premiumDeleteDispose(DynamicObject[] finBills) {
        ArrayList<DynamicObject> premiumBills = new ArrayList<DynamicObject>(finBills.length);
        ArrayList<Long> premiumSourceBillIds = new ArrayList<Long>(finBills.length);
        for (DynamicObject bill : finBills) {
            if (!bill.getBoolean("ispremium")) continue;
            premiumBills.add(bill);
            premiumSourceBillIds.add(bill.getLong("sourcebillid"));
        }
        if (!premiumSourceBillIds.isEmpty()) {
            QFilter[] sourceBillFilters = new QFilter[]{new QFilter("id", "in", premiumSourceBillIds)};
            List selectors = FinApBillHandleHelper.getLockWBSelector();
            DynamicObject[] sourceFinBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", selectors), (QFilter[])sourceBillFilters);
            HashMap<Object, DynamicObject> sourceFinBillsMap = new HashMap<Object, DynamicObject>(sourceFinBills.length);
            for (DynamicObject finBill : sourceFinBills) {
                sourceFinBillsMap.put(finBill.getPkValue(), finBill);
            }
            for (DynamicObject premiumBill : premiumBills) {
                Long sourceBillId = premiumBill.getLong("sourcebillid");
                DynamicObject sourceFinBill = (DynamicObject)sourceFinBillsMap.get(sourceBillId);
                PremiumWBFinBillServiceHelper.deleteWriteBack((DynamicObject)sourceFinBill, (DynamicObject)premiumBill);
            }
            SaveServiceHelper.save((DynamicObject[])sourceFinBills);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        HashSet<String> props = new HashSet<String>(10);
        props.add("sourcebillid");
        props.add("sourcebilltype");
        props.add("pricetaxtotal");
        props.add("ispremium");
        props.add("settleversion");
        props.add("planentity.planpricetax");
        props.add("planentity.p_sourcebillid");
        props.add("planentity.p_sourcebillentryid");
        props.addAll(FinApBillHandleHelper.getLockWBSelector());
        fieldKeys.addAll(props);
    }
}

