/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.action.ActionResponse;
import kd.fi.arapcommon.business.piaozone.kingdee.action.DeleteAction;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.util.ErStdConfig;

public class FinApBill4InvDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinApBill4InvDeleteOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        logger.info("FinApBill4InvDeleteOp beginOperationTransaction begin");
        HashMap bill4InvoiceMap = new HashMap(16);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Map<String, Object>> invoiceParams = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject entity : dataEntities) {
            if (entity.getBoolean("iswrittenoff")) continue;
            HashSet<Long> invoiceIds = new HashSet<Long>(8);
            DynamicObjectCollection invEntry = entity.getDynamicObjectCollection("inventry");
            if (invEntry.isEmpty()) continue;
            for (DynamicObject invRow : invEntry) {
                if (!ObjectUtils.isEmpty((Object)invRow.getString("i_serialno"))) {
                    HashMap<String, Object> invoiceParam = new HashMap<String, Object>(4);
                    invoiceParam.put("org", entity.get("org"));
                    invoiceParam.put("invid", invRow.get("invid"));
                    invoiceParam.put("i_billno", invRow.get("i_billno"));
                    invoiceParams.add(invoiceParam);
                }
                if (InvoiceSrcTypeEnum.BYINVOICE.getValue().equals(invRow.getString("i_srctype"))) continue;
                invoiceIds.add(invRow.getLong("invid"));
            }
            if (invoiceIds.isEmpty()) continue;
            bill4InvoiceMap.put(entity.getLong("id"), invoiceIds);
        }
        if (bill4InvoiceMap.isEmpty() && invoiceParams.isEmpty()) {
            return;
        }
        logger.info("FinApBill4InvDeleteOp beginOperationTransaction deleteAction begin");
        this.deleteAction(invoiceParams);
        logger.info("FinApBill4InvDeleteOp beginOperationTransaction deleteAction end");
        logger.info("FinApBill4InvDeleteOp beginOperationTransaction IInvoiceEntryDeleteService begin");
        InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
        deleteParam.setBill4InvoiceMap(bill4InvoiceMap).setOperateKey(String.valueOf(this.operateMeta.get("key"))).setAppId((String)this.getOption().getVariables().get("appnumber"));
        IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPDELETEINVROW.getValue());
        deleteService.deleteInvoiceRow(deleteParam);
        logger.info("FinApBill4InvDeleteOp beginOperationTransaction IInvoiceEntryDeleteService end");
        logger.info("FinApBill4InvDeleteOp beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        logger.info("FinApBill4InvDeleteOp endOperationTransaction begin");
        HashSet<Long> orgIds = new HashSet<Long>(8);
        ArrayList<Long> billIds = new ArrayList<Long>(32);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            orgIds.add(dataEntity.getLong("org.id"));
            billIds.add(dataEntity.getLong("id"));
        }
        ReplaceInvoiceHelper.deleteReplaceRecord((String)"ap_finapbill", orgIds, billIds);
        logger.info("FinApBill4InvDeleteOp endOperationTransaction end");
    }

    private void deleteAction(List<Map<String, Object>> invoiceParams) {
        if (ObjectUtils.isEmpty(invoiceParams)) {
            return;
        }
        Set invoiceIds = invoiceParams.stream().map(param -> (Long)param.get("invid")).collect(Collectors.toSet());
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        HashSet<Long> existInvoiceIds = new HashSet<Long>(16);
        for (DynamicObject invoice : invoices) {
            existInvoiceIds.add(invoice.getLong("id"));
        }
        boolean isXH = "true".equals(ErStdConfig.get((String)"invoicecloud.invoicecloudxh"));
        for (Map<String, Object> invoiceParam : invoiceParams) {
            Long invId = (Long)invoiceParam.get("invid");
            DynamicObject org = (DynamicObject)invoiceParam.get("org");
            String iBillNo = (String)invoiceParam.get("i_billno");
            if (existInvoiceIds.contains(invId)) continue;
            if (isXH) {
                HashMap<String, Object> param2 = new HashMap<String, Object>(2);
                param2.put("billId", invId);
                param2.put("entityId", "ap_invoice");
                JSONObject raw_response = this.invokeBizService(param2);
                logger.info("response : " + raw_response);
                Map response = (Map)JSON.parseObject((String)raw_response.toJSONString(), Map.class);
                Object errCode = response.get("errcode");
                if ("0000".equals(errCode)) {
                    logger.info("delete is success!");
                    continue;
                }
                Object desc = response.get("description");
                logger.info("delete is error! " + desc + "(" + errCode + ")");
                throw new KDBizException(String.valueOf(desc));
            }
            DeleteAction deleteAction = new DeleteAction(org, (Object)invId, iBillNo);
            String execute = deleteAction.execute();
            ActionResponse actionResponse = (ActionResponse)JSON.parseObject((String)execute, ActionResponse.class);
            if (actionResponse != null && actionResponse.success()) continue;
            String tipString = ResManager.loadKDString((String)"%s\u6267\u884c\u5931\u8d25", (String)"FinApBill4InvDeleteOp_1", (String)"fi-ap-opplugin", (Object[])new Object[]{ResManager.loadKDString((String)"\uff1a", (String)"FinApBill4InvDeleteOp_2", (String)"fi-ap-opplugin", (Object[])new Object[0])});
            tipString = actionResponse == null ? deleteAction.desc().concat(tipString) : actionResponse.getDescription();
            throw new KDBizException(tipString);
        }
    }

    private JSONObject invokeBizService(Map<String, Object> param) {
        logger.info("\u5220\u9664\u6574\u5355\u53d1\u7968\u4e91\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(param));
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"delete", (Object[])new Object[]{param});
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("iswrittenoff");
        lst.add("org");
        lst.add("inventry.invid");
        lst.add("inventry.i_serialno");
        lst.add("inventry.i_srctype");
        lst.add("inventry.i_billno");
        lst.add("inventry.i_invoiceno");
        lst.add("inventry.i_invoicecode");
    }
}

