/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.invoice.assign.IAssignInvoiceService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.validator.FinApBillAnti4AssignValidator;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;

public class FinApBillAnti4AssignOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinApBillAnti4AssignOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FinApBillAnti4AssignValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(InvoiceHelper.getInvoiceAdjustSelectors());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        logger.info("FinApBillAnti4AssignOp beginOperationTransaction begin");
        this.antiAssign(e.getDataEntities(), true);
        logger.info("FinApBillAnti4AssignOp beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("FinApBillAnti4AssignOp endOperationTransaction begin");
        this.antiAssign(e.getDataEntities(), false);
        logger.info("FinApBillAnti4AssignOp endOperationTransaction end");
    }

    private void antiAssign(DynamicObject[] dataEntities, boolean isBeginOperation) {
        Object[] finApBills = (DynamicObject[])Arrays.stream(dataEntities).filter(bill -> isBeginOperation == bill.getBoolean("iswrittenoff")).toArray(DynamicObject[]::new);
        if (ObjectUtils.isEmpty((Object[])finApBills)) {
            return;
        }
        List<Long> finApBillIds = this.getNeedProcessFinApBillIds((DynamicObject[])finApBills);
        if (ObjectUtils.isEmpty(finApBillIds)) {
            return;
        }
        logger.info("FinApBillAnti4AssignOp antiAssign IAssignInvoiceService begin");
        AssignInvoiceParam assignInvoiceParam = new AssignInvoiceParam();
        String appId = (String)this.getOption().getVariables().get("appnumber");
        String operateKey = String.valueOf(this.operateMeta.get("key"));
        assignInvoiceParam.setBillIds(finApBillIds).setAutoAssign(true).setAppId(appId).setOperateKey(operateKey);
        IAssignInvoiceService assignInvoiceService = (IAssignInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPASSIGNINVOICE.getValue());
        assignInvoiceService.antiAssign(assignInvoiceParam);
        logger.info("FinApBillAnti4AssignOp antiAssign IAssignInvoiceService end");
    }

    private List<Long> getNeedProcessFinApBillIds(DynamicObject[] dataEntities) {
        HashSet<Long> finApBillIds = new HashSet<Long>(64);
        ArrayList<Long> writeOffFinApBillIds = new ArrayList<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject dataEntity : dataEntities) {
            if ("ap_invoice".equals(dataEntity.getString("sourcebilltype"))) continue;
            long finApBillId = dataEntity.getLong("id");
            boolean isHasAdjustDiff = false;
            DynamicObjectCollection detailEntry = dataEntity.getDynamicObjectCollection("detailentry");
            for (DynamicObject detail : detailEntry) {
                if (detail.getBigDecimal("e_taxdiffamt").signum() == 0 && detail.getBigDecimal("e_amountdiffamt").signum() == 0 && detail.getBigDecimal("e_pricetaxdiffamt").signum() == 0) continue;
                isHasAdjustDiff = true;
                break;
            }
            if (!isHasAdjustDiff && dataEntity.getDynamicObjectCollection("inventry").isEmpty()) {
                writeOffFinApBillIds.add(finApBillId);
                orgIds.add(dataEntity.getLong("org.id"));
                continue;
            }
            finApBillIds.add(finApBillId);
        }
        if (!writeOffFinApBillIds.isEmpty()) {
            QFilter filter = new QFilter("org", "in", orgIds);
            filter.and(new QFilter("writeofftypeid", "=", (Object)1893666267970144256L));
            DataSet asMainRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_record_as_mian", (String)"ap_matchrecord_verify", (String)"entry.billid", (QFilter[])new QFilter[]{filter, new QFilter("entry.billid", "in", writeOffFinApBillIds)}, (String)"");
            for (Row row : asMainRecordDataSet) {
                finApBillIds.add(row.getLong("entry.billid"));
            }
            DataSet asAssRecordDataSet = QueryServiceHelper.queryDataSet((String)"query_record_as_ass", (String)"ap_matchrecord_verify", (String)"entry.assbillid", (QFilter[])new QFilter[]{filter, new QFilter("entry.assbillid", "in", writeOffFinApBillIds)}, (String)"");
            for (Row row : asAssRecordDataSet) {
                finApBillIds.add(row.getLong("entry.assbillid"));
            }
        }
        return new ArrayList<Long>(finApBillIds);
    }
}

