/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.business.invoice.assign.IAssignInvoiceService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.validator.AdjustDiffValidator;
import kd.fi.ap.validator.FinApAntiAssignValidator;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;

public class FinApBillAntiAssignOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinApBillAntiAssignOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AdjustDiffValidator());
        e.addValidator((AbstractValidator)new FinApAntiAssignValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        logger.info("FinApBillAntiAssignOp endOperationTransaction begin");
        List finApBillIds = Arrays.stream(e.getDataEntities()).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        AssignInvoiceParam assignInvoiceParam = new AssignInvoiceParam();
        String appId = (String)this.getOption().getVariables().get("appnumber");
        String operateKey = String.valueOf(this.operateMeta.get("key"));
        assignInvoiceParam.setBillIds(finApBillIds).setAutoAssign(false).setAppId(appId).setOperateKey(operateKey);
        IAssignInvoiceService assignInvoiceService = (IAssignInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPASSIGNINVOICE.getValue());
        assignInvoiceService.antiAssign(assignInvoiceParam);
        logger.info("FinApBillAntiAssignOp endOperationTransaction end");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        Set invoiceAdjustSelectors = InvoiceHelper.getInvoiceAdjustSelectors();
        lst.addAll(invoiceAdjustSelectors);
    }
}

