/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.CoordinationInvoiceService;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.validator.FinInvAmtValidator;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.util.StdConfig;

public class FinApBillAudit4InvOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinApBillAudit4InvOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FinInvAmtValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("FinApBillAudit4InvOp endOperationTransaction begin .");
        DynamicObject[] dataEntities = e.getDataEntities();
        logger.info("FinApBillAudit4InvOp updateInvoiceTexDeduction begin .");
        this.updateInvoiceTexDeduction(dataEntities);
        logger.info("FinApBillAudit4InvOp updateInvoiceTexDeduction end .");
        logger.info("FinApBillAudit4InvOp coordinateApArticulate begin .");
        this.coordinateApArticulate(dataEntities);
        logger.info("FinApBillAudit4InvOp coordinateApArticulate end .");
        logger.info("FinApBillAudit4InvOp endOperationTransaction end .");
    }

    private void coordinateApArticulate(DynamicObject[] dataEntities) {
        ArrayList<Long> finApBillIds = new ArrayList<Long>(8);
        for (DynamicObject dataEntity : dataEntities) {
            BigDecimal priceTaxTotal = dataEntity.getBigDecimal("pricetaxtotal");
            BigDecimal unInvoicedAmt = dataEntity.getBigDecimal("uninvoicedamt");
            if (!BillSrcTypeEnum.COORDINATEADJUST.getValue().equals(dataEntity.getString("billsrctype")) || priceTaxTotal.compareTo(BigDecimal.ZERO) == 0 || unInvoicedAmt.compareTo(priceTaxTotal) != 0) continue;
            finApBillIds.add(dataEntity.getLong("sourcebillid"));
        }
        logger.info("FinApBillAudit4InvOp coordinateApArticulate finApBillIds size :" + finApBillIds.size());
        if (finApBillIds.isEmpty()) {
            return;
        }
        CoordinationInvoiceService coordinationInvoiceService = (CoordinationInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.COORDINATIONINVOICE.getValue());
        coordinationInvoiceService.articulate(finApBillIds);
    }

    private void updateInvoiceTexDeduction(DynamicObject[] entities) {
        List finApBillIds = Arrays.stream(entities).filter(bill -> !bill.getDynamicObjectCollection("inventry").isEmpty()).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        if (finApBillIds.isEmpty()) {
            return;
        }
        DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"istaxdeduction,inventry.invid,inventry.i_istaxdeduction,inventry.i_serialno,billtypeid", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)});
        ArrayList<Long> invoiceIds = new ArrayList<Long>(64);
        for (DynamicObject finApBill : entities) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                invoiceIds.add(invRow.getLong("invid"));
            }
        }
        DynamicObject[] invoiceBills = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,istaxdeduction,serialno,invoiceno,invoicecode", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        Map<Long, DynamicObject> invoiceMap = Arrays.stream(invoiceBills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        ArrayList<DynamicObject> needUpdateInvoices = new ArrayList<DynamicObject>(64);
        String billTypes = StdConfig.get((String)"ignore.billTypes");
        for (DynamicObject finApBill : finApBills) {
            String billTypeNum = finApBill.getString("billtypeid.number");
            boolean isIgnore = billTypes != null && billTypes.contains(billTypeNum);
            boolean isTaxDeduction = finApBill.getBoolean("istaxdeduction");
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                DynamicObject invoice = invoiceMap.get(invRow.getLong("invid"));
                if (isTaxDeduction == invoice.getBoolean("istaxdeduction") || isIgnore) continue;
                invoice.set("istaxdeduction", (Object)isTaxDeduction);
                needUpdateInvoices.add(invoice);
                invRow.set("i_istaxdeduction", (Object)isTaxDeduction);
            }
        }
        if (!needUpdateInvoices.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])needUpdateInvoices.toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])finApBills);
            this.updateTaxDeduction(needUpdateInvoices.toArray(new DynamicObject[0]));
            this.getOperationResult().setMessage("invoice_is_null");
        }
        InvoiceHelper.updateInvoiceStatus((Long[])invoiceIds.toArray(new Long[0]));
    }

    private void updateTaxDeduction(DynamicObject[] invoices) {
        if (ObjectUtils.isEmpty((Object[])invoices)) {
            return;
        }
        ArrayList<Object> invoiceIds = new ArrayList<Object>(64);
        ArrayList<String> invNoAndCodes = new ArrayList<String>(64);
        for (DynamicObject invoice : invoices) {
            if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
            invoiceIds.add(invoice.getPkValue());
            invNoAndCodes.add(invoice.getString("invoiceno") + "_" + invoice.getString("invoicecode"));
        }
        logger.info("FinApBillAudit4InvOp updateTaxDeduction invoiceIds : " + invoiceIds);
        if (ObjectUtils.isEmpty(invoiceIds)) {
            return;
        }
        CommonParam param = new CommonParam();
        param.put((Object)"invoiceIds", invoiceIds);
        param.put((Object)"uniquekey", (Object)DB.genGlobalLongId());
        param.put((Object)"invNoAndCodes", invNoAndCodes);
        param.put((Object)"operate", (Object)"finapaudit");
        ECServiceHelper.beginAndRegisterWithBusInfo((String)"ap_updatetaxdeduction", null, (String)"fi", (String)"ap", (String)"ApUpdateTaxDeductionECService", (Param)param, (String)"", invoiceIds);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("inventry.i_srctype");
        fieldKeys.add("inventry.invid");
        fieldKeys.add("inventry.i_usedamt");
        fieldKeys.add("inventry.i_pricetaxtotal");
        fieldKeys.add("inventry.i_canuseamt");
        fieldKeys.add("inventry.i_tax");
        fieldKeys.add("inventry.i_amount");
        fieldKeys.add("org");
        fieldKeys.add("iswrittenoff");
        fieldKeys.add("tax");
        fieldKeys.add("amount");
        fieldKeys.add("billsrctype");
        fieldKeys.add("uninvoicedamt");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("billstatus");
    }
}

