/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.validator.AdjustDiffValidator;
import kd.fi.ap.validator.FinApInvDeleteRowValidator;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinApBillDeleteInvEntryOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinApBillDeleteInvEntryOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AdjustDiffValidator());
        e.addValidator((AbstractValidator)new FinApInvDeleteRowValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("FinApBillDeleteInvEntryOp endOperationTransaction begin");
        Map optionMap = this.getOption().getVariables();
        String invPkStr = (String)optionMap.get("invPk");
        long invPk = 0L;
        if (EmptyUtils.isNotEmpty((Object)invPkStr)) {
            invPk = Long.parseLong(invPkStr);
        }
        String pks = (String)optionMap.get("invPks");
        Set<Long> delRowIds = new HashSet(16);
        if (EmptyUtils.isNotEmpty((Object)pks)) {
            delRowIds = (Set)JSONObject.parseObject((String)pks, Set.class);
        }
        DynamicObject finApBill = e.getDataEntities()[0];
        DynamicObjectCollection invEntries = finApBill.getDynamicObjectCollection("inventry");
        for (DynamicObject invEntry : invEntries) {
            long invId = invEntry.getLong("invid");
            if (invPk != invId) continue;
            delRowIds.add(invId);
        }
        logger.info("FinApBillDeleteInvEntryOp endOperationTransaction delRowIds is : " + delRowIds);
        HashMap<Long, Set<Long>> bill4InvoiceMap = new HashMap<Long, Set<Long>>(8);
        bill4InvoiceMap.put(finApBill.getLong("id"), delRowIds);
        InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
        deleteParam.setBill4InvoiceMap(bill4InvoiceMap).setAppId((String)optionMap.get("appnumber"));
        IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPDELETEINVROW.getValue());
        deleteService.deleteInvoiceRow(deleteParam);
        logger.info("FinApBillDeleteInvEntryOp endOperationTransaction end");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("uninvoicedamt");
        fieldKeys.add("e_invoicedamt");
        fieldKeys.add("e_uninvoicedamt");
        fieldKeys.add("e_pricetaxtotal");
        fieldKeys.add("inventry.invid");
        fieldKeys.add("inventry.i_usedamt");
        fieldKeys.add("inventry.i_canuseamt");
        fieldKeys.add("material");
        fieldKeys.add("planmaterial");
        fieldKeys.add("iswrittenoff");
        fieldKeys.add("quotation");
        fieldKeys.add("bizdate");
        fieldKeys.add("billstatus");
        fieldKeys.add("ispremium");
        fieldKeys.add("istanspay");
        fieldKeys.add("amount");
        fieldKeys.add("tax");
        fieldKeys.add("settleamount");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("isvoucher");
        fieldKeys.add("e_tax");
        fieldKeys.add("e_pricetaxdiffamt");
        fieldKeys.add("e_taxlocalamt");
        fieldKeys.add("e_pricetaxtotalbase");
        fieldKeys.add("e_amountbase");
        fieldKeys.add("relationpay");
        fieldKeys.add("e_taxdiffamt");
        fieldKeys.add("e_amountdiffamt");
        fieldKeys.add("i_tax");
        fieldKeys.add("amountbase");
        fieldKeys.add("i_pricetaxtotal");
        fieldKeys.add("exchangerate");
        fieldKeys.add("basecurrency");
        fieldKeys.add("i_amount");
        fieldKeys.add("e_amount");
        fieldKeys.add("pricetaxtotal");
        fieldKeys.add("quantity");
        fieldKeys.add("verifyamount");
        fieldKeys.add("e_unverifyamount");
        fieldKeys.add("lockedamt");
        fieldKeys.add("unlockamt");
        fieldKeys.add("settledamt");
        fieldKeys.add("unsettleamt");
        fieldKeys.add("settledamtbase");
        fieldKeys.add("unsettleamtbase");
        fieldKeys.add("i_srctype");
        fieldKeys.add("pricetaxtotalbase");
        fieldKeys.add("unsettleamountbase");
        fieldKeys.add("unsettleamount");
        fieldKeys.add("taxlocamt");
        fieldKeys.add("unverifyamount");
        fieldKeys.add("expenseitem");
        fieldKeys.add("e_contract");
        fieldKeys.add("project");
        fieldKeys.add("corebillno");
        fieldKeys.add("paycond");
        fieldKeys.add("duedate");
        fieldKeys.add("splitscheme");
        fieldKeys.add("settlementtype");
        fieldKeys.add("planentity.seq");
        fieldKeys.add("planentity.planpricetax");
        fieldKeys.add("planentity.unplanlockamt");
        fieldKeys.add("planentity.unplansettleamt");
        fieldKeys.add("planentity.planpricetaxloc");
        fieldKeys.add("planentity.unplansettlelocamt");
        fieldKeys.add("planentity.planduedate");
        fieldKeys.add("planentity.e_freezestate");
        fieldKeys.add("planentity.plansettletype");
        fieldKeys.add("premiumrate");
        fieldKeys.add("premiumamt");
        fieldKeys.add("deductiblerate");
        fieldKeys.add("isintax");
        fieldKeys.add("e_farmproducts");
        fieldKeys.add("isexpensealloc");
        fieldKeys.add("istaxdeduction");
        fieldKeys.add("invoicebiztype");
        fieldKeys.add("curdeductibleamt");
        fieldKeys.add("intercostamt");
        fieldKeys.add("e_unallocatedamt");
        fieldKeys.add("taxrate");
        fieldKeys.add("i_billno");
        fieldKeys.add("detailentry.seq");
        fieldKeys.add("preentry");
        fieldKeys.add("corebillno");
        fieldKeys.add("corebillid");
        fieldKeys.add("plancorebillno");
        fieldKeys.add("plancorebillid");
        fieldKeys.add("haspaperticket");
        fieldKeys.add("i_invoicetypef7");
        Set properties = PlanSplitSchemeServiceHelper.getNeedProperties((boolean)false);
        fieldKeys.addAll(properties);
        Set invoiceAdjustSelectors = InvoiceHelper.getInvoiceAdjustSelectors();
        fieldKeys.addAll(invoiceAdjustSelectors);
    }
}

