/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.business.invoice.InvoiceAdjustDiffService;
import kd.fi.ap.business.invoice.collect.ICollectInvoiceService;
import kd.fi.ap.enums.InvoiceAdjustEnum;
import kd.fi.ap.validator.AdjustDiffValidator;
import kd.fi.ap.validator.FinApBillInvCollValidator;
import kd.fi.ap.validator.FinInvAmtValidator;
import kd.fi.ap.vo.InvoiceAdjustParam;
import kd.fi.ap.vo.InvoiceCollectParam;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;

public class FinApBillInvCollOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinApBillInvCollOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FinInvAmtValidator());
        e.addValidator((AbstractValidator)new AdjustDiffValidator());
        e.addValidator((AbstractValidator)new FinApBillInvCollValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        logger.info("FinApBillInvCollOp beforeExecuteOperationTransaction begin .");
        DynamicObject[] dataEntities = e.getDataEntities();
        Object opType = this.operateMeta.get("key");
        if ("submit".equals(opType) || "assignsave".equals(opType)) {
            logger.info("FinApBillInvCollOp beforeExecuteOperationTransaction adjust diff .");
            InvoiceAdjustDiffService adjustDiffService = (InvoiceAdjustDiffService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.INVOCIEADJUST.getValue());
            InvoiceAdjustParam invoiceAdjustParam = new InvoiceAdjustParam(InvoiceAdjustEnum.ADJUST);
            adjustDiffService.executeAdjustDiff(dataEntities, invoiceAdjustParam);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        logger.info("FinApBillInvCollOp endOperationTransaction begin .");
        Object[] finApBills = (DynamicObject[])Arrays.stream(e.getDataEntities()).filter(bill -> !bill.getDynamicObjectCollection("inventry").isEmpty()).toArray(DynamicObject[]::new);
        if (ObjectUtils.isEmpty((Object[])finApBills)) {
            return;
        }
        logger.info("FinApBillInvCollOp endOperationTransaction begin collect.");
        List billIds = Arrays.stream(finApBills).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", this.getSelectors()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        String appId = (String)this.getOption().getVariables().get("appnumber");
        InvoiceCollectParam collectParam = new InvoiceCollectParam();
        collectParam.setAppId(appId);
        collectParam.setOperateKey(String.valueOf(this.operateMeta.get("key")));
        ICollectInvoiceService collectService = (ICollectInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPCOLLECT.getValue());
        collectService.collectInvoice(collectParam, (DynamicObject[])finApBills);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List lst = e.getFieldKeys();
        lst.addAll(this.getSelectors());
    }

    private List<String> getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(256);
        selectors.add("paycond");
        selectors.add("termsdate");
        selectors.add("currency");
        selectors.add("planentity");
        selectors.add("planduedate");
        selectors.add("duedate");
        selectors.add("istaxdeduction");
        selectors.add("billstatus");
        selectors.add("org");
        selectors.add("pricetaxtotal");
        selectors.add("tax");
        selectors.add("amount");
        selectors.add("asstacttype");
        selectors.add("asstact");
        selectors.add("material");
        selectors.add("planmaterial");
        selectors.add("iswrittenoff");
        selectors.add("ispremium");
        selectors.add("istanspay");
        selectors.add("settleamount");
        selectors.add("istaxdeduction");
        selectors.add("iswrittenoff");
        selectors.add("isinvoicematch");
        selectors.add("uninvoicedamt");
        selectors.add("e_pricetaxtotal");
        selectors.add("e_uninvoicedamt");
        selectors.add("e_invoicedamt");
        selectors.add("inventry.invid");
        selectors.add("inventry.i_usedamt");
        selectors.add("inventry.seq");
        selectors.add("inventry.i_billno");
        selectors.add("inventry.i_invoicetype");
        selectors.add("inventry.i_invoicetypef7");
        selectors.add("inventry.i_invoicecode");
        selectors.add("inventry.i_currency");
        selectors.add("inventry.i_invoiceno");
        selectors.add("inventry.i_invoicedate");
        selectors.add("inventry.i_pricetaxtotal");
        selectors.add("inventry.i_taxrate");
        selectors.add("inventry.i_tax");
        selectors.add("inventry.i_srctype");
        selectors.add("inventry.i_amount");
        selectors.add("inventry.i_asstactname");
        selectors.add("inventry.i_buyername");
        selectors.add("inventry.i_istaxdeduction");
        selectors.add("inventry.i_remark");
        selectors.add("inventry.i_serialno");
        selectors.add("inventry.i_issupplement");
        selectors.add("inventry.i_invoicestatus");
        selectors.add("billno");
        selectors.add("inventry.i_canuseamt");
        selectors.add("preentry");
        selectors.add("preentry.y_settleamt");
        selectors.add("preentry.y_unsettleamt");
        selectors.add("preentry.y_amount");
        selectors.add("preentry.y_billtype");
        selectors.add("preentry.y_billid");
        selectors.add("relationpay");
        selectors.add("unlockamt");
        selectors.add("e_taxdiffamt");
        selectors.add("e_amountdiffamt");
        selectors.add("e_pricetaxdiffamt");
        selectors.add("e_tax");
        selectors.add("e_amount");
        selectors.add("e_pricetaxtotal");
        selectors.add("e_adjustamount");
        selectors.add("planpricetaxloc");
        selectors.add("unplanlockamt");
        selectors.add("unplansettleamt");
        selectors.add("unplansettlelocamt");
        selectors.add("splitscheme");
        selectors.add("sourcebilltype");
        selectors.add("detailentry.seq");
        selectors.add("e_unverifyamount");
        selectors.add("unsettleamt");
        selectors.add("unverifyamount");
        selectors.add("unsettleamount");
        selectors.add("e_taxlocalamt");
        selectors.add("e_amountbase");
        selectors.add("e_pricetaxtotalbase");
        selectors.add("planpricetax");
        selectors.add("taxlocamt");
        selectors.add("amountbase");
        selectors.add("pricetaxtotalbase");
        selectors.add("basecurrency");
        selectors.add("quotation");
        selectors.add("exchangerate");
        selectors.add("settlementtype");
        selectors.add("unsettleamtbase");
        selectors.add("planentity.plansettletype");
        selectors.add("planentity.e_freezestate");
        selectors.add("unsettleamountbase");
        selectors.add("lockedamt");
        selectors.add("bizdate");
        selectors.add("e_farmproducts");
        selectors.add("deductiblerate");
        selectors.add("taxrate");
        selectors.add("invoicebiztype");
        selectors.add("curdeductibleamt");
        selectors.add("intercostamt");
        selectors.add("e_unallocatedamt");
        selectors.add("isexpensealloc");
        selectors.add("allocatebyper");
        selectors.add("isintax");
        selectors.add("preentry");
        selectors.add("a_allocationamt");
        selectors.add("a_localamt");
        selectors.add("a_allocationper");
        selectors.add("planentity.seq");
        selectors.add("isincludetax");
        selectors.add("ispricetotal");
        selectors.add("discountmode");
        selectors.add("discountrate");
        selectors.add("discountamount");
        selectors.add("price");
        selectors.add("premiumamt");
        selectors.add("premiumrate");
        selectors.add("settledamtbase");
        selectors.add("corebillno");
        selectors.add("corebillid");
        selectors.add("plancorebillno");
        selectors.add("plancorebillid");
        selectors.add("haspaperticket");
        Set properties = PlanSplitSchemeServiceHelper.getNeedProperties((boolean)false);
        selectors.addAll(properties);
        return selectors;
    }

    @Deprecated
    public static void assertResult(OperationResult result, DynamicObject[] finApBills) {
        OperationHelper.assertResult((OperationResult)result);
    }
}

