/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.InvoiceAdjustDiffService;
import kd.fi.ap.business.invoice.assign.IAssignInvoiceService;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.enums.InvoiceAdjustEnum;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.validator.AdjustDiffValidator;
import kd.fi.ap.validator.FinApBillInvDiffAdjustValidator;
import kd.fi.ap.vo.InvoiceAdjustParam;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.BillRelationBuilder;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;

public class FinApBillInvDiffAdjustOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinApBillInvDiffAdjustOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FinApBillInvDiffAdjustValidator());
        AdjustDiffValidator adjustDiffValidator = new AdjustDiffValidator();
        adjustDiffValidator.setIgnoreSysParam(true);
        e.addValidator((AbstractValidator)adjustDiffValidator);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("FinApBillInvDiffAdjustOp endOperationTransaction begin");
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<Long, Set<Long>> bill4InvoiceMap = new HashMap<Long, Set<Long>>(8);
        ArrayList<Long> allInvoiceIds = new ArrayList<Long>(8);
        for (DynamicObject finApBill : dataEntities) {
            HashSet<Long> needReleaseInvoiceIds = new HashSet<Long>(8);
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                long invId = invRow.getLong("invid");
                if (BigDecimal.ZERO.compareTo(invRow.getBigDecimal("i_usedamt")) == 0) continue;
                needReleaseInvoiceIds.add(invId);
                allInvoiceIds.add(invId);
            }
            bill4InvoiceMap.put(finApBill.getLong("id"), needReleaseInvoiceIds);
        }
        logger.info("FinApBillInvDiffAdjustOp endOperationTransaction bill4InvoiceMap is : " + bill4InvoiceMap);
        String appId = (String)this.getOption().getVariables().get("appnumber");
        String operateKey = String.valueOf(this.operateMeta.get("key"));
        InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
        deleteParam.setBill4InvoiceMap(bill4InvoiceMap).setOperateKey(operateKey).setAppId(appId).setDeleteInvRow(false).setNotDeleteBOTP(true);
        IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPDELETEINVROW.getValue());
        deleteService.deleteInvoiceRow(deleteParam);
        dataEntities = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", this.getSelectors()), (QFilter[])new QFilter[]{new QFilter("id", "in", bill4InvoiceMap.keySet())});
        InvoiceAdjustDiffService adjustDiffService = (InvoiceAdjustDiffService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.INVOCIEADJUST.getValue());
        InvoiceAdjustParam invoiceAdjustParam = new InvoiceAdjustParam(InvoiceAdjustEnum.ROLLBACKTHENADJUST);
        invoiceAdjustParam.setIgnoreSysParam(true);
        adjustDiffService.executeAdjustDiff(dataEntities, invoiceAdjustParam);
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        AssignInvoiceParam assignInvoiceParam = new AssignInvoiceParam();
        assignInvoiceParam.setBillIds(new ArrayList(bill4InvoiceMap.keySet())).setInvoiceIds(allInvoiceIds).setAutoAssign(true).setAppId(appId).setOperateKey(operateKey).setCreateBOTP(false);
        IAssignInvoiceService assignInvoiceService = (IAssignInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPASSIGNINVOICE.getValue());
        assignInvoiceService.assign(assignInvoiceParam);
        this.processBotpRelation(bill4InvoiceMap);
        logger.info("FinApBillInvDiffAdjustOp endOperationTransaction end");
    }

    private void processBotpRelation(Map<Long, Set<Long>> bill4InvoiceMap) {
        DataSet latestFinApDataSet = QueryServiceHelper.queryDataSet((String)"query", (String)"ap_finapbill", (String)"id,inventry.invid,inventry.i_usedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", bill4InvoiceMap.keySet())}, (String)"");
        HashMap<Long, List> needSaveBotpMap = new HashMap<Long, List>(8);
        for (Row latestFinApRow : latestFinApDataSet) {
            Long billId = latestFinApRow.getLong("id");
            Long invId = latestFinApRow.getLong("inventry.invid");
            BigDecimal iUserAmt = latestFinApRow.getBigDecimal("inventry.i_usedamt");
            Set<Long> hasBotpInvIds = bill4InvoiceMap.get(billId);
            List needCreateBotpInvIds = needSaveBotpMap.getOrDefault(billId, new ArrayList(8));
            if (iUserAmt != null && BigDecimal.ZERO.compareTo(iUserAmt) != 0 && !hasBotpInvIds.contains(invId)) {
                needCreateBotpInvIds.add(invId);
            }
            if (needCreateBotpInvIds.isEmpty()) continue;
            needSaveBotpMap.put(billId, needCreateBotpInvIds);
        }
        if (!needSaveBotpMap.isEmpty()) {
            BillRelationBuilder billRelationBuilder = new BillRelationBuilder("ap_invoice", "ap_finapbill");
            for (Map.Entry entrySet : needSaveBotpMap.entrySet()) {
                billRelationBuilder.saveRelation((Collection)entrySet.getValue(), (Long)entrySet.getKey());
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(this.getSelectors());
    }

    private Set<String> getSelectors() {
        HashSet<String> fieldKeys = new HashSet<String>(128);
        Set properties = PlanSplitSchemeServiceHelper.getNeedProperties((boolean)false);
        fieldKeys.addAll(properties);
        Set invoiceAdjustSelectors = InvoiceHelper.getInvoiceAdjustSelectors();
        fieldKeys.addAll(invoiceAdjustSelectors);
        return fieldKeys;
    }
}

